<?php
namespace addons\turntable_gzhx\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public $data;
    public $PluginName = "TurntableGzhx";
    public function initialize()
    {
        parent::initialize();
        $DbConfig = \Think\Db::getConfig();
        $fieldList = \Think\Db::name("gzhx_activity")->getTableFields();
        if (!in_array("turntable_open", $fieldList)) {
            \Think\Db::query("ALTER TABLE `" . $DbConfig["prefix"] . "gzhx_activity` ADD COLUMN `turntable_open` int(2) NULL DEFAULT 1;");
        }
        if (!in_array("coupon_open", $fieldList)) {
            \Think\Db::query("ALTER TABLE `" . $DbConfig["prefix"] . "gzhx_activity` ADD COLUMN `coupon_open` int(2) NULL DEFAULT 1;");
        }
        $fieldList2 = \Think\Db::name("gzhx_activity_group")->getTableFields();
        if (!in_array("enterprise", $fieldList2)) {
            \Think\Db::query("ALTER TABLE `" . $DbConfig["prefix"] . "gzhx_activity_group` ADD COLUMN `enterprise` int(2) NULL DEFAULT '0';");
        }
        if (!in_array("aid", $fieldList2)) {
            \Think\Db::query("ALTER TABLE `" . $DbConfig["prefix"] . "gzhx_activity_group` ADD COLUMN `aid` int(10) NULL DEFAULT '0';");
        }
        $fieldList3 = \Think\Db::name("gzhx_activity_prize_setting")->getTableFields();
        if (!in_array("aid", $fieldList3)) {
            \Think\Db::query("ALTER TABLE `" . $DbConfig["prefix"] . "gzhx_activity_prize_setting` ADD COLUMN `aid` int(10) NULL DEFAULT '0';");
        }
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function activity()
    {
        if (!empty($this->data)) {
            switch ($this->data["action"]) {
                case "prizesetting":
                    $this->data["data"]["plugin"] = $this->PluginName;
                    if (empty($this->data["data"]["title"])) {
                        $this->error("请输入活动名称");
                        exit;
                    }
                    if (empty($this->data["data"]["start_time"])) {
                        $this->error("请输入活动开始时间");
                        exit;
                    }
                    if (empty($this->data["data"]["end_time"])) {
                        $this->error("请输入活动结束");
                        exit;
                    }
                    if (empty($this->data["data"]["id"])) {
                        $this->data["data"]["id"] = \Think\Db::name("gzhx_activity")->insertGetId($this->data["data"]);
                    } else {
                        \Think\Db::name("gzhx_activity")->update($this->data["data"]);
                        $this->data["data"]["status"] = \Think\Db::name("gzhx_activity")->where("id", "=", $this->data["data"]["id"])->value("status");
                    }
                    $this->success($this->data["data"]);
                    exit;
                    break;
                case "setmenu":
                    $menuClient = \Think\Db::name("MenuActive")->field("b.id,b.nav_list")->alias("a")->leftJoin("menus b", "a.menuid=b.id")->where("a.type", "client")->find();
                    $menuClients = json_decode($menuClient["nav_list"], true);
                    $menuName = false;
                    foreach ($menuClients as $k => &$v) {
                        if ($v["plugin"] == "TurntableGzhx") {
                            $menuName = $v["name"];
                            if ($menuName === false) {
                                $this->error("导航中心不存在对应导航，请到站务，导航设置中增加");
                                exit;
                            }
                            foreach ($menuClients as $k => &$v) {
                                if ($v["plugin"] == "TurntableGzhx") {
                                    $v["name"] = $this->data["name"];
                                    $lang = json_decode($v["lang"], true);
                                    $lang["chinese"] = $v["name"];
                                    $lang["chinese_tw"] = $v["name"];
                                    $v["lang"] = json_encode($lang);
                                    \Think\Db::name("menus")->where("id", "=", $menuClient["id"])->update(["nav_list" => json_encode($menuClients)]);
                                    $this->success("设置成功");
                                    exit;
                                }
                            }
                        }
                    }
                    break;
                case "open_status":
                    $update = [];
                    $update[$this->data["field"]] = $this->data["status"];
                    \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $this->data["id"])->update($update);
                    $this->success("设置成功");
                    break;
                case "status":
                    $status = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("status", "=", 2)->find();
                    if (intval($this->data["status"]) == 2) {
                        $setting = unserialize(\Think\Db::name("gzhx_activity")->where("id", "=", $this->data["id"])->value("setting"));
                        if (!$setting) {
                            $this->error("请先配置活动");
                            exit;
                        }
                    }
                    \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $this->data["id"])->update(["status" => intval($this->data["status"]) == 2 ? 2 : 1]);
                    $this->success("设置成功");
                    exit;
                    break;
                default:
                    $this->error($this->data["action"] . "参数不存在");
                    exit;
            }
        } else {
            $menuClient = \Think\Db::name("MenuActive")->field("b.id,b.nav_list")->alias("a")->leftJoin("menus b", "a.menuid=b.id")->where("a.type", "client")->find();
            $menuClients = json_decode($menuClient["nav_list"], true);
            $menuName = "";
            foreach ($menuClients as $k => &$v) {
                if ($v["plugin"] == "TurntableGzhx") {
                    $menuName = $v["name"];
                    $this->assign("menuName", $menuName);
                    $this->assign("Title", "活动设置");
                    $this->assign("List", \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->order("status desc,start_time desc,id desc")->select()->toArray());
                    return $this->fetch("/activity");
                }
            }
        }
    }
    public function activityset()
    {
        if (empty($_GET["id"])) {
            $this->assign("msg", "参数错误");
            return $this->fetch("/error");
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->find();
        if (empty($activity)) {
            $this->assign("msg", "活动不存在");
            return $this->fetch("/error");
        }
        if (!empty($this->data)) {
            switch ($this->data["action"]) {
                case "save":
                    $pay = [];
                    foreach ($this->data["pay"] as $k => $v) {
                        if ($v && !in_array($v, $pay)) {
                            $pay[] = $v;
                        }
                    }
                    $consumption = [];
                    foreach ($this->data["consumption"] as $k => $v) {
                        if ($v && !in_array($v, $consumption)) {
                            $consumption[] = $v;
                        }
                    }
                    ksort($consumption);
                    ksort($pay);
                    $save = ["pay" => $pay, "consumption" => $consumption, "onepay" => $this->data["onepay"], "add" => $this->data["prize_add"], "info" => $this->data["info"], "affiliates" => $this->data["affiliates"], "oneonpay" => $this->data["oneonpay"], "oneonconsumption" => $this->data["oneonconsumption"], "navLeft" => $this->data["navLeft"]];
                    \Think\Db::name("gzhx_activity")->where("id", "=", $_GET["id"])->update(["setting" => serialize($save)]);
                    $this->success("提交成功");
                    exit;
                    break;
                default:
                    $this->error($this->data["action"] . "参数不存在");
                    exit;
            }
        } else {
            $activity["setting"] = unserialize($activity["setting"]);
            $activity["setting"]["start_time"] = date("Y-m-d", $activity["setting"]["start_time"]);
            $activity["setting"]["end_time"] = date("Y-m-d", $activity["setting"]["end_time"]);
            $this->assign("Activity", $activity);
            $this->assign("Title", $activity["title"] . "活动设置");
            return $this->fetch("/activityset");
        }
    }
    public function index()
    {
        if (isset($_GET["id"])) {
            \Think\Db::name("gzhx_activity_group")->where("aid", 0)->update(["aid" => $_GET["id"]]);
            \Think\Db::name("gzhx_activity_prize_setting")->where("aid", 0)->update(["aid" => $_GET["id"]]);
            if (!empty($this->data)) {
                switch ($this->data["action"]) {
                    case "save":
                        $pay = [];
                        foreach ($this->data["pay"] as $k => $v) {
                            if ($v && !in_array($v, $pay)) {
                                $pay[] = $v;
                            }
                        }
                        $consumption = [];
                        foreach ($this->data["consumption"] as $k => $v) {
                            if ($v && !in_array($v, $consumption)) {
                                $consumption[] = $v;
                            }
                        }
                        ksort($consumption);
                        ksort($pay);
                        $save = ["title" => $this->data["title"], "start_time" => strtotime($this->data["start_time"]), "end_time" => strtotime($this->data["end_time"]), "pay" => $pay, "consumption" => $consumption, "onepay" => $this->data["onepay"], "add" => $this->data["prize_add"], "info" => $this->data["info"]];
                        \Think\Db::name("gzhx_activity")->insert(["plugin" => $this->PluginName, "setting" => serialize($save)], true);
                        $this->success("提交成功");
                        exit;
                        break;
                    case "delete":
                        if ($this->data["type"] == "product") {
                            \Think\Db::name("gzhx_activity_group")->where("id", "=", $this->data["data"]["id"])->delete();
                        } else {
                            \Think\Db::name("gzhx_activity_prize_setting")->where("id", "=", $this->data["data"]["id"])->delete();
                        }
                        $this->success("删除完成");
                        exit;
                        break;
                    case "product":
                        $this->data["data"]["plugin"] = $this->PluginName;
                        $g_name = \Think\Db::name("product_groups")->where("id", "=", $this->data["data"]["gid"])->value("name");
                        if (empty($this->data["data"]["name"])) {
                            $this->data["data"]["name"] = $g_name;
                        }
                        if (empty($this->data["data"]["id"])) {
                            $this->data["data"]["aid"] = $_GET["id"];
                            $this->data["data"]["id"] = \Think\Db::name("gzhx_activity_group")->insertGetId($this->data["data"]);
                        } else {
                            \Think\Db::name("gzhx_activity_group")->update($this->data["data"]);
                        }
                        $this->data["data"]["group_name"] = $g_name;
                        $this->success($this->data["data"]);
                        exit;
                        break;
                    case "prizesetting":
                        if (empty($this->data["data"]["name"])) {
                            $this->error("请输入奖品名称");
                            exit;
                        }
                        if (empty($this->data["data"]["winning"]) && $this->data["data"]["winning"] != 0) {
                            $this->error("请输入中奖率");
                            exit;
                        }
                        if (100 < floatval($this->data["data"]["winning"]) || floatval($this->data["data"]["winning"]) < 0) {
                            $this->error("中奖率0到100之间");
                            exit;
                        }
                        $this->data["data"]["plugin"] = $this->PluginName;
                        if (empty($this->data["data"]["id"])) {
                            $sum = intval(\Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName)->sum("winning"));
                            unset($this->data["data"]["id"]);
                            $this->data["data"]["id"] = \Think\Db::name("gzhx_activity_prize_setting")->insertGetId($this->data["data"]);
                            if (!\Think\Db::name("gzhx_prize")->where("prize_id", "=", $this->data["data"]["id"])->value("id")) {
                                \Think\Db::name("gzhx_prize")->insert(["uid" => 0, "prize_id" => $this->data["data"]["id"], "prize_name" => $this->data["data"]["name"], "user_name" => "***@qq.com", "add_time" => date("Y-m-d H:i:s"), "plugin" => $this->PluginName]);
                            }
                            $this->success($this->data["data"]);
                            exit;
                        }
                        $sum = intval(\Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName)->where("id", "<>", $this->data["data"]["id"])->sum("winning"));
                        \Think\Db::name("gzhx_activity_prize_setting")->update($this->data["data"]);
                        if (!\Think\Db::name("gzhx_prize")->where("prize_id", "=", $this->data["data"]["id"])->value("id")) {
                            \Think\Db::name("gzhx_prize")->insert(["uid" => 0, "prize_id" => $this->data["data"]["id"], "prize_name" => $this->data["data"]["name"], "user_name" => "***@qq.com", "add_time" => date("Y-m-d H:i:s"), "plugin" => $this->PluginName, "aid" => $_GET["id"]]);
                        }
                        $this->success($this->data["data"]);
                        exit;
                        break;
                    default:
                        $this->error($this->data["action"] . "参数不存在");
                        exit;
                }
            } else {
                $List = \Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName)->where("aid", "=", $_GET["id"])->order("ord asc,id asc")->select()->toArray();
                $Product = \Think\Db::name("gzhx_activity_group")->where("plugin", "=", $this->PluginName)->where("aid", "=", $_GET["id"])->order("ord asc")->select()->toArray();
                $this->assign("Title", "奖品设置");
                $this->assign("List", $List);
                $this->assign("Product", $Product);
                $this->assign("Groups", \Think\Db::name("product_groups")->select()->toArray());
                return $this->fetch("/index");
            }
        } else {
            header("HTTP/1.1 301 Moved Permanently");
            header("Location: ./addons?_plugin=turntable_gzhx&_controller=admin_index&_action=activity&languagesys=CN");
            exit;
        }
    }
    public function set()
    {
        if (empty($_GET["id"])) {
            $this->assign("msg", "参数错误");
            return $this->fetch("/error");
        }
        $prize_setting = \Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->find();
        if (empty($prize_setting)) {
            $this->assign("msg", "奖品不存在");
            return $this->fetch("/error");
        }
        if (!empty($this->data)) {
            $cycles = [];
            foreach ($this->data["cycles"] as $key => $value) {
                $cycles[] = $key;
            }
            $this->data["cycles"] = $cycles;
            \Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->update(["setting" => serialize($this->data)]);
            $this->success("设置成功");
            exit;
        } else {
            $prize_setting["setting"] = unserialize($prize_setting["setting"]);
            $cycles = ["monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付", "biennially" => "两年付", "triennially" => "三年付", "fourly" => "四年付", "fively" => "五年付"];
            $cycles_setting = $prize_setting["setting"]["cycles"];
            $cyclesArray = [];
            foreach ($cycles as $k => $v) {
                if (in_array($k, $cycles_setting)) {
                    $cyclesArray[] = ["name" => $k, "label" => $v, "checked" => "checked"];
                } else {
                    $cyclesArray[] = ["name" => $k, "label" => $v, "checked" => ""];
                }
            }
            if ($prize_setting["type"] == "优惠券") {
                $groups = \Think\Db::name("product_first_groups")->select()->toArray();
                $subGroup = \Think\Db::name("product_groups")->select()->toArray();
                foreach ($groups as $k => $v) {
                    foreach ($subGroup as $kk => $vv) {
                        if (strval($vv["gid"]) == strval($v["id"])) {
                            $groups[$k]["sub"][] = $vv;
                            unset($subGroup[$kk]);
                        }
                    }
                }
                $prize_setting["GroupSet"] = $groups;
                $prize_setting["ProductList"] = \Think\Db::name("products")->select()->toArray();
            }
            $this->assign("Title", $prize_setting["name"] . "设置");
            $this->assign("List", $prize_setting);
            $this->assign("cyclesArray", $cyclesArray);
            return $this->fetch("/set");
        }
    }
    public function product()
    {
        if (empty($_GET["id"])) {
            $this->assign("msg", "参数错误");
            return $this->fetch("/error");
        }
        $prize_setting = \Think\Db::name("gzhx_activity_group")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->find();
        if (empty($prize_setting)) {
            $this->assign("msg", "商品组不存在");
            return $this->fetch("/error");
        }
        if (!empty($this->data)) {
            $cycles1 = [];
            foreach ($this->data["setting"][0]["cycles"] as $key => $value) {
                $cycles1[] = $key;
            }
            $this->data["setting"][0]["cycles"] = $cycles1;
            $cycles2 = [];
            foreach ($this->data["setting"][1]["cycles"] as $key => $value) {
                $cycles2[] = $key;
            }
            $this->data["setting"][1]["cycles"] = $cycles2;
            \Think\Db::name("gzhx_activity_group")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["id"])->update(["setting" => serialize($this->data["setting"]), "propaganda" => $this->data["propaganda"]]);
            $this->success("设置成功");
            exit;
        } else {
            $prize_setting["setting"] = unserialize($prize_setting["setting"]);
            if (empty($prize_setting["setting"])) {
                $prize_setting["setting"] = [["name" => "商品一设置"], ["name" => "商品二设置"], ["name" => "商品三设置"], ["name" => "商品四设置"]];
            }
            if (count($prize_setting["setting"]) < 4) {
                for ($i = 4 - count($prize_setting["setting"]) + 1; $i <= 4; $i++) {
                    $prize_setting["setting"][] = ["name" => "商品" . $i . "设置"];
                }
            }
            $cycles = ["monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付", "biennially" => "两年付", "triennially" => "三年付", "fourly" => "四年付", "fively" => "五年付"];
            foreach ($prize_setting["setting"] as $kk => $vv) {
                $_cycles = $vv["cycles"];
                $cyclesArray = [];
                foreach ($cycles as $k => $v) {
                    if (in_array($k, $_cycles)) {
                        $cyclesArray[] = ["name" => $k, "label" => $v, "checked" => "checked"];
                    } else {
                        $cyclesArray[] = ["name" => $k, "label" => $v, "checked" => ""];
                    }
                }
                $prize_setting["setting"][$kk]["cyclesarray"] = $cyclesArray;
            }
            $this->assign("Title", $prize_setting["name"] . "设置");
            $this->assign("List", $prize_setting);
            $this->assign("ProductGroup", \Think\Db::name("product_groups")->select()->toArray());
            $this->assign("productArray", \Think\Db::name("products")->select()->toArray());
            return $this->fetch("/product");
        }
    }
    public function winningrecord()
    {
        $page = !intval($_GET["page"]) ? 1 : intval($_GET["page"]);
        if ($page < 1) {
            $page = 1;
        }
        $limit = 10;
        $M = \Think\Db::name("gzhx_activity_user")->alias("a")->leftJoin("gzhx_activity b", "a.aid=b.id")->leftJoin("clients c", "a.uid=c.id")->where("a.plugin", "=", $this->PluginName);
        if (!empty($_GET["uid"])) {
            $M = $M->where("a.uid", "=", $_GET["uid"]);
        }
        if (!empty($_GET["activity_id"])) {
            $M = $M->where("a.aid", "=", $_GET["activity_id"]);
        }
        if (!empty($_GET["keyword"])) {
            $M = $M->where("a.prize_name|a.msg|a.error", "LIKE", "%" . $_GET["keyword"] . "%");
        }
        $listM = $M;
        $count = $M->count();
        $list = $listM->field("a.*,b.title,c.username,c.id as c_id")->page($page . "," . $limit)->order("a.id desc")->select()->toArray();
        $this->assign("Title", "中奖记录");
        $this->assign("List", $list);
        $this->assign("Page", $page);
        $this->assign("PageSize", ceil($count / $limit));
        $this->assign("productArray", \Think\Db::name("products")->where("gid", "=", $prize_setting["gid"])->select()->toArray());
        $page_data = $_GET;
        unset($page_data["page"]);
        $this->assign("PageLink", http_build_query($page_data));
        return $this->fetch("/record");
    }
}

?>