<?php
namespace addons\turntable_gzhx\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public $data;
    public $PluginName = "TurntableGzhx";
    public function initialize()
    {
        parent::initialize();
        $this->data = $_POST;
    }
    public function success($arr)
    {
        echo json_encode(["status" => 1, "encrypt" => 1, "info" => $arr]);
        exit;
    }
    public function error($arr)
    {
        echo json_encode(["status" => 0, "info" => $arr]);
        exit;
    }
    public function index()
    {
        $uid = request()->uid;
        $page = !intval($_GET["page"]) ? 1 : intval($_GET["page"]);
        if ($page < 1) {
            $page = 1;
        }
        $limit = 10;
        $count = \Think\Db::name("gzhx_activity_user")->alias("a")->leftJoin("gzhx_activity b", "a.aid=b.id")->where("a.plugin", "=", $this->PluginName)->where("a.uid", "=", $uid)->count();
        $list = \Think\Db::name("gzhx_activity_user")->alias("a")->field("a.*,b.title")->leftJoin("gzhx_activity b", "a.aid=b.id")->where("a.uid", "=", $uid)->where("a.plugin", "=", $this->PluginName)->page($page . "," . $limit)->order("a.id desc")->select()->toArray();
        foreach ($list as $key => $item) {
            $p = NULL;
            preg_match("/【产品ID：(\\d+)】/isu", $item["error"], $p);
            if (!empty($p)) {
                $list[$key]["product_id"] = $p[1];
            }
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("status", "=", 2)->find();
        $aff = "";
        if (!empty($activity)) {
            $aff = \Think\Db::name("affiliates")->where("uid", "=", $uid)->value("url_identy");
            $activity["setting"] = unserialize($activity["setting"]);
        }
        $protocol = !empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https://" : "http://";
        $url = $protocol . $_SERVER["HTTP_HOST"];
        $this->assign("aff", $url . "/plugins/addons/turntable_gzhx/template/index.html?from=" . $aff);
        $this->assign("Title", "中奖记录");
        $this->assign("List", $list);
        $this->assign("Page", $page);
        $this->assign("PageSize", ceil($count / $limit));
        $this->assign("Activity", $activity);
        $page_data = $_GET;
        unset($page_data["page"]);
        $this->assign("PageLink", http_build_query($page_data));
        return $this->fetch("/index");
    }
    public function activity()
    {
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName);
        if (isset($_GET["activity_id"]) && is_numeric($_GET["activity_id"])) {
            $activity = $activity->where("id", $_GET["activity_id"]);
        } else {
            $activity = $activity->where("status", "=", 2);
        }
        $activity = $activity->order("id desc")->find();
        $activityList = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("status", "=", 2)->order("id desc")->limit(4)->select()->toArray();
        foreach ($activityList as $key => $value) {
            $activityList[$key]["out"] = ["start" => strtotime($value["start_time"]) - time(), "end" => strtotime($value["end_time"]) - time(), "info" => unserialize($value["setting"])];
        }
        $List = \Think\Db::name("gzhx_activity_prize_setting")->field("id,type,name,winning")->where("plugin", "=", $this->PluginName)->order("ord asc,id asc");
        $List = $List->where("aid", $activity["id"]);
        $List = $List->select()->toArray();
        $prize = 0;
        $Data = [];
        foreach ($List as $k => $v) {
            if (intval($v["winning"]) - 100 == 0) {
                $prize = 1;
            }
            $Data[] = ["id" => $v["id"], "name" => $v["name"], "type" => $v["type"]];
        }
        if ($prize == 0) {
            $Data[] = ["id" => 0, "name" => "谢谢惠顾", "type" => ""];
        }
        $activity["setting"] = unserialize($activity["setting"]);
        $activity["affiliates"] = $activity["setting"]["affiliates"];
        $uid = request()->uid;
        if (!empty($uid)) {
            $User = \Think\Db::name("clients")->where("id", "=", $uid)->find();
            $regAdd = false;
            if ($activity["setting"]["add"]["reg"] && 0 < $User["create_time"] - strtotime($activity["start_time"])) {
                $checkReg = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "reg")->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                if (empty($checkReg)) {
                    \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "reg", "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "新用户注册获得抽奖1次"]);
                    $regAdd = true;
                } else {
                    $regAdd = true;
                }
            }
            if (!$regAdd && $activity["setting"]["add"]["user"]) {
                $checkUser = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "user")->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                if (empty($checkUser)) {
                    \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "user", "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "老用户获得抽奖1次"]);
                }
            }
            if ($activity["setting"]["add"]["verified"]) {
                $checkVerified = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "verified")->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                if (empty($checkVerified)) {
                    $certifi_person = \Think\Db::name("certifi_person")->where("auth_user_id", "=", $uid)->where("status", "=", 1)->find();
                    if (empty($certifi_person)) {
                        $certifi_person = \Think\Db::name("certifi_company")->where("auth_user_id", "=", $uid)->where("status", "=", 1)->find();
                    }
                    if ($certifi_person) {
                        \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "verified", "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "实名认证获得抽奖1次"]);
                    }
                }
            }
            if (!empty($activity["setting"]["onepay"])) {
                $invoices = \Think\Db::name("invoices")->where("type", "=", "recharge")->where("payment_status", "=", "Paid")->where("uid", "=", $uid)->where("total", ">=", $activity["setting"]["onepay"])->where("paid_time", ">=", strtotime($activity["start_time"]))->select()->toArray();
                foreach ($invoices as $k => $v) {
                    if (!strstr($v["notes"], $this->PluginName . "抽奖")) {
                        $checkInvoices = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "onepay#" . $v["id"])->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                        if (empty($checkInvoices)) {
                            \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "onepay#" . $v["id"], "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "单笔充值满" . $activity["setting"]["onepay"] . "元获得抽奖1次"]);
                        }
                    }
                }
            }
            if (!empty($activity["setting"]["oneonpay"])) {
                $invoices = \Think\Db::name("invoices")->where("type", "=", "recharge")->where("payment_status", "=", "Paid")->where("uid", "=", $uid)->where("paid_time", ">=", strtotime($activity["start_time"]))->sum("total");
                $oneOnPayLength = floor($invoices / ceil($activity["setting"]["oneonpay"]));
                for ($i = 1; $i <= $oneOnPayLength; $i++) {
                    $v = $i * ceil($activity["setting"]["oneonpay"]);
                    $checkInvoices = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "totalonpay#" . $v)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                    if (empty($checkInvoices)) {
                        \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "totalonpay#" . $v, "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "累计充值满" . $v . "元获得抽奖1次"]);
                    }
                }
            }
            if (!empty($activity["setting"]["oneonconsumption"])) {
                $invoices = \Think\Db::name("invoices")->where("type", "in", ["product", "upgrade", "renew"])->where("uid", "=", $uid)->where("payment_status", "=", "Paid")->where("paid_time", ">=", strtotime($activity["start_time"]))->sum("credit");
                $oneOnPayLength = floor($invoices / ceil($activity["setting"]["oneonconsumption"]));
                for ($i = 1; $i <= $oneOnPayLength; $i++) {
                    $v = $i * ceil($activity["setting"]["oneonconsumption"]);
                    $checkInvoices = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "oneonconsumption#" . $v)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                    if (empty($checkInvoices)) {
                        \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "oneonconsumption#" . $v, "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "累计消费" . $v . "元获得抽奖1次"]);
                    }
                }
            }
            if (!empty($activity["setting"]["pay"])) {
                $invoices = \Think\Db::name("invoices")->where("type", "=", "recharge")->where("uid", "=", $uid)->where("payment_status", "=", "Paid")->where("paid_time", ">=", strtotime($activity["start_time"]))->sum("total");
                foreach ($activity["setting"]["pay"] as $k => $v) {
                    if (!empty($v)) {
                        $checkInvoices = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "totalpay#" . $v)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                        if (empty($checkInvoices)) {
                            \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "totalpay#" . $v, "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "累计充值满" . $v . "元获得抽奖1次"]);
                        }
                    }
                }
            }
            if (!empty($activity["setting"]["consumption"][0])) {
                $productInvoices = \Think\Db::name("invoices")->where("type", "in", ["product", "upgrade", "renew"])->where("uid", "=", $uid)->where("payment_status", "=", "Paid")->where("paid_time", ">=", strtotime($activity["start_time"]))->sum("credit");
                foreach ($activity["setting"]["consumption"] as $k => $v) {
                    if (!empty($v)) {
                        $checkInvoices = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "consumption#" . $v)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
                        if (empty($checkInvoices)) {
                            \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "consumption#" . $v, "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "累计消费满" . $v . "元获得抽奖1次"]);
                        }
                    }
                }
            }
            $num = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("status", "=", 1)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->count() ?: 0;
        } else {
            $num = 99;
        }
        $product_setting_list = \Think\Db::name("gzhx_activity_group")->field("id,name,setting,propaganda,enterprise")->where("plugin", "=", $this->PluginName)->where("aid", $activity["id"])->order("ord asc,id asc")->select()->toArray();
        foreach ($product_setting_list as $k => &$v) {
            $prodoct_setting_data = unserialize($v["setting"]);
            foreach ($prodoct_setting_data as $kk => &$vv) {
                if (empty($vv["activity_num"])) {
                    $vv["received"] = 100;
                } else {
                    $vv["received"] = ceil((\Think\Db::name("gzhx_activity_user")->where("aid", "=", $activity["id"])->where("type", "=", "coupon#" . $v["id"] . "#" . $vv["pid"])->count() ?: 0) * 1000 / $vv["activity_num"]) / 10;
                }
            }
            $v["setting"] = $prodoct_setting_data;
        }
        $activityInfo = $activity;
        $activityInfo["info"] = $activity["setting"]["info"];
        $activityInfo["navLeft"] = $activity["setting"]["navLeft"] ? intval($activity["setting"]["navLeft"]) : 0;
        unset($activityInfo["setting"]);
        $affiliate = \Think\Db::name("configuration")->where("setting", "LIKE", "affiliate_%")->select()->toArray();
        $affiliateData = [];
        foreach ($affiliate as $kk => $vvv) {
            $affiliateData[$vvv["setting"]] = $vvv["value"];
        }
        unset($affiliateData["affiliate_withdraw"]);
        $outTimeConfig = ["day" => 0, "hour" => 0, "minute" => 0, "msecond" => 0];
        $startTime = strtotime($activityInfo["start_time"]) - time();
        $outTime = strtotime($activityInfo["end_time"]) - time();
        $outTimeConfig["msecond"] = $outTime * 100;
        $outTimeConfig["day"] = floor($outTime / 86400);
        if ($outTimeConfig["day"] < 10) {
            $outTimeConfig["day"] = "0" . $outTimeConfig["day"];
        }
        $outTimeConfig["hour"] = floor($outTime % 86400 / 3600);
        $outTimeConfig["minute"] = floor($outTime % 3600 / 60);
        if ($outTimeConfig["hour"] < 10) {
            $outTimeConfig["hour"] = "0" . $outTimeConfig["hour"];
        }
        if ($outTimeConfig["minute"] < 10) {
            $outTimeConfig["minute"] = "0" . $outTimeConfig["minute"];
        }
        $outTimeConfig["start"] = $startTime * 100;
        $activityInfo["out"] = $outTimeConfig;
        $data = ["uid" => $uid, "setting" => $Data, "product" => $product_setting_list, "affiliate" => $affiliateData, "num" => $num, "activity" => $activityInfo, "activityList" => $activityList, "prize" => \Think\Db::name("gzhx_activity_user")->field("user_name,prize_name")->where("plugin", "=", $this->PluginName)->where("status", "=", 2)->where("prize_id", ">", 0)->order("id desc")->limit(50)->select()->toArray()];
        $this->success($data);
    }
    public function affiliates()
    {
        $uid = request()->uid;
        if (empty($uid)) {
            $this->error("请先登录 ");
            exit;
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", $_GET["aid"])->find();
        if (empty($activity)) {
            $this->error("当前没有进行中的活动");
            exit;
        }
        if (time() - strtotime($activity["start_time"]) < 0) {
            $this->error("活动未开启");
            exit;
        }
        if (0 < time() - strtotime($activity["end_time"])) {
            \Think\Db::name("gzhx_activity")->where("id", "=", $activity["id"])->update(["status" => 1]);
            $this->error("活动已结束");
            exit;
        }
        $aff = "";
        if (!empty($activity)) {
            $aff = \Think\Db::name("affiliates")->where("uid", "=", $uid)->value("url_identy");
        }
        if (empty($aff)) {
            $this->error("请先点击<a href==\"/affiliates\" target=\"_bank\" style=\"color: #ff0000\">这里</a>申请推介者");
            exit;
        }
        $this->success($aff);
        exit;
    }
    public function createNonceStr($length = 16)
    {
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $str = "";
        for ($i = 0; $i < $length; $i++) {
            $str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
        }
        return $str;
    }
    public function coupon()
    {
        $uid = request()->uid;
        if (empty($uid)) {
            $this->error("请先登录 ");
            exit;
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $_POST["aid"])->find();
        if (empty($activity)) {
            $this->error("当前没有进行中的活动");
            exit;
        }
        if (time() - strtotime($activity["start_time"]) < 0) {
            $this->error("活动未开启");
            exit;
        }
        if (0 < time() - strtotime($activity["end_time"])) {
            \Think\Db::name("gzhx_activity")->where("id", "=", $activity["id"])->update(["status" => 1]);
            $this->error("活动已结束");
            exit;
        }
        if (empty($this->data["id"])) {
            $this->error("参数错误");
            exit;
        }
        $prize_setting = \Think\Db::name("gzhx_activity_group")->where("plugin", "=", $this->PluginName)->where("id", "=", $this->data["id"])->where("aid", "=", $activity["id"])->find();
        if (empty($prize_setting)) {
            $this->error("商品不存在");
            exit;
        }
        $User = \Think\Db::name("clients")->where("id", "=", $uid)->find();
        if (empty($User["email"]) && empty($User["phonenumber"])) {
            $this->error("请先绑定手机或邮箱 ");
            exit;
        }
        if (!empty($User["phonenumber"])) {
            $user_name = mb_substr($User["phonenumber"], 0, 5, "utf-8") . "******";
        } else {
            $len = strstr($User["email"], "@");
            $user_name = "******" . mb_substr($User["email"], $len, NULL, "utf-8");
        }
        $prize_setting["setting"] = unserialize($prize_setting["setting"]);
        $setting = $prize_setting["setting"][$this->data["sid"]];
        $this->data["pid"] = $setting["pid"];
        if (empty($setting)) {
            $this->error("活动商品出错，请联系管理人员");
            exit;
        }
        if ($setting["utype"] == "2") {
            $checkInvoicesUtypeOrder = \Think\Db::name("orders")->where("uid", "=", $uid)->whereRaw("(status='Active' OR status='Completed')")->find();
            if (!empty($checkInvoicesUtypeOrder)) {
                $this->error("当前产品为新用户专享，您不符合条件！");
                exit;
            }
            $checkInvoicesUtype = \Think\Db::name("gzhx_activity_user")->alias("a")->join("promo_code b", "a.code=b.code")->where("a.uid", "=", $uid)->whereLike("a.type", "coupon%")->where("a.plugin", "=", $this->PluginName)->where("b.expiration_time", ">", time())->find();
            if (!empty($checkInvoicesUtype)) {
                $this->error("当前产品为新用户专享，您不符合条件！");
                exit;
            }
        } else {
            if ($setting["utype"] == "3") {
                $checkInvoicesUtypeOrder = \Think\Db::name("invoice_items")->alias("a")->join("invoices b", "a.invoice_id=b.id")->where("a.uid", "=", $uid)->where("b.status", "Paid")->find();
                if (!empty($checkInvoicesUtypeOrder)) {
                    $this->error("当前产品为首单特惠，您已购买过此商品，无法参与！");
                    exit;
                }
                $checkInvoicesUtype = \Think\Db::name("gzhx_activity_user")->alias("a")->join("promo_code b", "a.code=b.code")->where("a.uid", "=", $uid)->whereLike("b.appliesto", $this->data["pid"])->where("a.plugin", "=", $this->PluginName)->where("b.expiration_time", ">", time())->find();
                if (!empty($checkInvoicesUtype)) {
                    $this->error("当前产品为首单特惠，您有此商品的优惠券未使用，无法参与！");
                    exit;
                }
            }
        }
        if ($prize_setting["enterprise"] == 1) {
            $certifi_person = \Think\Db::name("certifi_person")->where("auth_user_id", "=", $uid)->where("status", "=", 1)->find();
            if (empty($certifi_person)) {
                $this->error("当前优惠券为个人专享，请先完成个人实名认证");
                exit;
            }
        } else {
            if ($prize_setting["enterprise"] == 2) {
                $certifi_person = \Think\Db::name("certifi_company")->where("auth_user_id", "=", $uid)->where("status", "=", 1)->find();
                if (empty($certifi_person)) {
                    $this->error("当前优惠券为企业专享，请先完成企业实名认证");
                    exit;
                }
            }
        }
        $checkInvoices = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("type", "=", "coupon#" . $this->data["id"] . "#" . $this->data["pid"])->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->find();
        if (!empty($checkInvoices)) {
            $this->success(["msg" => "您已领取[" . $prize_setting["name"] . "]优惠券<br>" . $checkInvoices["code"] . "<br>，快去购买商品吧", "pid" => $this->data["pid"], "code" => $checkInvoices["code"]]);
            exit;
        }
        $allNum = \Think\Db::name("gzhx_activity_user")->where("aid", "=", $activity["id"])->where("type", "=", "coupon#" . $this->data["id"] . "#" . $this->data["pid"])->count() ?: 0;
        if (0 <= intval($allNum) - intval($setting["activity_num"])) {
            $this->error("此商品优惠券被抢光了");
            exit;
        }
        $code = $this->createNonceStr(7);
        $promo_code = ["type" => $setting["type"], "value" => $setting["value"], "recurring" => 0, "start_time" => time(), "max_times" => 1, "one_time" => 1, "once_per_client" => 1, "appliesto" => $this->data["pid"], "notes" => $uid . "[" . $User["username"] . "]活动领取(" . $setting["label"] . ")", "code" => $code];
        if (intval($setting["time_out"]) == 1) {
            $promo_code["expiration_time"] = strtotime("+" . $setting["time_out_day"] . " day", time());
        } else {
            $promo_code["expiration_time"] = strtotime($setting["time_out_date"] . ":00");
        }
        if (\Think\Db::name("promo_code")->insert($promo_code)) {
            \Think\Db::name("gzhx_activity_user")->insert(["uid" => $uid, "type" => "coupon#" . $this->data["id"] . "#" . $this->data["pid"], "plugin" => $this->PluginName, "aid" => $activity["id"], "msg" => "领取优惠券", "error" => "领取优惠券成功【产品ID：" . $this->data["pid"] . "】", "status" => 2, "prize_id" => $this->data["id"], "add_time" => date("Y-m-d H:i:s"), "user_name" => $user_name, "prize_name" => $setting["label"], "code" => $code]);
            $this->success(["msg" => "您已领取[" . $prize_setting["name"] . "]优惠券<br>" . $code . "<br>，快去购买商品吧", "pid" => $this->data["pid"], "code" => $code]);
            exit;
        }
        $this->error("系统错误，请联系管理员处理");
        exit;
    }
    public function prize()
    {
        $uid = request()->uid;
        if (empty($uid)) {
            $this->error("请先登录 ");
            exit;
        }
        $activity = \Think\Db::name("gzhx_activity")->where("plugin", "=", $this->PluginName)->where("id", "=", $_GET["aid"])->find();
        if (empty($activity)) {
            $this->error("当前没有进行中的活动");
            exit;
        }
        if (time() - strtotime($activity["start_time"]) < 0) {
            $this->error("活动未开启");
            exit;
        }
        if (0 < time() - strtotime($activity["end_time"])) {
            \Think\Db::name("gzhx_activity")->where("id", "=", $activity["id"])->update(["status" => 1]);
            $this->error("活动已结束");
            exit;
        }
        $User = \Think\Db::name("clients")->where("id", "=", $uid)->find();
        if (empty($User["email"]) && empty($User["phonenumber"])) {
            $this->error("请先绑定手机或邮箱 ");
            exit;
        }
        if (!empty($User["phonenumber"])) {
            $user_name = mb_substr($User["phonenumber"], 0, 5, "utf-8") . "******";
        } else {
            $len = strstr($User["email"], "@");
            $user_name = "******" . mb_substr($User["email"], $len, NULL, "utf-8");
        }
        $num = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("status", "=", 1)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->count() ?: 0;
        if ($num < 1) {
            $this->error("没有抽奖次数啦");
            exit;
        }
        $List = \Think\Db::name("gzhx_activity_prize_setting")->field("id,winning,name")->where("plugin", "=", $this->PluginName)->order("winning asc,id asc")->where("aid", "=", $activity["id"])->select()->toArray();
        if (empty($List)) {
            $this->error("奖品出错");
            exit;
        }
        $last_names = array_column($List, "winning");
        array_multisort($last_names, SORT_DESC, $List);
        $max_prize = $List[0];
        if (intval($max_prize["winning"]) != 100) {
            $List[] = ["id" => 0, "winning" => 100];
        }
        $prize = NULL;
        foreach ($List as $k => $v) {
            if (0 < intval($v["winning"])) {
                $n = ceil(100 / $v["winning"]);
                $lasid = \Think\Db::name("gzhx_activity_user")->where("prize_id", "=", $v["id"])->order("id desc")->value("id") ?: 0;
                $last_prize = \Think\Db::name("gzhx_activity_user")->where("id", ">", $lasid)->where("prize_id", ">", 0)->count();
                if ($n < $last_prize) {
                    $prize = $v;
                    if (empty($prize)) {
                        $prize = end($List);
                    }
                    $NumberOfDraws = \Think\Db::name("gzhx_activity_user")->where("uid", "=", $uid)->where("status", "=", 1)->where("plugin", "=", $this->PluginName)->where("aid", "=", $activity["id"])->order("id asc")->find();
                    \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["status" => 2, "prize_id" => $prize["id"], "add_time" => date("Y-m-d H:i:s"), "user_name" => $user_name, "plugin" => $this->PluginName, "prize_name" => $prize["name"]]);
                    $msg = "";
                    if (0 < $prize["id"]) {
                        $prize["status"] = 1;
                        $prize["msg"] = "恭喜您已抽中[" . $prize["name"] . "]，奖品已成功发放";
                        $prize_setting = \Think\Db::name("gzhx_activity_prize_setting")->where("plugin", "=", $this->PluginName)->where("id", "=", $prize["id"])->find();
                        if (empty($prize_setting)) {
                            \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "奖品未找到"]);
                            $prize["status"] = 0;
                            $prize["msg"] = "您已抽中[" . $prize["name"] . "]，但是系统错误，请联系管理员处理 ";
                            $this->success($prize);
                            exit;
                        }
                        $prize_setting["setting"] = unserialize($prize_setting["setting"]);
                        if (empty($prize_setting["setting"])) {
                            \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "奖品未配置"]);
                            $prize["status"] = 0;
                            $prize["msg"] = "您已抽中[" . $prize["name"] . "]，但是系统错误，请联系管理员处理 ";
                            $this->success($prize);
                            exit;
                        }
                        $setting = $prize_setting["setting"];
                        if ($prize_setting["type"] == "优惠券") {
                            $code = $this->createNonceStr(10);
                            $promo_code = ["type" => $setting["type"], "value" => $setting["value"], "recurring" => 0, "start_time" => time(), "max_times" => 1, "one_time" => 1, "once_per_client" => 1, "notes" => $uid . "[" . $User["username"] . "]大转盘抽奖", "code" => $code];
                            if (intval($setting["time_out"]) == 1) {
                                $promo_code["expiration_time"] = strtotime("+" . $setting["time_out_day"] . " day", time());
                            } else {
                                $promo_code["expiration_time"] = strtotime($setting["time_out_date"] . ":00");
                            }
                            if (!empty($setting["product_id"])) {
                                $promo_code["appliesto"] = $setting["product_id"];
                            }
                            if (\Think\Db::name("promo_code")->insert($promo_code)) {
                                \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "奖品发放成功" . (empty($setting["product_id"]) ? "" : "【产品ID：" . $setting["product_id"] . "】") . "", "code" => $code]);
                                $prize["status"] = 1;
                                $prize["msg"] = "您已抽中[" . $prize["name"] . "]，奖品已成功发放";
                                $this->success($prize);
                                exit;
                            }
                            \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "生成优惠码失败", "code" => $code]);
                            $prize["status"] = 0;
                            $prize["msg"] = "您已抽中[" . $prize["name"] . "]，但是系统错误，请联系管理员处理 ";
                            $this->success($prize);
                            exit;
                        }
                        if ($prize_setting["type"] == "余额红包") {
                            $invoice_id = \Think\Db::name("invoices")->insertGetId(["uid" => $uid, "create_time" => time(), "update_time" => time(), "due_time" => time(), "subtotal" => $setting["value"], "total" => $setting["value"], "status" => "Unpaid", "payment" => "Payssion", "type" => "recharge", "notes" => $this->PluginName . "抽奖"]);
                            if ($invoice_id) {
                                $invoice_item_id = \Think\Db::name("invoice_items")->insertGetId(["uid" => $uid, "invoice_id" => $invoice_id, "type" => "recharge", "description" => "大转盘抽奖", "description2" => "大转盘抽奖", "amount" => $setting["value"], "due_time" => time()]);
                                if ($invoice_item_id) {
                                    $order_data = ["invoice_id" => $invoice_id, "trans_id" => "#" . date("YmdHis") . mt_rand(100, 9999), "currency" => "-", "payment" => "Payssion", "amount_in" => $setting["value"], "paid_time" => date("Y-m-d H:i:s")];
                                    $Order = new \app\home\controller\OrderController();
                                    $Order->orderPayHandle($order_data, empty($payinfo["pay_type"]) ? "credit_pay" : $payinfo["pay_type"]);
                                    \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "奖品发放成功"]);
                                    $prize["status"] = 1;
                                    $prize["msg"] = "您已抽中[" . $prize["name"] . "]，奖品已成功发放";
                                    $this->success($prize);
                                    exit;
                                }
                                \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "生成账单失败"]);
                                $prize["status"] = 0;
                                $prize["msg"] = "您已抽中[" . $prize["name"] . "]，但是系统错误，请联系管理员处理 ";
                                $this->success($prize);
                                exit;
                            }
                            \Think\Db::name("gzhx_activity_user")->where("id", "=", $NumberOfDraws["id"])->update(["error" => "生成账单失败"]);
                            $prize["status"] = 0;
                            $prize["msg"] = "您已抽中[" . $prize["name"] . "]，但是系统错误，请联系管理员处理 ";
                            $this->success($prize);
                            exit;
                        }
                    } else {
                        $prize["status"] = 1;
                        $prize["msg"] = NULL;
                    }
                    $this->success($prize);
                }
            }
        }
    }
}

?>