
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>


                    <div class="tab-content mt-4">
                        <div class="table-body"><form class="form cycles-setting">
                            {eq name="List.type" value="优惠券"}
                                    <div class="form-group row">
                                        <label class="require">类型
                                            <i class="far fa-question-circle" style="color: blue;" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-html="true" data-original-title="<em>Tooltip</em> <u>with</u> <b>HTML</b>"></i>
                                        </label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="type" required>
                                                <option value="percent" {eq name="List.setting.type" value="percent"}selected{/eq}>百分比</option>
                                                <option value="fixed" {eq name="List.setting.type" value="fixed"}selected{/eq}>固定金额</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="require">价值</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" name="value" value="{$List.setting.value}" required>
                                        </div>
                                    </div>


                                    <div class="form-group row">
                                        <label>适用周期</label>
                                        <div class="col-sm-4">
                                            {foreach $cyclesArray as $k=>$v}
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" id="cyclesArray{$k}" value="{$v.name}" name="cycles[{$v.name}]" {$v.checked}>
                                                <label class="form-check-label" for="cyclesArray{$k}">{$v.label}</label>
                                            </div>
                                           {/foreach}
                                        </div>
                                    </div>
                                <div class="form-group row">
                                    <label>选择产品类目</label>
                                    <div class="col-sm-4">

                                        <select class="form-control" name="product_group">
                                            <option value="">商品类目(可选)</option>
                                            {foreach $List.GroupSet as $k=>$v}
                                                <optgroup label="{$v.name}"></optgroup>
                                            {foreach $v.sub as $kk=>$vv}
                                                <option value="{$vv.id}" {eq name="List.setting.product_group" value="$vv['id']"}selected{/eq}>{$vv.name}</option>
                                            {/foreach}
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label>指定使用产品</label>
                                    <div class="col-sm-4">

                                        <select class="form-control" name="product_id">
                                            <option value="">产品选择(可选)</option>
                                            {foreach $List.ProductList as $kk=>$vv}
                                                <option value="{$vv.id}" data-gid="{$vv.gid}" {eq name="List.setting.product_id" value="$vv['id']"}selected{/eq}>{$vv.name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                                    <div class="form-group row">
                                        <label>有效期类型</label>
                                        <div class="col-sm-4">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" id="inlineTimeOut1" value="1" name="time_out" required  {eq name="List.setting.time_out" value="1"}checked{/eq}>
                                                <label class="form-check-label" for="inlineTimeOut1">中奖后N天内使用</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" id="inlineTimeOut2" value="2" name="time_out" required {eq name="List.setting.time_out" value="2"}checked{/eq}>
                                                <label class="form-check-label" for="inlineTimeOut2">自定到期日期</label>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="require">天数</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" name="time_out_day" value="{$List.setting.time_out_day}">
                                        </div>
                                    </div>


                                    <div class="form-group row">
                                        <label class="require">固定有效期</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control v-input-date" name="time_out_date" value="{$List.setting.time_out_date}">
                                        </div>
                                    </div>

                            {/eq}
                                {eq name="List.type" value="余额红包"}

                                    <div class="form-group row">
                                        <label class="require">价值</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" name="value" value="{$List.setting.value}" required>
                                        </div>
                                    </div>


                                {/eq}
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-primary w-md">保存更改</button>
                                        <button type="submit" class="btn btn-outline-secondary w-md">取消更改</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    $(function (){
        $('input.v-input-date').datetimepicker({
            minView: "month", //选择日期后，不会再跳转去选择时分秒
            language:  'zh-CN',
            format: 'yyyy-mm-dd',
            todayBtn:  1,
            autoclose: 1,
        });
        let ajax=function (option){
            $.ajax({
                    dataType: "json",
                    type: option.type||"post",

                    headers: {
                        "X-Requested-With": "XMLHttpRequest",

                    },
                    url: option.url||"",
                    data:option.data,
                    async:true,
                    success: function (t) {



                        if( t.status==1 ){
                            if(option.success)  option.success(t.info);
                        }else{
                            if(option.error){
                                option.error(t.info)
                            }else{
                                $('#renewMsg').html(t.info);
                            }
                        }
                    },

                    error: function (request, status, errorThrown) {
                        if(option.error){ option.error("网络错误，请重试") }else{
                            $('#renewMsg').html("网络错误，请重试");
                        }
                    }
                }
            );
        }
        $('select[name="product_group"]').off("change").on("change",function () {
            let val=$(this).val();

            if(val){
                $('select[name="product_id"]>option').show();
                $('select[name="product_id"]>option[data-gid!="'+val+'"]').hide();
            }else{
                $('select[name="product_id"]>option').show();
            }
        })
        $('.cycles-setting').on('submit',function (){
            let object={ },data=$(this).serializeArray();
            $.each( data,function (k,v){
                object[ v.name ]=v.value;
            } )
            if(object.time_out){
                if(object.time_out.toString()=="2"){
                    if(!object.time_out_date){
                        $('input[name="time_out_date"]').focus();
                        return false;
                    }
                }else{
                    if(!object.time_out_day){
                        $('input[name="time_out_day"]').focus();
                        return false;
                    }
                }
            }

            ajax({
                data:object,
                success:function (res){
                    $('#renewMsg').html(res);
                    top.location.href="addons?_plugin=turntable_gzhx&_controller=admin_index&_action=index";
                }
            })
            return false;
        })
    })
</script>

