<?php
namespace addons\wechat_gzhx;
use app\admin\lib\Plugin;
use Think\Exception;
use Think\Db;

class WechatGzhxPlugin extends Plugin
{
    # 插件基本信息
    public $info = array(
        'name'        => 'WechatGzhx',
        'title'       => '微信助理',
        'description' => '微信助理',
        'status'      => 1,
        'author'      => 'GZHX Technology',
        'version'     => '1.0.5',
        'module'     => 'addons',
        'update_description'=>'修复已知BUG'
    );

    # 插件安装
    public function install()
    {
        $DbConfig=Db::getConfig();

        $CacheDbName=$DbConfig["prefix"]."wechat_uid";
        $LogDbName=$DbConfig["prefix"]."gzhx_wechat_log";

        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`uid` int(11) NOT NULL,`config` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,`openid` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`nickname` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,PRIMARY KEY (`uid`) USING BTREE,UNIQUE INDEX `uid`(`uid`) USING BTREE,INDEX `openid`(`openid`) USING BTREE) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        if( !in_array($LogDbName,$tableList) ){
            Db::query("CREATE TABLE `{$LogDbName}`  (`id` int(11) NOT NULL AUTO_INCREMENT,`add_time` datetime(0) NULL DEFAULT NULL,`openid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,`text` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,`result` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,PRIMARY KEY (`id`) USING BTREE) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        }
        $hookType=Db::name("plugin")->getFieldsType('',"hooks");
        if( strtolower($hookType)=='varchar(255)' ){

            Db::query("alter table {$DbConfig["prefix"]}plugin modify column hooks varchar(4000) ;");
        }
        return true;
    }
    # 插件卸载
    public function uninstall()
    {
        return true;
    }
    public function curl($path,$data=[]){
        $data['backurl']=Db::name("configuration")->where("setting","=","domain")->value("value");
        $data['webname']=Db::name("configuration")->where("setting","=","company_name")->value("value");
        $data['uuid']=Db::name("configuration")->where("setting","=","system_license")->value("value");
        $iv = mb_substr(md5(mt_rand(1000000000000000,9999999999999999)),0,16);
        $ch = curl_init();
        $header = array(
            "HostAPI: idcsmart.com",
            "HostAPIIP: " . $_SERVER["SERVER_ADDR"],
            "HostAPISITE: " . $_SERVER["HTTP_HOST"],
            "Content-Type: application/json; charset=UTF-8",
            "X-Requested-With: XMLHttpRequest"
        );
        curl_setopt($ch, CURLOPT_URL, "https://connect.03s.cn/Wechat/{$path}");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            'data'=>base64_encode(openssl_encrypt(json_encode($data), 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, $iv)),
            'iv'=>$iv
        ]) );
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        $this->debugLog([
            'host'=>$result
        ]);
        $data=json_decode($result,true);
        if(empty($data)){
            return [
                'status'=>0,
                'info'=>empty($curl_error)?'未知错误':$curl_error
            ];

        }

        return $data;
    }

    public function getUrl()
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $url = $protocol . $_SERVER['HTTP_HOST'];
        return $url;
    }


    public function ticketOpen($param){
        $openid=null;
        $configuration= Db::name("configuration")->select()->toArray();
        $configuration=array_column($configuration,null,'setting');
        $data=[
            'technology'=>unserialize(base64_decode($configuration['gzhx_wechat_technology']['value'])),
            'finance'=>unserialize(base64_decode($configuration['gzhx_wechat_finance']['value'])),
            'consult'=>unserialize(base64_decode($configuration['gzhx_wechat_consult']['value'])),
        ];
        $type="";
        switch ($param['dptname']){
            case '技术部门':$openid=$data['technology'];$type='technology';break;
            case '售前咨询':$openid=$data['consult'];$type='consult';break;
            case '财务部门':$openid=$data['finance'];$type='finance';break;
        }
        if(empty($openid)){
            $sendOpenid=['member'];
            $type='member';
        }else{
            $sendOpenid=array_column($openid,'openid');
        }
        if(empty($sendOpenid)){
            $sendOpenid=['member'];
        }
        $cilents=Db::name('clients')->where("id","=",$param['uid'])->value("username");
        foreach ($sendOpenid as $item){
            $option=[
                'array'=>array(
                    "first"=>array("value"=>"{$param['title']}","color"=>"#173177"),
                    "keyword1"=>array("value"=>"{$param['dptname']}","color"=>"#173177"),
                    "keyword2"=>array("value"=>date("Y-m-d H:i:s"),"color"=>"#173177"),
                    "keyword3"=>array("value"=>$cilents,"color"=>"#173177"),
                    "remark"=>array("value"=>"ID:{$param['ticketid']} 内容：{$param['content']}","color"=>"#173177"),
                ),
                'openid'=>$item,
                'tpl'=>"ticketOpen",
                'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=member&id=".bin2hex(openssl_encrypt(serialize([
                    'openid'=>$item,
                    'type'=>$type,
                    'url'=>"#/support-ticket-detail?id={$param['ticketid']}&tid={$param['tid']}"
                    ]), 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, 'A09VB9PXBXJZ7834'))
            ];
            $resultData= $this->curl("send",[
                'msg'=>base64_encode(serialize($option))
            ]);
            if($resultData['status']==1){
                Db::name("gzhx_wechat_log")->insert($resultData['info']);
            }else{
                Db::name("gzhx_wechat_log")->insert([
                    'add_time'=>date("Y-m-d H:i:s"),
                    'openid'=>$item,
                    'text'=>var_export($option['array'],true),
                    'result'=>$resultData['info'],
                ]);
            }

        }
    }
    public function ticketUserReply($param){
        $openid=null;
        $configuration= Db::name("configuration")->select()->toArray();
        $configuration=array_column($configuration,null,'setting');
        $data=[
            'technology'=>unserialize(base64_decode($configuration['gzhx_wechat_technology']['value'])),
            'finance'=>unserialize(base64_decode($configuration['gzhx_wechat_finance']['value'])),
            'consult'=>unserialize(base64_decode($configuration['gzhx_wechat_consult']['value'])),
        ];
        $type="";
        switch ($param['dptname']){
            case '技术部门':$openid=$data['technology'];$type='technology';break;
            case '售前咨询':$openid=$data['consult'];$type='consult';break;
            case '财务部门':$openid=$data['finance'];$type='finance';break;
        }
        if(empty($openid)){
            $sendOpenid=['member'];
            $type='member';
        }else{
            $sendOpenid=array_column($openid,'openid');
        }
        if(empty($sendOpenid)){
            $sendOpenid=['member'];
        }
        $cilents=Db::name('clients')->where("id","=",$param['uid'])->value("username");
        foreach ($sendOpenid as $item){
            $option=[
                'array'=>array(
                    "first"=>array("value"=>"{$param['title']}","color"=>"#173177"),
                    "keyword1"=>array("value"=>"{$param['dptname']}","color"=>"#173177"),
                    "keyword2"=>array("value"=>date("Y-m-d H:i:s"),"color"=>"#173177"),
                    "keyword3"=>array("value"=>$cilents,"color"=>"#173177"),
                    "remark"=>array("value"=>"ID:{$param['ticketid']} 内容：{$param['content']}","color"=>"#173177"),
                ),
                'openid'=>$item,
                'tpl'=>"ticketOpen",
                'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=member&id=".bin2hex(openssl_encrypt(serialize([
                        'openid'=>$item,
                        'type'=>$type,
                        'url'=>"#/support-ticket-detail?id={$param['ticketid']}"
                    ]), 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, 'A09VB9PXBXJZ7834'))
            ];
            $resultData= $this->curl("send",[
                'msg'=>base64_encode(serialize($option))
            ]);
            if($resultData['status']==1){
                Db::name("gzhx_wechat_log")->insert($resultData['info']);
            }else{
                Db::name("gzhx_wechat_log")->insert([
                    'add_time'=>date("Y-m-d H:i:s"),
                    'openid'=>$item,
                    'text'=>var_export($option['array'],true),
                    'result'=>$resultData['info'],
                ]);
            }
        }
    }
    public function ticketClose($param){
        if(!file_exists(CMF_DATA."key.key")){
            file_put_contents(CMF_DATA."key.key",time());
        }

        $key=file_get_contents(CMF_DATA."key.key");
       foreach ($param['ticketid'] as $ticketid){
            $ticket=Db::name("ticket")->alias("a")
                ->field("b.config,b.openid,a.tid,a.c,a.title,a.uid")
                ->join('wechat_uid b',"a.uid=b.uid")
                ->where("a.id","=",$ticketid)
                ->find();
            if(!empty($ticket)&&!empty($ticket['config'])&&!empty($ticket['openid'])){
                $wechatConfig=explode(",",$ticket['config']);
                $content=mb_substr(strip_tags($param['content']),0,50,"UTF-8");
                if(in_array('ticketClose',$wechatConfig)){
                    $option=[
                        'array'=>array(
                            "first"=>array("value"=>"{$ticket['title']}","color"=>"#173177"),
                            "keyword1"=>array("value"=>"{$ticket['tid']}","color"=>"#173177"),
                            "keyword2"=>array("value"=>"关闭工单","color"=>"#173177"),
                            "keyword3"=>array("value"=>"管理员","color"=>"#173177"),
                            "remark"=>array("value"=>"工单已关闭","color"=>"#173177"),
                        ),
                        'openid'=>$ticket['openid'],
                        'tpl'=>"ticketAdmin",
                        'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=touser&id=".bin2hex(openssl_encrypt(serialize([
                                'uid'=>$ticket['uid'],
                                'url'=>"/viewticket?tid={$ticket['tid']}&c={$ticket['c']}"
                            ]), 'aes-128-cbc', 'A79VB9PXBXJZ7834', true, mb_substr(md5($key),8,16)))
                    ];
                    $resultData= $this->curl("send",[
                        'msg'=>base64_encode(serialize($option))
                    ]);
                    if($resultData['status']==1){
                        Db::name("gzhx_wechat_log")->insert($resultData['info']);
                    }else{
                        Db::name("gzhx_wechat_log")->insert([
                            'add_time'=>date("Y-m-d H:i:s"),
                            'openid'=>$ticket['openid'],
                            'text'=>var_export($option['array'],true),
                            'result'=>$resultData['info'],
                        ]);
                    }
                }

            }
        }
    }
    public function ticketStatusChange($param){
        if(!file_exists(CMF_DATA."key.key")){
            file_put_contents(CMF_DATA."key.key",time());
        }

        $key=file_get_contents(CMF_DATA."key.key");
        foreach ($param['ticketid'] as $ticketid){
            $ticket=Db::name("ticket")->alias("a")
                ->field("b.config,b.openid,a.tid,a.c,a.title,a.uid")
                ->join('wechat_uid b',"a.uid=b.uid")
                ->where("a.id","=",$ticketid)
                ->find();
            if(!empty($ticket)&&!empty($ticket['config'])&&!empty($ticket['openid'])){
                $wechatConfig=explode(",",$ticket['config']);
                $content=mb_substr(strip_tags($param['content']),0,50,"UTF-8");
                if(in_array('ticketStatusChange',$wechatConfig)){
                    $option=[
                        'array'=>array(
                            "first"=>array("value"=>"{$ticket['title']}","color"=>"#173177"),
                            "keyword1"=>array("value"=>"{$ticket['tid']}","color"=>"#173177"),
                            "keyword2"=>array("value"=>"{$param['status_title']}","color"=>"#173177"),
                            "keyword3"=>array("value"=>"管理员","color"=>"#173177"),
                            "remark"=>array("value"=>"工单状态变更","color"=>"#173177"),
                        ),
                        'openid'=>$ticket['openid'],
                        'tpl'=>"ticketAdmin",
                        'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=touser&id=".bin2hex(openssl_encrypt(serialize([
                                'uid'=>$ticket['uid'],
                                'url'=>"/viewticket?tid={$ticket['tid']}&c={$ticket['c']}"
                            ]), 'aes-128-cbc', 'A79VB9PXBXJZ7834', true, mb_substr(md5($key),8,16)))
                    ];
                    $resultData= $this->curl("send",[
                        'msg'=>base64_encode(serialize($option))
                    ]);
                    if($resultData['status']==1){
                        Db::name("gzhx_wechat_log")->insert($resultData['info']);
                    }else{
                        Db::name("gzhx_wechat_log")->insert([
                            'add_time'=>date("Y-m-d H:i:s"),
                            'openid'=>$ticket['openid'],
                            'text'=>var_export($option['array'],true),
                            'result'=>$resultData['info'],
                        ]);
                    }
                }

            }
        }

    }
    public function ticketAdminReply($param){
        if(!file_exists(CMF_DATA."key.key")){
            file_put_contents(CMF_DATA."key.key",time());
        }

        $key=file_get_contents(CMF_DATA."key.key");
        $ticket=Db::name("ticket")->alias("a")
                ->field("b.config,b.openid,a.tid,a.c,a.uid")
                ->join('wechat_uid b',"a.uid=b.uid")
                ->where("a.id","=",$param['ticketid'])
                ->find();
        if(!empty($ticket)&&!empty($ticket['config'])&&!empty($ticket['openid'])){
            $wechatConfig=explode(",",$ticket['config']);
            $content=mb_substr(str_ireplace([" ","　","\r","\n","\t"],"",trim(strip_tags($param['content']))),0,50,"UTF-8");
            if(in_array('ticketAdminReply',$wechatConfig)){
                $option=[
                    'array'=>array(
                        "first"=>array("value"=>"{$param['title']}","color"=>"#173177"),
                        "keyword1"=>array("value"=>"{$ticket['tid']}","color"=>"#173177"),
                        "keyword2"=>array("value"=>"{$param['status_title']}","color"=>"#173177"),
                        "keyword3"=>array("value"=>"管理员","color"=>"#173177"),
                        "remark"=>array("value"=>$content,"color"=>"#173177"),
                    ),
                    'openid'=>$ticket['openid'],
                    'tpl'=>"ticketAdmin",
                    'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=touser&id=".bin2hex(openssl_encrypt(serialize([
                            'uid'=>$ticket['uid'],
                            'url'=>"/viewticket?tid={$ticket['tid']}&c={$ticket['c']}"
                        ]), 'aes-128-cbc', 'A79VB9PXBXJZ7834', true, mb_substr(md5($key),8,16)))
                ];
                $resultData= $this->curl("send",[
                    'msg'=>base64_encode(serialize($option))
                ]);
                if($resultData['status']==1){
                    Db::name("gzhx_wechat_log")->insert($resultData['info']);
                }else{
                    Db::name("gzhx_wechat_log")->insert([
                        'add_time'=>date("Y-m-d H:i:s"),
                        'openid'=>$ticket['openid'],
                        'text'=>var_export($option['array'],true),
                        'result'=>$resultData['info'],
                    ]);
                }
            }

        }
    }
    public function debugLog($msg){
       //   file_put_contents(dirname( __FILE__ )."/log.txt",var_export($msg,true).PHP_EOL."===================".PHP_EOL,FILE_APPEND);
    }
    public function OrderSuccess($option){
        if(!file_exists(CMF_DATA."key.key")){
            file_put_contents(CMF_DATA."key.key",time());
        }

        $key=file_get_contents(CMF_DATA."key.key");
        $host=Db::name("host")->alias("a")
            ->field("a.`domain`,b.`name`,a.`dedicatedip`,a.uid,c.config,c.openid")
            ->join("products b","b.id=a.productid")
            ->join('wechat_uid c',"a.uid=c.uid")
            ->where("a.id","=",$option['id'])
            ->find();

        if(!empty($host)&&!empty($host['config'])&&!empty($host['openid'])){
            $wechatConfig=explode(",",$host['config']);
            if(in_array($option['hook'],$wechatConfig)){
                if(!empty($host['dedicatedip'])){
                    $ipData ="IP：{$host['dedicatedip']}\n";
                }
                $option=[
                    'array'=>array(
                        "first"=>array("value"=>"{$host['name']}{$option['tag']}","color"=>"#173177"),
                        "keyword1"=>array("value"=>"{$option['id']}","color"=>"#173177"),
                        "keyword2"=>array("value"=>date("Y-m-d H:i:s"),"color"=>"#173177"),
                        "keyword3"=>array("value"=>"[{$option['id']}]{$host['name']}{$host['domain']}{$ipData}","color"=>"#173177"),
                        "remark"=>array("value"=>"{$option['tag']}","color"=>"#173177"),
                    ),
                    'openid'=>$host['openid'],

                    'tpl'=>"OrderSuccess",
                    'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=touser&id=".bin2hex(openssl_encrypt(serialize([
                            'uid'=>$host['uid'],
                            'url'=>"/servicedetail?id={$option['id']}"
                        ]), 'aes-128-cbc', 'A79VB9PXBXJZ7834', true, mb_substr(md5($key),8,16)))
                ];
                $resultData= $this->curl("send",[
                    'msg'=>base64_encode(serialize($option))
                ]);
                if($resultData['status']==1){
                    Db::name("gzhx_wechat_log")->insert($resultData['info']);
                }else{
                    Db::name("gzhx_wechat_log")->insert([
                        'add_time'=>date("Y-m-d H:i:s"),
                        'openid'=>$option['openid'],
                        'text'=>var_export($option['array'],true),
                        'result'=>$resultData['info'],
                    ]);
                }

            }

        }
        if(strstr($option['tag'],'失败')){
            $failure_notification=Db::name("configuration")->where("setting","=","gzhx_wechat_failure_notification")->value("value");
            if($failure_notification=="true"){
                $WebHost=$host;
                if(empty($WebHost)){
                    $WebHost=Db::name("host")->alias("a")
                        ->field("a.`domain`,b.`name`,a.`dedicatedip`,a.uid")
                        ->join("products b","b.id=a.productid")
                        ->where("a.id","=",$option['id'])
                        ->find();
                }
                if(!empty($WebHost)){
                    if(!empty($host['dedicatedip'])){
                        $ipData ="IP：{$WebHost['dedicatedip']}\n";
                    }
                    $option=[
                        'array'=>array(
                            "first"=>array("value"=>"{$WebHost['name']}{$option['tag']}","color"=>"#173177"),
                            "keyword1"=>array("value"=>"{$option['id']}","color"=>"#173177"),
                            "keyword2"=>array("value"=>date("Y-m-d H:i:s"),"color"=>"#173177"),
                            "keyword3"=>array("value"=>"[{$option['id']}]{$WebHost['name']}{$WebHost['domain']}{$ipData}","color"=>"#173177"),
                            "remark"=>array("value"=>"{$option['tag']}","color"=>"#173177"),
                        ),
                        'openid'=>'member',
                        'tpl'=>"OrderSuccess",
                        'url'=>$this->getUrl()
                    ];
                    $resultData= $this->curl("send",[
                        'msg'=>base64_encode(serialize($option))
                    ]);
                    if($resultData['status']==1){
                        Db::name("gzhx_wechat_log")->insert($resultData['info']);
                    }else{
                        Db::name("gzhx_wechat_log")->insert([
                            'add_time'=>date("Y-m-d H:i:s"),
                            'openid'=>'member',
                            'text'=>var_export($option['array'],true),
                            'result'=>$resultData['info'],
                        ]);
                    }
                }
            }

        }



    }
    public function afterModuleChangePackage($param){
        if(!empty($param['params']['hostid'])){
                $this->OrderSuccess([
                    'id'=>$param['params']['hostid'],
                    'tag'=>'升降级成功',
                    'hook'=>'afterModuleChangePackage'
                ]);
        }
    }
    public function afterModuleChangePackageFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'升降级失败',
                'hook'=>'afterModuleChangePackageFailed'
            ]);
        }
    }
    public function afterModuleCrackPassword($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'重置密码成功，新密码为：'.$param['newspassword'],
                'hook'=>'afterModuleCrackPassword'
            ]);
        }
    }
    public function afterModuleCrackPasswordFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'重置密码失败',
                'hook'=>'afterModuleCrackPasswordFailed',
            ]);
        };
    }

    public function afterModuleCreate($param){

        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'开通成功',
                'hook'=>'afterModuleCreate',
            ]);
        };
    }

    public function afterModuleCreateFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'开通失败',
                'hook'=>'afterModuleCreateFailed',
            ]);
        };
    }

    public function afterModuleSuspend($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'暂停成功',
                'hook'=>'afterModuleSuspend',
            ]);
        };
    }

    public function afterModuleSuspendFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'暂停失败',
                'hook'=>'afterModuleSuspendFailed',
            ]);
        };
    }

    public function afterModuleTerminate($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'删除成功',
                'hook'=>'afterModuleTerminate',
            ]);
        };
    }

    public function afterModuleTerminateFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'删除失败',
                'hook'=>'afterModuleTerminateFailed',
            ]);
        };
    }

    public function afterModuleUnsuspend($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'解除暂停成功',
                'hook'=>'afterModuleUnsuspend',
            ]);
        };
    }

    public function afterModuleUnsuspendFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'解除暂停失败',
                'hook'=>'afterModuleUnsuspendFailed',
            ]);
        };
    }

    public function afterModuleOn($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'开机成功',
                'hook'=>'afterModuleOn',
            ]);
        };
    }

    public function afterModuleOnFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'开机失败',
                'hook'=>'afterModuleOnFailed',
            ]);
        };
    }

    public function afterModuleOff($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'关机成功',
                'hook'=>'afterModuleOff',
            ]);
        };
    }

    public function afterModuleOffFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'模块关机失败',
                'hook'=>'afterModuleOffFailed',
            ]);
        };
    }

    public function afterModuleReboot($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'重启成功',
                'hook'=>'afterModuleReboot',
            ]);
        };
    }

    public function afterModuleRebootFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'重启失败',
                'hook'=>'afterModuleRebootFailed',
            ]);
        };
    }

    public function afterModuleHardOff($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'硬关机成功',
                'hook'=>'afterModuleHardOff',
            ]);
        };
    }

    public function afterModuleHardOffFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'硬关机失败',
                'hook'=>'afterModuleHardOffFailed',
            ]);
        };
    }

    public function afterModuleHardReboot($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'硬重启成功',
                'hook'=>'afterModuleHardReboot',
            ]);
        };
    }

    public function afterModuleHardRebootFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'硬重启失败',
                'hook'=>'afterModuleHardRebootFailed',
            ]);
        };
    }

    public function afterModuleReinstall($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'重装系统成功',
                'hook'=>'afterModuleReinstall',
            ]);
        };
    }

    public function afterModuleReinstallFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'重装系统失败',
                'hook'=>'afterModuleReinstallFailed',
            ]);
        };
    }

    public function afterModuleRescueSystem($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'救援系统成功',
                'hook'=>'afterModuleRescueSystem',
            ]);
        };
    }

    public function afterModuleRescueSystemFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'救援系统失败',
                'hook'=>'afterModuleRescueSystemFailed',
            ]);
        };
    }

    public function afterModuleSync($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'拉取信息成功',
                'hook'=>'afterModuleSync',
            ]);
        };
    }

    public function afterModuleSyncFailed($param){
        if(!empty($param['params']['hostid'])){
            $this->OrderSuccess([
                'id'=>$param['params']['hostid'],
                'tag'=>'拉取信息失败',
                'hook'=>'afterModuleSyncFailed',
            ]);
        };
    }
    public function shoppingCartSettle($param){

    }
    /**前台购物车结算**/
    public function invoicePaidBeforeEmail($param){
        if(!file_exists(CMF_DATA."key.key")){
            file_put_contents(CMF_DATA."key.key",time());
        }

        $key=file_get_contents(CMF_DATA."key.key");

        $tickets=Db::name("invoice_items")->alias("a")
            ->field("b.config,b.openid,a.description,a.amount,c.id as invoice_id,a.uid")
            ->join('wechat_uid b',"b.uid=a.uid")
            ->join('invoices c',"c.id=a.invoice_id")
            ->where("a.invoice_id","=",$param['invoiceid'])
            ->select()->toArray();

        $WebName=Db::name("configuration")->where("setting","=","company_name")->value("value");
        foreach ($tickets as $ticket){
            if(!empty($ticket)&&!empty($ticket['config'])&&!empty($ticket['openid'])){

                $wechatConfig=explode(",",$ticket['config']);

                if(in_array('shoppingCartSettle',$wechatConfig)){
                    $option=[
                        'array'=>array(
                            "first"=>array("value"=>"{$ticket['description']}支付成功","color"=>"#173177"),
                            "keyword1"=>array("value"=>"{$ticket['description']}","color"=>"#173177"),
                            "keyword2"=>array("value"=>"{$ticket['amount']}","color"=>"#173177"),
                            "keyword3"=>array("value"=>date("Y-m-d H:i:s"),"color"=>"#173177"),
                            "keyword4"=>array("value"=>$WebName,"color"=>"#173177"),
                            "remark"=>array("value"=>"已成功支付","color"=>"#173177"),
                        ),
                        'openid'=>$ticket['openid'],

                        'tpl'=>"CartSettle",
                        'url'=>$this->getUrl()."/addons?_plugin=wechat_gzhx&_controller=index&_action=touser&id=".bin2hex(openssl_encrypt(serialize([
                                'uid'=>$ticket['uid'],
                                'url'=>"/viewbilling?id={$ticket['invoice_id']}"
                            ]), 'aes-128-cbc', 'A79VB9PXBXJZ7834', true, mb_substr(md5($key),8,16)))
                    ];
                    $resultData= $this->curl("send",[
                        'msg'=>base64_encode(serialize($option))
                    ]);
                    if($resultData['status']==1){
                        Db::name("gzhx_wechat_log")->insert($resultData['info']);
                    }else{
                        Db::name("gzhx_wechat_log")->insert([
                            'add_time'=>date("Y-m-d H:i:s"),
                            'openid'=>$option['openid'],
                            'text'=>var_export($option['array'],true),
                            'result'=>$resultData['info'],
                        ]);
                    }
                }

            }
        }

    }
}