<?php
namespace addons\wechat_gzhx\controller;
use app\admin\controller\PluginAdminBaseController;
use Think\Db;
use function GuzzleHttp\Psr7\parse_query;

class AdminIndexController extends PluginAdminBaseController
{
    public $data,$pluginName="wechat_gzhx";
    public function initialize()
    {
        parent::initialize();

        $this->assign('GzhxPluginPath',$this->pluginName);

        $this->data=$_POST;
    }
    public function success($arr){
        echo json_encode([
            'status'=>1,
            'encrypt'=>1,
            'info'=>$arr
        ]);die;
    }
    public function error($arr){
        echo json_encode([
            'status'=>0,
            'info'=>$arr
        ]);die;
    }
    public function curl($path,$data=[]){
        $data['backurl']=Db::name("configuration")->where("setting","=","domain")->value("value");
        $data['webname']=Db::name("configuration")->where("setting","=","company_name")->value("value");
        $data['uuid']=Db::name("configuration")->where("setting","=","system_license")->value("value");
        $iv = mb_substr(md5(mt_rand(1000000000000000,9999999999999999)),0,16);
        $ch = curl_init();
        $header = array(
            "HostAPI: idcsmart.com",
            "HostAPIIP: " . $_SERVER["SERVER_ADDR"],
            "HostAPISITE: " . $_SERVER["HTTP_HOST"],
            "Content-Type: application/json; charset=UTF-8",
            "X-Requested-With: XMLHttpRequest"
        );
        curl_setopt($ch, CURLOPT_URL, "https://connect.03s.cn/Wechat/{$path}");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            'data'=>base64_encode(openssl_encrypt(json_encode($data), 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, $iv)),
            'iv'=>$iv
        ]) );
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);

        $data=json_decode($result,true);
        if(empty($data)){
            return [
                'status'=>0,
                'info'=>empty($curl_error)?'未知错误':$curl_error
            ];

        }

        return $data;
    }
    public function index(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "":{
                    $this->error("参数错误");
                    break;
                }
                case "login":{
                    $result=$this->curl("status",$this->data);

                    if($result['status']==0){
                        $this->error($result['info']);
                    }
                    if(strval($result['info']['status'])=="2"){
                        $key=file_get_contents(CMF_DATA."key.key");
                        $data=bin2hex(openssl_encrypt(serialize($result['info']),'aes-128-cbc',  mb_substr(md5($key),8,16) , true, mb_substr(md5("798yyhhhjio^*(uihkjh"),8,16)));
                        file_put_contents(CMF_DATA."auto_login_gzhx.key",$data);
                    }
                    $this->success($result['info']);
                    break;
                }
                case "pay":{
                    if(!file_exists(CMF_DATA."key.key")){
                        file_put_contents(CMF_DATA."key.key",time());
                    }
                    $key=file_get_contents(CMF_DATA."key.key");
                    $loginInfo="";
                    if(file_exists(CMF_DATA."auto_login_gzhx.key")){
                        $login= file_get_contents(CMF_DATA."auto_login_gzhx.key");
                        $loginInfo= openssl_decrypt(hex2bin($login),'aes-128-cbc',  mb_substr(md5($key),8,16) , true, mb_substr(md5("798yyhhhjio^*(uihkjh"),8,16));
                        $loginInfo=unserialize($loginInfo);
                    }
                    $result=$this->curl($action,[
                        'id'=>$loginInfo['openid']
                    ]);
                    if($result['status']==0){
                        $this->error($result['info']);
                    }
                    $this->success($result['info']);
                    break;
                }
                case "payReturn":{


                    $result=$this->curl($action,$this->data);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $this->success($result['info']);
                    break;
                }
                case 'hook':{
                    $data=file_get_contents(dirname(__FILE__)."/HooksController.txt");

                    file_put_contents(APP_PATH."home/controller/HooksController.php",$data);
                    $exit=class_exists("\app\home\controller\HooksController");

                    if($exit){
                        $exit=method_exists("\app\home\controller\HooksController","ticket_admin_reply");
                    }
                    if($exit){
                        $this->success("成功");
                    }else{
                        $this->error("修改失败，请加QQ群:1065433015 解决");
                    }
                }
                case 'failure_notification':{
                    $config=Db::name("configuration")->where("setting","=","gzhx_wechat_failure_notification")->find();
                    if(empty($config)){
                        Db::name("configuration")->insert([
                            'setting'=>"gzhx_wechat_failure_notification",
                            'value'=>intval($this->data['status'])==2?'true':'false'
                        ]);
                    }else{
                        Db::name("configuration")->where("setting","=","gzhx_wechat_failure_notification")->update([
                            'value'=>intval($this->data['status'])==2?'true':'false'
                        ]);
                    }
                    $this->success("设置成功");
                }


                default:{
                    $serverInfo=$this->curl("login",[]);
                    if($serverInfo['status']==1){
                        $serverInfo['info']['data']=unserialize(base64_decode($serverInfo['info']['data']));
                    }
                    $serverInfo['info']['failure_notification']=Db::name("configuration")->where("setting","=","gzhx_wechat_failure_notification")->value("value");
                    $Hooks=Db::name("plugin")->where("name","=","WechatGzhx")->value("hooks");
                    $Hooks=explode(",",$Hooks);
                    if(!in_array('ticket_admin_reply',$Hooks)){
                        $serverInfo['info']['hooks']='repair';
                    }
                    $this->success($serverInfo);
                    break;
                }
            }

        }
        


        $this->assign('Title','基本设置');
        return $this->fetch('/index');
    }
    public function getUrl()
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $url = $protocol . $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
        return $url;
    }
    public function manual(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){

                case "status":{
                    $result=$this->curl("status",$this->data);

                    if($result['status']==0){
                        $this->error($result['info']);
                    }
                    if(strval($result['info']['status'])=="2"){
                        $configuration= Db::name("configuration")->where("setting","=","gzhx_wechat_{$result['info']['type']}")->find();
                        if(empty($configuration)){
                            $bind=[];
                            $bind[ $result['info']['raw']['openid'] ]=$result['info']['raw'];
                            Db::name("configuration")->insert([
                                'setting'=>"gzhx_wechat_{$result['info']['type']}",
                                'value'=>base64_encode(serialize($bind))
                            ]);
                        }else{
                            $bind=unserialize(base64_decode($configuration['value']));
                            if(empty($bind)) $bind=[];
                            if(!array_key_exists($result['info']['raw']['openid'],$bind)){
                                $bind[ $result['info']['raw']['openid'] ]=$result['info']['raw'];
                            }
                            Db::name("configuration")->where("setting","=","gzhx_wechat_{$result['info']['type']}")->update([
                                'value'=>base64_encode(serialize($bind))
                            ]);
                        }

                        $TagInfo="";
                        if($this->data['uid']=='consult'){
                            $TagInfo="售前咨询客服";
                        }else if($this->data['uid']=='technology'){
                            $TagInfo="技术工单客服";
                        }else if($this->data['uid']=='finance'){
                            $TagInfo="财务工单客服";
                        }

                        $option=[
                            'array'=>array(
                                "first"=>array("value"=>"{$result['info']['raw']['nickname']}绑定{$TagInfo}成功","color"=>"#173177"),
                                "keyword1"=>array("value"=>"{$result['info']['raw']['nickname']}","color"=>"#173177"),
                                "keyword2"=>array("value"=>"{$TagInfo}","color"=>"#173177"),
                                "remark"=>array("value"=>"绑定成功","color"=>"#173177"),
                            ),
                            'openid'=>"member",
                            'tpl'=>"BindMsg",
                            'url'=>$this->getUrl()."?".http_build_query($_GET)
                        ];
                        $resultData= $this->curl("send",[
                            'msg'=>base64_encode(serialize($option))
                        ]);
                        if($resultData['status']==1){
                            Db::name("gzhx_wechat_log")->insert($resultData['info']);
                        }else{
                            Db::name("gzhx_wechat_log")->insert([
                                'add_time'=>date("Y-m-d H:i:s"),
                                'openid'=>$option['openid'],
                                'text'=>var_export($option['array'],true),
                                'result'=>$resultData['info'],
                            ]);
                        }
                        $this->success($result['info']);
                    }
                    $this->error($result['info']);


                    break;
                }
                case 'delete':{
                    $configuration= Db::name("configuration")->where("setting","=","gzhx_wechat_{$this->data['type']}")->find();
                    $bind=unserialize(base64_decode($configuration['value']));
                    if(empty($bind)) $bind=[];
                    unset($bind[$this->data['id']]);
                    Db::name("configuration")->where("setting","=","gzhx_wechat_{$this->data['type']}")->update([
                        'value'=>base64_encode(serialize($bind))
                    ]);

                    $this->success("OK");
                }

                case 'bind':{
                    $serverInfo=$this->curl("bind",[
                        'type'=>$this->data['id']
                    ]);
                    if($serverInfo['status']!=1){
                        $this->error($serverInfo['info']);
                    }
                    $this->success($serverInfo['info']);
                    break;
                }
                case 'update':{

                    if($this->data['type']=="member"){
                        Db::name("configuration")->where('setting','=','gzhx_wechat_member')->update([
                            'value'=>$this->data['user_id']
                        ]);
                    }else{
                        $configuration= Db::name("configuration")->where("setting","=","gzhx_wechat_{$this->data['type']}")->find();
                        $bind=unserialize(base64_decode($configuration['value']));

                        if(empty($bind)) $bind=[];
                        if(!array_key_exists($this->data['id'],$bind)){
                            $this->error("更新失败，未找到客服");
                        }
                        $bind[$this->data['id']]['user_id']=$this->data['user_id'];
                        Db::name("configuration")->where("setting","=","gzhx_wechat_{$this->data['type']}")->update([
                            'value'=>base64_encode(serialize($bind))
                        ]);


                    }
                    $this->success("OK");
                    break;
                }
                case 'get':{
                    $configuration= Db::name("configuration")->select()->toArray();
                    $configuration=array_column($configuration,null,'setting');
                    if(!isset($configuration['gzhx_wechat_member'])){
                        Db::name("configuration")->insert([
                            'setting'=>'gzhx_wechat_member',
                            'value'=>''
                        ]);
                    }
                    $data=[
                        'technology'=>unserialize(base64_decode($configuration['gzhx_wechat_technology']['value'])),
                        'finance'=>unserialize(base64_decode($configuration['gzhx_wechat_finance']['value'])),
                        'consult'=>unserialize(base64_decode($configuration['gzhx_wechat_consult']['value'])),
                        'member'=>$configuration['gzhx_wechat_member']['value'],
                    ];

                    $this->success([
                        'user'=>Db::name("user")->select()->toArray(),
                        'list'=>$data
                    ]);die;
                    break;
                }
                default:{
                    $this->error("参数错误");
                    break;
                }
            }

        }


        $this->assign('Title','工单客服设置');
        return $this->fetch('/manual');
    }
    public function wechat(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case 'save':{
                    $authorization=$this->curl("save_authorization",$this->data['data']);
                    if($authorization['status']!=1){
                        $this->error("{$authorization['info']}");
                    }
                    $this->success("保存成功");
                    break;
                }
                case 'authorization':{
                    if(empty($_FILES)){
                        $this->error("请上传授权txt文件");
                    }
                    $name=$_FILES['file']['name'];

                    if(!move_uploaded_file($_FILES['file']['tmp_name'],CMF_ROOT."public/{$name}")){
                        $this->error("上传授权txt文件失败");
                    }
                    $authorization=$this->curl("authorization",[
                        'name'=>$name,
                        'txt'=>file_get_contents(CMF_ROOT."public/{$name}")
                    ]);
                    if($authorization['status']!=1){
                        $this->error("上传授权txt文件失败：{$authorization['info']}");
                    }
                    $this->success("上传授权文件成功");
                }
                case 'get':{
                    $configuration= Db::name("configuration")->select()->toArray();
                    $configuration=array_column($configuration,null,'setting');
                    if(!isset($configuration['gzhx_wechat_member'])){
                        Db::name("configuration")->insert([
                            'setting'=>'gzhx_wechat_member',
                            'value'=>''
                        ]);
                    }
                    $data=[
                        'technology'=>unserialize(base64_decode($configuration['gzhx_wechat_technology']['value'])),
                        'finance'=>unserialize(base64_decode($configuration['gzhx_wechat_finance']['value'])),
                        'consult'=>unserialize(base64_decode($configuration['gzhx_wechat_consult']['value'])),
                        'member'=>$configuration['gzhx_wechat_member']['value'],
                    ];

                    $this->success([
                        'user'=>Db::name("user")->select()->toArray(),
                        'list'=>$data
                    ]);die;
                    break;
                }
                default:{
                    $this->error("参数错误");
                    break;
                }
            }

        }
        $serverInfo=$this->curl("self_employed",[]);

        if($serverInfo['status']!=1){
            $this->assign('msg',$serverInfo['info']);
            return $this->fetch('/error');
        }
        $serverInfo['info']['domain']=str_ireplace(['http://','https:'],"",strtolower(Db::name("configuration")->where("setting","=","domain")->value("value")));
        $this->assign('InfoData',$serverInfo['info']);
        $this->assign('Title','自有公众号设置');
        return $this->fetch('/wechat');
    }
    public function carte(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case 'save':{
                    $menu_1=strtolower($this->data['data']['menu_1']);
                    $menu_2=strtolower($this->data['data']['menu_2']);
                    $menu_3=strtolower($this->data['data']['menu_3']);
                    $menu_1_name=$this->data['data']['menu_1_name'];
                    $menu_2_name=$this->data['data']['menu_2_name'];
                    $menu_3_name=$this->data['data']['menu_3_name'];
                    if(!empty($menu_1)&&!strstr($menu_1,"https://")&&!strstr($menu_1,"http://")){
                        $this->error("菜单一必须要带http://或者https://开头");
                    }
                    if(!empty($menu_2)&&!strstr($menu_2,"https://")&&!strstr($menu_2,"http://")){
                        $this->error("菜单二必须要带http://或者https://开头");
                    }
                    if(!empty($menu_3)&&!strstr($menu_3,"https://")&&!strstr($menu_3,"http://")){
                        $this->error("菜单三必须要带http://或者https://开头");
                    }
                    if((empty($menu_1)&&empty($menu_2)&&empty($menu_3))||(empty($menu_1_name)&&empty($menu_2_name)&&empty($menu_3_name))){
                        $authorization=$this->curl("delete_carte",[]);
                        if($authorization['status']!=1){
                            $this->error("{$authorization['info']}");
                        }
                        $this->success($authorization);
                    }
                    $Option=[];
                    if(!empty($menu_1)&&!empty($menu_1_name)){
                        $Option[]=[
                            "type"=>"view",
                            "name"=>$menu_1_name,
                            "url"=>Db::name("configuration")->where("setting","=","domain")->value("value")."/addons?_plugin=wechat_gzhx&_controller=index&_action=wechat&token=".bin2hex(openssl_encrypt($menu_1, 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, 'A89VB9PXBXJZ7834'))
                        ];
                    }
                    if(!empty($menu_2)&&!empty($menu_2_name)){
                        $Option[]=[
                            "type"=>"view",
                            "name"=>$menu_2_name,
                            "url"=>Db::name("configuration")->where("setting","=","domain")->value("value")."/addons?_plugin=wechat_gzhx&_controller=index&_action=wechat&token=".bin2hex(openssl_encrypt($menu_2, 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, 'A89VB9PXBXJZ7834'))
                        ];
                    }
                    if(!empty($menu_3)&&!empty($menu_3_name)){
                        $Option[]=[
                            "type"=>"view",
                            "name"=>$menu_3_name,
                            "url"=>Db::name("configuration")->where("setting","=","domain")->value("value")."/addons?_plugin=wechat_gzhx&_controller=index&_action=wechat&token=".bin2hex(openssl_encrypt($menu_3, 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, 'A89VB9PXBXJZ7834'))
                        ];
                    }

                    $authorization=$this->curl("save_carte",[
                        'menu'=>$Option
                    ]);
                    if($authorization['status']!=1){
                        $this->error("{$authorization['info']}");
                    }
                    $this->success($authorization);
                    break;
                }

                default:{
                    $this->error("参数错误");
                    break;
                }
            }

        }
        $serverInfo=$this->curl("carte",[]);


        if($serverInfo['status']!=1){
            $this->assign('msg',$serverInfo['info']);
            return $this->fetch('/error');
        }
        $MenuInfo=[];
        foreach ($serverInfo['info']['info']['menu']['button'] as $key=>$item){
            $arr= parse_url($item['url'])['query'];
            $vid=$key+1;
            $MenuInfo[ "menu_{$vid}_name" ]=$item['name'];
            if(!empty($arr)){
                parse_str($arr,$query);
                $uri=openssl_decrypt(hex2bin($query['token']), 'aes-128-cbc', 'A89VB9PXBXJZ7834', true, 'A89VB9PXBXJZ7834');
                $MenuInfo[ "menu_{$vid}" ]=$uri;
            }

        }
        $this->assign('InfoData',$MenuInfo);
        $this->assign('Title','公众号菜单设置');
        return $this->fetch('/menu');
    }
    public function Log(){
        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        $M=Db::name('gzhx_wechat_log');
        $count=$M->count();

        $DomainList=$M
            ->order("add_time desc,id desc")
            ->page("{$Page},20")
            ->select()->toArray();
        $this->assign('DomainList',$DomainList);

        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','发送日志');
        return $this->fetch('/log');
    }
}