<?php
class west_cloud_gzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ClassName = "WestCloudGzhxClass";
    private $ApiUrl = "http://api.west263.com/api/";
    public $Discount = 100;
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curlV2($url, $data = NULL)
    {
        if (!empty($data)) {
            foreach ($data as $k => $v) {
                $data[$k] = mb_convert_encoding($v, "GB2312", "UTF-8");
            }
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        return mb_convert_encoding($result, "UTF-8", "GBK");
    }
    private function getV2($Action, $option)
    {
        list($msec, $sec) = explode(" ", microtime());
        $msectime = (double) sprintf("%.0f", (floatval($msec) + floatval($sec)) * 1000);
        $token = strtolower(md5($this->uid . $this->APiKey . $msectime));
        $option["username"] = $this->uid;
        $option["time"] = $msectime;
        $option["token"] = $token;
        $url = "https://api.west.cn/api/v2" . $Action;
        $result = $this->curlV2($url, $option);
        $myarray = json_decode($result, true);
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("result", $myarray)) {
            return ["status" => 0, "info" => "没有参数【result】"];
        }
        if ($myarray["result"] != "200") {
            return ["status" => 0, "info" => $myarray["msg"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    private function curl($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        return mb_convert_encoding($result, "UTF-8", "GBK");
    }
    private function get($Action, $option)
    {
        $entityname = $option["entityname"];
        $query = [$Action => NULL, empty($option["Method"]) ? "get" : $option["Method"] => NULL, "entityname" => $option["entityname"]];
        unset($option["entityname"]);
        unset($option["Method"]);
        unserialize($option["Method"]);
        if ($option["room"] == 47 || $option["room"] == 44) {
            $option["ddos"] = 100;
        }
        $query = array_merge($query, $option);
        $data = [];
        foreach ($query as $kk => $vv) {
            if (empty($vv) && $vv !== 0 && $vv !== "0") {
                $data[] = $kk;
            } else {
                $data[] = $kk . ":" . $vv;
            }
        }
        $cmd = implode("\r\n", $data) . "\r\n.\r\n";
        $md5sing = md5($this->uid . $this->APiKey . substr($cmd, 0, 10));
        $url = $this->ApiUrl . "?userid=" . $this->uid . "&versig=" . $md5sing . "&strCmd=" . urlencode(mb_convert_encoding($cmd, "GBK", "UTF-8"));
        $result = $this->curl($url);
        $result = str_ireplace("gb2312", "UTF-8", $result);
        $myarray = simplexml_load_string($result, "SimpleXMLElement", LIBXML_NOCDATA);
        $myarray = json_decode(json_encode($myarray), true);
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("returncode", $myarray)) {
            return ["status" => 0, "info" => "没有参数【returncode】"];
        }
        if ($myarray["returncode"] != "200") {
            return ["status" => 0, "info" => $myarray["returnmsg"] . "(" . $entityname . ")"];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    public function setCache($file, $data)
    {
        if (!is_dir(CMF_DATA . "gzhx/" . $this->ClassName . "/")) {
            mkdir(CMF_DATA . "gzhx/" . $this->ClassName . "/", 493, true);
        }
        file_put_contents(CMF_DATA . "gzhx/" . $this->ClassName . "/" . $file, serialize(["time" => time(), "list" => $data]));
    }
    public function getCache($file, $time = 86400)
    {
        if (!is_dir(CMF_DATA . "gzhx/" . $this->ClassName . "/")) {
            mkdir(CMF_DATA . "gzhx/" . $this->ClassName . "/", 493, true);
        }
        $data = unserialize(file_get_contents(CMF_DATA . "gzhx/" . $this->ClassName . "/" . $file));
        if ($data["time"] && time() - $data["time"] < $time) {
            return $data["list"];
        }
        return NULL;
    }
    public function DescribeRegions()
    {
        $r = $this->getCache("DescribeRegions");
        if (empty($r)) {
            $r = $this->getV2("/server/config/?act=base", []);
            if ($r["status"] != 1) {
                return $r;
            }
            $this->setCache("DescribeRegions", $r);
        }
        $data = [];
        foreach ($r["info"]["data"]["room"] as $key => $value) {
            $data[$value["roomid"]] = $value["roomname"];
        }
        return ["status" => 1, "info" => $data];
    }
    public function DescribeDisksCategory($query)
    {
        $config = ["ebs" => "高性能云硬盘", "ssd" => "SSD云硬盘"];
        $result = ["status" => 1, "info" => ["list" => $config, "min" => 20, "max" => 1000]];
        return $result;
    }
    public function Period()
    {
        return ["a0" => "1个月", "a2" => "3个月", "a3" => "半年", "a1" => "一年"];
    }
    public function Service()
    {
        return ["基础服务" => "基础服务", "铜牌服务" => "铜牌服务", "银牌服务" => "银牌服务", "金牌服务" => "金牌服务"];
    }
    public function RunInstances($query)
    {
        $Instance = explode("-", $query["Instance"]);
        $queryArray = ["cpuhz", "data", "ramsize", "flux", "paymethod", "renewtime", "room", "paytype", "servicetype"];
        $priceData = ["prodtype" => 0, "cpu" => $Instance[1], "ram" => $Instance[2], "flux" => intval($query["bindWidth"]), "osdata" => 30, "data" => intval($query["dataSize"]), "paymethod" => intval(mb_substr($query["period"], 1, NULL, "utf-8")), "room" => $query["region"], "renewtime" => 1, "snapadv" => 0, "ddos" => 0, "cc" => 0, "paytype" => 0, "os" => $query["osId"], "servicetype" => $query["service"], "disktype" => $query["osDisk"], "pricmoney" => empty($query["PayPrice"]) ? 99999999 : floatval($query["PayPrice"])];
        $result = $this->getV2("/server/create/?act=create", $priceData);
        if ($result["status"] === 1) {
            $InstanceIdSets = $result["info"]["data"];
            $save = ["status" => 1, "info" => ["vid" => $InstanceIdSets["id"], "domain" => $InstanceIdSets["ip"], "end_time" => $InstanceIdSets["expiredate"], "password" => $InstanceIdSets["password"], "active" => "正常"]];
            return $save;
        }
        return $result;
    }
    public function DescribePrice($query)
    {
        $Instance = explode("-", $query["Instance"]);
        $priceData = ["prodtype" => 0, "cpu" => $Instance[1], "ram" => $Instance[2], "flux" => intval($query["bindWidth"]), "osdata" => 30, "data" => intval($query["dataSize"]), "paymethod" => intval(mb_substr($query["period"], 1, NULL, "utf-8")), "room" => $query["region"], "renewtime" => 1, "snapadv" => 0, "ddos" => 0, "cc" => 0, "paytype" => 0, "os" => $query["osId"], "servicetype" => $query["service"], "disktype" => $query["osDisk"]];
        $rr = $this->getV2("/server/create/?act=createprice", $priceData);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $OriginalPrice = $rr["info"]["data"]["fullprice"];
        $DiscountPrice = $rr["info"]["data"]["price"];
        $Price = $DiscountPrice + ceil(floatval($OriginalPrice - $DiscountPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function DescribeImages($query)
    {
        $r = $this->getCache("DescribeRegions");
        if (empty($r)) {
            $r = $this->getV2("/server/config/?act=base", []);
            if ($r["status"] != 1) {
                return $r;
            }
            $this->setCache("DescribeRegions", $r);
        }
        $os = ["windows" => [], "linux" => []];
        foreach ($r["info"]["data"]["os"] as $value) {
            if (mb_substr(strtolower($value["system"]), 0, 3, "UTF-8") == "win") {
                $os["windows"][] = ["id" => $value["value"], "name" => $value["name"]];
            } else {
                $os["linux"][] = ["id" => $value["value"], "name" => $value["name"]];
            }
        }
        $result = ["status" => 1, "info" => $os];
        return $result;
    }
    public function Instance($query)
    {
        $r = $this->getCache("DescribeRegions");
        if (empty($r)) {
            $r = $this->getV2("/server/config/?act=base", []);
            if ($r["status"] != 1) {
                return $r;
            }
            $this->setCache("DescribeRegions", $r);
        }
        $Cpus = $r["info"]["data"]["cpu"];
        $Mems = $r["info"]["data"]["ram"];
        $list = [];
        $Cpu = [];
        $Memory = [];
        foreach ($Cpus as $k => $v) {
            if ($v < 4) {
                $maxMem = 4;
            } else {
                if ($v < 12) {
                    $maxMem = 32;
                } else {
                    $maxMem = 9999;
                }
            }
            foreach ($Mems as $kk => $vv) {
                $list[] = ["InstanceType" => "Cloud-" . $v . "-" . $vv, "Cpu" => $v, "Memory" => $vv, "CpuType" => "-", "Zone" => $query["zone"]];
                if (!in_array($v, $Cpu)) {
                    $Cpu[] = $v;
                }
                if (!in_array($vv, $Memory)) {
                    $Memory[] = $vv;
                }
                if ($maxMem <= $vv) {
                }
            }
        }
        asort($Cpu);
        asort($Memory);
        $result = ["status" => 1, "info" => ["list" => $list, "cpu" => $Cpu, "memory" => $Memory]];
        return $result;
    }
    public function Zone($query)
    {
        $r = $this->getCache("DescribeRegions");
        if (empty($r)) {
            $r = $this->getV2("/server/config/?act=base", []);
            if ($r["status"] != 1) {
                return $r;
            }
            $this->setCache("DescribeRegions", $r);
        }
        $data = NULL;
        foreach ($r["info"]["data"]["room"] as $key => $value) {
            if ($value["roomid"] == $query["region"]) {
                $data = $value;
                if (empty($data)) {
                    return ["status" => 0, "info" => "集群获取失败"];
                }
                $list = [];
                foreach ($data["ebsid"] as $key => $value) {
                    $list[$value["id"]] = $value["name"];
                }
                $result = ["status" => 1, "info" => $list];
                return $result;
            }
        }
    }
    public function RenewInstances($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $priceData = ["entityname" => "server", "Method" => "renew", "serverip" => $IP["info"]["data"]["ip"], "paymethod" => intval($op["years"]), "renewtime" => 1, "pricmoney" => empty($query["PayPrice"]) ? 99999999 : floatval($query["PayPrice"])];
        $result = $this->get("server", $priceData);
        return $result;
    }
    public function Bandwidth($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        $query = $data["query"];
        $op = $data["data"];
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $Setting = $this->get("server", ["Method" => "manage", "entityname" => "getserverinfo", "serverip" => $IP["info"]["data"]["ip"]]);
        if ($Setting["status"] != 1) {
            return $Setting;
        }
        $info = $Setting["info"]["info"];
        $ram = floor($info["memory"] / 1024);
        $ram = $ram == 0 ? 0 : $ram;
        $query = ["data" => $info["harddisk"], "Method" => "set", "entityname" => "upserverdiy", "serverip" => $IP["info"]["data"]["ip"], "cpuhz" => $info["cpu"], "ramsize" => $ram, "flux" => intval($op["Bandwidth"])];
        $query["p_proid"] = "ebscloud";
        $query["pricmoney"] = 99999999;
        $result = $this->get("server", $query);
        return $result;
    }
    public function BandwidthPrice($query, $op)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $Setting = $this->getV2("/server/manager/?act=info", ["ip" => $IP["info"]["data"]["ip"]]);
        if ($Setting["status"] != 1) {
            return $Setting;
        }
        $info = $Setting["info"]["data"];
        $ram = floor($info["memory"] / 1024);
        $ram = $ram == 0 ? 0 : $ram;
        $querySetting = ["ip" => $IP["info"]["data"]["ip"], "cpu" => $info["cpu"], "ram" => $ram, "flux" => intval($op["Bandwidth"]), "osdata" => $info["osharddisk"], "data" => $info["harddisk"] - $info["osharddisk"], "disktype" => $info["disktype"], "room" => $info["serverroom"]];
        $oldPrice = $this->getV2("/server/system/?act=updateprice", $querySetting);
        if ($oldPrice["status"] != 1) {
            return $oldPrice;
        }
        $outPrice = ceil($oldPrice["info"]["data"]["upprice"] + $oldPrice["info"]["data"]["blprice"]);
        $OriginalPrice = $outPrice * 2;
        $DiscountPrice = $outPrice;
        $Price = $DiscountPrice + ceil(floatval($OriginalPrice - $DiscountPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function Vnc($query, $op)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $queryData = ["entityname" => "console", "Method" => "get", "serverip" => $IP["info"]["data"]["ip"]];
        $result = $this->get("server", $queryData);
        if ($result["status"] === 1) {
            $result["info"]["RemoteServerUrl"] = $result["info"]["returnmsg"];
        }
        return $result;
    }
    public function myhostpassword($query, $op)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $query = ["Method" => "manage", "entityname" => "myhostpassword", "serverip" => $IP["info"]["data"]["ip"], "RamdomPass" => $op["password"]];
        $rr = $this->get("server", $query);
        if ($rr["status"] !== 1) {
            return $rr;
        }
        return $rr;
    }
    public function password($query, $op)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $op["password"] = "GzLtd" . mt_rand(10000, 9999999);
        $query = ["Method" => "manage", "entityname" => "uppassword", "serverip" => $IP["info"]["data"]["ip"], "RamdomPass" => $op["password"]];
        $rr = $this->get("server", $query);
        if ($rr["status"] !== 1) {
            return $rr;
        }
        $rr["info"]["password"] = $op["password"];
        return $rr;
    }
    public function reloadOS($query, $op)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $query = ["Method" => "manage", "entityname" => "serverreload", "serverip" => $IP["info"]["data"]["ip"], "choice_os" => $op["os"], "keepdata" => "true"];
        $DescribeInstances = $this->get("server", $query);
        return $DescribeInstances;
    }
    public function Op($query, $op)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        switch ($op["op"]) {
            case "start":
                $opBtn = "openserver";
                break;
            case "reboot":
                $opBtn = "Reboot";
                break;
            case "stop":
                $opBtn = "closeserver";
                $query = ["Method" => "manage", "entityname" => "serverdiy", "serverip" => $IP["info"]["data"]["ip"], "type" => $opBtn];
                $DescribeInstances = $this->get("server", $query);
                return $DescribeInstances;
                break;
            default:
                return ["status" => 0, "info" => "不支持的操作"];
        }
    }
    public function DescribeInstanceFull($query)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $rr = $this->getV2("/server/manager/?act=info", ["ip" => $IP["info"]["data"]["ip"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $info = $rr["info"]["data"];
        if (intval($info["memory"]) == 512) {
            $info["memory"] = "0.5";
        }
        if (intval($info["memory"]) == 512) {
            $info["memory"] = "0.5";
        }
        strval($info["sstate"]);
        switch (strval($info["sstate"])) {
            case "2":
                $Status = "管理员关机";
                break;
            case "0":
                $Status = "运行中";
                break;
            case "1":
                $Status = "关机";
                break;
            default:
                $Status = "未知";
                $Info = ["ID" => $info["id"], "购买时间" => $info["starttime"], "到期时间" => $info["exptime"], "内网IP" => $info["v_selfip"], "公网IP" => $info["allocateip"], "Cpu" => $info["cpu"], "内存" => $info["memory"], "带宽" => $info["flux"], "状态" => $Status, "服务" => $info["addedserver"], "修改面板密码" => "", "官方管理面板" => "https://www.myhostadmin.net/default.asp"];
                $ImageName = ["id" => $info["os"], "name" => $info["os_text"]];
                $Info["操作系统"] = $ImageName["name"];
                $Info["登录IP"] = $info["allocateip"];
                $Info["登录端口"] = $info["port"];
                $Info["登录帐号"] = $info["os_extend"]["远程登陆帐号"]["value"];
                $DiskConfig = ["CLOUD_BASIC" => "普通云硬盘", "CLOUD_PREMIUM" => "高性能云硬盘", "CLOUD_SSD" => "SSD云硬盘"];
                $Disk = [["name" => "系统盘+数据盘", "id" => "-", "type" => "-", "size" => $info["harddisk"]]];
                return ["status" => 1, "info" => ["info" => $Info, "disk" => $Disk, "os" => $ImageName, "status" => $Status, "InstanceType" => "Cloud-" . $info["cpu"] . "-" . $info["memory"], "config" => $rr["info"]["InstanceSet"][0]]];
        }
    }
    public function InquiryPriceResizeDisk($query)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $Setting = $this->getV2("/server/manager/?act=info", ["ip" => $IP["info"]["data"]["ip"]]);
        if ($Setting["status"] != 1) {
            return $Setting;
        }
        $info = $Setting["info"]["data"];
        $ram = floor($info["memory"] / 1024);
        $ram = $ram == 0 ? 0 : $ram;
        $querySetting = ["ip" => $IP["info"]["data"]["ip"], "cpu" => $info["cpu"], "ram" => $ram, "flux" => $info["flux"], "osdata" => $info["osharddisk"], "data" => $info["harddisk"] - $info["osharddisk"] + intval($query["size"]), "disktype" => $info["disktype"], "room" => $info["serverroom"]];
        $oldPrice = $this->getV2("/server/system/?act=updateprice", $querySetting);
        if ($oldPrice["status"] != 1) {
            return $oldPrice;
        }
        $outPrice = ceil($oldPrice["info"]["data"]["upprice"] + $oldPrice["info"]["data"]["blprice"]);
        $OriginalPrice = $outPrice * 2;
        $DiscountPrice = $outPrice;
        $Price = $DiscountPrice + ceil(floatval($OriginalPrice - $DiscountPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function ResizeDisk($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $Setting = $this->get("server", ["Method" => "manage", "entityname" => "getserverinfo", "serverip" => $IP["info"]["data"]["ip"]]);
        if ($Setting["status"] != 1) {
            return $Setting;
        }
        $info = $Setting["info"]["info"];
        $ram = floor($info["memory"] / 1024);
        $ram = $ram == 0 ? 0 : $ram;
        $query = ["data" => $info["harddisk"] + $op["size"], "Method" => "set", "entityname" => "upserverdiy", "serverip" => $IP["info"]["data"]["ip"], "cpuhz" => $info["cpu"], "ramsize" => $ram, "flux" => $info["flux"]];
        $query["p_proid"] = "ebscloud";
        $query["pricmoney"] = 99999999;
        $result = $this->get("server", $query);
        return $result;
    }
    public function DescribeInstance($query)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $rr = $this->getV2("/server/manager/?act=info", ["id" => $IP["info"]["data"]["ip"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $info = $rr["info"]["data"];
        if (intval($info["memory"]) == 512) {
            $info["memory"] = "0.5";
        }
        $r = ["vid" => $info["id"], "start_time" => $info["starttime"], "end_time" => $info["exptime"], "domain" => $info["allocateip"], "templete_info" => $info["cpu"] . "核" . $info["memory"] . "G" . $info["flux"] . "M"];
        return ["status" => 1, "info" => $r, "end_time" => $info["exptime"]];
    }
    public function InquiryPriceRenewInstances($query)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $query["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $result = $this->getV2("/server/system/?act=renewprice", ["ip" => $IP["info"]["data"]["ip"], "paymethod" => intval(mb_substr($query["period"], 1, NULL, "utf-8")), "renewtime" => 1]);
        if ($result["status"] != 1) {
            return $result;
        }
        $OriginalPrice = $result["info"]["data"]["fullprice"];
        $DiscountPrice = $result["info"]["data"]["price"];
        $Price = $DiscountPrice + ceil(floatval($OriginalPrice - $DiscountPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => floatval($Price)];
    }
    public function DescribeInstances($query, $page = 1)
    {
        return ["status" => 1, "info" => ["list" => [], "TotalCount" => 0]];
    }
    public function MonitorData($DomainInfo, $set)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $DomainInfo["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $Period = intval($set["period"]) ?: 60;
        $priceData = ["Method" => "manage", "entityname" => "getdb", "serverip" => $IP["info"]["data"]["ip"]];
        $result = $this->get("server", $priceData);
        if ($result["status"] != 1) {
            return $result;
        }
        $json = json_decode($result["info"]["info"]["json"], true);
        if (3000 < $Period) {
            $Info = $json["day"];
        }
        if (empty($Info["title"])) {
            $Info = $json["hour"];
        }
        $MetricArray = ["cpu", "dskbytesin", "dskbytesout", "dskrqin", "dskrqout"];
        $MetricData = [];
        foreach ($MetricArray as $k => $v) {
            $MetricData[$v] = ["date" => $Info["title"], "value" => $Info[$v]];
        }
        return ["status" => 1, "info" => ["Period" => $Info["Period"], "data" => $MetricData, "name" => ["cpu" => ["name" => "cpu使用率", "unit" => "%"], "dskbytesin" => ["name" => "硬盘读取大小", "unit" => "kb"], "dskbytesout" => ["name" => "硬盘写入大小", "unit" => "kb"], "dskrqin" => ["name" => "硬盘读取次数", "unit" => ""], "dskrqout" => ["name" => "硬盘写入次数", "unit" => ""]]]];
    }
    public function InternetMonitorData($DomainInfo, $set)
    {
        $IP = $this->getV2("/server/?act=idtoip", ["id" => $DomainInfo["vid"]]);
        if ($IP["status"] != 1) {
            return $IP;
        }
        $Period = intval($set["period"]) ?: 60;
        $priceData = ["Method" => "manage", "entityname" => "getdb", "serverip" => $IP["info"]["data"]["ip"]];
        $result = $this->get("server", $priceData);
        if ($result["status"] != 1) {
            return $result;
        }
        $json = json_decode($result["info"]["info"]["json"], true);
        if (3000 < $Period) {
            $Info = $json["day"];
        }
        if (empty($Info["title"])) {
            $Info = $json["hour"];
        }
        $MetricArray = ["ifbytesin", "ifbytesout"];
        $MetricData = [];
        foreach ($MetricArray as $k => $v) {
            $MetricData[$v] = ["date" => $Info["title"], "value" => $Info[$v]];
        }
        return ["status" => 1, "info" => ["Period" => $Info["Period"], "data" => $MetricData, "name" => ["ifbytesout" => ["name" => "网络发送大小", "unit" => "kbps"], "ifbytesin" => ["name" => "网络接收大小", "unit" => "kbps"]]]];
    }
}

?>