<?php
class west_dominbygzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "https://api.west.cn/api/v2";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curl($url, $data = NULL)
    {
        if (!empty($data)) {
            foreach ($data as $k => $v) {
                $data[$k] = mb_convert_encoding($v, "GB2312", "UTF-8");
            }
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        return mb_convert_encoding($result, "UTF-8", "GBK");
    }
    private function get($Action, $option)
    {
        list($msec, $sec) = explode(" ", microtime());
        $msectime = (double) sprintf("%.0f", (floatval($msec) + floatval($sec)) * 1000);
        $token = strtolower(md5($this->uid . $this->APiKey . $msectime));
        $option["username"] = $this->uid;
        $option["time"] = $msectime;
        $option["token"] = $token;
        $url = $this->ApiUrl . $Action;
        $result = $this->curl($url, $option);
        $myarray = json_decode($result, true);
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("result", $myarray)) {
            return ["status" => 0, "info" => "没有参数【result】"];
        }
        if ($myarray["result"] != "200") {
            return ["status" => 0, "info" => $myarray["msg"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    private function CheckDomain($query)
    {
        $DomainName = $query["DomainName"];
        $domainArr = explode(".", $DomainName);
        $domainExt = mb_substr($DomainName, mb_strlen($domainArr[0], "UTF-8"), NULL, "UTF-8");
        $r = $this->get("/domain/query/", ["domain" => $domainArr[0], "suffix" => $domainExt]);
        if ($r["status"] == 1) {
            $r["info"]["Avail"] = $r["info"]["data"][0]["avail"];
        }
        return $r;
    }
    public function SaveRegistrantProfile($query)
    {
        $post = ["c_regtype" => $query["RegistrantType"] == 1 ? "I" : "E", "c_org_m" => $query["RegistrantType"] == 1 ? "" : $query["ZhRegistrantOrganization"], "c_ln_m" => mb_substr($query["ZhRegistrantName"], 0, 1, "UTF-8"), "c_fn_m" => mb_substr($query["ZhRegistrantName"], 1, NULL, "UTF-8"), "c_co" => "CN", "cocode" => "+86", "c_st_m" => $query["ZhProvince"], "c_ct_m" => $query["ZhCity"], "c_adr_m" => $query["ZhAddress"], "c_pc" => $query["PostalCode"], "c_ph_type" => 0, "c_ph" => $query["Telephone"], "c_em" => $query["Email"], "c_org" => $query["RegistrantType"] == 1 ? "" : $query["RegistrantOrganization"], "c_ln" => explode(" ", $query["RegistrantName"])[0], "c_fn" => explode(" ", $query["RegistrantName"])[1], "c_st" => $query["Province"], "c_ct" => $query["City"], "c_adr" => $query["Address"]];
        if (!empty($query["RegistrantProfileId"])) {
            $post["c_sysid"] = $query["RegistrantProfileId"];
            $r = $this->get("/audit/?act=auditmod", $post);
            $r["info"]["data"]["c_sysid"] = $post["c_sysid"];
        } else {
            $r = $this->get("/audit/?act=auditsub", $post);
            if ($r["status"] == 0 && strstr($r["info"], "的模板已存在,不必再新创建")) {
                $rInfo = $this->get("/audit/?act=auditlist", ["c_org_m" => $query["ZhRegistrantOrganization"], "c_em" => $query["Email"]]);
                $r = [];
                $r["status"] = 1;
                $r["info"]["data"]["c_sysid"] = $rInfo["info"]["data"]["info"][0]["c_sysid"];
            }
        }
        if ($r["status"] != 1) {
            return $r;
        }
        if ($r["status"] == 1) {
            $r["info"]["RegistrantProfileId"] = $r["info"]["data"]["c_sysid"];
        }
        $upload = $this->RegistrantProfileRealNameVerification(["IdentityCredentialType" => $query["IdentityCredentialType"], "RegistrantProfileID" => $r["info"]["data"]["c_sysid"], "IdentityCredentialNo" => $query["IdentityCredentialNo"], "RegistrantProfilePic" => $query["RegistrantProfilePic"]]);
        if ($upload["status"] != 1) {
            return ["status" => 0, "info" => "证件上传错误" . $upload["info"]];
        }
        return $r;
    }
    private function RegistrantProfileRealNameVerification($query)
    {
        switch ($query["IdentityCredentialType"]) {
            case "SFZ":
                $f_type_org = 1;
                break;
            case "HZ":
                $f_type_org = 5;
                break;
            case "TXZ":
                $f_type_org = 6;
                break;
            case "YYZZ":
                $f_type_org = 3;
                break;
            case "ORG":
                $f_type_org = 2;
                break;
            case "XYDM":
                $f_type_org = 4;
                break;
            default:
                $r = $this->get("/audit/?act=uploadwcftoken", ["c_sysid" => $query["RegistrantProfileID"], "f_type_org" => $f_type_org, "f_code_org" => $query["IdentityCredentialNo"]]);
                if ($r["status"] != 1) {
                    return $r;
                }
                $token = $r["info"]["data"];
                $data = json_encode(["token" => $token, "file_org" => $query["RegistrantProfilePic"]]);
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://netservice.vhostgo.com/wcfservice/Service1.svc/Wcf_AuditUploadFile");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
                curl_setopt($ch, CURLOPT_TIMEOUT, 50);
                curl_setopt($ch, CURLINFO_HEADER_OUT, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                $result = curl_exec($ch);
                $info = curl_getinfo($ch);
                $curl_error = curl_error($ch);
                curl_close($ch);
                $encode = mb_detect_encoding($result, ["ASCII", "UTF-8", "GB2312", "GBK", "BIG5"]);
                if ($encode != "UTF-8") {
                    $result = mb_convert_encoding($result, "UTF-8", $encode);
                }
                $myarray = json_decode($result, true);
                if (!is_array($myarray)) {
                    return ["status" => 0, "info" => "数据解析失败" . $result];
                }
                if (!array_key_exists("Result", $myarray["d"])) {
                    return ["status" => 0, "info" => "没有参数【Result】" . $result];
                }
                if ($myarray["d"]["Result"] != "200") {
                    return ["status" => 0, "info" => $myarray["d"]["Msg"]];
                }
                return ["status" => 1, "info" => $myarray["d"]["Msg"]];
        }
    }
    public function DescribeDomainBaseInfo($query)
    {
        $rr = $this->get("/audit/?act=domaininfo", ["domain" => $query["DomainName"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $Info = $rr["info"]["data"];
        $status = "未知";
        switch ($Info["c_status"]) {
            case 0:
                $status = "未实名认证";
                break;
            case 2:
                $status = "审核中";
                break;
            case 1:
                $status = "已实名认证";
                break;
            case 3:
                $status = "实名失败";
                break;
            case 4:
                $status = "审核中";
                break;
            case 5:
                $status = "实名失败";
                break;
            default:
                return ["status" => 1, "info" => ["域名" => $query["DomainName"], "注册时间" => $Info["regdate"], "到期时间" => $Info["rexpiredate"], "实名状态" => $status, "所有中（中文）" => $Info["dom_org_m"], "所有者（英文）" => $Info["dom_ln"], "电子邮箱" => $Info["dom_em"], "手机号" => $Info["dom_ph"]]];
        }
    }
    private function TemplateData($data)
    {
        $status = "未知";
        intval($data["r_status"]);
        switch (intval($data["r_status"])) {
            case 0:
                $status = "未实名认证";
                break;
            case 2:
                $status = "审核中";
                break;
            case 1:
                $status = "已实名认证";
                break;
            case 3:
                $status = "实名失败";
                break;
            case 4:
                $status = "审核中";
                break;
            case 5:
                $status = "实名失败";
                break;
            default:
                $info = ["TemplateId" => $data["c_sysid"], "Email" => $data["c_em"], "RegistrantType" => $data["c_regtype"] == "E" ? 2 : 1, "ZhRegistrantOrganization" => $data["c_org_m"], "ZhRegistrantName" => $data["c_ln_m"] . $data["c_fn_m"], "RegistrantOrganization" => $data["c_org"], "RegistrantName" => $data["c_ln"] . " " . $data["c_fn"], "Province" => "zhe jiang", "City" => "hang zhou shi", "Address" => "zhe jiang sheng hang zhou shi shang cheng qu 10001 hao", "Country" => "CN", "TelArea" => "86", "Telephone" => explode(".", $data["c_ph_all"])[1], "TelExt" => "1234", "PostalCode" => "310024", "IdentityCredentialType" => "", "IdentityCredentialNo" => "", "RegistrantProfilePic" => "", "AuditStatus" => $status];
                if ($status == "实名失败" && (!empty($data["failinfo"]) || !empty($data["r_failinfo"]))) {
                    $info["AuditStatus"] = $data["failinfo"] . $data["r_failinfo"];
                }
                if (!empty($data["orgfile"]["f_type"])) {
                    intval($data["orgfile"]["f_type"]);
                    switch (intval($data["orgfile"]["f_type"])) {
                        case 1:
                            $f_type_org = "SFZ";
                            break;
                        case 5:
                            $f_type_org = "HZ";
                            break;
                        case 6:
                            $f_type_org = "TXZ";
                            break;
                        case 3:
                            $f_type_org = "YYZZ";
                            break;
                        case 2:
                            $f_type_org = "ORG";
                            break;
                        case 4:
                            $f_type_org = "XYDM";
                            break;
                        default:
                            $info["IdentityCredentialType"] = $f_type_org;
                    }
                }
                if (!empty($data["orgfile"]["f_code"])) {
                    $info["IdentityCredentialNo"] = $data["orgfile"]["f_code"];
                }
                return $info;
        }
    }
    public function DescribeTemplate($query)
    {
        $r = $this->get("/audit/?act=auditinfo", ["c_sysid" => $query["vid"]]);
        if ($r["status"] == 1) {
            $status = "未知";
            $status = "未知";
            intval($r["info"]["data"]["r_status"]);
            switch (intval($r["info"]["data"]["r_status"])) {
                case 0:
                    $status = "未实名认证";
                    break;
                case 2:
                    $status = "审核中";
                    break;
                case 1:
                    $status = "已实名认证";
                    break;
                case 3:
                    $status = "实名失败";
                    break;
                case 4:
                    $status = "审核中";
                    break;
                case 5:
                    $status = "实名失败";
                    break;
                default:
                    $r["AuditStatus"] = $status;
                    return ["status" => 1, "AuditStatus" => $status, "info" => $this->TemplateData($r["info"]["data"])];
            }
        } else {
            return $r;
        }
    }
    public function DescribeTemplateList($Offset)
    {
        $r = $this->get("/audit/?act=auditlist", ["pageno" => $Offset + 1, "pagesize" => 100]);
        if ($r["status"] != 1) {
            return $r;
        }
        $info = ["status" => 1, "info" => ["TemplateSet" => [], "TotalCount" => $r["info"]["data"]["pagelist"]["total"]]];
        foreach ($r["info"]["data"]["info"] as $key => $value) {
            $info["info"]["TemplateSet"][] = $this->TemplateData($value);
        }
        return $info;
    }
    public function DescribeDomainNameList($Offset = 0)
    {
        $r = $this->get("/domain/?act=getdomains&limit=100&pageno=" . ($Offset + 1), []);
        if ($r["status"] != 1) {
            return $r;
        }
        $data = [];
        foreach ($r["info"]["data"]["items"] as $item) {
            $data[] = ["DomainId" => $item["domain"], "DomainName" => $item["domain"], "CreationDate" => $item["regdate"], "ExpirationDate" => $item["expdate"], "BuyStatus" => "ok"];
        }
        return ["status" => 1, "info" => ["DomainSet" => $data, "TotalCount" => $r["info"]["data"]["total"]]];
    }
    private function QueryDomainList($query)
    {
        $r = $this->get("/audit/?act=domaininfo", ["domain" => $query["DomainName"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $query["DomainName"], "DomainName" => $query["DomainName"], "ExpirationDate" => $r["info"]["data"]["rexpiredate"], "RegistrationDate" => $r["info"]["data"]["regdate"]]]]]];
        return $result;
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $arr = ["domain" => $query["DomainName"], "regyear" => $query["Period"], "c_sysid" => $query["RegistrantProfileId"], "client_price" => $query["Price"]];
        if (!empty($query["Dns1"]) && !empty($query["Dns2"])) {
            $arr["dns_host1"] = $query["Dns1"];
            $arr["dns_host2"] = $query["Dns2"];
        }
        $r = $this->get("/audit/?act=regdomain", $arr);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["active"] = "正常";
        return $r;
    }
    private function SaveBatchTaskForModifyingDomainDns($query)
    {
        $arr = ["domain" => $query["DomainName.1"]];
        if (!empty($query["DomainNameServer.1"]) && !empty($query["DomainNameServer.2"])) {
            $arr["dns1"] = $query["DomainNameServer.1"];
            $arr["dns2"] = $query["DomainNameServer.2"];
        } else {
            $arr["dns1"] = "ns1.myhostadmin.net";
            $arr["dns2"] = "ns2.myhostadmin.net";
        }
        $r = $this->get("/domain/?act=moddns", $arr);
        return $r;
    }
    public function DescribeDomainNs($query)
    {
        $r = $this->get("/audit/?act=domaininfo", ["domain" => $query["DomainName"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => [$r["info"]["data"]["dns_host1"], $r["info"]["data"]["dns_host2"]]];
    }
    private function SaveBatchTaskForCreatingOrderRenew($query)
    {
        $rr = $this->get("/audit/?act=domaininfo", ["domain" => $query["OrderRenewParam.1.DomainName"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $r = $this->get("/domain/?act=renew", ["domain" => $query["OrderRenewParam.1.DomainName"], "year" => intval($query["OrderRenewParam.1.SubscriptionDuration"]), "expiredate" => $rr["info"]["data"]["rexpiredate"], "client_price" => $query["Price"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["expiredate"] = date("Y-m-d H:i:s", strtotime("+" . $query["OrderRenewParam.1.SubscriptionDuration"] . " year", strtotime($rr["info"]["data"]["rexpiredate"])));
        return $r;
    }
}

?>