<?php
define("QCLOUDAPI_ROOT_PATH", dirname(__FILE__) . "/QCloud/src/QcloudApi");
class west_dominbygzhx_dns
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "https://api.west.cn/api/v2";
    public $ttl = 900;
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curl($url, $data = NULL)
    {
        if (!empty($data)) {
            foreach ($data as $k => $v) {
                $data[$k] = mb_convert_encoding($v, "GB2312", "UTF-8");
            }
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        return mb_convert_encoding($result, "UTF-8", "GBK");
    }
    public function Line()
    {
        return ["default" => "默认", "LTEL" => "中国电信", "LCNC" => "中国联通", "LMOB" => "中国移动", "LEDU" => "教育网", "LSEO" => "搜索引擎"];
    }
    public function recordType()
    {
        return ["A" => "A", "CNAME" => "CNAME", "MX" => "MX", "TXT" => "TXT", "AAAA" => "AAAA", "SRV" => "SRV"];
    }
    private function get($Action, $option)
    {
        list($msec, $sec) = explode(" ", microtime());
        $msectime = (double) sprintf("%.0f", (floatval($msec) + floatval($sec)) * 1000);
        $token = strtolower(md5($this->uid . $this->APiKey . $msectime));
        $option["username"] = $this->uid;
        $option["time"] = $msectime;
        $option["token"] = $token;
        $url = $this->ApiUrl . $Action;
        $result = $this->curl($url, $option);
        $myarray = json_decode($result, true);
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("result", $myarray)) {
            return ["status" => 0, "info" => "没有参数【result】"];
        }
        if ($myarray["result"] != "200") {
            return ["status" => 0, "info" => $myarray["msg"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data)
    {
        return $this->{$Action}($query);
    }
    public function GetRecords($DomainName, $page = 1)
    {
        $r = $this->get("/domain/?act=getdnsrecord", ["domain" => $DomainName, "limit" => 20, "pageno" => 1]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["records" => [], "count" => $r["info"]["data"]["total"]]];
        foreach ($r["info"]["data"]["items"] as $k => $v) {
            $result["info"]["records"][] = ["RR" => $v["item"], "Line" => $this->Line()[empty($v["line"]) ? "default" : $v["line"]], "Type" => $v["type"], "Value" => $v["value"], "TTL" => $v["ttl"], "Status" => $v["pause"] == 1 ? "" : "ENABLE", "RecordId" => $v["id"], "Priority" => $v["level"]];
        }
        return $result;
    }
    public function DescribeDomainRecords($query)
    {
        $r = $this->GetRecords($query["DomainName"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $totalpages = $r["info"]["totalpages"];
        $Records = $r["info"];
        if (1 < $totalpages) {
            for ($i = 2; $i <= $totalpages; $i++) {
                $rr = $this->GetRecords($query["DomainName"], $i);
                if ($rr["status"] == 1) {
                    $Records = array_merge($Records, $rr["info"]);
                }
            }
        }
        return ["status" => 1, "info" => ["DomainRecords" => ["Record" => $Records]]];
    }
    public function AddDomainRecord($query)
    {
        $r = $this->get("/domain/?act=adddnsrecord", ["domain" => $query["DomainName"], "host" => $query["RR"], "type" => $query["Type"], "value" => $query["Value"], "ttl" => 900, "level" => empty($query["Priority"]) ? 1 : $query["Priority"], "line" => $query["Line"] == "default" ? "" : $query["Line"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => ["RecordId" => $r["info"]["data"]["id"]]];
    }
    public function UpdateDomainRecord($query)
    {
        $r = $this->get("/domain/?act=moddnsrecord", ["domain" => $query["DomainName"], "id" => $query["RecordId"], "value" => $query["Value"], "ttl" => 900]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "修改成功"];
    }
    public function SetDomainRecordStatus($query)
    {
        return ["status" => 0, "info" => "不支持"];
    }
    public function DeleteDomainRecord($query)
    {
        $r = $this->get("/domain/?act=deldnsrecord", ["domain" => $query["DomainName"], "id" => $query["RecordId"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "删除成功"];
    }
    public function DescribeDomainNs($query)
    {
        $r = $this->get("/audit/?act=domaininfo", ["domain" => $query["DomainName"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => ["ExpectDnsServers" => ["ExpectDnsServer" => [$r["info"]["data"]["dns_host1"], $r["info"]["data"]["dns_host2"]]]]];
    }
    public function AddDomain($query)
    {
        return ["status" => 0, "info" => "西部数码解析只允许西部数码的域名，请联系客服处理"];
    }
}

?>