<?php
class xinnet_dominbygzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "http://api.xinnet.com/domain/api.gb";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curl($option)
    {
        if (array_key_exists("checksum", $option)) {
            $checksum[] = $option["method"];
            $checksum[] = $this->uid;
            $checksum[] = $this->APiKey;
            if ($option["token"]) {
                $option["data"]["checksum"] = $option["token"];
            } else {
                if (is_array($option["checksum"])) {
                    foreach ($option["checksum"] as $key => $value) {
                        if ($option["data"][$value]) {
                            $checksum[] = $option["data"][$value];
                        }
                    }
                } else {
                    foreach ($option["data"] as $key => $value) {
                        if ($value) {
                            $checksum[] = $value;
                        }
                    }
                }
                $option["data"]["checksum"] = strtolower(md5(implode("", $checksum)));
            }
        }
        $option["data"]["client"] = $this->uid;
        $option["data"]["enc"] = "E";
        $option["data"]["charset"] = "utf-8";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->ApiUrl . "?method=" . $option["method"]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($option["data"])) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($option["data"]));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        parse_str($result, $myArr);
        return $myArr;
    }
    private function get($Action, $option)
    {
        $option["method"] = $Action;
        $result = $this->curl($option);
        $myarray = $result;
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("ret", $myarray)) {
            return ["status" => 0, "info" => "没有参数【ret】"];
        }
        if ($myarray["ret"] != "100") {
            return ["status" => 0, "info" => $myarray["err"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    public function DescribeDomainBaseInfo($query)
    {
        $rr = $this->get("queryDomainInfo", ["data" => ["dn" => $query["DomainName"], "queryType" => "regType"], "checksum" => "all"]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $Info = $rr["info"];
        return ["status" => 1, "info" => ["域名" => $Info["domainName"], "注册时间" => $Info["applyDate"], "到期时间" => $Info["expireDate"], "所有中（中文）" => $Info["r_organize_name_cn"], "所有者（英文）" => $Info["r_organize_name_uk"], "电子邮箱" => $Info["r_email"], "手机号" => $Info["r_phone"]]];
    }
    private function CheckDomain($query)
    {
        $DomainName = $query["DomainName"];
        $domainArr = explode(".", $DomainName);
        $domainExt = mb_substr($DomainName, mb_strlen($domainArr[0], "UTF-8"), NULL, "UTF-8");
        $r = $this->curl(["method" => "check", "data" => ["name" => $domainArr[0], "suffix" => $domainExt], "token" => "123"]);
        if (array_key_exists("chk1", $r) && intval($r["chk1"]) == 100) {
            $r["info"]["Avail"] = 1;
            $r["status"] = 1;
        } else {
            $r["status"] = 1;
            $r["info"]["Avail"] = 2;
        }
        return $r;
    }
    public function SaveRegistrantProfile($query)
    {
        switch ($query["IdentityCredentialType"]) {
            case "SFZ":
                $f_type_org = "SFZ";
                break;
            case "HZ":
                $f_type_org = "HZ";
                break;
            case "TXZ":
                $f_type_org = "TXZ";
                break;
            case "YYZZ":
                $f_type_org = "YYZZ";
                break;
            case "ORG":
                $f_type_org = "ORG";
                break;
            case "TYDMZ":
                $f_type_org = "XYDM";
                break;
            default:
                $post = ["tname" => $query["RegistrantProfileId"] ?: "T" . date("YmdHis") . $query["RegistrantType"], "utype" => $query["RegistrantType"] == 1 ? "P" : "C", "uname1" => $query["ZhRegistrantOrganization"], "uname2" => str_ireplace(" ", "", $query["RegistrantOrganization"]), "rname1" => $query["ZhRegistrantName"], "rname2" => explode(" ", $query["RegistrantName"])[0], "rname3" => explode(" ", $query["RegistrantName"])[1], "organ_code" => $query["IdentityCredentialNo"], "file_reg" => $query["RegistrantProfilePic"], "ust" => "CN", "utelc" => "86", "ufaxc" => "86", "uprov" => "zhejiangsheng", "ucity2" => "hangzhoushi", "uaddr1" => $query["ZhAddress"], "uaddr2" => $query["Address"], "uzip" => $query["PostalCode"], "utela" => mb_substr($query["Telephone"], 0, 3, "utf-8"), "uteln" => mb_substr($query["Telephone"], 3, NULL, "utf-8"), "ufaxa" => mb_substr($query["Telephone"], 0, 3, "utf-8"), "ufaxn" => mb_substr($query["Telephone"], 3, NULL, "utf-8"), "uemail" => $query["Email"], "idType" => $f_type_org, "testFlag" => "新网数码"];
                if (!empty($query["RegistrantProfileId"])) {
                    $post["tname"] = $query["RegistrantProfileId"];
                    $checksum = [];
                    $checksum[] = "modTemplate";
                    $checksum[] = $post["tname"];
                    $checksum[] = $this->uid;
                    $checksum[] = $this->APiKey;
                    $r = $this->get("modTemplate", ["data" => $post, "checksum" => ["tname"], "token" => strtolower(md5(implode("", $checksum)))]);
                } else {
                    $checksum = [];
                    $checksum[] = "createTemplate";
                    $checksum[] = $post["tname"];
                    $checksum[] = $this->uid;
                    $checksum[] = $this->APiKey;
                    $r = $this->get("createTemplate", ["data" => $post, "checksum" => ["tname"], "token" => strtolower(md5(implode("", $checksum)))]);
                }
                if ($r["status"] != 1) {
                    return $r;
                }
                if ($r["status"] == 1) {
                    $r["info"]["RegistrantProfileId"] = $post["tname"];
                }
                return $r;
        }
    }
    private function TemplateData($data)
    {
        $status = "未知";
        strval($data["status"]);
        switch (strval($data["status"])) {
            case "00":
                $status = "未实名认证";
                break;
            case "04":
                $status = "审核中";
                break;
            case "06":
                $status = "已实名认证";
                break;
            case "07":
                $status = "实名失败";
                break;
            case "05":
                $status = "实名失败";
                break;
            default:
                parse_str($data["info"], $arr);
                $info = ["TemplateId" => $arr["tname"], "Email" => $data["uemail"], "RegistrantType" => $data["utype"] == "P" ? 1 : 2, "ZhRegistrantName" => (string) $data["uname1"], "AuditStatus" => $status, "RegistrantName" => $data["uname2"], "Province" => $data["uprov"], "City" => $data["ucity2"], "Address" => $data["uaddr2"], "Country" => "CN", "TelArea" => "86", "Telephone" => $data["uteln"], "TelExt" => "1234", "PostalCode" => $data["uzip"]];
                if ($status == "实名失败" && !empty($data["auditUnpassReason"])) {
                    $info["AuditStatus"] = (string) $data["auditUnpassReason"];
                }
                return $info;
        }
    }
    public function DescribeTemplate($query)
    {
        $checksum = [];
        $checksum[] = "templateInfo";
        $checksum[] = $query["vid"];
        $checksum[] = $this->uid;
        $checksum[] = $this->APiKey;
        $r = $this->get("templateInfo", ["data" => ["tname" => $query["vid"], "refresh" => "true", "testFlag" => "新网数码"], "checksum" => ["tname"], "token" => strtolower(md5(implode("", $checksum)))]);
        if ($r["status"] == 1) {
            $status = "未知";
            strval($r["info"]["status"]);
            switch (strval($r["info"]["status"])) {
                case "00":
                    $status = "未实名认证";
                    break;
                case "04":
                    $status = "审核中";
                    break;
                case "06":
                    $status = "已实名认证";
                    break;
                case "07":
                    $status = "实名失败";
                    break;
                case "05":
                    $status = "实名失败";
                    break;
                default:
                    $r["AuditStatus"] = $status;
                    return ["status" => 1, "AuditStatus" => $status, "info" => $this->TemplateData($r["info"])];
            }
        } else {
            return $r;
        }
    }
    public function DescribeTemplateList($Offset)
    {
        $r = $this->get("/audit/?act=auditlist", ["pageno" => $Offset + 1, "pagesize" => 100]);
        if ($r["status"] != 1) {
            return $r;
        }
        $info = ["status" => 1, "info" => ["TemplateSet" => [], "TotalCount" => $r["info"]["data"]["pagelist"]["total"]]];
        foreach ($r["info"]["data"]["info"] as $key => $value) {
            $info["info"]["TemplateSet"][] = $this->TemplateData($value);
        }
        return $info;
    }
    public function DescribeDomainNameList($Offset = 0)
    {
        $r = $this->get("/domain/?act=getdomains&limit=100&pageno=" . ($Offset + 1), []);
        if ($r["status"] != 1) {
            return $r;
        }
        $data = [];
        foreach ($r["info"]["data"]["items"] as $item) {
            $data[] = ["DomainId" => $item["domain"], "DomainName" => $item["domain"], "CreationDate" => $item["regdate"], "ExpirationDate" => $item["expdate"], "BuyStatus" => "ok"];
        }
        return ["status" => 1, "info" => ["DomainSet" => $data, "TotalCount" => $r["info"]["data"]["total"]]];
    }
    public function QueryDomainList($query)
    {
        $r = $this->get("queryDomainInfo", ["data" => ["dn" => $query["DomainName"], "queryType" => "regType"], "checksum" => "all"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $query["DomainName"], "DomainId" => $query["DomainName"], "DomainName" => $query["DomainName"], "ExpirationDate" => $r["info"]["expireDate"], "RegistrationDate" => $r["info"]["applyDate"]]]]]];
        return $result;
    }
    public function DomainPassword($query)
    {
        $checksum = [];
        $checksum[] = "GetProductKey";
        $checksum[] = $this->uid;
        $checksum[] = $this->APiKey;
        $checksum[] = $query["DomainName"];
        $checksum[] = "E";
        $r = $this->get("GetProductKey", ["data" => ["name" => $query["DomainName"], "keyname" => "Password"], "checksum" => ["name"], "token" => strtoupper(md5(implode("", $checksum)))]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["password"] = $r["info"]["key"];
        $r["info"]["uri"] = "https://dcp.xinnet.com/";
        return $r;
    }
    public function queryDomainVerifyStatus($query)
    {
        $checksum = [];
        $checksum[] = "queryDomainVerifyStatus";
        $checksum[] = $this->uid;
        $checksum[] = $this->APiKey;
        $checksum[] = $query["DomainName"];
        $r = $this->get("queryDomainVerifyStatus", ["data" => ["dn" => $query["DomainName"]], "checksum" => ["name"], "token" => strtolower(md5(implode("", $checksum)))]);
        if ($r["status"] != 1) {
            return $r;
        }
        parse_str($r["info"]["info"], $arr);
        $status = "未知";
        strval($arr["auditStatus"]);
        switch (strval($arr["auditStatus"])) {
            case "00":
                $status = "未实名认证";
                break;
            case "04":
                $status = "审核中";
                break;
            case "06":
                $status = "已实名认证";
                break;
            case "07":
                $status = "实名失败";
                break;
            case "05":
                $status = "实名失败";
                break;
            default:
                $r["AuditStatus"] = $status;
                return $r;
        }
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $checksum = [];
        $checksum[] = "templateRegister";
        $checksum[] = $query["RegistrantProfileId"];
        $checksum[] = $query["DomainName"];
        $checksum[] = $this->uid;
        $checksum[] = $this->APiKey;
        $r = $this->get("templateRegister", ["data" => ["tname" => $query["RegistrantProfileId"], "dn" => $query["DomainName"], "testFlag" => "新网数码", "period" => $query["Period"]], "checksum" => ["tname"], "token" => strtolower(md5(implode("", $checksum)))]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["active"] = "正常";
        return $r;
    }
    public function beforeReg($query)
    {
        $r = $this->DescribeTemplate(["vid" => $query["RegistrantProfileId"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        if ($r["AuditStatus"] != "已实名认证") {
            return ["status" => 0, "info" => "当前信息模版" . $r["AuditStatus"] . "，暂时无法注册域名"];
        }
        return $r;
    }
    private function SaveBatchTaskForModifyingDomainDns($query)
    {
        $arr = ["domain" => $query["DomainName.1"]];
        if (!empty($query["DomainNameServer.1"]) && !empty($query["DomainNameServer.2"])) {
            $arr["dns1"] = $query["DomainNameServer.1"];
            $arr["dns2"] = $query["DomainNameServer.2"];
        } else {
            $arr["dns1"] = "ns11.xincache.com";
            $arr["dns2"] = "ns12.xincache.com";
        }
        $r = $this->get("ModDns", ["data" => ["dn" => $query["DomainName.1"], "dns1" => $arr["dns1"], "dns2" => $arr["dns2"]], "checksum" => "all"]);
        return $r;
    }
    public function DescribeDomainNs($query)
    {
        return ["status" => 1, "info" => ["ns11.xincache.com", "ns12.xincache.com"]];
    }
    private function SaveBatchTaskForCreatingOrderRenew($query)
    {
        $rDomainInfo = $this->get("queryDomainInfo", ["data" => ["dn" => $query["OrderRenewParam.1.DomainName"], "queryType" => "regType"], "checksum" => "all"]);
        if ($rDomainInfo["status"] != 1) {
            return $rDomainInfo;
        }
        $checksum = [];
        $checksum[] = "DomainRenew";
        $checksum[] = $this->uid;
        $checksum[] = $this->APiKey;
        $checksum[] = $query["OrderRenewParam.1.DomainName"];
        $checksum[] = "E";
        $checksum[] = $rDomainInfo["info"]["expireDate"];
        $r = $this->get("DomainRenew", ["data" => ["begindate" => $rDomainInfo["info"]["expireDate"], "dn" => $query["OrderRenewParam.1.DomainName"], "period" => intval($query["OrderRenewParam.1.SubscriptionDuration"]), "price" => $query["Price"]], "checksum" => ["tname"], "token" => strtolower(md5(implode("", $checksum)))]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["expiredate"] = date("Y-m-d H:i:s", strtotime("+" . $query["OrderRenewParam.1.SubscriptionDuration"] . " year", strtotime($rDomainInfo["info"]["expireDate"])));
        return $r;
    }
}

?>