<?php
class xinnet_dominbygzhx_dns
{
    public $ttl = 900;
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "http://api.xinnet.com/domain/api.gb";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curl($option)
    {
        if (array_key_exists("checksum", $option)) {
            $checksum[] = $option["method"];
            $checksum[] = $this->uid;
            $checksum[] = $this->APiKey;
            if (is_array($option["checksum"])) {
                foreach ($option["checksum"] as $key => $value) {
                    if ($option["data"][$value]) {
                        $checksum[] = $option["data"][$value];
                    }
                }
            } else {
                foreach ($option["data"] as $key => $value) {
                    if ($value) {
                        $checksum[] = $value;
                    }
                }
            }
            $option["data"]["checksum"] = strtolower(md5(implode("", $checksum)));
        }
        $option["data"]["client"] = $this->uid;
        $option["data"]["enc"] = "E";
        $option["data"]["charset"] = "utf-8";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->ApiUrl . "?method=" . $option["method"]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($option["data"])) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($option["data"]));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        parse_str($result, $myArr);
        return $myArr;
    }
    private function get($Action, $option)
    {
        list($msec, $sec) = explode(" ", microtime());
        $msectime = (double) sprintf("%.0f", (floatval($msec) + floatval($sec)) * 1000);
        $token = strtolower(md5($this->uid . $this->APiKey . $msectime));
        $option["method"] = $Action;
        $result = $this->curl($option);
        $myarray = $result;
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("ret", $myarray)) {
            return ["status" => 0, "info" => "没有参数【ret】"];
        }
        if ($myarray["ret"] != "100") {
            return ["status" => 0, "info" => $myarray["err"] ?: $myarray["reason"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    public function recordType()
    {
        return ["A" => "A", "CNAME" => "CNAME", "MX" => "MX", "TXT" => "TXT", "AAAA" => "AAAA", "SRV" => "SRV"];
    }
    public function Line()
    {
        return ["default" => "默认"];
    }
    public function GetRecords($DomainName, $page = 1)
    {
        $recordType = $this->recordType();
        $Records = [];
        foreach ($recordType as $key => $value) {
            $r = $this->get("DomainDNSQuery", ["data" => ["name" => $DomainName, "type" => $key], "checksum" => ["name"]]);
            $SubRecords = [];
            $DomainNameLen = mb_strlen($DomainName, "utf-8");
            for ($i = 1; $i <= $r["info"]["num"]; $i++) {
                $recordname = $r["info"]["recordname" . $i];
                $recordnameLen = mb_strlen($recordname, "utf-8");
                $id = mb_substr($recordname, 0, $recordnameLen - $DomainNameLen, "utf-8");
                if (mb_substr($id, -1, NULL, "utf-8") == ".") {
                    $id = mb_substr($id, 0, -1, "utf-8");
                }
                $rid = base64_encode($r["info"]["type"] . "#" . $id);
                $SubRecords[] = ["id" => $rid, "item" => $id, "type" => $r["info"]["type"], "value" => $r["info"]["content" . $i], "line" => "default"];
            }
            $Records = array_merge($Records, $SubRecords);
        }
        $result = ["status" => 1, "info" => ["records" => [], "count" => count($Records)]];
        foreach ($Records as $k => $v) {
            $result["info"]["records"][] = ["RR" => $v["item"], "Line" => $this->Line()[empty($v["line"]) ? "default" : $v["line"]], "Type" => $v["type"], "Value" => $v["value"], "TTL" => $v["ttl"], "Status" => $v["pause"] == 1 ? "" : "ENABLE", "RecordId" => $v["id"], "Priority" => $v["level"]];
        }
        return $result;
    }
    public function DescribeDomainRecords($query)
    {
        $r = $this->GetRecords($query["DomainName"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $totalpages = $r["info"]["totalpages"];
        $Records = $r["info"];
        if (1 < $totalpages) {
            for ($i = 2; $i <= $totalpages; $i++) {
                $rr = $this->GetRecords($query["DomainName"], $i);
                if ($rr["status"] == 1) {
                    $Records = array_merge($Records, $rr["info"]);
                }
            }
        }
        return ["status" => 1, "info" => ["DomainRecords" => ["Record" => $Records]]];
    }
    public function AddDomainRecord($query)
    {
        $r = $this->get("DomainDNSAdd", ["data" => ["name" => $query["DomainName"], "recordname" => empty($query["RR"]) ? $query["DomainName"] : $query["RR"] . "." . $query["DomainName"], "type" => $query["Type"], "content" => $query["Value"], "ttl" => 900, "prio" => 0], "checksum" => ["name"]]);
        if ($r["status"] != 1) {
            if (strstr($r["info"], "实名")) {
                return ["status" => 0, "info" => "当前域名通过实名认证，请通过官方面板提交实名信息"];
            }
            return $r;
        }
        return ["status" => 1, "info" => ["RecordId" => base64_encode($query["Type"] . "#" . $query["RR"])]];
    }
    public function UpdateDomainRecord($query)
    {
        return ["status" => 0, "info" => "请删除后重新添加"];
    }
    public function SetDomainRecordStatus($query)
    {
        return ["status" => 0, "info" => "不支持"];
    }
    public function DeleteDomainRecord($query)
    {
        $id = explode("#", base64_decode($query["RecordId"]));
        $r = $this->get("DomainDNSDel", ["data" => ["name" => $query["DomainName"], "recordname" => empty($id[1]) ? $query["DomainName"] : $id[1] . "." . $query["DomainName"], "type" => $id[0]], "checksum" => ["name"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "删除成功"];
    }
    public function DescribeDomainNs($query)
    {
        return ["status" => 1, "info" => ["ExpectDnsServers" => ["ExpectDnsServer" => ["", ""]]]];
    }
    public function AddDomain($query)
    {
        return ["status" => 0, "info" => "新网解析只允许西部数码的域名，请联系客服处理"];
    }
}

?>