<?php
function ancdnflyuser_idcsmartauthorizes()
{
}
function ancdnflyuser_AllowFunction()
{
    return ["client" => ["wzhcqk", "wzccgzon", "wzccgzoff", "wzccgzdel", "wzccgzput", "wzccglon", "wzccgloff", "wzccgldel", "wzccglput", "wzccppon", "wzccppoff", "wzccppdel", "wzccppput", "wzzssqput", "dnsapidel", "dnsapiput", "wzylcx", "wzglpostdx", "wzgziptype", "wzglwebsocket", "wzglgzip", "wzssll", "wzccsafe", "autoccsafe", "wzglhmd", "wzglbmd", "wzglpbdl", "wzglpbgw", "wzglmaxkxljtimeout", "wzglmaxkxlj", "wzglhyljc", "wzglhyhttpbb", "wzglhyym", "wzglfphy", "wzglaclid", "wzgldhcgz", "wzxgsslaqpz", "wzxgdhsts", "wzxgwzdocsp", "wzxgdwzhttpsport", "wzxgdqzhttps", "wzxgdhttp2", "wzxgdhydkys", "wzxgdyzfzfsxy", "wzxgdtimeout", "wzxgdyzsz", "wzxgdhttpshydk", "wzxgdhttphydk", "wzxgdhyxy", "wzxgdwzzs", "wzxgdjtdk", "wzxgym", "wzglxx", "wzgldel", "wzgloff", "wzglon", "wzglput", "l4xgzdyacl", "l4xgmracl", "l4xgljxz", "l4xgyzsz", "l4xgdstport", "l4xgyzfzjh", "l4xgprotocol", "l4xgjtdk", "l4zfxx", "l4del", "l4off", "l4on", "l4put", "wzzsdel", "wzzsoff", "wzzson", "wzzsput", "wzacldel", "wzacloff", "wzaclon", "wzaclput"], "admin" => []];
}
function ancdnflyuser_MetaData()
{
    return ["DisplayName" => "cdnfly用户端", "APIVersion" => "1.2", "HelpDoc" => "https://anvps.cn"];
}
function ancdnflyuser_ConfigOptions()
{
    return [["type" => "text", "name" => "在售套餐id", "description" => "绑定在售套餐的id，获取方法(1，联系cdnfly平台客服；(2，前往帮助文档使用自动化获取工具；", "default" => "1", "key" => "package"]];
}
function ancdnflyuser_ClientArea($params)
{
    return ["wzgl" => ["name" => "网站管理"], "wzzs" => ["name" => "证书管理"], "wzgz" => ["name" => "网站ACL"], "ccgz" => ["name" => "CC规则组"], "ccpp" => ["name" => "CC匹配器"], "ccgl" => ["name" => "CC过滤器"], "wzjk" => ["name" => "网站监控"], "sczf" => ["name" => "四层转发"], "ylcx" => ["name" => "用量查询"], "dnsapi" => ["name" => "DNSAPI"]];
}
function ancdnflyuser_ClientAreaOutput($params, $key)
{
    if ($key == "wzgl") {
        return ["template" => "templates/wzgl.html", "vars" => ["list" => ancdnflyuser_wzgl($params), "ccfh" => ancdnflyuser_wzccfh($params)]];
    }
    if ($key == "wzzs") {
        return ["template" => "templates/wzzs.html", "vars" => ["list" => ancdnflyuser_wzzs($params), "wzlist" => ancdnflyuser_wzgl($params)]];
    }
    if ($key == "wzgz") {
        return ["template" => "templates/wzgz.html", "vars" => ["list" => ancdnflyuser_wzacl($params)]];
    }
    if ($key == "ccgz") {
        return ["template" => "templates/ccgz.html", "vars" => ["list" => ancdnflyuser_ccgzz($params)]];
    }
    if ($key == "ccpp") {
        return ["template" => "templates/ccpp.html", "vars" => ["list" => ancdnflyuser_ccppq($params)]];
    }
    if ($key == "ccgl") {
        return ["template" => "templates/ccgl.html", "vars" => ["list" => ancdnflyuser_ccglq($params)]];
    }
    if ($key == "wzjk") {
        return ["template" => "templates/wzjk.html", "vars" => ["list" => ancdnflyuser_wzgl($params)]];
    }
    if ($key == "sczf") {
        return ["template" => "templates/sczf.html", "vars" => ["list" => ancdnflyuser_l4zf($params)]];
    }
    if ($key == "ylcx") {
        return ["template" => "templates/ylcx.html", "vars" => ["list" => ancdnflyuser_wzgl($params)]];
    }
    if ($key == "dnsapi") {
        return ["template" => "templates/dnsapi.html", "vars" => ["list" => ancdnflyuser_dnsapi($params)]];
    }
}
function ancdnflyuser_TestLink($params)
{
    $path = "/api-key";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = "error";
    }
    return $result;
}
function ancdnflyuser_CreateAccount($params)
{
    $path = "/user-packages";
    $time = $params["billingcycle"] == "annually" ? "year" : substr($params["billingcycle"], 0, -2);
    $post = json_encode(["duration" => $time, "package" => $params["configoptions"]["package"], "name" => $params["domain"]]);
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $update["username"] = $array["data"];
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        $result["status"] = "success";
        $result["msg"] = $array["msg"];
    } else {
        $result["status"] = "error";
        $result["msg"] = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_TerminateAccount($params)
{
    $path = "/user-packages/" . $params["username"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result["status"] = "success";
        $result["msg"] = $array["msg"];
    } else {
        $result["status"] = "error";
        $result["msg"] = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_Renew($params)
{
    $path = "/user-packages/" . $params["username"];
    $time = $params["billingcycle"] == "annually" ? "year" : substr($params["billingcycle"], 0, -2);
    $post = json_encode(["duration" => $time]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result["status"] = "success";
        $result["msg"] = $array["msg"];
    } else {
        $result["status"] = "error";
        $result["msg"] = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_post($path, $post, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $body = curl_exec($ch);
    curl_close($ch);
    return $body;
}
function ancdnflyuser_get($path, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $body = curl_exec($ch);
    curl_close($ch);
    return $body;
}
function ancdnflyuser_del($path, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper("DELETE"));
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}
function ancdnflyuser_put($path, $post, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper("PUT"));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}
function ancdnflyuser_l4zf($params)
{
    $path = "/streams?user_package=" . $params["username"];
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = $array["data"];
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_l4put($params)
{
    $post = input("post.");
    $path = "/streams";
    $post = html_entity_decode("[{\"user_package\":\"" . $params["username"] . "\",\"listen\":[{\"protocol\":\"" . $post["type"] . "\",\"port\":\"" . $post["src_port"] . "\"}],\"backend_port\":\"" . $post["dst_port"] . "\",\"backend\":[{\"addr\":\"" . $post["address"] . "\"}]}]");
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4on($params)
{
    $post = input("post.");
    $path = "/streams";
    $post = json_encode(["id" => $post["id"], "enable" => 1]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4off($params)
{
    $post = input("post.");
    $path = "/streams";
    $post = json_encode(["id" => $post["id"], "enable" => 0]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4del($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzzs($params)
{
    $path = "/certs?des=" . $params["domain"];
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = $array["data"];
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzzson($params)
{
    $post = input("post.");
    $path = "/certs";
    $post = json_encode(["id" => $post["id"], "enable" => 1]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzzsoff($params)
{
    $post = input("post.");
    $path = "/certs";
    $post = json_encode(["id" => $post["id"], "enable" => 0]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzzsdel($params)
{
    $post = input("post.");
    $path = "/certs/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzzsput($params)
{
    $post = input("post.");
    $path = "/certs";
    $post = json_encode(["name" => $post["name"], "des" => $params["domain"], "cert" => $post["cert"], "key" => $post["key"], "type" => "custom"]);
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzacl($params)
{
    $path = "/acls";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = [];
        foreach ($array["data"] as $aclid => $acldata) {
            if ($acldata["des"] == $params["domain"]) {
                $result[] = $acldata;
            }
        }
        if (sizeof($result) === 0) {
            $result = "count";
        }
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzaclon($params)
{
    $post = input("post.");
    $path = "/acls";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":1}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzacloff($params)
{
    $post = input("post.");
    $path = "/acls";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":0}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzacldel($params)
{
    $post = input("post.");
    $path = "/acls/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzaclput($params)
{
    $post = input("post.");
    $path = "/acls";
    $post = html_entity_decode("{\"name\":\"" . $post["name"] . "\",\"des\":\"" . $params["domain"] . "\",\"data\":" . $post["code"] . ",\"default_action\":\"" . $post["type"] . "\"}");
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgport($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = html_entity_decode("{\"listen\":[" . $post["code"] . "]}");
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4zfxx($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["data"]) ? $array["data"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgjtdk($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = html_entity_decode("{\"listen\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgprotocol($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = "{\"proxy_protocol\":" . $post["data"] . "}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgyzfzjh($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = "{\"balance_way\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgdstport($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = "{\"backend_port\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgyzsz($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = html_entity_decode("{\"backend\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgljxz($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = "{\"conn_limit\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgmracl($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = "{\"acl\":{\"default_action\":\"" . $post["data"] . "\"}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_l4xgzdyacl($params)
{
    $post = input("post.");
    $path = "/streams/" . $post["id"];
    $post = html_entity_decode("{\"acl\":{\"rule\":" . $post["data"] . "}}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzgl($params)
{
    $path = "/sites?user_package=" . $params["username"];
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = $array["data"];
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzglon($params)
{
    $post = input("post.");
    $path = "/sites";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":1}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzgloff($params)
{
    $post = input("post.");
    $path = "/sites";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":0}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzgldel($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglput($params)
{
    $post = input("post.");
    $path = "/sites";
    $post = "[{\"user_package\":\"" . $params["username"] . "\",\"domain\":\"" . $post["domain"] . "\",\"http_listen\":{\"port\":\"80\"},\"backend\":[{\"addr\":\"" . $post["dstip"] . "\"}],\"backend_http_port\":\"" . $post["dstport"] . "\"}]";
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglxx($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["data"]) ? $array["data"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgym($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"domain\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdjtdk($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"http_listen\":{\"port\":\"" . $post["data"] . "\"}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdwzzs($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    if ($post["data"] == 0) {
        $post = "{\"https_listen\":{}}";
    } else {
        $post = "{\"https_listen\":{\"cert\":\"" . $post["data"] . "\"}}";
    }
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdhyxy($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"backend_protocol\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdhttphydk($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"backend_http_port\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdhttpshydk($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"backend_https_port\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdyzsz($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"backend\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdtimeout($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"proxy_timeout\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdyzfzfsxy($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"balance_way\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdhydkys($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"backend_port_mapping\":" . $post["data"] . "}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdhsts($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"https_listen\":{\"hsts\":" . $post["data"] . "}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdhttp2($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"https_listen\":{\"http2\":" . $post["data"] . "}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdqzhttps($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"https_listen\":{\"force_ssl_enable\":" . $post["data"] . "}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgdwzhttpsport($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"https_listen\":{\"force_ssl_port\":\"" . $post["data"] . "\"}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgwzdocsp($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"https_listen\":{\"ocsp_stapling\":" . $post["data"] . "}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzxgsslaqpz($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"https_listen\":{\"ssl_protocols\":\"" . $post["a"] . "\",\"ssl_ciphers\":\"" . $post["b"] . "\",\"ssl_prefer_server_ciphers\":\"" . $post["c"] . "\"}}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzgldhcgz($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"proxy_cache\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglaclid($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"acl\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglfphy($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"range\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglhyym($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"backend_host\":\"" . $post["data"] . "\"}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglhyhttpbb($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"proxy_http_version\":\"" . $post["data"] . "\"}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglhyljc($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"ups_keepalive\":" . $post["data"] . "}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglmaxkxlj($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"ups_keepalive_conn\":\"" . $post["data"] . "\"}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglmaxkxljtimeout($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = html_entity_decode("{\"ups_keepalive_timeout\":\"" . $post["data"] . "\"}");
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccfh($params)
{
    $path = "/cc-rules?internal_self=1";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = $array["data"];
        if (sizeof($result) === 0) {
            $result = "count";
        }
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzglpbgw($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    if ($post["data"] == "true") {
        $post = "{\"block_region\":\"mn,kp,kr,jp,vn,la,kh,th,mm,my,sg,id,bn,ph,tl,in,bd,bt,np,pk,lk,mv,sa,qa,bh,kw,ae,om,ye,ge,lb,sy,il,ps,jo,iq,ir,af,cy,az,tm,tj,kg,uz,kz,dz,ao,bj,bw,bf,bi,cm,cv,cf,td,km,ci,cd,dj,eg,gq,er,et,ga,gm,gh,gn,gw,ke,ls,lr,ly,mg,mw,ml,mr,mu,ma,mz,na,ne,ng,cg,rw,st,sn,sc,sl,so,za,sd,ss,tz,tg,tn,ug,zm,zw,ag,bs,bb,bz,ca,cr,cu,dm,do,sv,ai,bm,gl,gd,gp,gt,ht,hn,jm,mq,mx,ms,aw,cw,ni,pa,kn,lc,vc,tt,tc,us,mf,pr,bl,sx,ar,bo,br,cl,co,ec,gy,py,pe,sr,uy,ve,al,ad,am,at,by,be,ba,bg,hr,cz,dk,ee,fi,fr,de,gr,hu,is,ie,it,lv,li,lt,lu,mk,mt,md,mc,me,nl,no,pl,pt,ro,ru,sm,rs,sk,si,es,se,ch,tr,ua,uk,va,au,pg,nz,fj,sb,pf,nc,vu,ws,gu,fm,to,ki,as,pw,wf,nr,tv,nu,tk\"}";
    } else {
        $post = "{\"block_region\":\"\"}";
    }
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglpbdl($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"block_proxy\":" . $post["data"] . "}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccsafe($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"cc_default_rule\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglhmd($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = json_encode(["black_ip" => $post["data"]]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglbmd($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = json_encode(["white_ip" => $post["data"]]);
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_autoccsafe($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    if (isset($post["time"]) && isset($post["mod"])) {
        $post = "{\"cc_switch\":{\"rule\":\"" . $post["mod"] . "\",\"switch\":\"" . $post["time"] . "\",\"enable\":1}}";
    } else {
        $post = "{\"cc_switch\":{}}";
    }
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzssll($params)
{
    $post = input("post.");
    date_default_timezone_set("PRC");
    $time = time();
    $time0 = date("Y-m-d H:i:s", $time - 3600);
    $time1 = date("Y-m-d H:i:s", $time);
    $path = "/monitor/site/realtime?type=" . $post["type"] . "&start=" . urlencode($time0) . "&end=" . urlencode($time1) . "&domain=" . $post["domain"] . "&port=";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $num = sizeof($array["data"]);
        $return = [];
        foreach ($array["data"] as $id => $value) {
            $return[] = $value[1];
        }
        $result = ["msg" => $return];
    } else {
        $result = "error";
    }
    return $result;
}
function ancdnflyuser_wzglgzip($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"gzip_enable\":" . $post["data"] . "}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglwebsocket($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"websocket_enable\":" . $post["data"] . ",\"ups_keepalive\":0}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzgziptype($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"gzip_types\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzglpostdx($params)
{
    $post = input("post.");
    $path = "/sites/" . $post["id"];
    $post = "{\"post_size_limit\":\"" . $post["data"] . "\"}";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzylcx($params)
{
    $post = input("post.");
    date_default_timezone_set("PRC");
    $time = time();
    $day = $post["time"] * 86400;
    $time0 = date("Y-m-d", $time - $day + 86400);
    $time1 = date("Y-m-d", $time + 86400);
    if ($post["domain"] == "all") {
        $domain = "";
    } else {
        $domain = $post["domain"];
    }
    $path = "/monitor/usage?cate=site&type=" . $post["type"] . "&start=" . urlencode($time0) . "&end=" . urlencode($time1) . "&res=" . $domain . "&user_package=" . $params["username"];
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = $array;
    } else {
        $result = "error";
    }
    return $result;
}
function ancdnflyuser_dnsapi($params)
{
    $path = "/dnsapis";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $v = [];
        foreach ($array["data"] as $id => $value) {
            if ($value["des"] == $params["domain"]) {
                $v[] = $value;
            }
        }
        if (sizeof($v) === 0) {
            $result = "count";
        } else {
            $result = $v;
        }
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_dnsapidel($params)
{
    $post = input("post.");
    $path = "/dnsapis/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_dnsapiput($params)
{
    $post = input("post.");
    $path = "/dnsapis";
    $post = "{\"name\":\"" . $post["name"] . "\",\"des\":\"" . $params["domain"] . "\",\"type\":\"" . $post["type"] . "\",\"auth\":{" . html_entity_decode($post["auth"]) . "}}";
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzzssqput($params)
{
    $post = input("post.");
    $path = "/certs";
    $post = json_encode(["name" => $post["name"], "des" => $params["domain"], "dnsapi" => $post["dnsapi"], "domain" => $post["domain"], "type" => $post["type"]]);
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_ccppq($params)
{
    $path = "/cc-matchs?internal_self=1";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = [];
        foreach ($array["data"] as $aclid => $acldata) {
            if ($acldata["des"] == $params["domain"] || $acldata["des"] == "内置匹配器") {
                $result[] = $acldata;
            }
        }
        if (sizeof($result) === 0) {
            $result = "count";
        }
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzccppon($params)
{
    $post = input("post.");
    $path = "/cc-matchs";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":1}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccppoff($params)
{
    $post = input("post.");
    $path = "/cc-matchs";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":0}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccppdel($params)
{
    $post = input("post.");
    $path = "/cc-matchs/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccppput($params)
{
    $post = input("post.");
    $path = "/cc-matchs";
    $post = html_entity_decode("{\"name\":\"" . $post["name"] . "\",\"des\":\"" . $params["domain"] . "\",\"data\":" . $post["code"] . "}");
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $post;
}
function ancdnflyuser_ccglq($params)
{
    $path = "/cc-filters?internal_self=1";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = [];
        foreach ($array["data"] as $aclid => $acldata) {
            if ($acldata["des"] == $params["domain"] || $acldata["des"] == "内置过滤器") {
                $result[] = $acldata;
            }
        }
        if (sizeof($result) === 0) {
            $result = "count";
        }
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzccglon($params)
{
    $post = input("post.");
    $path = "/cc-filters";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":1}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccgloff($params)
{
    $post = input("post.");
    $path = "/cc-filters";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":0}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccgldel($params)
{
    $post = input("post.");
    $path = "/cc-filters/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccglput($params)
{
    $post = input("post.");
    $path = "/cc-filters";
    $post = html_entity_decode("{\"name\":\"" . $post["name"] . "\",\"des\":\"" . $params["domain"] . "\",\"type\":\"" . $post["type"] . "\",\"within_second\":\"" . $post["time"] . "\",\"max_req\":\"" . $post["num"] . "\",\"max_req_per_uri\":\"0\",\"extra\":{}}");
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_ccgzz($params)
{
    $path = "/cc-rules?internal_self=1";
    $json = ancdnflyuser_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        if (isset($array["count"]) && $array["count"] === 0) {
            $result = "count";
        }
        $result = [];
        foreach ($array["data"] as $aclid => $acldata) {
            if ($acldata["des"] == $params["domain"] || $acldata["des"] == "内置规则") {
                $result[] = $acldata;
            }
        }
        if (sizeof($result) === 0) {
            $result = "count";
        }
    } else {
        $result = "count";
    }
    return $result;
}
function ancdnflyuser_wzccgzon($params)
{
    $post = input("post.");
    $path = "/cc-rules";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":1}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccgzoff($params)
{
    $post = input("post.");
    $path = "/cc-rules";
    $post = "[{\"id\":" . $post["id"] . ",\"enable\":0}]";
    $json = ancdnflyuser_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccgzdel($params)
{
    $post = input("post.");
    $path = "/cc-rules/" . $post["id"];
    $json = ancdnflyuser_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzccgzput($params)
{
    $post = input("post.");
    $path = "/cc-rules";
    $post = html_entity_decode("{\"name\":\"" . $post["name"] . "\",\"des\":\"" . $params["domain"] . "\",\"data\":" . $post["code"] . ",\"sort\":\"1\",\"is_show\":true}");
    $json = ancdnflyuser_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function ancdnflyuser_wzhcqk($params)
{
    $post = input("post.");
    $path = "/jobs";
    $posts = html_entity_decode("{\"type\":\"clean_dir\",\"data\":{\"url\":\"" . $post["domain"] . "\"}}");
    $json = ancdnflyuser_post($path, $posts, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    } else {
        $result = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}

?>