<?php
function cdn007idcgd_idcsmartauthorizes()
{
}
function cdnflyadmin_MetaData()
{
    return ["DisplayName" => "cdn007idcgd", "APIVersion" => "7.3.0", "HelpDoc" => "https://course.007idc.cn/"];
}
function cdnflyadmin_ConfigOptions()
{
    return [["type" => "dropdown", "name" => "开通方式", "options" => ["套餐ID开通", "弹性开通"], "description" => "0_套餐ID开通 / 1_弹性开通", "default" => "0", "key" => "way"], ["type" => "text", "name" => "套餐ID", "description" => "若选择套餐ID开通则此项必填", "default" => "1", "key" => "id_package"]];
}
function cdnflyadmin_ClientArea($params)
{
    return ["manage" => ["name" => "产品管理"]];
}
function cdnflyadmin_ClientAreaOutput($params, $key)
{
    if ($params["secure"] == 1) {
        $ssl = "https://";
    } else {
        $ssl = "http://";
    }
    $path = "/users/" . $params["dedicatedip"] . "?token=1";
    $json = cdnflyadmin_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $token = $array["data"]["access_token"];
        $token1 = @str_replace("/", "_", $token);
        $token2 = @str_replace("=", ",", $token1);
    }
    if ($key == "manage") {
        return ["template" => "templates/index.html", "vars" => ["login" => $ssl . $params["server_host"] . "/console/index.html#/user/login/redirect=/access_token=" . $token2 . "/username=" . $params["username"] . "/uid=" . $params["dedicatedip"], "url" => $params["server_host"], "username" => $params["domain"], "password" => $params["password"]]];
    }
}
function cdnflyadmin_TestLink($params)
{
    $path = "/api-key";
    $json = cdnflyadmin_get($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
        return $result;
    }
}
function cdnflyadmin_CreateAccount($params)
{
    $path = "/users";
    $post = json_encode(["email" => $params["domain"] . "@qq.com", "name" => $params["domain"], "password" => $params["password"], "type" => 2]);
    $json = cdnflyadmin_post($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        think\Db::name("host")->where("id", $params["hostid"])->update(["dedicatedip" => $array["data"]]);
        $path1 = "/user-packages";
        if ($params["configoptions"]["way"] == 0) {
            $package = $params["configoptions"]["id_package"];
        } else {
            $package = $params["configoptions"]["package"];
        }
        $time = $params["billingcycle"] == "annually" ? "year" : substr($params["billingcycle"], 0, -2);
        $post1 = json_encode(["package" => $package, "duration" => $time, "uid" => $array["data"], "name" => $params["name"]]);
        $json1 = cdnflyadmin_post($path1, $post1, $params);
        $array1 = json_decode($json1, true);
        if (isset($array1["code"]) && $array1["code"] === 0) {
            $update["username"] = $array1["data"];
            think\Db::name("host")->where("id", $params["hostid"])->update($update);
        } else {
            $result["status"] = "error";
            $result["msg"] = isset($array1["msg"]) ? $array1["msg"] : "error";
        }
    } else {
        $result["status"] = "error";
        $result["msg"] = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function cdnflyadmin_TerminateAccount($params)
{
    $path = "/user-packages/" . $params["username"];
    $json = cdnflyadmin_del($path, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result["status"] = "success";
        $result["msg"] = $array["msg"];
    } else {
        $result["status"] = "error";
        $result["msg"] = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function cdnflyadmin_Renew($params)
{
    $path = "/user-packages/" . $params["username"];
    $time = $params["billingcycle"] == "annually" ? "year" : substr($params["billingcycle"], 0, -2);
    $post = json_encode(["duration" => $time]);
    $json = cdnflyadmin_put($path, $post, $params);
    $array = json_decode($json, true);
    if (isset($array["code"]) && $array["code"] === 0) {
        $result["status"] = "success";
        $result["msg"] = $array["msg"];
    } else {
        $result["status"] = "error";
        $result["msg"] = isset($array["msg"]) ? $array["msg"] : "error";
    }
    return $result;
}
function cdnflyadmin_get($path, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $body = curl_exec($ch);
    curl_close($ch);
    return $body;
}
function cdnflyadmin_post($path, $post, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $body = curl_exec($ch);
    curl_close($ch);
    return $body;
}
function cdnflyadmin_del($path, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper("DELETE"));
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}
function cdnflyadmin_put($path, $post, $params)
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper("PUT"));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip");
    curl_setopt($ch, CURLOPT_HEADER, false);
    $headers = [];
    $headers[] = "Accept-Encoding:gzip, deflate";
    $headers[] = "api-key:" . $params["server_username"];
    $headers[] = "api-secret:" . $params["server_password"];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

?>