<?php
function cdnflyuser_idcsmartauthorizes()
{
}
function cdnflyuser_MetaData()
{
    return ["DisplayName" => "cdnfly对接模块(用户端)", "APIVersion" => "2.0", "HelpDoc" => "http://bbs.zeauo.cn/?thread-47.htm"];
}
function cdnflyuser_ConfigOptions()
{
    return [["type" => "text", "name" => "默认显示IP", "description" => "不填默认是无", "key" => "ip"], ["type" => "text", "name" => "在售套餐ID", "description" => "请先填写cdnfly在售套餐ID", "key" => "package"]];
}
function cdnflyuser_TestLink($params)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = "API信息错误";
    }
    return $result;
}
function cdnflyuser_Chart($params)
{
    $new_data[0]["name"] = "全部";
    $new_data[0]["vlaue"] = "";
    $res = cdnflyuser_GetSites($params);
    foreach ($res as $k => $v) {
        $new_data[$k + 1]["name"] = $v["domain"];
        $new_data[$k + 1]["value"] = $v["domain"];
    }
    return ["bandwidth" => ["title" => "网站带宽", "select" => $new_data], "traffic" => ["title" => "流量图", "select" => $new_data], "req" => ["title" => "访问次数", "select" => $new_data], "qps" => ["title" => "每秒请求次数", "select" => $new_data], "req-cache-status" => ["title" => "请求命中率", "select" => $new_data], "byte-cache-status" => ["title" => "字节命中率", "select" => $new_data]];
}
function cdnflyuser_ChartData($params)
{
    $start = $params["chart"]["start"];
    $result["status"] = "success";
    $result["data"] = [];
    if ($params["chart"]["type"] == "bandwidth") {
        $res = json_decode(cdnflyuser_GetBandWidth($params, $params["chart"]["select"]), true);
        $result["data"]["unit"] = "Kbps";
        $result["data"]["chart_type"] = "line";
        $result["data"]["list"] = [];
        $result["data"]["label"] = ["带宽(Kbps)"];
        foreach ($res["data"] as $v) {
            if ($v[0] >= $start) {
                $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $v[0] / 1000), "value" => $v[1] / 100];
            }
        }
    } else {
        if ($params["chart"]["type"] == "traffic") {
            $res = json_decode(cdnflyuser_GetTraffic($params, $params["chart"]["select"]), true);
            $result["data"]["unit"] = "MB";
            $result["data"]["chart_type"] = "line";
            $result["data"]["list"] = [];
            $result["data"]["label"] = ["实时流量"];
            foreach ($res["data"] as $v) {
                if ($v[0] >= $start) {
                    $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $v[0] / 1000), "value" => $v[1] / 1024 / 1000];
                }
            }
        } else {
            if ($params["chart"]["type"] == "req") {
                $res = json_decode(cdnflyuser_GetReq($params, $params["chart"]["select"]), true);
                $result["data"]["unit"] = "次";
                $result["data"]["chart_type"] = "line";
                $result["data"]["list"] = [];
                $result["data"]["label"] = ["访问次数"];
                foreach ($res["data"] as $v) {
                    if ($v[0] >= $start) {
                        $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $v[0] / 1000), "value" => $v[1]];
                    }
                }
            } else {
                if ($params["chart"]["type"] == "qps") {
                    $res = json_decode(cdnflyuser_GetQps($params, $params["chart"]["select"]), true);
                    $result["data"]["unit"] = "次";
                    $result["data"]["chart_type"] = "line";
                    $result["data"]["list"] = [];
                    $result["data"]["label"] = ["每秒请求次数"];
                    foreach ($res["data"] as $v) {
                        if ($v[0] >= $start) {
                            $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $v[0] / 1000), "value" => $v[1]];
                        }
                    }
                } else {
                    if ($params["chart"]["type"] == "req-cache-status") {
                        $res = json_decode(cdnflyuser_GetReqCacheStatus($params, $params["chart"]["select"]), true);
                        $result["data"]["unit"] = "%";
                        $result["data"]["chart_type"] = "area";
                        $result["data"]["list"] = [];
                        $result["data"]["label"] = ["请求命中率(%)"];
                        foreach ($res["data"] as $v) {
                            if ($v[0] >= $start) {
                                $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $v[0] / 1000), "value" => $v[1]];
                            }
                        }
                    } else {
                        if ($params["chart"]["type"] == "byte-cache-status") {
                            $res = json_decode(cdnflyuser_GetByteCacheStatus($params, $params["chart"]["select"]), true);
                            $result["data"]["unit"] = "%";
                            $result["data"]["chart_type"] = "area";
                            $result["data"]["list"] = [];
                            $result["data"]["label"] = ["字节   命中率(%)"];
                            foreach ($res["data"] as $v) {
                                if ($v[0] >= $start) {
                                    $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $v[0] / 1000), "value" => $v[1]];
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return $result;
}
function cdnflyuser_CreateAccount($params)
{
    $cdn_data["package"] = $params["configoptions"]["package"];
    $cdn_data["name"] = $params["domain"];
    if ($params["billingcycle"] == "monthly") {
        $cdn_data["duration"] = "month";
    } else {
        if ($params["billingcycle"] == "yearly") {
            $cdn_data["duration"] = "year";
        } else {
            $cdn_data["duration"] = "quarter";
        }
    }
    $url = cdnflyuser_GetUrl($params, "/v1/user-packages");
    $res = json_decode(cdnflyuser_Post($url, $cdn_data, $params), true);
    if ($res["code"] == "0") {
        $customid = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->where("fieldname", "package_id")->value("id");
        if (empty($customid)) {
            $customfields = ["type" => "product", "relid" => $params["productid"], "fieldname" => "package_id", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
            $customid = think\Db::name("customfields")->insertGetId($customfields);
        }
        $exist = think\Db::name("customfieldsvalues")->where("fieldid", $customid)->where("relid", $params["hostid"])->find();
        if (empty($exist)) {
            $data = ["fieldid" => $customid, "relid" => $params["hostid"], "value" => $res["data"], "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $exist["id"])->update(["value" => $res["data"]]);
        }
        if ($params["configoptions"]["ip"]) {
            $update["dedicatedip"] = $params["configoptions"]["ip"];
        } else {
            $update["dedicatedip"] = "无";
        }
        $update["domainstatus"] = "Active";
        $update["username"] = "";
        $update["password"] = "";
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return "success";
    }
    return ["status" => "error", "msg" => $res["msg"]];
}
function cdnflyuser_ChangePackage($params)
{
    $pid = cdnflyuser_GetPackageId($params);
    if (empty($pid)) {
        return "套餐ID为空！";
    }
    if (isset($params["configoptions_upgrade"]["package"])) {
        $post_data["package"] = $params["configoptions"]["package"];
    }
    $url = cdnflyuser_GetUrl($params, "/v1/user-packages/" . $pid);
    $res = json_decode(cdnflyuser_Request($url, ["package" => 1], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result["status"] = "success";
        $result["msg"] = "升级配置成功";
    } else {
        $result["status"] = "error";
        $result["msg"] = $res["msg"];
    }
    return $result;
}
function cdnflyuser_SuspendAccount($params)
{
    $pid = cdnflyuser_GetPackageId($params);
    if (empty($pid)) {
        return "套餐ID为空！";
    }
    $sites = cdnflyuser_GetSites($params);
    foreach ($sites as $k => $v) {
        $data[$k]["id"] = $v["id"];
        $data[$k]["enable"] = 0;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/sites");
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result["status"] = "success";
        $result["msg"] = "暂停成功";
    } else {
        $result["status"] = "error";
        $result["msg"] = $res["msg"];
    }
    return $result;
}
function cdnflyuser_UnsuspendAccount($params)
{
    $pid = cdnflyuser_GetPackageId($params);
    if (empty($pid)) {
        return "套餐ID为空！";
    }
    $sites = cdnflyuser_GetSites($params);
    foreach ($sites as $k => $v) {
        $data[$k]["id"] = $v["id"];
        $data[$k]["enable"] = 1;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/sites");
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result["status"] = "success";
        $result["msg"] = "解除暂停成功";
    } else {
        $result["status"] = "error";
        $result["msg"] = $res["msg"];
    }
    return $result;
}
function cdnflyuser_TerminateAccount($params)
{
    $pid = cdnflyuser_GetPackageId($params);
    if (empty($pid)) {
        return "套餐ID为空！";
    }
    $sites = cdnflyuser_GetSites($params);
    foreach ($sites as $k => $v) {
        $data[$k] = $v["id"];
    }
    $str = implode(",", $data);
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $str);
    $res = json_decode(cdnflyuser_Request($url, [], $params, "DELETE"), true);
    if ($res["code"] == "0") {
        $result["status"] = "success";
        $result["msg"] = "删除成功";
    } else {
        $result["status"] = "error";
        $result["msg"] = $res["msg"];
    }
    return $result;
}
function cdnflyuser_Renew($params)
{
    $pid = cdnflyuser_GetPackageId($params);
    if (empty($pid)) {
        return "套餐ID为空！";
    }
    if ($params["billingcycle"] == "monthly") {
        $data["duration"] = "month";
    } else {
        if ($params["billingcycle"] == "yearly") {
            $data["duration"] = "year";
        } else {
            $data["duration"] = "quarter";
        }
    }
    $url = cdnflyuser_GetUrl($params, "/v1/user-packages/" . $pid);
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result["status"] = "success";
        $result["msg"] = "续费用户套餐成功";
    } else {
        $result["status"] = "error";
        $result["msg"] = $res["msg"];
    }
    return $result;
}
function cdnflyuser_Status($params)
{
    $result["status"] = "success";
    $host = think\Db::name("host")->where("id", $params["hostid"])->find();
    if ($host["domainstatus"] == "Active") {
        $result["data"]["status"] = "on";
        $result["data"]["des"] = "运行中";
    } else {
        if ($host["domainstatus"] == "Suspended") {
            $result["data"]["status"] = "suspend";
            $result["data"]["des"] = "暂停";
        } else {
            if ($host["domainstatus"] == "Pending") {
                $result["data"]["status"] = "unknown";
                $result["data"]["des"] = "待开通";
            } else {
                if ($host["domainstatus"] == "Deleted") {
                    $result["data"]["status"] = "waiting";
                    $result["data"]["des"] = "已删除";
                }
            }
        }
    }
    return $result;
}
function cdnflyuser_ClientArea($params)
{
    return ["usage" => ["name" => "用量查看"], "sites" => ["name" => "网站列表"], "certs" => ["name" => "证书列表"], "streams" => ["name" => "转发列表"]];
}
function cdnflyuser_ClientAreaOutput($params, $key)
{
    if ($key == "usage") {
        return ["template" => "templates/usage.html", "vars" => ["data" => cdnflyuser_GetPackageInfo($params), "usage" => cdnflyuser_GetPackageUsage($params)]];
    }
    if ($key == "sites") {
        return ["template" => "templates/sites.html", "vars" => ["list" => cdnflyuser_GetSites($params), "pid" => cdnflyuser_GetPackageId($params), "certs" => cdnflyuser_GetCerts($params), "rules" => cdnflyuser_GetRules($params)]];
    }
    if ($key == "certs") {
        return ["template" => "templates/certs.html", "vars" => ["list" => cdnflyuser_GetCerts($params), "pid" => cdnflyuser_GetPackageId($params)]];
    }
    if ($key == "streams") {
        return ["template" => "templates/streams.html", "vars" => ["list" => cdnflyuser_GetStreams($params), "pid" => cdnflyuser_GetPackageId($params)]];
    }
}
function cdnflyuser_GetPackageId($params)
{
    return (int) $params["customfields"]["package_id"];
}
function cdnflyuser_GetPackageInfo($params)
{
    $pid = cdnflyuser_getpackageid($params);
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/user-packages/" . $pid);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetPackageUsage($params)
{
    $pid = cdnflyuser_getpackageid($params);
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/user-package/" . $pid . "/usage");
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetSites($params)
{
    $pid = cdnflyuser_getpackageid($params);
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/sites", ["page" => 1, "limit" => 10000, "user_package" => $pid]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetCerts($params)
{
    $pid = cdnflyuser_getpackageid($params);
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/certs", ["page" => 1, "limit" => 10000, "des" => $pid]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetStreams($params)
{
    $pid = cdnflyuser_getpackageid($params);
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/streams", ["page" => 1, "limit" => 10000, "user_package" => $pid]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetRules($params)
{
    $pid = cdnflyuser_getpackageid($params);
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/cc-rules", ["page" => 1, "limit" => 10000, "internal" => 1]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetTop($params)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/top", ["type" => "top-domain", "recent_time" => "60m"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    return $res["data"];
}
function cdnflyuser_GetBandWidth($params, $domain = NULL)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $query = ["type" => "bandwidth", "start" => urlencode(date("Y-m-d H:i:s", strtotime("-1 day"))), "end" => urlencode(date("Y-m-d H:i:s", time()))];
    if ($domain) {
        $query["domain"] = $domain;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/realtime", $query);
    $res = cdnflyuser_Get($url, $header);
    return $res;
}
function cdnflyuser_GetTraffic($params, $domain = NULL)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $query = ["type" => "traffic", "start" => urlencode(date("Y-m-d H:i:s", strtotime("-1 day"))), "end" => urlencode(date("Y-m-d H:i:s", time()))];
    if ($domain) {
        $query["domain"] = $domain;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/realtime", $query);
    $res = cdnflyuser_Get($url, $header);
    return $res;
}
function cdnflyuser_GetReq($params, $domain = NULL)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $query = ["type" => "req", "start" => urlencode(date("Y-m-d H:i:s", strtotime("-1 day"))), "end" => urlencode(date("Y-m-d H:i:s", time()))];
    if ($domain) {
        $query["domain"] = $domain;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/realtime", $query);
    $res = cdnflyuser_Get($url, $header);
    return $res;
}
function cdnflyuser_GetQps($params, $domain = NULL)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $query = ["type" => "qps", "start" => urlencode(date("Y-m-d H:i:s", strtotime("-1 day"))), "end" => urlencode(date("Y-m-d H:i:s", time()))];
    if ($domain) {
        $query["domain"] = $domain;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/realtime", $query);
    $res = cdnflyuser_Get($url, $header);
    return $res;
}
function cdnflyuser_GetReqCacheStatus($params, $domain = NULL)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $query = ["type" => "req-cache-status", "start" => urlencode(date("Y-m-d H:i:s", strtotime("-1 day"))), "end" => urlencode(date("Y-m-d H:i:s", time()))];
    if ($domain) {
        $query["domain"] = $domain;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/realtime", $query);
    $res = cdnflyuser_Get($url, $header);
    return $res;
}
function cdnflyuser_GetByteCacheStatus($params, $domain = NULL)
{
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $query = ["type" => "byte-cache-status", "start" => urlencode(date("Y-m-d H:i:s", strtotime("-1 day"))), "end" => urlencode(date("Y-m-d H:i:s", time()))];
    if ($domain) {
        $query["domain"] = $domain;
    }
    $url = cdnflyuser_GetUrl($params, "/v1/monitor/site/realtime", $query);
    $res = cdnflyuser_Get($url, $header);
    return $res;
}
function cdnflyuser_GetCertInfo($params)
{
    $post = input("post.");
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/certs/" . $post["id"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "获取成功", "data" => $res["data"]];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    return $result;
}
function cdnflyuser_GetSiteInfo($params)
{
    $post = input("post.");
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $backend = json_decode($res["data"]["backend"], true);
        $http_listen = json_decode($res["data"]["http_listen"], true);
        $https_listen = json_decode($res["data"]["https_listen"], true);
        if ($https_listen["port"]) {
            $backend_port = $res["data"]["backend_https_port"];
        } else {
            $backend_port = $res["data"]["backend_http_port"];
        }
        $data = ["id" => $res["data"]["id"], "domain" => $res["data"]["domain"], "backend" => $backend[0]["addr"], "http_listen" => $http_listen["port"], "backend_port" => $backend_port, "proxy_timeout" => $res["data"]["proxy_timeout"], "cc_default_rule" => $res["data"]["cc_default_rule"], "https_listen" => $https_listen["cert"], "backend_protocol" => $res["data"]["backend_protocol"], "websocket_enable" => $res["data"]["websocket_enable"]];
        $result = ["status" => "success", "msg" => $res["msg"] ?: "获取成功", "data" => $data];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    return $result;
}
function cdnflyuser_GetSiteBackend($params)
{
    $post = input("post.");
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $data = ["id" => $res["data"]["id"], "backend_host" => $res["data"]["backend_host"], "proxy_http_version" => $res["data"]["proxy_http_version"], "range" => $res["data"]["range"], "ups_keepalive" => $res["data"]["ups_keepalive"], "ups_keepalive_conn" => $res["data"]["ups_keepalive_conn"], "ups_keepalive_timeout" => $res["data"]["ups_keepalive_timeout"]];
        $result = ["status" => "success", "msg" => $res["msg"] ?: "获取成功", "data" => $data];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    return $result;
}
function cdnflyuser_GetSiteSafe($params)
{
    $post = input("post.");
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $data = ["id" => $res["data"]["id"], "cc_default_rule" => $res["data"]["cc_default_rule"], "black_ip" => $res["data"]["black_ip"], "white_ip" => $res["data"]["white_ip"]];
        $result = ["status" => "success", "msg" => $res["msg"] ?: "获取成功", "data" => $data];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    return $result;
}
function cdnflyuser_GetSiteHign($params)
{
    $post = input("post.");
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $data = ["id" => $res["data"]["id"], "gzip_enable" => $res["data"]["gzip_enable"], "gzip_types" => $res["data"]["gzip_types"], "websocket_enable" => $res["data"]["websocket_enable"], "page_404" => $res["data"]["page_404"], "page_50x" => $res["data"]["page_50x"], "acme_proxy_to_orgin" => $res["data"]["acme_proxy_to_orgin"], "post_size_limit" => $res["data"]["post_size_limit"]];
        $result = ["status" => "success", "msg" => $res["msg"] ?: "获取成功", "data" => $data];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    return $result;
}
function cdnflyuser_GetStreamInfo($params)
{
    $post = input("post.");
    $header = ["api-key:" . $params["server_username"], "api-secret:" . $params["server_password"]];
    $url = cdnflyuser_GetUrl($params, "/v1/streams/" . $post["id"]);
    $res = json_decode(cdnflyuser_Get($url, $header), true);
    if ($res["code"] == "0") {
        $backend = json_decode($res["data"]["backend"], true);
        $listen = json_decode($res["data"]["listen"], true);
        $data = ["id" => $res["data"]["id"], "port" => $listen[0]["port"], "backend_port" => $res["data"]["backend_port"], "backend_ip" => $backend[0]["addr"], "protocol" => $listen[0]["protocol"], "balance_way" => $res["data"]["balance_way"], "proxy_protocol" => $res["data"]["proxy_protocol"], "conn_limit" => $res["data"]["conn_limit"]];
        $result = ["status" => "success", "msg" => $res["msg"] ?: "获取成功", "data" => $data];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    return $result;
}
function cdnflyuser_AllowFunction()
{
    return ["client" => ["addSite", "editSite", "enaSite", "disSite", "delSite", "addCert", "enaCert", "editCert", "disCert", "delCert", "addStream", "enaStream", "disStream", "delStream", "GetCertInfo", "GetSiteInfo", "GetSiteBackend", "GetSiteSafe", "GetSiteHign", "GetStreamInfo", "editSiteBackend", "editSiteSafe", "editSiteHign", "editStream"]];
}
function cdnflyuser_addSite($params)
{
    $post = input("post.");
    $site_data["user_package"] = $post["user_package"];
    $site_data["domain"] = $post["domain"];
    $site_data["backend"] = [["addr" => $post["backend"], "state" => "up"]];
    if ($post["http_listen"]) {
        $site_data["http_listen"] = ["port" => $post["http_listen"]];
    }
    if ($post["https_listen"]) {
        $site_data["https_listen"] = ["cert" => $post["https_listen"]];
    }
    if ($post["backend_protocol"]) {
        $site_data["backend_protocol"] = $post["backend_protocol"];
    }
    if ($post["backend_protocol"] == "https") {
        $site_data["backend_https_port"] = $post["backend_port"];
    } else {
        $site_data["backend_http_port"] = $post["backend_port"];
    }
    if ($post["proxy_timeout"]) {
        $site_data["proxy_timeout"] = $post["proxy_timeout"];
    }
    if ($post["balance_way"]) {
        $site_data["balance_way"] = $post["balance_way"];
    }
    $url = cdnflyuser_GetUrl($params, "/v1/sites");
    $res = json_decode(cdnflyuser_Post($url, $site_data, $params), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "添加成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "添加失败"];
    }
    return $result;
}
function cdnflyuser_editSite($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $data["domain"] = $post["domain"];
    $data["backend"] = [["addr" => $post["backend"], "state" => "up", "weight" => 1]];
    $data["http_listen"] = ["port" => $post["http_listen"]];
    if ($post["https_listen"]) {
        $data["https_listen"] = ["cert" => $post["https_listen"]];
    } else {
        $data["https_listen"] = [];
    }
    $data["backend_protocol"] = $post["backend_protocol"];
    if ($post["backend_protocol"] == "https") {
        $data["backend_https_port"] = $post["backend_port"];
    } else {
        $data["backend_http_port"] = $post["backend_port"];
    }
    $data["proxy_timeout"] = $post["proxy_timeout"];
    $data["balance_way"] = $post["balance_way"];
    if ($post["backend_port_mapping"] == 1) {
        $data["backend_port_mapping"] = true;
    } else {
        $data["websocket_enable"] = false;
    }
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "编辑成功"];
    } else {
        $result = ["status" => "error", "msg" => $post["backend_port_mapping"] ?: "编辑失败"];
    }
    return $result;
}
function cdnflyuser_editSiteBackend($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $data["backend_host"] = $post["backend_host"];
    $data["proxy_http_version"] = $post["proxy_http_version"];
    if ($post["ups_keepalive_conn"]) {
        $data["ups_keepalive_conn"] = $post["ups_keepalive_conn"];
    }
    if ($post["ups_keepalive_timeout"]) {
        $data["ups_keepalive_timeout"] = $post["ups_keepalive_timeout"];
    }
    if ($post["ups_keepalive"] == 1) {
        $data["ups_keepalive"] = true;
    } else {
        $data["ups_keepalive"] = false;
    }
    if ($post["range"] == 1) {
        $data["range"] = true;
    } else {
        $data["range"] = false;
    }
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "编辑成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "编辑失败"];
    }
    return $result;
}
function cdnflyuser_editSiteSafe($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $data["black_ip"] = $post["black_ip"];
    $data["white_ip"] = $post["white_ip"];
    if ($post["cc_default_rule"]) {
        $data["cc_default_rule"] = $post["cc_default_rule"];
    }
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "编辑成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "编辑失败"];
    }
    return $result;
}
function cdnflyuser_editSiteHign($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $data["gzip_types"] = $post["gzip_types"];
    $data["page_404"] = $post["page_404"];
    $data["page_50x"] = $post["page_50x"];
    $data["post_size_limit"] = $post["post_size_limit"];
    if ($post["gzip_enable"] == 1) {
        $data["gzip_enable"] = true;
    } else {
        $data["gzip_enable"] = false;
    }
    if ($post["websocket_enable"] == 1) {
        $data["websocket_enable"] = true;
    } else {
        $data["websocket_enable"] = false;
    }
    if ($post["acme_proxy_to_orgin"] == 1) {
        $data["acme_proxy_to_orgin"] = true;
    } else {
        $data["acme_proxy_to_orgin"] = false;
    }
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "编辑成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "编辑失败"];
    }
    return $result;
}
function cdnflyuser_editStream($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/streams/" . $post["id"]);
    $stream_data["listen"] = [["protocol" => $post["protocol"], "port" => $post["port"]]];
    $stream_data["backend_port"] = $post["backend_port"];
    $stream_data["backend"] = [["addr" => $post["backend_ip"], "state" => "up", "weight" => 1]];
    $data["conn_limit"] = $post["conn_limit"];
    $data["balance_way"] = $post["balance_way"];
    if ($post["proxy_protocol"] == 1) {
        $data["proxy_protocol"] = true;
    } else {
        $data["proxy_protocol"] = false;
    }
    $res = json_decode(cdnflyuser_Request($url, $data, $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "编辑成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "编辑失败"];
    }
    return $result;
}
function cdnflyuser_enaSite($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["enable" => 1], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "启用成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "启用失败"];
    }
    return $result;
}
function cdnflyuser_disSite($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["enable" => 0], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "禁用成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "禁用失败"];
    }
    return $result;
}
function cdnflyuser_delSite($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/sites/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, [], $params, "DELETE"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "删除成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "删除失败"];
    }
    return $result;
}
function cdnflyuser_addCert($params)
{
    $post = input("post.");
    $cert_data["des"] = $post["des"];
    $cert_data["name"] = $post["name"];
    $cert_data["cert"] = $post["cert"];
    $cert_data["key"] = $post["key"];
    $cert_data["type"] = "custom";
    $url = cdnflyuser_GetUrl($params, "/v1/certs");
    $res = json_decode(cdnflyuser_Post($url, $cert_data, $params), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "添加成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "添加失败"];
    }
    return $result;
}
function cdnflyuser_editCert($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/certs/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["name" => $post["name"], "cert" => $post["cert"], "key" => $post["key"]], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "编辑成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "编辑失败"];
    }
    return $result;
}
function cdnflyuser_enaCert($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/certs/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["enable" => 1], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "启用成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "启用失败"];
    }
    return $result;
}
function cdnflyuser_disCert($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/certs/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["enable" => 0], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "禁用成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "禁用失败"];
    }
    return $result;
}
function cdnflyuser_delCert($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/certs/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, [], $params, "DELETE"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "删除成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "删除失败"];
    }
    return $result;
}
function cdnflyuser_addStream($params)
{
    $post = input("post.");
    $stream_data["user_package"] = $post["user_package"];
    $stream_data["protocol"] = $post["protocol"];
    $stream_data["listen"] = [["protocol" => $post["protocol"], "port" => $post["port"]]];
    $stream_data["backend_port"] = $post["backend_port"];
    $stream_data["backend"] = [["addr" => $post["backend_ip"], "state" => "up", "weight" => 1]];
    $url = cdnflyuser_GetUrl($params, "/v1/streams");
    $res = json_decode(cdnflyuser_Post($url, $stream_data, $params), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "添加成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "添加失败"];
    }
    return $result;
}
function cdnflyuser_enaStream($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/streams/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["enable" => 1], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "启用成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "启用失败"];
    }
    return $result;
}
function cdnflyuser_disStream($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/streams/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, ["enable" => 0], $params, "PUT"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "禁用成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "禁用失败"];
    }
    return $result;
}
function cdnflyuser_delStream($params)
{
    $post = input("post.");
    $url = cdnflyuser_GetUrl($params, "/v1/streams/" . $post["id"]);
    $res = json_decode(cdnflyuser_Request($url, [], $params, "DELETE"), true);
    if ($res["code"] == "0") {
        $result = ["status" => "success", "msg" => $res["msg"] ?: "删除成功"];
    } else {
        $result = ["status" => "error", "msg" => $res["msg"] ?: "删除失败"];
    }
    return $result;
}
function cdnflyuser_GetUrl($params, $path = "/v1/user", $query = [])
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $q = "";
    foreach ($query as $k => $v) {
        $q .= "&" . $k . "=" . $v;
    }
    if (!empty($q)) {
        $url = $url . "?" . ltrim($q, "&");
    }
    return $url;
}
function cdnflyuser_Get($url = "", $headers = [])
{
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HEADER, 0);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($httph, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    $data = curl_exec($curl);
    curl_close($curl);
    return $data;
}
function cdnflyuser_Post($url, $post_data, $params)
{
    $post_data = json_encode($post_data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json; charset=utf-8", "Content-Length: " . strlen($post_data), "api-key: " . $params["server_username"], "api-secret: " . $params["server_password"]]);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return $response;
}
function cdnflyuser_Request($url, $post_data, $params, $method = "PUT")
{
    $method = strtoupper($method);
    $post_data = json_encode($post_data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_TIMEOUT, "10");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json; charset=utf-8", "Content-Length: " . strlen($post_data), "api-key: " . $params["server_username"], "api-secret: " . $params["server_password"]]);
    if (!empty($post_data)) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

?>