<?php
function dnspod_MetaData()
{
    return ["DisplayName" => "二级域名【DNSPOD版】", "APIVersion" => "1.0.0", "HelpDoc" => "帮助文档"];
}
function dnspod_ConfigOptions()
{
    return [["type" => "radio", "name" => "开通方式", "description" => "选择开通方式", "key" => "create_type", "options" => ["type1" => "自定义", "type2" => "弹性"]], ["type" => "textarea", "name" => "弹性应用列表", "description" => "输入应用域名ID和域名，每行一个，格式为：域名ID=域名", "key" => "app_list"], ["type" => "text", "name" => "自定义域名ID:", "description" => "域名ID", "key" => "domainid"], ["type" => "text", "name" => "自定义域名:", "description" => "域名", "key" => "domains"], ["type" => "text", "name" => "自定义记录类型:", "description" => "记录类型", "key" => "types"]];
}
function dnspod_TestLink($params)
{
    $action = "DescribeUserDetail";
    $payload = "{}";
    $respons = dnspod_post($action, $payload, $params);
    $response = json_decode($respons);
    if (isset($response->Response->Error)) {
        $errorCode = $response->Response->Error->Code;
        $errorMessage = $response->Response->Error->Message;
        $results["status"] = "error";
        $results["msg"] = $errorMessage ?: "链接失败";
    } else {
        $recordId = $response->Response->UserInfo->Status;
        $results["status"] = "success";
        $results["msg"] = "链接成功";
    }
    if ($results["status"] == "success") {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = $results["msg"];
    }
    return $result;
}
function dnspod_getServerIp()
{
    $url = "https://www.bt.cn/Api/getIpAddress";
    $url2 = "http://members.3322.org/dyndns/getip";
    $address = $_SERVER["REMOTE_ADDR"];
    if ($data = file_get_contents($url)) {
        return $data;
    }
    $data = file_get_contents($url2);
    return $data;
}
function dnspod_AllowFunction()
{
    return ["client" => ["adddomain", "modifydomain", "checkdomain"], "admin" => ["key"]];
}
function dnspod_AdminButton($params)
{
    $button = ["UnsuspendAccount" => "恢复解析", "SuspendAccount" => "暂停解析"];
    return $button;
}
function sign($key, $msg)
{
    return hash_hmac("sha256", $msg, $key, true);
}
function dnspod_CreateAccount($params)
{
    if ($params["configoptions"]["create_type"] == "type2") {
        $app_names = [];
        $app_list = explode("\n", $params["configoptions"]["app_list"]);
        foreach ($app_list as $app) {
            $app = trim($app);
            if (!empty($app)) {
                list($app_id, $app_name) = explode("=", $app);
                $app_names[$app_id] = $app_name;
            }
        }
        $insert["app_id"] = $params["configoptions"]["domain"];
        $insert["app_name"] = $app_names[$insert["app_id"]];
        $domain = $insert["app_id"];
        $domainid = $insert["app_name"];
        $type = $params["configoptions"]["type"];
    } else {
        $domain = $params["configoptions"]["domains"];
        $domainid = $params["configoptions"]["domainid"];
        $type = $params["configoptions"]["types"];
    }
    $fieldNames = ["解析ID", "域名", "域名ID", "主机头", "记录线路", "记录类型", "记录值", "TTL值", "MX值", "权重值"];
    $customFields = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->whereIn("fieldname", $fieldNames)->field("id, fieldname")->select();
    $results = [];
    foreach ($customFields as $field) {
        if (!isset($results[$field["fieldname"]])) {
            $results[$field["fieldname"]] = [];
        }
        $results[$field["fieldname"]] = ["id" => $field["id"], "fieldname" => $field["fieldname"]];
    }
    if (!isset($results["解析ID"])) {
        $hostid = ["type" => "product", "relid" => $params["productid"], "fieldname" => "解析ID", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostids = think\Db::name("customfields")->insertGetId($hostid);
    }
    if (isset($results["域名"])) {
        $hostdomains = $results["域名"]["id"];
    } else {
        $hostdomain = ["type" => "product", "relid" => $params["productid"], "fieldname" => "域名", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostdomains = think\Db::name("customfields")->insertGetId($hostdomain);
    }
    $existhostdomain = think\Db::name("customfieldsvalues")->where("fieldid", $hostdomains)->where("relid", $params["hostid"])->find();
    if (empty($existhostdomain)) {
        $data = ["fieldid" => $hostdomains, "relid" => $params["hostid"], "value" => $domainid, "create_time" => time()];
        think\Db::name("customfieldsvalues")->insert($data);
    } else {
        think\Db::name("customfieldsvalues")->where("id", $existhostdomain["id"])->update(["value" => $domainid]);
    }
    if (isset($results["域名ID"])) {
        $hostdomainids = $results["域名ID"]["id"];
    } else {
        $hostdomainid = ["type" => "product", "relid" => $params["productid"], "fieldname" => "域名ID", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostdomainids = think\Db::name("customfields")->insertGetId($hostdomainid);
    }
    $hostdomainidexist = think\Db::name("customfieldsvalues")->where("fieldid", $hostdomainids)->where("relid", $params["hostid"])->find();
    if (empty($hostdomainidexist)) {
        $data = ["fieldid" => $hostdomainids, "relid" => $params["hostid"], "value" => $domain, "create_time" => time()];
        think\Db::name("customfieldsvalues")->insert($data);
    } else {
        think\Db::name("customfieldsvalues")->where("id", $hostdomainidexist["id"])->update(["value" => $domain]);
    }
    if (!isset($results["主机头"])) {
        $hosttou = ["type" => "product", "relid" => $params["productid"], "fieldname" => "主机头", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hosttous = think\Db::name("customfields")->insertGetId($hosttou);
    }
    if (!isset($results["记录线路"])) {
        $hostline = ["type" => "product", "relid" => $params["productid"], "fieldname" => "记录线路", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostlines = think\Db::name("customfields")->insertGetId($hostline);
    }
    if (isset($results["记录类型"])) {
        $hosttypes = $results["记录类型"]["id"];
    } else {
        $hosttype = ["type" => "product", "relid" => $params["productid"], "fieldname" => "记录类型", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hosttypes = think\Db::name("customfields")->insertGetId($hosttype);
    }
    $hosttypesexist = think\Db::name("customfieldsvalues")->where("fieldid", $hosttypes)->where("relid", $params["hostid"])->find();
    if (empty($hosttypesexist)) {
        $data = ["fieldid" => $hosttypes, "relid" => $params["hostid"], "value" => $type, "create_time" => time()];
        think\Db::name("customfieldsvalues")->insert($data);
    } else {
        think\Db::name("customfieldsvalues")->where("id", $hosttypesexist["id"])->update(["value" => $type]);
    }
    if (!isset($results["记录值"])) {
        $hostrecord = ["type" => "product", "relid" => $params["productid"], "fieldname" => "记录值", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostrecords = think\Db::name("customfields")->insertGetId($hostrecord);
    }
    if (!isset($results["TTL值"])) {
        $hostttl = ["type" => "product", "relid" => $params["productid"], "fieldname" => "TTL值", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostttls = think\Db::name("customfields")->insertGetId($hostttl);
    }
    if (!isset($results["MX值"])) {
        $hostmx = ["type" => "product", "relid" => $params["productid"], "fieldname" => "MX值", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostmxs = think\Db::name("customfields")->insertGetId($hostmx);
    }
    if (!isset($results["权重值"])) {
        $hostquan = ["type" => "product", "relid" => $params["productid"], "fieldname" => "权重值", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $hostquans = think\Db::name("customfields")->insertGetId($hostquan);
    }
    $result["status"] = "success";
    $result["msg"] = "开通成功";
    return $result;
}
function dnspod_SuspendAccount($params)
{
    $post_data = print_r($params, true);
    $recordid = $params["customfields"]["解析ID"];
    $domainid = $params["customfields"]["域名ID"];
    $domainx = $params["customfields"]["主机头"];
    $domain = $params["customfields"]["域名"];
    $action = "ModifyRecordStatus";
    $payload = "{\"Domain\":\"" . $domain . "\",\"RecordId\":" . $recordid . ",\"Status\":\"DISABLE\"}";
    $graderesponse = dnspod_post($action, $payload, $params);
    $responseData = json_decode($graderesponse, true);
    if (isset($responseData["Response"]["Error"])) {
        $errorCode = $responseData["Response"]["Error"]["Code"];
        $errorMessage = $responseData["Response"]["Error"]["Message"];
        $result["status"] = "error";
        $result["msg"] = $errorMessage;
        return $result;
    }
    $requestId = $responseData["Response"]["RequestId"];
    $recordId = $responseData["Response"]["RecordId"];
    $result["status"] = "success";
    $result["msg"] = "暂停成功";
    return $result;
}
function dnspod_UnsuspendAccount($params)
{
    $post_data = print_r($params, true);
    $recordid = $params["customfields"]["解析ID"];
    $domainid = $params["customfields"]["域名ID"];
    $domainx = $params["customfields"]["主机头"];
    $domain = $params["customfields"]["域名"];
    $action = "ModifyRecordStatus";
    $payload = "{\"Domain\":\"" . $domain . "\",\"RecordId\":" . $recordid . ",\"Status\":\"ENABLE\"}";
    $respons = dnspod_post($action, $payload, $params);
    $responseData = json_decode($respons, true);
    if (isset($responseData["Response"]["Error"])) {
        $errorCode = $responseData["Response"]["Error"]["Code"];
        $errorMessage = $responseData["Response"]["Error"]["Message"];
        $result["status"] = "error";
        $result["msg"] = $errorMessage;
        return $result;
    }
    $requestId = $responseData["Response"]["RequestId"];
    $recordId = $responseData["Response"]["RecordId"];
    $result["status"] = "success";
    $result["msg"] = "解除暂停成功";
    return $result;
}
function dnspod_TerminateAccount($params)
{
    $recordid = $params["customfields"]["解析ID"];
    $domainid = $params["customfields"]["域名ID"];
    $domainx = $params["customfields"]["主机头"];
    $domain = $params["customfields"]["域名"];
    $post_data = print_r($params, true);
    $action = "DeleteRecord";
    $payload = "{\"Domain\":\"" . $domain . "\",\"RecordId\":" . $recordid . "}";
    $respons = dnspod_post($action, $payload, $params);
    $responseData = json_decode($respons, true);
    if (isset($responseData["Response"]["Error"])) {
        $errorCode = $responseData["Response"]["Error"]["Code"];
        $errorMessage = $responseData["Response"]["Error"]["Message"];
        $result["status"] = "error";
        $result["msg"] = $errorMessage;
        return $result;
    }
    $requestId = $responseData["Response"]["RequestId"];
    $recordId = $responseData["Response"]["RecordId"];
    $result["status"] = "success";
    $result["msg"] = "删除成功";
    return $result;
}
function dnspod_Renew($params)
{
    dnspod_unsuspendaccount($params);
    return ["status" => "success", "msg" => "续费成功"];
}
function dnspod_line($domain, $domainid, $params)
{
    $action = "DescribeDomain";
    $payload = "{\"Domain\":\"" . $domain . "\"}";
    $respons = dnspod_post($action, $payload, $params);
    $response = json_decode($respons, true);
    $grade = $response["Response"]["DomainInfo"]["Grade"];
    $domainId = $response["Response"]["DomainInfo"]["DomainId"];
    $gradeaction = "DescribeRecordLineList";
    $gradepayload = "{\"Domain\":\"" . $domain . "\",\"DomainGrade\":\"" . $grade . "\"}";
    $graderespons = dnspod_post($gradeaction, $gradepayload, $params);
    $graderesponse = json_decode($graderespons);
    if (isset($graderesponse->Response->Error)) {
        $errorCode = $graderesponse->Response->Error->Code;
        $errorMessage = $graderesponse->Response->Error->Message;
        return json(["status" => "error", "msg" => $errorMessage]);
    }
    $linelist = $graderesponse->Response->LineList;
    return $linelist;
}
function dnspod_checkdomain($params)
{
    $post = input("post.");
    $post_data = print_r($params, true);
    $domainx = $params["customfields"]["主机头"];
    $domain = $params["customfields"]["域名"];
    $record = $post["record"];
    $line = $post["line"];
    $type = $post["type"];
    $value = $post["value"];
    $ttl = $post["ttl"];
    $mx = $post["mx"];
    $weight = $post["weight"];
    $action = "DescribeRecordList";
    $payload = "{\"Domain\":\"" . $domain . "\"}";
    $respons = dnspod_post($action, $payload, $params);
    $response = json_decode($respons, true);
    if (empty($post["record"])) {
        $result = ["status" => "error", "msg" => "该主机头不能为空"];
        return $result;
    }
    $found = false;
    if (isset($response["Response"]["RecordList"])) {
        foreach ($response["Response"]["RecordList"] as $record) {
            if (strtolower($record["Name"]) === strtolower($post["record"]) && strtolower($record["Type"]) == strtolower($post["type"]) || $record["Name"] === "@" && $post["record"] === "") {
                $found = true;
                if ($post["record"] == $domainx) {
                    $result = ["status" => "success", "msg" => "该主机头记录您正在使用"];
                } else {
                    $result = ["status" => "error", "msg" => "该解析类型主机头解析记录已存在，请修改"];
                }
                return $result;
            }
        }
        if (!$found) {
            $result["status"] = "success";
            $result["msg"] = "域名可用";
            return $result;
        }
    } else {
        $errorMessage = $response["Response"]["Error"]["Message"];
        $msg = $errorMessage ?: "失败";
        $result = ["status" => "error", "msg" => $errorMessage];
        return $result;
    }
}
function dnspod_adddomain($params)
{
    $post = input("post.");
    $post_data = print_r($post, true);
    $uid = $params["uid"];
    $domain = $post["domain"];
    $record = $post["record"];
    $line = $post["line"];
    $type = $post["type"];
    $value = $post["value"];
    $ttl = $post["ttl"];
    $mx = $post["mx"];
    $weight = $post["weight"];
    $mx = intval($mx);
    $ttl = intval($ttl);
    $weight = intval($weight);
    $checkaction = "DescribeRecordList";
    $checkpayload = "{\"Domain\":\"" . $domain . "\"}";
    $checkrespons = dnspod_post($checkaction, $checkpayload, $params);
    $checkresponse = json_decode($checkrespons, true);
    if (empty($post["record"])) {
        $result = ["status" => "error", "msg" => "该主机头不能为空"];
        return $result;
    }
    $found = false;
    if (isset($checkresponse["Response"]["RecordList"])) {
        foreach ($checkresponse["Response"]["RecordList"] as $records) {
            if (strtolower($records["Name"]) === strtolower($post["record"]) && strtolower($records["Type"]) == strtolower($post["type"]) || $records["Name"] === "@" && $post["record"] === "") {
                $found = true;
                $result = ["status" => "error", "msg" => "该解析类型解析记录已存在"];
                return $result;
            }
        }
    }
    $action = "CreateRecord";
    $payload = "{\"Domain\":\"" . $domain . "\",\"RecordType\":\"" . $type . "\",\"RecordLine\":\"" . $line . "\",\"Value\":\"" . $value . "\",\"SubDomain\":\"" . $record . "\",\"MX\":" . $mx . ",\"TTL\":" . $ttl . ",\"Weight\":" . $weight . ",\"Status\":\"ENABLE\"}";
    $respons = dnspod_post($action, $payload, $params);
    $response = json_decode($respons);
    if (isset($response->Response->Error)) {
        $errorCode = $response->Response->Error->Code;
        $errorMessage = $response->Response->Error->Message;
        $result["status"] = "error";
        $result["msg"] = $errorMessage ?: "失败";
    } else {
        $recordId = $response->Response->RecordId;
        $fieldNames = ["解析ID", "域名", "域名ID", "主机头", "记录线路", "记录类型", "记录值", "TTL值", "MX值", "权重值"];
        $customFields = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->whereIn("fieldname", $fieldNames)->field("id, fieldname")->select();
        $results = [];
        foreach ($customFields as $field) {
            if (!isset($results[$field["fieldname"]])) {
                $results[$field["fieldname"]] = [];
            }
            $results[$field["fieldname"]] = ["id" => $field["id"], "fieldname" => $field["fieldname"]];
        }
        if (isset($results["解析ID"])) {
            $hostids = $results["解析ID"]["id"];
        }
        $hostidsx = think\Db::name("customfieldsvalues")->where("fieldid", $hostids)->where("relid", $params["hostid"])->find();
        if (empty($hostidsx)) {
            $data = ["fieldid" => $hostids, "relid" => $params["hostid"], "value" => $recordId, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostidsx["id"])->update(["value" => $recordId]);
        }
        if (isset($results["域名"])) {
            $hostdomains = $results["域名"]["id"];
        }
        $hostdomainss = think\Db::name("customfieldsvalues")->where("fieldid", $hostdomains)->where("relid", $params["hostid"])->find();
        if (empty($hostdomainss)) {
            $data = ["fieldid" => $hostdomains, "relid" => $params["hostid"], "value" => $domain, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostdomainss["id"])->update(["value" => $domain]);
        }
        if (isset($results["域名ID"])) {
            $hostdomainids = $results["域名ID"]["id"];
        }
        $hostdomainidss = think\Db::name("customfieldsvalues")->where("fieldid", $hostdomainids)->where("relid", $params["hostid"])->find();
        if (empty($hostdomainidss)) {
            $data = ["fieldid" => $hostdomainids, "relid" => $params["hostid"], "value" => $domain, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostdomainidss["id"])->update(["value" => $domain]);
        }
        if (isset($results["主机头"])) {
            $hosttous = $results["主机头"]["id"];
        }
        $hosttouss = think\Db::name("customfieldsvalues")->where("fieldid", $hosttous)->where("relid", $params["hostid"])->find();
        if (empty($hosttouss)) {
            $data = ["fieldid" => $hosttous, "relid" => $params["hostid"], "value" => $record, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hosttouss["id"])->update(["value" => $record]);
        }
        if (isset($results["记录线路"])) {
            $hostlines = $results["记录线路"]["id"];
        }
        $hostliness = think\Db::name("customfieldsvalues")->where("fieldid", $hostlines)->where("relid", $params["hostid"])->find();
        if (empty($hostliness)) {
            $data = ["fieldid" => $hostlines, "relid" => $params["hostid"], "value" => $line, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostliness["id"])->update(["value" => $line]);
        }
        if (isset($results["记录类型"])) {
            $hosttypes = $results["记录类型"]["id"];
        }
        $hosttypess = think\Db::name("customfieldsvalues")->where("fieldid", $hosttypes)->where("relid", $params["hostid"])->find();
        if (empty($hosttypess)) {
            $data = ["fieldid" => $hosttypes, "relid" => $params["hostid"], "value" => $type, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hosttypess["id"])->update(["value" => $type]);
        }
        if (isset($results["记录值"])) {
            $hostrecords = $results["记录值"]["id"];
        }
        $hostrecordss = think\Db::name("customfieldsvalues")->where("fieldid", $hostrecords)->where("relid", $params["hostid"])->find();
        if (empty($hostrecordss)) {
            $data = ["fieldid" => $hostrecords, "relid" => $params["hostid"], "value" => $value, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostrecordss["id"])->update(["value" => $value]);
        }
        if (isset($results["TTL值"])) {
            $hostttls = $results["TTL值"]["id"];
        }
        $hostttlss = think\Db::name("customfieldsvalues")->where("fieldid", $hostttls)->where("relid", $params["hostid"])->find();
        if (empty($hostttlss)) {
            $data = ["fieldid" => $hostttls, "relid" => $params["hostid"], "value" => $ttl, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostttlss["id"])->update(["value" => $ttl]);
        }
        if (isset($results["MX值"])) {
            $hostmxs = $results["MX值"]["id"];
        }
        $hostmxss = think\Db::name("customfieldsvalues")->where("fieldid", $hostmxs)->where("relid", $params["hostid"])->find();
        if (empty($hostmxss)) {
            $data = ["fieldid" => $hostmxs, "relid" => $params["hostid"], "value" => $mx, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostmxss["id"])->update(["value" => $mx]);
        }
        if (isset($results["权重值"])) {
            $hostquans = $results["权重值"]["id"];
        }
        $hostquanss = think\Db::name("customfieldsvalues")->where("fieldid", $hostquans)->where("relid", $params["hostid"])->find();
        if (empty($hostquanss)) {
            $data = ["fieldid" => $hostquans, "relid" => $params["hostid"], "value" => $weight, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostquanss["id"])->update(["value" => $weight]);
        }
        $result["status"] = "success";
        $result["msg"] = "添加解析成功";
    }
    return $result;
}
function dnspod_modifydomain($params)
{
    $post = input("post.");
    $post_data = print_r($params, true);
    $uid = $params["uid"];
    $recordid = $params["customfields"]["解析ID"];
    $domainid = $params["customfields"]["域名ID"];
    $domain = $params["customfields"]["域名"];
    $type = $params["customfields"]["记录类型"];
    $record = $params["customfields"]["主机头"];
    $line = $post["line"];
    $value = $post["value"];
    $ttl = $post["ttl"];
    $mx = $post["mx"];
    $weight = $post["weight"];
    $mx = intval($mx);
    $ttl = intval($ttl);
    $weight = intval($weight);
    $action = "ModifyRecord";
    $payload = "{\"Domain\":\"" . $domain . "\",\"RecordType\":\"" . $type . "\",\"RecordLine\":\"" . $line . "\",\"Value\":\"" . $value . "\",\"RecordId\":" . $recordid . ",\"SubDomain\":\"" . $record . "\",\"MX\":" . $mx . ",\"TTL\":" . $ttl . ",\"Weight\":" . $weight . "}";
    $respons = dnspod_post($action, $payload, $params);
    $response = json_decode($respons);
    if (isset($response->Response->Error)) {
        $errorCode = $response->Response->Error->Code;
        $errorMessage = $response->Response->Error->Message;
        $result["status"] = "error";
        $result["msg"] = $errorMessage ?: "失败";
    } else {
        $recordId = $response->Response->RecordId;
        $fieldNames = ["解析ID", "域名", "域名ID", "主机头", "记录线路", "记录类型", "记录值", "TTL值", "MX值", "权重值"];
        $customFields = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->whereIn("fieldname", $fieldNames)->field("id, fieldname")->select();
        $results = [];
        foreach ($customFields as $field) {
            if (!isset($results[$field["fieldname"]])) {
                $results[$field["fieldname"]] = [];
            }
            $results[$field["fieldname"]] = ["id" => $field["id"], "fieldname" => $field["fieldname"]];
        }
        if (isset($results["解析ID"])) {
            $hostids = $results["解析ID"]["id"];
        }
        $hostidsx = think\Db::name("customfieldsvalues")->where("fieldid", $hostids)->where("relid", $params["hostid"])->find();
        if (empty($hostidsx)) {
            $data = ["fieldid" => $hostids, "relid" => $params["hostid"], "value" => $recordId, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostidsx["id"])->update(["value" => $recordId]);
        }
        if (isset($results["域名"])) {
            $hostdomains = $results["域名"]["id"];
        }
        $hostdomainss = think\Db::name("customfieldsvalues")->where("fieldid", $hostdomains)->where("relid", $params["hostid"])->find();
        if (empty($hostdomainss)) {
            $data = ["fieldid" => $hostdomains, "relid" => $params["hostid"], "value" => $domain, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostdomainss["id"])->update(["value" => $domain]);
        }
        if (isset($results["域名ID"])) {
            $hostdomainids = $results["域名ID"]["id"];
        }
        $hostdomainidss = think\Db::name("customfieldsvalues")->where("fieldid", $hostdomainids)->where("relid", $params["hostid"])->find();
        if (empty($hostdomainidss)) {
            $data = ["fieldid" => $hostdomainids, "relid" => $params["hostid"], "value" => $domain, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostdomainidss["id"])->update(["value" => $domain]);
        }
        if (isset($results["主机头"])) {
            $hosttous = $results["主机头"]["id"];
        }
        $hosttouss = think\Db::name("customfieldsvalues")->where("fieldid", $hosttous)->where("relid", $params["hostid"])->find();
        if (empty($hosttouss)) {
            $data = ["fieldid" => $hosttous, "relid" => $params["hostid"], "value" => $record, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hosttouss["id"])->update(["value" => $record]);
        }
        if (isset($results["记录线路"])) {
            $hostlines = $results["记录线路"]["id"];
        }
        $hostliness = think\Db::name("customfieldsvalues")->where("fieldid", $hostlines)->where("relid", $params["hostid"])->find();
        if (empty($hostliness)) {
            $data = ["fieldid" => $hostlines, "relid" => $params["hostid"], "value" => $line, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostliness["id"])->update(["value" => $line]);
        }
        if (isset($results["记录类型"])) {
            $hosttypes = $results["记录类型"]["id"];
        }
        $hosttypess = think\Db::name("customfieldsvalues")->where("fieldid", $hosttypes)->where("relid", $params["hostid"])->find();
        if (empty($hosttypess)) {
            $data = ["fieldid" => $hosttypes, "relid" => $params["hostid"], "value" => $type, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hosttypess["id"])->update(["value" => $type]);
        }
        if (isset($results["记录值"])) {
            $hostrecords = $results["记录值"]["id"];
        }
        $hostrecordss = think\Db::name("customfieldsvalues")->where("fieldid", $hostrecords)->where("relid", $params["hostid"])->find();
        if (empty($hostrecordss)) {
            $data = ["fieldid" => $hostrecords, "relid" => $params["hostid"], "value" => $value, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostrecordss["id"])->update(["value" => $value]);
        }
        if (isset($results["TTL值"])) {
            $hostttls = $results["TTL值"]["id"];
        }
        $hostttlss = think\Db::name("customfieldsvalues")->where("fieldid", $hostttls)->where("relid", $params["hostid"])->find();
        if (empty($hostttlss)) {
            $data = ["fieldid" => $hostttls, "relid" => $params["hostid"], "value" => $ttl, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostttlss["id"])->update(["value" => $ttl]);
        }
        if (isset($results["MX值"])) {
            $hostmxs = $results["MX值"]["id"];
        }
        $hostmxss = think\Db::name("customfieldsvalues")->where("fieldid", $hostmxs)->where("relid", $params["hostid"])->find();
        if (empty($hostmxss)) {
            $data = ["fieldid" => $hostmxs, "relid" => $params["hostid"], "value" => $mx, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostmxss["id"])->update(["value" => $mx]);
        }
        if (isset($results["权重值"])) {
            $hostquans = $results["权重值"]["id"];
        }
        $hostquanss = think\Db::name("customfieldsvalues")->where("fieldid", $hostquans)->where("relid", $params["hostid"])->find();
        if (empty($hostquanss)) {
            $data = ["fieldid" => $hostquans, "relid" => $params["hostid"], "value" => $weight, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $hostquanss["id"])->update(["value" => $weight]);
        }
        $result["status"] = "success";
        $result["msg"] = "修改成功";
    }
    return $result;
}
function dnspod_Status($params)
{
    $recordid = $params["customfields"]["解析ID"];
    $domainid = $params["customfields"]["域名ID"];
    $domain = $params["customfields"]["域名"];
    $type = $params["customfields"]["记录类型"];
    $record = $params["customfields"]["主机头"];
    $status_result = dnspod_state($domain, $recordid, $params);
    $result["status"] = "success";
    if ($status_result["status"] == "success") {
        if ($status_result["code"] == "1") {
            $result["data"]["status"] = "on";
            $result["data"]["des"] = "正常解析";
        } else {
            if ($status_result["code"] == "0") {
                $result["data"]["status"] = "suspend";
                $result["data"]["des"] = "暂停解析";
            } else {
                $result["data"]["status"] = "unknown";
                $result["data"]["des"] = "未知状态";
            }
        }
    } else {
        if ($status_result["status"] == "error") {
            $result["data"]["status"] = "waiting";
            $result["data"]["des"] = $status_result["msg"];
        } else {
            $result["data"]["status"] = "waiting";
            $result["data"]["des"] = "未识别的状态";
        }
    }
    return $result;
}
function dnspod_state($domain, $recordid, $params)
{
    $action = "DescribeRecord";
    $payload = "{\"Domain\":\"" . $domain . "\",\"RecordId\":" . $recordid . "}";
    $respons = dnspod_post($action, $payload, $params);
    $response = json_decode($respons, true);
    if (isset($response["Response"]["Error"])) {
        $errorCode = $response["Response"]["Error"]["Code"];
        $errorMessage = $response["Response"]["Error"]["Message"];
        $result["status"] = "error";
        $result["code"] = "error";
        $result["msg"] = $errorMessage ?: "失败";
    } else {
        $status = $response["Response"]["RecordInfo"]["Enabled"];
        $result["status"] = "success";
        $result["code"] = $status;
        $result["msg"] = $status;
    }
    return $result;
}
function dnspod_ClientArea($params)
{
    return ["info" => ["name" => "解析管理"]];
}
function dnspod_idcsmartauthorizes()
{
}
function dnspod_ClientAreaOutput($params, $key)
{
    $action = $params["customfields"]["域名"];
    $payload = $params["customfields"]["域名ID"];
    $recordid = $params["customfields"]["解析ID"];
    $linelist = dnspod_line($action, $payload, $params);
    $status = dnspod_state($action, $recordid, $params);
    if ($key == "info") {
        return ["template" => "templates/info.html", "vars" => ["customfields" => $params["customfields"], "linelist" => $linelist, "status" => $status, "logs" => $pathinfo["logs"], "userini" => $pathinfo["userini"]]];
    }
}
function dnspod_Post($action, $payload, $params)
{
    $secret_id = $params["server_username"];
    $secret_key = $params["server_password"];
    $token = "";
    $service = "dnspod";
    $host = "dnspod.tencentcloudapi.com";
    $req_region = "";
    $version = "2021-03-23";
    $action = $action;
    $payload = $payload;
    $params = json_decode($payload);
    $endpoint = "https://dnspod.tencentcloudapi.com";
    $algorithm = "TC3-HMAC-SHA256";
    $timestamp = time();
    $date = gmdate("Y-m-d", $timestamp);
    $http_request_method = "POST";
    $canonical_uri = "/";
    $canonical_querystring = "";
    $ct = "application/json; charset=utf-8";
    $canonical_headers = "content-type:" . $ct . "\nhost:" . $host . "\nx-tc-action:" . strtolower($action) . "\n";
    $signed_headers = "content-type;host;x-tc-action";
    $hashed_request_payload = hash("sha256", $payload);
    $canonical_request = $http_request_method . "\n" . $canonical_uri . "\n" . $canonical_querystring . "\n" . $canonical_headers . "\n" . $signed_headers . "\n" . $hashed_request_payload;
    $credential_scope = $date . "/" . $service . "/tc3_request";
    $hashed_canonical_request = hash("sha256", $canonical_request);
    $string_to_sign = $algorithm . "\n" . $timestamp . "\n" . $credential_scope . "\n" . $hashed_canonical_request;
    $secret_date = sign("TC3" . $secret_key, $date);
    $secret_service = sign($secret_date, $service);
    $secret_signing = sign($secret_service, "tc3_request");
    $signature = hash_hmac("sha256", $string_to_sign, $secret_signing);
    $authorization = $algorithm . " Credential=" . $secret_id . "/" . $credential_scope . ", SignedHeaders=" . $signed_headers . ", Signature=" . $signature;
    $headers = ["Authorization" => $authorization, "Content-Type" => "application/json; charset=utf-8", "Host" => $host, "X-TC-Action" => $action, "X-TC-Timestamp" => $timestamp, "X-TC-Version" => $version];
    if ($req_region) {
        $headers["X-TC-Region"] = $req_region;
    }
    if ($token) {
        $headers["X-TC-Token"] = $token;
    }
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array_map(function ($k, $v) {
            return $k . ": " . $v;
        }, array_keys($headers), $headers));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    } catch (Exception $err) {
        return $err->getMessage();
    }
}

?>