<?php
class kanglepanel_api
{
    private function callUrl($params)
    {
        return ($params["secure"] ? "https" : "http") . "://" . $params["server_host"] . ":" . $params["port"] . "/api/index.php";
    }
    private function call_kanglepanel($params, $post)
    {
        $call = curl_init();
        curl_setopt($call, CURLOPT_URL, $this->callUrl($params));
        curl_setopt($call, CURLOPT_HTTPHEADER, "Content-Type: multipart/form-data");
        curl_setopt($call, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($call, CURLOPT_POST, true);
        curl_setopt($call, CURLOPT_POSTFIELDS, http_build_query($post));
        curl_setopt($call, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($call, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($call);
        $info = curl_getinfo($call);
        curl_close($call);
        $result = json_decode($result, true);
        return $result;
    }
    public function test_Link($params)
    {
        $random = rand(1000, 9999);
        $post = ["c" => "whm", "a" => "update_vh", "r" => $random, "s" => md5("update_vh" . $params["accesshash"] . $random), "name" => "", "status" => "1", "json" => "1"];
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function create_host($params)
    {
        if (empty($params["password"])) {
            $sys_pwd = randStr(8);
        } else {
            $sys_pwd = $params["password"];
        }
        $random = rand(1000, 9999);
        if ($params["configoptions"]["openway"] == "1") {
            $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "init" => "1", "name" => $params["domain"], "passwd" => $sys_pwd, "product_id" => $params["configoptions"]["product_id"]];
        } else {
            if ($params["configoptions"]["openway"] == "2") {
                $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "init" => "1", "name" => $params["domain"], "passwd" => $sys_pwd, "cdn" => $params["configoptions"]["cs1"], "templete" => $params["configoptions"]["cs2"], "web_quota" => $params["configoptions"]["cs7"], "db_type" => $params["configoptions"]["cs3"], "db_quota" => $params["configoptions"]["cs8"], "ftp" => $params["configoptions"]["cs4"], "log_handle" => $params["configoptions"]["cs5"], "domain" => $params["configoptions"]["cs9"], "max_connect" => $params["configoptions"]["cs10"], "speed_limit" => $params["configoptions"]["cs11"] * 1024 / 8, "subdir" => $params["configoptions"]["cs12"], "subdir_flag" => $params["configoptions"]["cs6"], "max_subdir" => $params["configoptions"]["cs13"], "flow_limit" => $params["configoptions"]["cs14"], "max_worker" => $params["configoptions"]["cs15"], "explode" => $params["configoptions"]["cs16"], "htaccess" => "1", "access" => "1", "port" => "80,443s", "module" => "php"];
            } else {
                if ($params["configoptions"]["openway"] == "3") {
                    $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "init" => "1", "name" => $params["domain"], "passwd" => $sys_pwd, "cdn" => $params["configoptions"]["cs1"], "templete" => $params["configoptions"]["cs2"], "web_quota" => $params["configoptions"]["web_max"], "db_type" => $params["configoptions"]["cs3"], "db_quota" => $params["configoptions"]["sql_max"], "ftp" => $params["configoptions"]["ftp_max"], "log_handle" => $params["configoptions"]["loghandle_max"], "domain" => $params["configoptions"]["domain_max"], "max_connect" => $params["configoptions"]["connect_max"], "speed_limit" => $params["configoptions"]["speed_max"] * 1024 / 8, "subdir" => $params["configoptions"]["cs12"], "subdir_flag" => $params["configoptions"]["sub_max"], "max_subdir" => $params["configoptions"]["max_max"], "flow_limit" => $params["configoptions"]["flow_max"], "max_worker" => $params["configoptions"]["work_max"], "explode" => $params["configoptions"]["cs16"], "log_file" => $params["configoptions"]["log_max"], "htaccess" => $params["configoptions"]["htaccess_max"], "ssi" => $params["configoptions"]["ssi_max"], "access" => $params["configoptions"]["access_max"], "port" => $params["configoptions"]["port_max"], "ftp_connect" => $params["configoptions"]["ftpc_max"], "ftp_usl" => $params["configoptions"]["ftps_max"] * 1024 / 8, "ftp_dsl" => $params["configoptions"]["ftpd_max"] * 1024 / 8, "module" => "php"];
                } else {
                    $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "init" => "1", "name" => $params["domain"], "passwd" => $sys_pwd, "product_name" => $params["configoptions"]["product_id"]];
                }
            }
        }
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function suspend_host($params)
    {
        $random = rand(1000, 9999);
        $post = ["c" => "whm", "a" => "update_vh", "r" => $random, "s" => md5("update_vh" . $params["accesshash"] . $random), "json" => "1", "name" => $params["username"], "status" => "1"];
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function unsuspend_host($params)
    {
        $random = rand(1000, 9999);
        $post = ["c" => "whm", "a" => "update_vh", "r" => $random, "s" => md5("update_vh" . $params["accesshash"] . $random), "json" => "1", "name" => $params["username"], "status" => "0"];
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function delete_host($params)
    {
        $random = rand(1000, 9999);
        $post = ["c" => "whm", "a" => "del_vh", "r" => $random, "s" => md5("del_vh" . $params["accesshash"] . $random), "json" => "1", "name" => $params["username"]];
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function resetpwd_host($params, $new_pass)
    {
        $random = rand(1000, 9999);
        $post = ["c" => "whm", "a" => "change_password", "r" => $random, "s" => md5("change_password" . $params["accesshash"] . $random), "name" => $params["username"], "passwd" => $new_pass, "json" => "1"];
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function syncpwd_host($params)
    {
        $sys_pwd = $params["password"];
        $random = rand(1000, 9999);
        $post = ["c" => "whm", "a" => "change_password", "r" => $random, "s" => md5("change_password" . $params["accesshash"] . $random), "name" => $params["username"], "passwd" => $sys_pwd, "json" => "1"];
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
    public function changepackage_host($params)
    {
        $random = rand(1000, 9999);
        if ($params["configoptions"]["openway"] == "1") {
            $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "edit" => "1", "name" => $params["domain"], "product_id" => $params["configoptions"]["product_id"]];
        } else {
            if ($params["configoptions"]["openway"] == "4") {
                $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "edit" => "1", "name" => $params["domain"], "product_name" => $params["configoptions"]["product_id"]];
            } else {
                if ($params["configoptions"]["openway"] == "2") {
                    $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "edit" => "1", "name" => $params["username"], "passwd" => $params["password"], "cdn" => $params["configoptions"]["cs1"], "templete" => $params["configoptions"]["cs2"], "web_quota" => $params["configoptions"]["cs7"], "db_type" => $params["configoptions"]["cs3"], "db_quota" => $params["configoptions"]["cs8"], "ftp" => $params["configoptions"]["cs4"], "log_handle" => $params["configoptions"]["cs5"], "domain" => $params["configoptions"]["cs9"], "max_connect" => $params["configoptions"]["cs10"], "speed_limit" => $params["configoptions"]["cs11"] * 1024 / 8, "subdir" => $params["configoptions"]["cs12"], "subdir_flag" => $params["configoptions"]["cs6"], "max_subdir" => $params["configoptions"]["cs13"], "flow_limit" => $params["configoptions"]["cs14"], "max_worker" => $params["configoptions"]["cs15"], "explode" => $params["configoptions"]["cs16"], "htaccess" => "1", "access" => "1", "port" => "80,443s", "module" => "php"];
                } else {
                    $post = ["c" => "whm", "a" => "add_vh", "r" => $random, "s" => md5("add_vh" . $params["accesshash"] . $random), "json" => "1", "edit" => "1", "name" => $params["username"], "passwd" => $params["password"], "cdn" => $params["configoptions"]["cs1"], "templete" => $params["configoptions"]["cs2"], "web_quota" => $params["configoptions"]["web_max"], "db_type" => $params["configoptions"]["cs3"], "db_quota" => $params["configoptions"]["sql_max"], "ftp" => $params["configoptions"]["ftp_max"], "log_handle" => $params["configoptions"]["loghandle_max"], "domain" => $params["configoptions"]["domain_max"], "max_connect" => $params["configoptions"]["connect_max"], "speed_limit" => $params["configoptions"]["speed_max"] * 1024 / 8, "subdir" => $params["configoptions"]["cs12"], "subdir_flag" => $params["configoptions"]["sub_max"], "max_subdir" => $params["configoptions"]["max_max"], "flow_limit" => $params["configoptions"]["flow_max"], "max_worker" => $params["configoptions"]["work_max"], "explode" => $params["configoptions"]["cs16"], "log_file" => $params["configoptions"]["log_max"], "htaccess" => $params["configoptions"]["htaccess_max"], "ssi" => $params["configoptions"]["ssi_max"], "access" => $params["configoptions"]["access_max"], "port" => $params["configoptions"]["port_max"], "ftp_connect" => $params["configoptions"]["ftpc_max"], "ftp_usl" => $params["configoptions"]["ftps_max"] * 1024 / 8, "ftp_dsl" => $params["configoptions"]["ftpd_max"] * 1024 / 8, "module" => "php"];
                }
            }
        }
        $result = $this->call_kanglepanel($params, $post);
        return $result;
    }
}
function kanglepanel_idcsmartauthorizes()
{
}
function kanglepanel_MetaData()
{
    return ["DisplayName" => "kangLe对接模块（高级版）", "APIVersion" => "1.1.4", "HelpDoc" => "https://kangle.cc"];
}
function kanglepanel_ConfigOptions()
{
    $group_id = input("param.id/d");
    if ($group_id) {
        $s = think\Db::name("servers");
        $server = $s->where("gid", $group_id)->find();
    }
    if ($server["secure"] == 1) {
        $ssl = "https://";
    } else {
        $ssl = "http://";
    }
    return [["type" => "dropdown", "name" => "产品开通方式", "description" => "【必选项】选择开通方式", "options" => ["1" => "使用【产品ID】开通", "2" => "使用【自定义配置】开通", "3" => "使用【弹性配置】开通", "4" => "使用【产品名称】开通"], "default" => "1", "key" => "openway"], ["type" => "text", "name" => "产品ID或产品名称", "description" => "名称或ID开通，填产品ID或产品名称", "key" => "product_id"], ["type" => "dropdown", "name" => " 产品类型", "description" => " 【必选项】请选择产品类型", "options" => ["1" => "CDN", "0" => "虚拟主机"], "default" => "0", "key" => "cs1"], ["type" => "dropdown", "name" => " 空间类型", "description" => " 【必选项】请选择空间类型", "options" => ["php" => "PHP"], "default" => "php", "key" => "cs2"], ["type" => "dropdown", "name" => " 数据库类型", "description" => " 【必选项】请选择数据库类型", "options" => ["mysql" => "MySQL"], "default" => "mysql", "key" => "cs3"], ["type" => "dropdown", "name" => " 是否开启FTP", "description" => "请选择是否开启FTP", "options" => ["1" => "开启", "0" => "关闭"], "default" => "1", "key" => "cs4"], ["type" => "dropdown", "name" => " 是否开启日志分析", "description" => " 请选择是否开启日志分析", "options" => ["1" => "开启", "0" => "关闭"], "default" => "0", "key" => "cs5"], ["type" => "dropdown", "name" => " 是否开启子目录", "description" => "是否允许绑定域名到子目录", "options" => ["1" => "开启", "0" => "关闭"], "default" => "1", "key" => "cs6"], ["type" => "text", "name" => " 空间容量", "description" => "填数字，单位MB", "default" => "100", "key" => "cs7"], ["type" => "text", "name" => " 数据库容量", "description" => "填数字，单位MB，0表示不开通", "default" => "100", "key" => "cs8"], ["type" => "text", "name" => " 绑定域名数", "description" => "填数字，-1表示不限量", "default" => "10", "key" => "cs9"], ["type" => "text", "name" => " 连接数", "description" => "填数字，0表示不限制", "default" => "100", "key" => "cs10"], ["type" => "text", "name" => " 带宽限制", "description" => "填数字，单位M/秒，0表示不限制", "default" => "1", "key" => "cs11"], ["type" => "text", "name" => " 默认绑定到子目录名", "description" => "默认例子：/wwwroot", "default" => "/wwwroot", "key" => "cs12"], ["type" => "text", "name" => " 子目录数", "description" => "填数字，0表示不限制", "default" => "1", "key" => "cs13"], ["type" => "text", "name" => " 月流量", "description" => "填数字，单位G/月", "default" => "10", "key" => "cs14"], ["type" => "text", "name" => " 工作数", "description" => "填数字，0表示不限制", "default" => "10", "key" => "cs15"], ["type" => "text", "name" => "提示说明", "description" => "主要用于前台显示，可为空", "default" => "请勿将本产品用于违法用途。", "key" => "d1"]];
}
function kanglepanel_TestLink($params)
{
    try {
        $api = new kanglepanel_api();
        $response = $api->test_Link($params);
        if (isset($response["result"]) && $response["result"] == "500") {
            $result["status"] = 200;
            $result["data"]["server_status"] = 1;
        } else {
            if ($response["result"] == "403") {
                $result["status"] = 200;
                $result["data"]["server_status"] = 0;
                $result["data"]["msg"] = $response["msg"];
            } else {
                $result["status"] = 200;
                $result["data"]["server_status"] = 0;
                $result["data"]["msg"] = "请检查主机名和IP，kangle面板通信安全码是否已填写到了Hash中。";
            }
        }
        return $result;
    } catch (Exception $e) {
        return $e->getMessage();
    }
    return $result;
}
function kanglepanel_getServerIp()
{
    $url = "https://www.bt.cn/Api/getIpAddress";
    $url2 = "http://members.3322.org/dyndns/getip";
    $address = $_SERVER["REMOTE_ADDR"];
    if ($data = file_get_contents($url)) {
        return $data;
    }
    $data = file_get_contents($url2);
    return $data;
}
function kanglepanel_FiveMinuteCron()
{
    $time = time();
    $host_data = think\Db::name("host")->alias("a")->field("a.id,a.domainstatus,a.suspendreason,a.uid,c.ip_address server_ip,\n\t\t\t\t\tc.hostname server_host,c.username server_username,c.password server_password,c.accesshash,c.secure,c.port")->leftJoin("products b", "a.productid=b.id")->leftJoin("servers c", "a.serverid=c.id")->leftJoin("server_groups d", "c.gid=d.id")->whereIn("a.domainstatus", "Active,Suspended")->where("a.nextduedate=0 OR a.nextduedate>" . $time)->where("a.serverid", ">", 0)->whereIn("b.api_type", ["", "normal"])->where("d.system_type", "normal")->where("c.type", "kanglepanel")->select()->toArray();
    $host = new app\common\logic\Host();
    $model = new app\common\model\HostModel();
    foreach ($host_data as $v) {
        $params = $model->getProvisionParams($v["id"]);
        $host->crackPass($v["id"], $params["password"]);
    }
}
function kanglepanel_CreateAccount($params)
{
    if (empty($params["password"])) {
        $sys_pwd = randStr(8);
    } else {
        $sys_pwd = $params["password"];
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->create_host($params);
        if ($response["result"] == "200") {
            $update["username"] = $params["domain"];
            $update["dedicatedip"] = $params["server_ip"];
            $update["password"] = cmf_encrypt($sys_pwd);
            think\Db::name("host")->where("id", $params["hostid"])->update($update);
            return ["status" => "success", "msg" => "开通成功"];
        }
        if ($response["result"] == "500") {
            return "主机名已存在，请修改";
        }
        return "开通失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_SuspendAccount($params)
{
    if (empty($params["username"])) {
        return "账号为空，请先填写账号";
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->suspend_host($params);
        if ($response["result"] == "200") {
            return ["status" => "success", "msg" => "暂停成功"];
        }
        if ($response["result"] == "500") {
            return "暂停失败,请检查相关配置";
        }
        return "暂停失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_UnSuspendAccount($params)
{
    if (empty($params["username"])) {
        return "账号为空，请先填写账号";
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->unsuspend_host($params);
        if ($response["result"] == "200") {
            return ["status" => "success", "msg" => "解除暂停成功"];
        }
        if ($response["result"] == "500") {
            return "解除暂停失败,请检查相关配置";
        }
        return "解除暂停失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_CrackPassword($params, $new_pass)
{
    if (empty($params["username"])) {
        return "账号为空，请先填写账号";
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->resetpwd_host($params, $new_pass);
        if ($response["result"] == "200") {
            return ["status" => "success", "msg" => "重置密码成功"];
        }
        if ($response["result"] == "500") {
            return "重置密码失败,请检查相关配置";
        }
        return "重置密码失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_TerminateAccount($params)
{
    if (empty($params["username"])) {
        return "账号为空，请先填写账号";
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->delete_host($params);
        if ($response["result"] == "200") {
            return ["status" => "success", "msg" => "主机删除成功"];
        }
        if ($response["result"] == "500") {
            return "删除失败,请检查相关配置";
        }
        return "删除失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_ChangePackage($params)
{
    if (empty($params["username"])) {
        return "账号为空，请先填写账号";
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->changepackage_host($params);
        if ($response["result"] == "200") {
            return ["status" => "success", "msg" => "升降级成功"];
        }
        if ($response["result"] == "500") {
            return "升降级失败,请检查相关配置";
        }
        return "升降级失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_CreateSign($a, $skey, $r)
{
    return md5($a . $skey . $r);
}
function kanglepanel_GetUrl($params, $info, $skey, $r)
{
    $url = "";
    foreach ($info as $k => $v) {
        $url .= $k . "=" . $v . "&";
    }
    return "http://" . $params["server_ip"] . ":" . $params["port"] . "/api/index.php?" . $url . "r=" . $r . "&s=" . $skey . "&json=1";
}
function kanglepanel_GetHostInfo($params)
{
    $a = "getvh";
    $r = rand(100000, 999999);
    $info = ["c" => "whm", "a" => $a, "name" => $params["domain"]];
    $skey = kanglepanel_createsign($a, $params["accesshash"], $r);
    $url = kanglepanel_geturl($params, $info, $skey, $r);
    $result = json_decode(file_get_contents($url), true);
    if ($result["result"] == 200) {
        return $result;
    }
    return "获取失败";
}
function kanglepanel_Status($params)
{
    $res = kanglepanel_gethostinfo($params);
    if ($res["result"] == 200) {
        $result["status"] = "success";
        if ($res["status"] == 0) {
            $result["data"]["status"] = "on";
            $result["data"]["des"] = "正在运行中";
        } else {
            $result["data"]["status"] = "suspend";
            $result["data"]["des"] = "主机已暂停";
        }
        return $result;
    }
    return ["status" => "error", "msg" => "主机获取失败，请检查"];
}
function kanglepanel_AdminButton($params)
{
    $button["syncpassword"] = "一键同步密码";
    return $button;
}
function kanglepanel_syncpassword($params)
{
    if (!($params["username"] || empty($params["password"]))) {
        return "账号或密码为空，不能进行同步密码操作~";
    }
    try {
        $api = new kanglepanel_api();
        $response = $api->syncpwd_host($params);
        if ($response["result"] == "200") {
            return ["status" => "success", "msg" => "密码同步成功"];
        }
        if ($response["result"] == "500") {
            return "同步密码失败,请检查相关配置";
        }
        return "同步密码失败,请检查相关配置";
    } catch (Exception $e) {
        return $e->getMessage();
    }
}
function kanglepanel_ClientArea($params)
{
    return ["information" => ["name" => "虚拟主机信息"]];
}
function kanglepanel_ClientAreaOutput($params, $key)
{
    $result = kanglepanel_gethostinfo($params);
    if ($key == "information") {
        return ["template" => "templates/information.html", "vars" => ["params" => $params, "info" => $result, "d1" => $d1], "d1" => $params["configoptions"]["d1"]];
    }
}

?>