<?php
function manualser_idcsmartauthorize()
{
}
function manualser_MetaData()
{
    return ["DisplayName" => "物理机手动上架模块", "APIVersion" => "1.0", "HelpDoc" => ""];
}
function manualser_ConfigOptions()
{
    return [["type" => "dropdown", "name" => "控制面板", "description" => "有无控制面板", "options" => ["0_无", "1_有"], "default" => "1", "key" => "is_panel"], ["type" => "text", "name" => "控制面板地址", "description" => "例如：Dcim地址", "key" => "panel_url"], ["type" => "text", "name" => "钉钉机器人Webhook", "description" => "留空则不通知", "default" => "", "key" => "ding"], ["type" => "text", "name" => "微信机器人Webhook", "description" => "留空则不通知", "default" => "", "key" => "wechat"], ["type" => "text", "name" => "机房", "description" => "所属机房", "key" => "local"], ["type" => "text", "name" => "CPU型号", "description" => "例如：E5-2650v2*2", "default" => "E5-2650v2*2", "key" => "cpu"], ["type" => "text", "name" => "内存", "description" => "例如：DDR3 16G", "default" => "DDR3 16G", "key" => "memory"], ["type" => "text", "name" => "硬盘", "description" => "例如：SSD 240G", "default" => "SSD 240G", "key" => "disk"], ["type" => "text", "name" => "带宽", "description" => "例如：独享50Mbps", "default" => "独享50Mbps", "key" => "net"], ["type" => "text", "name" => "IP数量", "description" => "个", "default" => "1", "key" => "ip"], ["type" => "text", "name" => "防御", "description" => "例如：100G DDOS防御", "default" => "100G DDOS防御", "key" => "ddos"], ["type" => "text", "name" => "其他描述", "description" => "", "default" => "", "key" => "ps"]];
}
function manualser_TestLink($params)
{
    $result["status"] = 200;
    $result["data"]["server_status"] = 1;
    return $result;
}
function manualser_CreateAccount($params)
{
    $mainip = "机器正在上架中";
    $os_info = think\Db::name("host_config_options")->alias("a")->field("c.option_name")->leftJoin("product_config_options b", "a.configid=b.id")->leftJoin("product_config_options_sub c", "a.optionid=c.id")->where("a.relid", $params["hostid"])->where("b.option_type", 5)->find();
    if (stripos($os_info["option_name"], "win") !== false) {
        $username = "administrator";
    } else {
        $username = "root";
    }
    $update["dedicatedip"] = $mainip;
    $update["username"] = $username;
    think\Db::name("host")->where("id", $params["hostid"])->update($update);
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机上架通知\n- 类型：<font color=\"warning\">开通</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- 操作系统：" . explode("^", $os_info["option_name"])[1] . "\n- CPU型号：" . $params["configoptions"]["cpu"] . "\n- 内存：" . $params["configoptions"]["memory"] . "\n- 硬盘：" . $params["configoptions"]["disk"] . "\n- 带宽：" . $params["configoptions"]["net"] . "\n- IP数量：" . $params["configoptions"]["ip"] . "\n- 防御：" . $params["configoptions"]["ddos"] . "\n- 开通时间：" . date("Y-m-d H:i:s", $params["regdate"]);
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机上架通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机暂停通知\n> 类型：<font color=\"warning\">开通</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> 操作系统：" . explode("^", $os_info["option_name"])[1] . "\n> CPU型号：" . $params["configoptions"]["cpu"] . "\n> 内存：" . $params["configoptions"]["memory"] . "\n> 硬盘：" . $params["configoptions"]["disk"] . "\n> 带宽：" . $params["configoptions"]["net"] . "\n> IP数量：" . $params["configoptions"]["ip"] . "\n> 防御：" . $params["configoptions"]["ddos"] . "\n> 开通时间：" . date("Y-m-d H:i:s", $params["regdate"]);
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机上架通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return "ok";
}
function manualser_SuspendAccount($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机到期暂停通知\n- 类型：<font color=\"warning\">到期暂停</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机到期暂停通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机到期通知\n> 类型：<font color=\"warning\">到期暂停</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机到期暂停通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_Renew($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机续费通知\n- 类型：<font color=\"warning\">续费</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机续费通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机续费通知\n> 类型：<font color=\"warning\">续费</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机续费通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_TerminateAccount($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机到期删除通知\n- 类型：<font color=\"warning\">到期删除</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机到期删除通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机到期删除通知\n> 类型：<font color=\"warning\">到期删除</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机到期删除通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_On($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机开机通知\n- 类型：<font color=\"warning\">开机</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机开机通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机开机通知\n> 类型：<font color=\"warning\">开机</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机开机通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_Off($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机关机通知\n- 类型：<font color=\"warning\">关机</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机关机通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机关机通知\n> 类型：<font color=\"warning\">关机</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机关机通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_Reboot($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机重启通知\n- 类型：<font color=\"warning\">重启</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机重启通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机重启通知\n> 类型：<font color=\"warning\">重启</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机重启通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_Reinstall($params)
{
    if ($params["configoptions"]["ding"]) {
        $message = "### 物理机重装系统通知\n- 类型：<font color=\"warning\">重装系统</font>\n- 会员名：" . $params["user_info"]["username"] . "\n- 机房：" . $params["configoptions"]["local"] . "\n- IP：" . $params["dedicatedip"] . "\n- 操作系统：" . $params["reinstall_os_name"] . "\n- 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机重装系统通知", "text" => $message]];
        $data_string = json_encode($data);
        manualser_DingCurl($params["configoptions"]["ding"], $data_string);
    }
    if ($params["configoptions"]["wechat"]) {
        $message = "### 物理机重装系统通知\n> 类型：<font color=\"warning\">重装系统</font>\n> 会员名：" . $params["user_info"]["username"] . "\n> 机房：" . $params["configoptions"]["local"] . "\n> IP：" . $params["dedicatedip"] . "\n> 操作系统：" . $params["reinstall_os_name"] . "\n> 提交时间：" . date("Y-m-d H:i:s", time());
        $data = ["msgtype" => "markdown", "markdown" => ["title" => "物理机重装系统通知", "content" => $message]];
        $data_string = json_encode($data);
        $result = manualser_DingCurl($params["configoptions"]["wechat"], $data_string);
    }
    if (stripos($params["reinstall_os_name"], "win") !== false) {
        $username = "administrator";
    } else {
        $username = "root";
    }
    think\Db::name("host")->where("id", $params["hostid"])->update(["username" => $username]);
    return ["status" => "success", "msg" => "已经提交机房工作人员"];
}
function manualser_ClientArea($params)
{
    return ["index" => ["name" => "主机信息"]];
}
function manualser_ClientAreaOutput($params, $key)
{
    if ($key == "index") {
        return ["template" => "templates/index.html", "vars" => ["params" => $params]];
    }
}
function manualser_DingCurl($remote_server, $post_string)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $remote_server);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json;charset=utf-8"]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

?>