<?php
function mcsm10_idcsmartauthorizes()
{
}
function mcsm10_MetaData()
{
    return ["DisplayName" => "五木幺七MCSM10对接模块", "APIVersion" => "3.1", "HelpDoc" => "", "version" => "3.1"];
}
function mcsm10_http($method, $url, $data = "", $headers = [])
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_URL, $url);
    if ($data) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    }
    if ($headers) {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}
function mcsm10_TestLink($params)
{
    $result["status"] = 200;
    $api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_services_list?apikey=" . $params["server_password"]), true);
    if ($api_result["status"] == 200) {
        foreach ($api_result["data"] as $v) {
            if ($v["uuid"] == $params["server_username"] && $v["available"]) {
                $result["data"]["server_status"] = 1;
            }
        }
        if ($result["data"]["server_status"] != 1) {
            $result["data"]["server_status"] = 0;
            $result["data"]["msg"] = "节点错误";
        }
    } else {
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = "无法连接MCSM面板";
    }
    return $result;
}
function mcsm10_CreateAccount($params)
{
    list($image, $start_command, $template_path) = explode("^", $params["configoptions"]["image"]);
    $create_protected_data = ["stopCommand" => "^C", "ie" => "UTF8", "oe" => "UTF8", "createDatetime" => NULL, "lastDatetime" => NULL, "type" => "universal", "tag" => [], "endTime" => NULL, "fileCode" => "UTF8", "processType" => "docker", "terminalOption" => ["haveColor" => true], "eventTask" => ["autoStart" => false, "autoRestart" => false, "ignore" => false], "docker" => ["ports" => [], "networkMode" => "bridge", "cpusetCpus" => "", "maxSpace" => NULL, "io" => NULL, "network" => NULL], "pingConfig" => []];
    $create_protected_data["nickname"] = $params["domain"];
    $create_protected_data["cwd"] = "/home/" . $params["domain"] . "/";
    $create_protected_data["docker"]["image"] = $image;
    $create_protected_data["docker"]["memory"] = $params["configoptions"]["memory"] ?? NULL;
    $create_protected_data["docker"]["cpuUsage"] = $params["configoptions"]["cpu"] * 100 ?? NULL;
    $create_protected_data["startCommand"] = $start_command ?? "bash";
    $create_protected_api_result = json_decode(mcsm10_http("POST", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($create_protected_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($create_protected_api_result["status"] != 200) {
        return "创建实例失败";
    }
    if ($template_path) {
        mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001");
        $init_command = "cp -r " . $template_path . "/* /home/" . $params["domain"] . "/";
        $init_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/command?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001&command=" . urlencode($init_command)), true);
        if ($init_protected_api_result["status"] != 200) {
            $delete_protected_data = ["uuids" => [], "deleteFile" => true];
            $delete_protected_data["uuids"][] = $create_protected_api_result["data"]["instanceUuid"];
            mcsm10_http("DELETE", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($delete_protected_data), ["Content-Type: application/json; charset=utf-8"]);
            return "初始化复制模板失败";
        }
    }
    $create_user_data = ["permission" => 1];
    $create_user_data["username"] = $params["domain"];
    $create_user_data["password"] = $params["password"];
    $create_user_api_result = json_decode(mcsm10_http("POST", $params["server_ip"] . "/api/auth?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($create_user_data), ["Content-Type: application/json; charset=utf-8"]), true);
    $find_user_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/auth/search?apikey=" . $params["server_password"] . "&page=1&page_size=1&role=&userName=" . $params["domain"]), true);
    $set_user_data = ["config" => ["permission" => 1, "instances" => []]];
    $set_user_data["uuid"] = $find_user_api_result["data"]["data"][0]["uuid"];
    $set_user_data["config"]["instances"][] = ["daemonId" => $params["server_username"], "instanceUuid" => $create_protected_api_result["data"]["instanceUuid"]];
    $set_user_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/auth?apikey=" . $params["server_password"], json_encode($set_user_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($set_user_api_result["status"] != 200) {
        $delete_protected_data = ["uuids" => [], "deleteFile" => true];
        $delete_protected_data["uuids"][] = $create_protected_api_result["data"]["instanceUuid"];
        mcsm10_http("DELETE", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($delete_protected_data), ["Content-Type: application/json; charset=utf-8"]);
        return "创建用户失败";
    }
    if ($params["configoptions"]["disk_gb"] || $params["configoptions"]["disk_mb"]) {
        $disk_quota_data["quota"] = $params["configoptions"]["disk_mb"] ? $params["configoptions"]["disk_mb"] : $params["configoptions"]["disk_gb"] * 1024;
        $disk_quota_data["command"] = "/opt/wood17mcsm/quotatool add " . $params["domain"] . " && " . "/opt/wood17mcsm/quotatool set " . $params["domain"] . " " . $disk_quota_data["quota"] . "M";
        mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001");
        $disk_quota_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/command?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001&command=" . urlencode($disk_quota_data["command"])), true);
        if ($disk_quota_api_result["status"] != 200) {
            $delete_protected_data = ["uuids" => [], "deleteFile" => true];
            $delete_protected_data["uuids"][] = $create_protected_api_result["data"]["instanceUuid"];
            mcsm10_http("DELETE", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($delete_protected_data), ["Content-Type: application/json; charset=utf-8"]);
            return "设置配额失败";
        }
    }
    $update["dedicatedip"] = $params["server_host"];
    $update["username"] = $params["domain"];
    think\Db::name("host")->where("id", $params["hostid"])->update($update);
    return "success";
}
function mcsm10_TerminateAccount($params)
{
    if ($params["configoptions"]["disk_gb"] || $params["configoptions"]["disk_mb"]) {
        $disk_quota_data["command"] = "/opt/wood17mcsm/quotatool del " . $params["domain"];
        mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001");
        $disk_quota_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/command?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001&command=" . urlencode($disk_quota_data["command"])), true);
        if ($disk_quota_api_result["status"] != 200) {
            return "取消配额失败";
        }
    }
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $kill_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/kill?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$kill_protected_api_result["status"]) {
        return "终止实例失败";
    }
    $delete_protected_data = ["uuids" => [], "deleteFile" => true];
    $delete_protected_data["uuids"][] = $find_protected_api_result["data"]["data"][0]["instanceUuid"];
    $delete_protected_api_result = json_decode(mcsm10_http("DELETE", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($delete_protected_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($delete_protected_api_result["status"] != 200 && $find_protected_api_result["data"]["data"][0]["instanceUuid"] != NULL) {
        return "删除实例失败";
    }
    $find_user_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/auth/search?apikey=" . $params["server_password"] . "&page=1&page_size=1&role=&userName=" . $params["domain"]), true);
    $delete_user_data[] = $find_user_api_result["data"]["data"][0]["uuid"];
    $delete_user_api_result = json_decode(mcsm10_http("DELETE", $params["server_ip"] . "/api/auth?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($delete_user_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($delete_user_api_result["status"] != 200) {
        return "删除用户失败";
    }
    return "success";
}
function mcsm10_ChangePackage($params)
{
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $set_protected_data["docker"]["memory"] = $params["configoptions"]["memory"] ?? NULL;
    $set_protected_data["docker"]["cpuUsage"] = $params["configoptions"]["cpu"] * 100 ?? NULL;
    $set_protected_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"], json_encode($set_protected_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($params["configoptions"]["disk_gb"] || $params["configoptions"]["disk_mb"]) {
        $disk_quota_data["quota"] = $params["configoptions"]["disk_mb"] ? $params["configoptions"]["disk_mb"] : $params["configoptions"]["disk_gb"] * 1024;
        $disk_quota_data["command"] = "/opt/wood17mcsm/quotatool set " . $params["domain"] . " " . $disk_quota_data["quota"] . "M";
        mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001");
        $disk_quota_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/command?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001&command=" . urlencode($disk_quota_data["command"])), true);
        if ($disk_quota_api_result["status"] != 200) {
            return "设置配额失败";
        }
    }
    if ($set_protected_api_result["status"] != 200) {
        return "修改实例失败";
    }
}
function mcsm10_Status($params)
{
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $protected_status = $find_protected_api_result["data"]["data"][0]["status"];
    if ($protected_status == 3) {
        $result["status"] = "success";
        $result["data"]["status"] = "on";
        $result["data"]["des"] = "运行中";
    } else {
        if ($protected_status == 0) {
            $result["status"] = "success";
            $result["data"]["status"] = "off";
            $result["data"]["des"] = "停止";
        } else {
            if ($protected_status == 1) {
                $result["status"] = "success";
                $result["data"]["status"] = "process";
                $result["data"]["des"] = "正在停止";
            } else {
                if ($protected_status == 2) {
                    $result["status"] = "success";
                    $result["data"]["status"] = "process";
                    $result["data"]["des"] = "正在启动";
                } else {
                    $result["status"] = "success";
                    $result["data"]["status"] = "unknown";
                    $result["data"]["des"] = "未知";
                }
            }
        }
    }
    return $result;
}
function mcsm10_SuspendAccount($params)
{
    $find_user_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/auth/search?apikey=" . $params["server_password"] . "&page=1&page_size=1&role=&userName=" . $params["domain"]), true);
    $ban_user_data["uuid"] = $find_user_api_result["data"]["data"][0]["uuid"];
    $ban_user_data["config"]["permission"] = -1;
    $ban_user_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/auth?apikey=" . $params["server_password"], json_encode($ban_user_data, true), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($ban_user_api_result["status"] != 200) {
        return "封禁用户失败";
    }
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $kill_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/kill?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$kill_protected_api_result["status"]) {
        return "关闭实例失败";
    }
    return "success";
}
function mcsm10_UnsuspendAccount($params)
{
    $find_user_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/auth/search?apikey=" . $params["server_password"] . "&page=1&page_size=1&role=&userName=" . $params["domain"]), true);
    $open_user_data["uuid"] = $find_user_api_result["data"]["data"][0]["uuid"];
    $open_user_data["config"]["permission"] = 1;
    $open_user_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/auth?apikey=" . $params["server_password"], json_encode($open_user_data, true), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($open_user_api_result["status"] != 200) {
        return "解封用户失败";
    }
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $open_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$open_protected_api_result["status"]) {
        return "开启实例失败";
    }
    return "success";
}
function mcsm10_Reinstall($params)
{
    list($image, $start_command, $template_path) = explode("^", $params["reinstall_os"]);
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $set_protected_data["docker"]["image"] = $image;
    $set_protected_data["startCommand"] = $start_command ?? "bash";
    $set_protected_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"], json_encode($set_protected_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($set_protected_api_result["status"] != 200) {
        return "切换镜像失败";
    }
    if ($template_path) {
        mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001");
        $init_command = "cp -r " . $template_path . "/* /home/" . $params["domain"] . "/";
        $init_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/command?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=global0001&command=" . urlencode($init_command)), true);
        if ($init_protected_api_result["status"] != 200) {
            $delete_protected_data = ["uuids" => [], "deleteFile" => true];
            $delete_protected_data["uuids"][] = $find_protected_api_result["data"]["data"][0]["instanceUuid"];
            mcsm10_http("DELETE", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"], json_encode($delete_protected_data), ["Content-Type: application/json; charset=utf-8"]);
            return "初始化复制模板失败";
        }
    }
    return "success";
}
function mcsm10_CrackPassword($params, $new_password)
{
    $find_user_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/auth/search?apikey=" . $params["server_password"] . "&page=1&page_size=1&role=&userName=" . $params["domain"]), true);
    $change_password_data["uuid"] = $find_user_api_result["data"]["data"][0]["uuid"];
    $change_password_data["config"]["passWord"] = $new_password;
    $change_password_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/auth?apikey=" . $params["server_password"], json_encode($change_password_data, true), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($change_password_api_result["status"] != 200) {
        return "重置密码失败，至少9位，要有小写字母，大写字母，数字";
    }
    return "success";
}
function mcsm10_On($params)
{
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $open_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/open?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$open_protected_api_result["status"]) {
        return "开启实例失败";
    }
    return "success";
}
function mcsm10_Off($params)
{
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $off_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/stop?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$off_protected_api_result["status"]) {
        return "关闭实例失败";
    }
    return "success";
}
function mcsm10_HardOff($params)
{
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $kill_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/kill?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$kill_protected_api_result["status"]) {
        return "终止实例失败";
    }
    return "success";
}
function mcsm10_Reboot($params)
{
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $reboot_protected_api_result = mcsm10_http("GET", $params["server_ip"] . "/api/protected_instance/restart?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"]);
    if (!$reboot_protected_api_result["status"]) {
        return "重启实例失败";
    }
    return "success";
}
function mcsm10_ClientArea($params)
{
    return ["info" => ["name" => "产品详情"], "natport" => ["name" => "端口转发"]];
}
function mcsm10_ClientAreaOutput($params, $key)
{
    if ($key == "info") {
        return ["template" => "templates/info.html", "vars" => ["panelurl" => $params["server_ip"], "username" => $params["domain"], "password" => $params["password"]]];
    }
    if ($key == "natport") {
        $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
        $protected_ports = $find_protected_api_result["data"]["data"][0]["config"]["docker"]["ports"];
        $view_ports_list = [];
        foreach ($protected_ports as $v) {
            $port_data = explode("/", $v);
            $exterior_port = intval(substr($port_data[0], 0, strpos($port_data[0], ":")));
            $interior_port = intval(explode(":", $port_data[0])[1]);
            $type = $port_data[1];
            $view_ports_list[] = ["raw" => $v, "exterior_port" => $exterior_port, "interior_port" => $interior_port, "type" => $type];
        }
        return ["template" => "templates/natport.html", "vars" => ["ports_list" => $view_ports_list]];
    }
}
function mcsm10_AllowFunction()
{
    return ["client" => ["NatportDel", "NatportAdd"]];
}
function mcsm10_NatportDel($params)
{
    $raw_port = $_POST["raw"];
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $protected_ports = $find_protected_api_result["data"]["data"][0]["config"]["docker"]["ports"];
    $del_port_key = array_search($raw_port, $protected_ports);
    if ($del_port_key === false) {
        return "此项映射不存在";
    }
    unset($protected_ports[$del_port_key]);
    $set_protected_data["docker"]["ports"] = $protected_ports;
    $set_protected_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"], json_encode($set_protected_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($set_protected_api_result["status"] != 200) {
        return "更新实例数据失败";
    }
    return ["status" => "success", "msg" => "删除成功"];
}
function mcsm10_NatportAdd($params)
{
    $add_exterior_port = $_POST["exterior_port"] != "" ? intval($_POST["exterior_port"]) : rand(1000, 65535);
    $add_interior_port = intval($_POST["interior_port"]);
    $add_type = $_POST["type"];
    if (!is_int($add_exterior_port) || 65565 < $add_exterior_port || $add_exterior_port < 1000 || !is_int($add_interior_port) || 65565 < $add_interior_port || $add_interior_port < 1 || $add_type != "tcp" && $add_type != "udp") {
        return "提交的数据格式错误";
    }
    $raw_port = $add_exterior_port . ":" . $add_interior_port . "/" . $add_type;
    $find_protected_api_result = json_decode(mcsm10_http("GET", $params["server_ip"] . "/api/service/remote_service_instances?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&page=1&page_size=1&status=&instance_name=" . $params["domain"]), true);
    $protected_ports = $find_protected_api_result["data"]["data"][0]["config"]["docker"]["ports"];
    if (array_search($raw_port, $protected_ports) !== false) {
        return "此项已存在";
    }
    if ($params["configoptions"]["natport"] <= count($protected_ports)) {
        return "端口数已达最大";
    }
    $protected_ports[] = $raw_port;
    $set_protected_data["docker"]["ports"] = $protected_ports;
    $set_protected_api_result = json_decode(mcsm10_http("PUT", $params["server_ip"] . "/api/instance?apikey=" . $params["server_password"] . "&daemonId=" . $params["server_username"] . "&uuid=" . $find_protected_api_result["data"]["data"][0]["instanceUuid"], json_encode($set_protected_data), ["Content-Type: application/json; charset=utf-8"]), true);
    if ($set_protected_api_result["status"] != 200) {
        return "更新实例数据失败";
    }
    return ["status" => "success", "msg" => "增加成功"];
}

?>