<?php
function membership_MetaData()
{
    return ["DisplayName" => "会员升级模块", "APIVersion" => "1.0.0", "HelpDoc" => "http://www.yunbuyun.com/"];
}
function membership_ConfigOptions()
{
    $groups = getClientGroups();
    $names = array_column($groups, "group_name", "id");
    $status = $names ? "成功" : "失败";
    return [["type" => "dropdown", "name" => "升级的会员组", "options" => $names, "description" => "会员分组获取" . $status, "key" => "group"], ["type" => "dropdown", "name" => "余额处理方式", "options" => ["扣除余额", "退回账户余额"], "key" => "returned"], ["type" => "yesno", "name" => "是否显示等级折扣", "description" => "是否显示当前等级产品折扣信息", "key" => "output_products", "default" => true]];
}
function membership0_ConfigOptions()
{
    $groups = getClientGroups();
    $names = array_column($groups, "group_name", "id");
    $status = $names ? "成功" : "失败";
    return [["type" => "dropdown", "name" => "升级的会员组", "options" => $names, "description" => "会员分组获取" . $status, "key" => "group"], ["type" => "dropdown", "name" => "余额处理方式", "options" => ["扣除余额", "退回账户余额"], "key" => "returned"], ["type" => "yesno", "name" => "是否显示等级折扣", "description" => "是否显示当前等级产品折扣信息", "key" => "output_products", "default" => true]];
}
function membership_idcsmartauthorize()
{
}
function membership_CreateAccount($params)
{
    $user = getClient($params["uid"]);
    $host = getHost($params["hostid"]);
    $update["groupid"] = $params["configoptions"]["group"];
    if ($params["configoptions"]["returned"] == "1") {
        $update["credit"] = $user["credit"] + $host["firstpaymentamount"];
    }
    $result = think\Db::name("clients")->where("id", $params["uid"])->update($update);
    if ($result) {
        $update2["domainstatus"] = "Active";
        think\Db::name("host")->where("id", $params["hostid"])->update($update2);
        return "success";
    }
    return ["status" => "error", "msg" => "开通失败"];
}
function membership_TestLink($params)
{
    return ["status" => 200, "data" => ["server_status" => 1]];
}
function membership_Status($params)
{
    $user = getClient($params["uid"]);
    $groups = getClientGroups();
    if ($user && $user["groupid"] == 0) {
        return ["status" => "success", "data" => ["status" => "off", "des" => "非代理会员"]];
    }
    $groupName = "";
    foreach ($groups as $group) {
        if ($group["id"] == $user["groupid"]) {
            $groupName = $group["group_name"];
            return ["status" => "success", "data" => ["status" => "on", "des" => $groupName]];
        }
    }
}
function membership_Cancel($params)
{
    $update["groupid"] = NULL;
    $result = think\Db::name("clients")->where("id", $params["uid"])->update($update);
    if ($result) {
        return ["status" => "success", "msg" => "取消成功"];
    }
    return ["status" => "error", "msg" => "取消失败"];
}
function membership_TerminateAccount($params)
{
    $update["groupid"] = NULL;
    $result = think\Db::name("clients")->where("id", $params["uid"])->update($update);
    if ($result) {
        return ["status" => "success", "msg" => "删除成功"];
    }
    return ["status" => "error", "msg" => "删除失败"];
}
function membership_AdminButton($params)
{
    return ["Cancel" => "取消会员等级"];
}
function getClientGroups()
{
    return think\Db::name("client_groups")->select()->toArray();
}
function getClient($clientId)
{
    return think\Db::name("clients")->find($clientId);
}
function getHost($hostId)
{
    return think\Db::name("host")->find($hostId);
}
function membership_ClientArea($params)
{
    return ["index" => ["name" => "会员信息"]];
}
function membership_ClientAreaOutput($params, $key)
{
    if ($key == "index") {
        $status = membership_status($params);
        $des = $status["data"]["des"];
        $user = getclient($params["uid"]);
        $groupId = $user["groupid"];
        $userProductBates = think\Db::name("user_product_bates")->where("user", $groupId)->select();
        $products = [];
        foreach ($userProductBates as $userProductBate) {
            $product = think\Db::name("products")->alias("p")->join("user_product_groups upg", "p.id = upg.id")->where("upg.id", $userProductBate["products"])->field("p.name, upg.group_name")->find();
            $productInfo = ["group_name" => $product["group_name"], "bates" => $userProductBate["bates"]];
            if ($params["configoptions"]["output_products"]) {
                $products[] = $productInfo;
            }
        }
        return ["template" => "templates/custom_tab.html", "vars" => ["des" => $des, "products" => $products]];
    }
}

?>