<?php
function prokvm_MetaData()
{
    return ["DisplayName" => "prokvm对接模块", "APIVersion" => "1.0", "HelpDoc" => "https://imzxw.cn/?p=144"];
}
function prokvm_TestLink($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["username"] . "&userstr=" . $params["password"] . "&action=checkvpsname&vpsname=0";
    $return = prokvm_request($url);
    if ($return == "") {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = "无法连接,地址可能错误" . $return;
        return $result;
    }
    $return = explode("&", $return);
    $arr = [];
    foreach ($return as $i) {
        $i = explode("=", $i);
        $arr[$i[0]] = $i[1];
    }
    if ($arr["ret"] == "ok" || $arr["err"] == "vpsname-err") {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        if ($arr["err"] == "auth-failure") {
            $result["status"] = 200;
            $result["data"]["server_status"] = 0;
            $result["data"]["msg"] = "API密钥不正确";
            $result["data"]["json"] = json_encode($arr);
        } else {
            $result["status"] = 200;
            $result["data"]["server_status"] = 0;
            $result["data"]["msg"] = "意外的错误:" . json_encode($arr);
        }
    }
    return $result;
}
function prokvm_ConfigOptions()
{
    return [["type" => "text", "name" => "规格ID", "description" => "请参考上游的对外接口文档", "placeholder" => "规格ID", "default" => "0", "key" => "productid"], ["type" => "text", "name" => "独立控制面板地址", "description" => "请填写完整的url", "placeholder" => "", "default" => "0", "key" => "panel_url"], ["type" => "dropdown", "name" => "机器类型", "description" => "NAT or 正常", "options" => ["server" => "正常", "nat" => "NAT机"], "default" => "nat", "key" => "server_type"], ["type" => "text", "name" => "可用区ID", "description" => "非必填、参考上游对接文档", "placeholder" => "可用区ID", "default" => "0", "key" => "idc_id"]];
}
function prokvm_ClientArea($params)
{
    return ["panel" => ["name" => "控制面板"]];
}
function prokvm_ClientAreaOutput($params, $key)
{
    if ($key == "panel") {
        return ["template" => "templates/panel.html", "vars" => ["url" => $params["configoptions"]["panel_url"]]];
    }
}
function prokvm_CreateAccount($params)
{
    if ($params["billingcycle"] == "monthly") {
        $params["billingcycle"] = "0.1";
    } else {
        if ($params["billingcycle"] == "quarterly") {
            $params["billingcycle"] = "0.25";
        } else {
            if ($params["billingcycle"] == "semiannually") {
                $params["billingcycle"] = "0.5";
            } else {
                if ($params["billingcycle"] == "annually") {
                    $params["billingcycle"] = "1";
                } else {
                    if ($params["billingcycle"] == "biennially") {
                        $params["billingcycle"] = "2";
                    } else {
                        if ($params["billingcycle"] == "triennially") {
                            $params["billingcycle"] = "3";
                        } else {
                            if ($params["billingcycle"] == "fourly") {
                                $params["billingcycle"] = "4";
                            } else {
                                if ($params["billingcycle"] == "fively") {
                                    $params["billingcycle"] = "5";
                                } else {
                                    return ["status" => "error", "msg" => "不支持的支付周期"];
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if ($params["configoptions"]["idc_id"] && $params["configoptions"]["idc_id"] != "0") {
        $idc_id = "&idc=" . $params["configoptions"]["idc_id"];
    } else {
        $idc_id = "";
    }
    if ($params["configoptions_upgrade"]["os"]) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=activate&productid=" . $params["configoptions"]["productid"] . "&year=" . $params["billingcycle"] . "&OSAllList=" . $params["configoptions_upgrade"]["os"] . $idc_id;
        $os_name = $params["configoptions_upgrade"]["os"];
    } else {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=activate&productid=" . $params["configoptions"]["productid"] . "&year=" . $params["billingcycle"] . $idc_id;
        $os_name = "请前往独立控制面板查看";
    }
    $return_info = prokvm_format(prokvm_request($url));
    if ($return_info["ret"] == "ok") {
        if ($params["configoptions"]["server_type"] == "nat") {
            $ip = "(内)" . $return_info["ip"];
            $update["dedicatedip"] = "(内)" . $return_info["ip"];
            $update["assignedips"] = "(公) 公网地址请查看控制面板";
        } else {
            $update["dedicatedip"] = $return_info["ip"];
        }
        $update["password"] = cmf_encrypt($return_info["vpspassword"]);
        $update["domainstatus"] = "Active";
        $update["username"] = $return_info["ip"];
        $update["os"] = $os_name;
        $update["domain"] = $return_info["vpsname"];
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return "ok";
    }
    return ["status" => "error", "msg" => $return_info["errorinfo"]];
}
function prokvm_Vnc($params)
{
    return ["status" => "success", "msg" => "打开面板成功", "url" => $params["configoptions"]["panel_url"]];
}
function prokvm_CrackPassword($params, $new_password)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=modpass&newpassword=" . $new_password . "&vpsname=" . $params["domain"];
    $return_info = prokvm_format(prokvm_request($url));
    if ($return_info["ret"] == "ok") {
        return ["status" => "success"];
    }
    return ["status" => "error", "msg" => "密码修改失败", "json" => json_encode($return_info)];
}
function prokvm_On($params)
{
    if (prokvm_ifServert($params)) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=vpsop&op=start&vpsname=" . $params["domain"];
        $return_info = prokvm_format(prokvm_request($url));
        active_logs("114514", $params["uid"], 2);
        if ($return_info["ret"] == "ok") {
            return ["status" => "success"];
        }
        return ["status" => "error", "msg" => $return_info["errorinfo"]];
    }
    return ["status" => "error", "msg" => "无法获取主机信息"];
}
function prokvm_Off($params)
{
    if (prokvm_ifServert($params)) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=vpsop&op=turnoff&vpsname=" . $params["domain"];
        $return_info = prokvm_format(prokvm_request($url));
        if ($return_info["ret"] == "ok") {
            return ["status" => "success"];
        }
        return ["status" => "error", "msg" => $return_info["errorinfo"]];
    }
    return ["status" => "error", "msg" => "无法获取主机信息"];
}
function prokvm_Reboot($params)
{
    if (prokvm_ifServert($params)) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=vpsop&op=reset&vpsname=" . $params["domain"];
        $return_info = prokvm_format(prokvm_request($url));
        if ($return_info["ret"] == "ok") {
            return ["status" => "success"];
        }
        return ["status" => "error", "msg" => $return_info["errorinfo"]];
    }
    return ["status" => "error", "msg" => "无法获取主机信息"];
}
function prokvm_HardOff($params)
{
    if (prokvm_ifServert($params)) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=vpsop&op=shutdown&vpsname=" . $params["domain"];
        $return_info = prokvm_format(prokvm_request($url));
        if ($return_info["ret"] == "ok") {
            return ["status" => "success"];
        }
        return ["status" => "error", "msg" => $return_info["errorinfo"]];
    }
    return ["status" => "error", "msg" => "无法获取主机信息"];
}
function prokvm_Renew($params)
{
    if ($params["billingcycle"] == "monthly") {
        $params["billingcycle"] = "0.1";
    } else {
        if ($params["billingcycle"] == "quarterly") {
            $params["billingcycle"] = "0.25";
        } else {
            if ($params["billingcycle"] == "semiannually") {
                $params["billingcycle"] = "0.5";
            } else {
                if ($params["billingcycle"] == "annually") {
                    $params["billingcycle"] = "1";
                } else {
                    if ($params["billingcycle"] == "biennially") {
                        $params["billingcycle"] = "2";
                    } else {
                        if ($params["billingcycle"] == "triennially") {
                            $params["billingcycle"] = "3";
                        } else {
                            if ($params["billingcycle"] == "fourly") {
                                $params["billingcycle"] = "4";
                            } else {
                                if ($params["billingcycle"] == "fively") {
                                    $params["billingcycle"] = "5";
                                } else {
                                    return ["status" => "error", "msg" => "不支持的支付周期"];
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=renew&year=" . $params["billingcycle"] . "&vpsname=" . $params["domain"];
    $return_info = prokvm_format(prokvm_request($url));
    if ($return_info["ret"] == "ok") {
        return ["status" => "success"];
    }
    return ["status" => "error", "msg" => "续费失败" . $return_info["errorinfo"]];
}
function prokvm_ChangePackage($params)
{
    $id = $params["configoptions"]["productid"];
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=update&vpsname=" . $params["domain"] . "&productid=" . $id;
    $return_info = prokvm_format(prokvm_request($url));
    if ($return_info["ret"] == "ok") {
        return ["status" => "success", "msg" => json_encode($return_info)];
    }
    return ["status" => "error", "msg" => $return_info["errorinfo"]];
}
function prokvm_getServerInfo($params)
{
    if (prokvm_ifServert($params)) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=getinfo&vpsname=" . $params["domain"];
        $return_info = prokvm_format(prokvm_request($url));
        if ($return_info["ret"] == "ok") {
            return $return_info;
        }
        return false;
    }
    return false;
}
function prokvm_ifServert($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . $params["server_password"] . "&action=checkvpsname&vpsname=" . $params["domain"];
    $return_info = prokvm_format(prokvm_request($url));
    if ($return_info["ret"] == "ok") {
        return true;
    }
    return false;
}
function prokvm_request($url)
{
    $headerArray = [];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $output = curl_exec($ch);
    curl_close($ch);
    $r = mb_convert_encoding($output, "UTF-8", "GBK");
    return $r;
}
function prokvm_format($text)
{
    if ($text == "") {
        return 0;
    }
    $text = explode("&", $text);
    $arr = [];
    foreach ($text as $i) {
        $i = explode("=", $i);
        $arr[$i[0]] = $i[1];
    }
    return $arr;
}

?>