<?php
require_once "vendor/autoload.php";
function prokvmmax_idcsmartauthorizes()
{
}
function prokvmmax_MetaData()
{
    return ["DisplayName" => "Prokvm Max", "APIVersion" => "2.1", "HelpDoc" => "https://imzxw.cn/?p=144"];
}
function prokvmmax_TestLink($params)
{
    echo json_encode($params);
}
function prokvmmax_ConfigOptions()
{
    return [["type" => "text", "name" => "规格ID", "description" => "请参考上游的对外接口文档", "placeholder" => "规格ID", "default" => "0", "key" => "productid"], ["type" => "text", "name" => "独立控制面板地址", "description" => "请填写协议头加域名即可", "placeholder" => "", "default" => "0", "key" => "panel_url"], ["type" => "dropdown", "name" => "机器类型", "description" => "NAT or 正常", "options" => ["server" => "正常", "nat" => "NAT机"], "default" => "nat", "key" => "server_type"], ["type" => "text", "name" => "自定义服务器域名", "description" => "非必填,填后会替换原有上游展示的域名,改为填写的", "placeholder" => "", "key" => "display_domain"]];
}
function prokvmmax_ClientArea($params)
{
    $status = prokvmmax_Status($params);
    if ($status["data"]["status"] != "on" && $status["data"]["status"] != "off") {
        $body["error"] = ["name" => "信息"];
    } else {
        $body["overview"] = ["name" => "概况"];
        $body["net"] = ["name" => "网络"];
        $body["disk"] = ["name" => "硬盘"];
        if ($params["configoptions"]["server_type"] == "nat") {
            $body["nat"] = ["name" => "端口映射"];
        }
        $body["connect"] = ["name" => "远程连接"];
        $body["firewall"] = ["name" => "安全组"];
        $body["back"] = ["name" => "备份"];
        $body["tasks"] = ["name" => "任务"];
        function prokvmmax_Chart()
        {
            return ["cpu" => ["title" => "vCPU利用率", "select" => [["name" => "一小时", "value" => "hour"], ["name" => "一天", "value" => "day"], ["name" => "一周", "value" => "week"], ["name" => "一月", "value" => "month"], ["name" => "一年", "value" => "year"]]], "mem" => ["title" => "内存使用率", "select" => [["name" => "一小时", "value" => "hour"], ["name" => "一天", "value" => "day"], ["name" => "一周", "value" => "week"], ["name" => "一月", "value" => "month"], ["name" => "一年", "value" => "year"]]], "net" => ["title" => "网络流量", "select" => [["name" => "一小时", "value" => "hour"], ["name" => "一天", "value" => "day"], ["name" => "一周", "value" => "week"], ["name" => "一月", "value" => "month"], ["name" => "一年", "value" => "year"]]], "disk" => ["title" => "硬盘读写", "select" => [["name" => "一小时", "value" => "hour"], ["name" => "一天", "value" => "day"], ["name" => "一周", "value" => "week"], ["name" => "一月", "value" => "month"], ["name" => "一年", "value" => "year"]]]];
        }
    }
    return $body;
}
function prokvmmax_ClientAreaOutput($params, $key)
{
    if ($key == "overview") {
        return ["template" => "templates/overview.html"];
    }
    if ($key == "net") {
        return ["template" => "templates/net.html"];
    }
    if ($key == "disk") {
        return ["template" => "templates/disk.html"];
    }
    if ($key == "tasks") {
        return ["template" => "templates/tasks.html"];
    }
    if ($key == "nat") {
        return ["template" => "templates/nat.html"];
    }
    if ($key == "back") {
        return ["template" => "templates/back.html"];
    }
    if ($key == "firewall") {
        return ["template" => "templates/firewall.html"];
    }
    if ($key == "error") {
        $data["submit"] = "time";
        $data["type"] = "power";
        $StatusRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/status/" . $params["domain"], $data), true);
        return ["template" => "templates/error.html", "vars" => ["status" => $StatusRequest, "statusjson" => json_encode($StatusRequest)]];
    }
    if ($key == "connect") {
        return ["template" => "templates/connect.html"];
    }
}
function prokvmmax_GetMonitorData($params)
{
    $charData = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/status/" . $params["domain"], ["submit" => "time", "type" => "monitor", "load_count" => "1"]), true);
    return ["status" => "200", "msg" => "获取成功", "data" => $charData];
}
function prokvmmax_ChartData($params)
{
    if ($params["chart"]["type"] == "cpu") {
        $result["status"] = "success";
        $result["data"]["unit"] = "%";
        $result["data"]["chart_type"] = "area";
        $result["data"]["label"] = ["CPU利用率"];
        $charData = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"] . "/rrd", ["submit" => "1", "timeframe" => $params["chart"]["select"]]);
        $charData = json_decode($charData, true)["data"];
        $i = 0;
        $data = [];
        foreach ($charData["cpu"] as $a) {
            $result["data"]["list"][0][] = ["value" => $a, "time" => $charData["xAxis"][$i]];
            $i += 1;
        }
        return $result;
    } else {
        if ($params["chart"]["type"] == "mem") {
            $result["status"] = "success";
            $result["data"]["unit"] = "GB";
            $result["data"]["chart_type"] = "line";
            $result["data"]["label"] = ["内存总额", "已使用内存"];
            $charData = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"] . "/rrd", ["submit" => "1", "timeframe" => $params["chart"]["select"]]);
            $charData = json_decode($charData, true)["data"];
            $i = 0;
            $data = [];
            foreach ($charData["mem"] as $a) {
                $mem = round($a / 102400 / 10240, 2);
                $maxmem = round($charData["maxmem"][$i] / 102400 / 10240, 2);
                $result["data"]["list"][0][] = ["value" => $maxmem, "time" => $charData["xAxis"][$i]];
                $result["data"]["list"][1][] = ["value" => $mem, "time" => $charData["xAxis"][$i]];
                $i += 1;
            }
            return $result;
        } else {
            if ($params["chart"]["type"] == "net") {
                $result["status"] = "success";
                $result["data"]["chart_type"] = "line";
                $result["data"]["label"] = ["出网bps", "入网bps"];
                $charData = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"] . "/rrd", ["submit" => "1", "timeframe" => $params["chart"]["select"]]);
                $charData = json_decode($charData, true)["data"];
                $i = 0;
                $conver = prokvmmax_convert_array(["out" => $charData["netout"], "in" => $charData["netin"]]);
                $result["data"]["unit"] = $conver["unit"];
                foreach ($conver["data"]["in"] as $a) {
                    $mem = round($a / 102400 / 10240, 2);
                    $maxmem = round($charData["maxmem"][$i] / 102400 / 10240, 2);
                    $netout = $conver["data"]["out"][$i];
                    $netin = $conver["data"]["in"][$i];
                    $result["data"]["list"][0][] = ["value" => $netout, "time" => $charData["xAxis"][$i]];
                    $result["data"]["list"][1][] = ["value" => $netin, "time" => $charData["xAxis"][$i]];
                    $i += 1;
                }
                return $result;
            } else {
                if ($params["chart"]["type"] == "disk") {
                    $result["status"] = "success";
                    $result["data"]["chart_type"] = "line";
                    $result["data"]["label"] = ["读", "写"];
                    $charData = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"] . "/rrd", ["submit" => "1", "timeframe" => $params["chart"]["select"]]);
                    $charData = json_decode($charData, true)["data"];
                    $conver = prokvmmax_convert_array(["read" => $charData["diskread"], "write" => $charData["diskwrite"]]);
                    $result["data"]["unit"] = $conver["unit"];
                    $i = 0;
                    $data = [];
                    foreach ($conver["data"]["read"] as $a) {
                        $diskread = $conver["data"]["read"][$i];
                        $diskwrite = $conver["data"]["write"][$i];
                        $result["data"]["list"][0][] = ["value" => $diskread, "time" => $charData["xAxis"][$i]];
                        $result["data"]["list"][1][] = ["value" => $diskwrite, "time" => $charData["xAxis"][$i]];
                        $i += 1;
                    }
                    return $result;
                }
            }
        }
    }
}
function prokvmmax_Vnc($params)
{
    $request = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"] . "/kvm", ["submit" => "1", "vnc_type" => "novnc"]);
    if (!$request) {
        return ["status" => "error", "msg" => "打开失败"];
    }
    active_logs("prokvmmax打开VNC:" . $request, $params["uid"], 2);
    return ["status" => "success", "msg" => "打开面板成功", "url" => json_decode($request, true)["openUrl"]];
}
function prokvmmax_CreateAccount($params)
{
    if ($params["billingcycle"] == "monthly") {
        $params["billingcycle"] = "0.1";
    } else {
        if ($params["billingcycle"] == "quarterly") {
            $params["billingcycle"] = "0.25";
        } else {
            if ($params["billingcycle"] == "semiannually") {
                $params["billingcycle"] = "0.5";
            } else {
                if ($params["billingcycle"] == "annually") {
                    $params["billingcycle"] = "1";
                } else {
                    if ($params["billingcycle"] == "biennially") {
                        $params["billingcycle"] = "2";
                    } else {
                        if ($params["billingcycle"] == "triennially") {
                            $params["billingcycle"] = "3";
                        } else {
                            if ($params["billingcycle"] == "fourly") {
                                $params["billingcycle"] = "4";
                            } else {
                                if ($params["billingcycle"] == "fively") {
                                    $params["billingcycle"] = "5";
                                } else {
                                    return ["status" => "error", "msg" => "不支持的支付周期"];
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if ($params["configoptions_upgrade"]["os"]) {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=activate&productid=" . $params["configoptions"]["productid"] . "&year=" . $params["billingcycle"] . "&OSAllList=" . $params["configoptions_upgrade"]["os"] . $idc_id;
        $os_name = $params["configoptions_upgrade"]["os"];
    } else {
        $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=activate&productid=" . $params["configoptions"]["productid"] . "&year=" . $params["billingcycle"] . $idc_id;
    }
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["ret"] == "ok") {
        $update["os"] = $os_name;
        $update["dedicatedip"] = $return_info["ip"];
        $update["password"] = cmf_encrypt($return_info["vpspassword"]);
        $update["domainstatus"] = "Active";
        $update["domain"] = $return_info["vpsname"];
        $update["notes"] = $return_info["ip"];
        $customfieldsDB = think\Db::name("customfields")->where("relid", $params["productid"])->select()->toArray();
        foreach ($customfieldsDB as $i) {
            if ($i["fieldname"] == "panel_ip") {
                active_logs("使用自定义字段存储IP信息:" . $params["hostid"], $params["uid"], 2);
                think\Db::name("customfieldsvalues")->insert(["fieldid" => $i["id"], "relid" => $params["hostid"], "value" => $return_info["ip"], "create_time" => "0", "update_time" => time()]);
            }
        }
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return "ok";
    } else {
        active_logs("开通时出现错误:" . $return_info["errorinfo"] . "|prokvm返回整体数据:" . json_encode($return_info) . "请求URL:" . $url, $params["uid"], 2);
        return ["status" => "error", "msg" => $return_info["errorinfo"]];
    }
}
function prokvmmax_Reinstall($params)
{
    $data["reinstall_type"] = 1;
    $data["reinstall_port"] = 0;
    $data["format_disk"] = 0;
    $data["os_template"] = $params["reinstall_os"];
    $data["password_safe"] = $params["server_password"];
    $data["action"] = 1;
    if (stripos($params["reinstall_os"], "windows") !== false) {
        $data["system_type"] = "windows";
    } else {
        if (stripos($params["reinstall_os"], "win") !== false) {
            $data["system_type"] = "windows";
        } else {
            if (stripos($params["reinstall_os"], "centos") !== false) {
                $data["system_type"] = "centos";
            } else {
                if (stripos($params["reinstall_os"], "ubuntu") !== false) {
                    $data["system_type"] = "ubuntu";
                } else {
                    if (stripos($params["reinstall_os"], "debian") !== false) {
                        $data["system_type"] = "debian";
                    } else {
                        if (stripos($params["reinstall_os"], "fedora") !== false) {
                            $data["system_type"] = "fedora";
                        } else {
                            return ["status" => "error", "msg" => "无效的操作系统,无法判断该系统的类型"];
                        }
                    }
                }
            }
        }
    }
    $ReinstallRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"] . "/reinstall", $data), true);
    if ($ReinstallRequest["data"]["ssh_pass"] || $ReinstallRequest["code"] == "0") {
        return ["status" => "success", "msg" => $ReinstallRequest["msg"], "data" => $ReinstallRequest];
    }
    return ["status" => "error", "msg" => $ReinstallRequest["msg"], "data" => $ReinstallRequest];
}
function prokvmmax_On($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=vpsop&op=start&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["errorinfo"] == "") {
        return ["status" => "200"];
    }
    return ["status" => "error", "data" => $return_info, "msg" => $return_info["errorinfo"]];
}
function prokvmmax_Off($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=vpsop&op=turnoff&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["errorinfo"] == "") {
        return ["status" => "200"];
    }
    return ["status" => "error", "data" => $return_info, "msg" => $return_info["errorinfo"]];
}
function prokvmmax_Reboot($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=vpsop&op=reset&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["errorinfo"] == "") {
        return ["status" => "200"];
    }
    return ["status" => "error", "data" => $return_info, "msg" => $return_info["errorinfo"]];
}
function prokvmmax_HardOff($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=vpsop&op=shutdown&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["errorinfo"] == "") {
        return ["status" => "200"];
    }
    return ["status" => "error", "data" => $return_info, "msg" => $return_info["errorinfo"]];
}
function prokvmmax_Status($params)
{
    $data["submit"] = "time";
    $data["type"] = "power";
    $StatusRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/status/" . $params["domain"], $data), true);
    if ($StatusRequest["status_info"]["name"] == "已关机") {
        $result["data"]["status"] = "off";
        $result["data"]["des"] = $StatusRequest["status_info"]["name"];
    } else {
        if ($StatusRequest["status_info"]["name"] == "运行中") {
            $result["data"]["status"] = "on";
            $result["data"]["des"] = $StatusRequest["status_info"]["name"];
        } else {
            if ($StatusRequest["status_key"] == "creating") {
                $result["data"]["status"] = "creating";
                $result["data"]["des"] = $StatusRequest["status_info"]["name"];
            } else {
                if ($StatusRequest["status_key"] == "cancel") {
                    $result["data"]["status"] = "unknown";
                    $result["data"]["des"] = $StatusRequest["status_info"]["name"];
                } else {
                    $result["data"]["status"] = "unknown";
                    $result["data"]["des"] = $StatusRequest["status_info"]["name"];
                }
            }
        }
    }
    $result["status"] = "success";
    return $result;
}
function prokvmmax_CrackPassword($params, $new_password)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=modpass&newpassword=" . $new_password . "&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["ret"] == "ok") {
        return ["status" => "success"];
    }
    return ["status" => "error", "msg" => "密码修改失败", "json" => json_encode($return_info)];
}
function prokvmmax_Renew($params)
{
    if ($params["billingcycle"] == "monthly") {
        $params["billingcycle"] = "0.1";
    } else {
        if ($params["billingcycle"] == "quarterly") {
            $params["billingcycle"] = "0.25";
        } else {
            if ($params["billingcycle"] == "semiannually") {
                $params["billingcycle"] = "0.5";
            } else {
                if ($params["billingcycle"] == "annually") {
                    $params["billingcycle"] = "1";
                } else {
                    if ($params["billingcycle"] == "biennially") {
                        $params["billingcycle"] = "2";
                    } else {
                        if ($params["billingcycle"] == "triennially") {
                            $params["billingcycle"] = "3";
                        } else {
                            if ($params["billingcycle"] == "fourly") {
                                $params["billingcycle"] = "4";
                            } else {
                                if ($params["billingcycle"] == "fively") {
                                    $params["billingcycle"] = "5";
                                } else {
                                    return ["status" => "error", "msg" => "不支持的支付周期"];
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=renew&year=" . $params["billingcycle"] . "&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    if ($return_info["ret"] == "ok") {
        active_logs("请求上游续费成功,上游实际到期时间:" . $return_info["endtime"], $params["uid"], 2);
        return ["status" => "success"];
    }
    active_logs("请求上游续费失败,原因:" . json_encode($return_info) . "|url=" . $url, $params["uid"], 2);
    return ["status" => "error", "msg" => "续费失败" . $return_info["errorinfo"]];
}
function prokvmmax_AllowFunction()
{
    return ["client" => ["GetStatusInfo", "GetDiskInfo", "GetTasksInfo", "GetNetInfo", "GetNatInfo", "NatAddClient", "NatDelClient", "GetBackInfo", "DelBackClient", "AddBackClient", "ResetBackClient", "GetSnapshotInfo", "AddSnapshotClient", "ResetSnapshotClient", "DelSnapshotClient", "GetFirewallInfo", "AddfirewallClient", "EditfirewallClient", "DelFirewallClient", "GetMonitorData"]];
}
function prokvmmax_DelFirewallClient($params)
{
    $post = input("post.");
    if ($post["id"] == "" || $post["type"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["ids"] = $post["id"];
    $data["batch"] = "del";
    $data["direction"] = $post["type"];
    $DelFirewallRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/firewall/" . $params["domain"], $data), true);
    if ($DelFirewallRequest["icon"] == "success") {
        return ["status" => "200", "msg" => $DelFirewallRequest["msg"]];
    }
    return ["status" => "500", "msg" => "失败:" . $DelFirewallRequest["msg"], "data" => $DelFirewallRequest];
}
function prokvmmax_EditfirewallClient($params)
{
    $post = input("post.");
    if ($post["type"] == "" || $post["action"] == "" || $post["proto"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["enable"] = 1;
    $data["type"] = $post["type"];
    $data["action"] = $post["action"];
    $data["proto"] = $post["proto"];
    $data["ip"] = $post["ip"];
    $data["port"] = $post["port"];
    $data["comment"] = $post["comment"];
    $data["submit"] = "1";
    $data["pos"] = $post["pos"];
    $AddFirewallRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/firewall/" . $params["domain"] . "/add_rule", $data);
    preg_match("/window.JSON.parse\\('(.*?)'\\)/s", $AddFirewallRequest, $matches);
    $json_data = json_decode($matches[1], true);
    if ($json_data["icon"] == "success") {
        return ["status" => "200", "msg" => $json_data["msg"]];
    }
    return ["status" => "500", "msg" => $json_data["msg"]];
}
function prokvmmax_AddfirewallClient($params)
{
    $post = input("post.");
    if ($post["type"] == "" || $post["action"] == "" || $post["proto"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["enable"] = 1;
    $data["type"] = $post["type"];
    $data["action"] = $post["action"];
    $data["proto"] = $post["proto"];
    $data["ip"] = $post["ip"];
    $data["port"] = $post["port"];
    $data["comment"] = $post["comment"];
    $data["submit"] = "1";
    $data["pos"] = "-1";
    $AddFirewallRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/firewall/" . $params["domain"] . "/add_rule", $data);
    preg_match("/window.JSON.parse\\('(.*?)'\\)/s", $AddFirewallRequest, $matches);
    $json_data = json_decode($matches[1], true);
    if ($json_data["icon"] == "success") {
        return ["status" => "200", "msg" => $json_data["msg"]];
    }
    return ["status" => "500", "msg" => $json_data["msg"]];
}
function prokvmmax_GetFirewallInfo($params)
{
    $post = input("post.");
    $ResetFirewallRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/firewall/" . $params["domain"] . "/" . $post["type"], $data);
    if (strpos($ResetFirewallRequest, "未开放防火墙，请联系客服！") !== false) {
        return ["status" => "200", "msg" => "未开启防火墙。", "start" => false];
    }
    $html = voku\helper\HtmlDomParser::str_get_html($ResetFirewallRequest);
    $a = $html->find("tbody")->find("tr")->innertext;
    $array = [];
    foreach ($a as $i) {
        $trhtml = voku\helper\HtmlDomParser::str_get_html($i);
        $a = $trhtml->find("td")->innertext;
        array_push($array, $a);
    }
    return ["status" => "200", "data" => $array];
}
function prokvmmax_DelSnapshotClient($params)
{
    $post = input("post.");
    if ($post["snapname"] == "" || $post["id"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["snapname"] = $post["snapname"];
    $data["id"] = $post["id"];
    $ResetSnapshotRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/del_snap", $data), true);
    if ($ResetSnapshotRequest["icon"] == "success") {
        return ["status" => "200", "msg" => $ResetSnapshotRequest["msg"]];
    }
    return ["status" => "500", "msg" => "失败:" . $ResetSnapshotRequest["msg"], "data" => $ResetSnapshotRequest];
}
function prokvmmax_ResetSnapshotClient($params)
{
    $post = input("post.");
    if ($post["snapname"] == "" || $post["id"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["snapname"] = $post["snapname"];
    $data["id"] = $post["id"];
    $ResetSnapshotRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/rollback_snap", $data), true);
    if ($ResetSnapshotRequest["icon"] == "success") {
        return ["status" => "200", "msg" => $ResetSnapshotRequest["msg"]];
    }
    return ["status" => "500", "msg" => "失败:" . $ResetSnapshotRequest["msg"], "data" => $ResetSnapshotRequest];
}
function prokvmmax_ResetBackClient($params)
{
    $post = input("post.");
    if ($post["volid"] == "" || $post["storage"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["volid"] = $post["volid"];
    $ResetBackRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/reset_backup", $data), true);
    if ($ResetBackRequest["icon"] == "success") {
        return ["status" => "200", "msg" => $ResetBackRequest["msg"]];
    }
    return ["status" => "500", "msg" => "失败:" . $ResetBackRequest["msg"], "data" => $ResetBackRequest];
}
function prokvmmax_AddSnapshotClient($params)
{
    $post = input("post.");
    $data["snapname"] = $post["name"];
    $data["description"] = $post["description"];
    $data["submit"] = 1;
    $AddSnapshotRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/add_snap", $data);
    preg_match("/window.JSON.parse\\('(.*?)'\\)/s", $AddSnapshotRequest, $matches);
    $json_data = json_decode($matches[1], true);
    if ($json_data["icon"] == "success") {
        return ["status" => "200", "msg" => $json_data["msg"]];
    }
    return ["status" => "500", "msg" => $json_data["msg"]];
}
function prokvmmax_AddBackClient($params)
{
    $post = input("post.");
    $data["compress"] = $post["compress"];
    $data["submit"] = "1";
    $data["storage"] = "local";
    $data["mode"] = "snapshot";
    $AddBackRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/add_backup", $data);
    preg_match("/window.JSON.parse\\('(.*?)'\\)/s", $AddBackRequest, $matches);
    $json_data = json_decode($matches[1], true);
    if ($json_data["icon"] == "success") {
        return ["status" => "200", "msg" => $json_data["msg"]];
    }
    return ["status" => "500", "msg" => $json_data["msg"]];
}
function prokvmmax_DelBackClient($params)
{
    $post = input("post.");
    if ($post["volid"] == "" || $post["storage"] == "") {
        return ["status" => "404", "msg" => "缺少参数"];
    }
    $data["volid"] = $post["volid"];
    $data["storage"] = $post["storage"];
    $DelBackRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/del_backup", $data), true);
    if ($DelBackRequest["icon"] == "success") {
        return ["status" => "200", "msg" => $DelBackRequest["msg"]];
    }
    return ["status" => "500", "msg" => "失败:" . $DelBackRequest["msg"], "data" => $DelBackRequest];
}
function prokvmmax_GetSnapshotInfo($params)
{
    $BackRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/snap" . $error);
    $html = voku\helper\HtmlDomParser::str_get_html($BackRequest);
    $a = $html->find("tbody")->find("tr")->innertext;
    $array = [];
    if (strpos($BackRequest, "备份中，请稍候刷新！") !== false) {
        $run = true;
    }
    if (strpos($BackRequest, "备份恢复中，请稍候刷新！") !== false) {
        $back_run = true;
    }
    foreach ($a as $i) {
        $trhtml = voku\helper\HtmlDomParser::str_get_html($i);
        $a = $trhtml->find("td")->innertext;
        array_push($array, $a);
    }
    return ["status" => "200", "data" => $array, "run" => $run, "back_run" => $back_run];
}
function prokvmmax_GetBackInfo($params)
{
    $BackRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/backup/" . $params["domain"] . "/backup" . $error);
    $html = voku\helper\HtmlDomParser::str_get_html($BackRequest);
    $a = $html->find("tbody")->find("tr")->innertext;
    $array = [];
    if (strpos($BackRequest, "备份中，请稍候刷新！") !== false) {
        $run = true;
    }
    if (strpos($BackRequest, "备份恢复中，请稍候刷新！") !== false) {
        $back_run = true;
    }
    foreach ($a as $i) {
        $trhtml = voku\helper\HtmlDomParser::str_get_html($i);
        $a = $trhtml->find("td")->innertext;
        array_push($array, $a);
    }
    return ["status" => "200", "data" => $array, "run" => $run, "back_run" => $back_run];
}
function prokvmmax_NatDelClient($params)
{
    $post = input("post.");
    if ($post["id"] == "") {
        return ["status" => "404", "msg" => "缺少id"];
    }
    $data["ids"] = $post["id"];
    $data["batch"] = "del";
    $DelNatRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/nat/" . $params["domain"], $data), true);
    if ($DelNatRequest["icon"] == "success") {
        return ["status" => "200", "msg" => "删除成功"];
    }
    return ["status" => "500", "msg" => $DelNatRequest["msg"]];
}
function prokvmmax_NatAddClient($params)
{
    $post = input("post.");
    $data["dis_type"] = $post["dis_type"];
    $data["name"] = $post["name"];
    $data["type"] = $post["type"];
    if ($post["dis_type"] != "1") {
        $data["inner_port"] = $post["inner_port"];
    }
    $data["submit"] = "1";
    if ($data["dis_type"] == "" || $data["name"] == "") {
        return ["status" => "404", "msg" => "请填写完整参数"];
    }
    $AddNatRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/nat/" . $params["domain"] . "/add", $data);
    preg_match("/window.JSON.parse\\('(.*?)'\\)/s", $AddNatRequest, $matches);
    $json_data = json_decode($matches[1], true);
    if ($json_data["icon"] == "success" || $json_data["msg"] == "\\u64cd\\u4f5c\\u6210\\u529f") {
        return ["status" => "200", "msg" => $json_data["msg"]];
    }
    return ["status" => "500", "msg" => $json_data["msg"]];
}
function prokvmmax_GetNatInfo($params)
{
    $post = input("post.");
    $NatRequestHtml = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/nat/" . $params["domain"]);
    $html = voku\helper\HtmlDomParser::str_get_html($NatRequestHtml);
    $a = $html->find("tbody")->find("tr")->innertext;
    $array = [];
    foreach ($a as $i) {
        $trhtml = voku\helper\HtmlDomParser::str_get_html($i);
        $a = $trhtml->find("td")->innertext;
        if ($params["configoptions"]["server_type"] == "nat" && $params["configoptions"]["display_domain"] != "") {
            $display_domain = true;
            $a[3] = $params["configoptions"]["display_domain"];
        }
        array_push($array, $a);
    }
    return ["status" => "200", "data" => $array, "display_domain" => $display_domain];
}
function prokvmmax_GetNetInfo($params)
{
    $post = input("post.");
    $NetRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/status/" . $params["domain"], ["submit" => "time", "type" => "info"]);
    if ($params["configoptions"]["server_type"] == "nat") {
        $NetInfo["nat"] = true;
    } else {
        $NetInfo["nat"] = false;
    }
    $NetInfo = json_decode($NetRequest, true)["data"];
    $NetRequestHtml = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/net/" . $params["domain"]);
    $NetInfo["bandwidth"] = prokvmmax_findspan($NetRequestHtml, "text-muted", "带宽：", "b");
    $NetInfo["defense"] = prokvmmax_findspan($NetRequestHtml, "text-muted", "防御总量：", "b");
    $NetInfo["flow"] = prokvmmax_findspan($NetRequestHtml, "text-muted", "可用流量：", "b");
    return ["status" => "200", "data" => $NetInfo];
}
function prokvmmax_GetTasksInfo($params)
{
    $post = input("post.");
    if ($post["error"] == "true") {
        $error = "?errors=1";
    }
    $TasksRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/tasks/" . $params["domain"] . $error);
    if ($TasksRequest == "" || $TasksRequest == "null") {
        active_logs("获取任务信息出现错误:返回结果为空:" . $TasksRequest, $params["uid"], 2);
        return ["status" => "500", "msg" => "获取失败", "data" => "返回结果为空:" . $TasksRequest];
    }
    $html = voku\helper\HtmlDomParser::str_get_html($TasksRequest);
    $a = $html->find("tbody")->find("tr")->innertext;
    $array = [];
    foreach ($a as $i) {
        $trhtml = voku\helper\HtmlDomParser::str_get_html($i);
        $a = $trhtml->find("td")->innertext;
        array_push($array, $a);
    }
    return ["status" => "200", "msg" => "获取成功", "data" => array_slice($array, 0, 10)];
}
function prokvmmax_GetDiskInfo($params)
{
    $post = input("post.");
    $diskRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/hdd/" . $params["domain"]);
    if ($diskRequest == "" || $diskRequest == "null") {
        active_logs("获取硬盘信息出现错误:返回结果为空:" . $diskRequest, $params["uid"], 2);
        return ["status" => "500", "msg" => "获取失败", "data" => "返回结果为空:" . $diskRequest];
    }
    $html = voku\helper\HtmlDomParser::str_get_html($diskRequest);
    $a = $html->find("tbody")->find("tr")->innertext;
    $array = [];
    foreach ($a as $i) {
        $trhtml = voku\helper\HtmlDomParser::str_get_html($i);
        $a = $trhtml->find("td")->innertext;
        array_push($array, $a);
    }
    return ["status" => "200", "msg" => "获取成功", "data" => $array];
}
function prokvmmax_GetStatusInfo($params)
{
    $post = input("post.");
    $htmlRequest = prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/detail/" . $params["domain"]);
    $html = voku\helper\HtmlDomParser::str_get_html($htmlRequest);
    $htmlDiv = $html->find("div.list-group", 1)->find("div")->innertext;
    preg_match_all("/(?<=^|>)[^<>]+?(?=<|\$)(?<!地域\\/线路\\/可用区：)/", $htmlDiv[3], $matches);
    $data["area"] = str_ireplace(" ", "", $matches[0][0]);
    $data["area"] = str_ireplace("\n", "", $data["area"]);
    $data["line"] = str_ireplace(" ", "", $matches[0][2]);
    $data["line"] = str_ireplace("\n", "", $data["line"]);
    $data["zone"] = str_ireplace(" ", "", $matches[0][4]);
    $data["zone"] = str_ireplace("\n", "", $data["zone"]);
    if ($server_os[1] == NULL) {
        $server_os[1] = "Windows Null";
    }
    $data["os"] = $server_os[1];
    $data["data"]["os"] = $server_os;
    preg_match_all("/<b>(.*?)<\\/b>/", $htmlDiv[6], $matches_pz);
    $data["config"]["cpu"] = $matches_pz[1][0];
    $data["config"]["mem"] = $matches_pz[1][1];
    $data["config"]["disk"] = $matches_pz[1][2];
    $data["config"]["bandwidth"] = $matches_pz[1][3];
    preg_match("/<span[^>]*class=\"main_ip\"[^>]*>([^<]+)/", $htmlRequest, $matches_hostname);
    $data["hostname"] = isset($matches_hostname[1]) ? trim($matches_hostname[1]) : "";
    if ($params["configoptions"]["server_type"] == "nat" && $params["configoptions"]["display_domain"] != "") {
        $data["hostname"] = $params["configoptions"]["display_domain"];
    }
    preg_match("/<span class=\"text-muted\">:\\s*(\\d+)<\\/span>/", $htmlRequest, $matches_port);
    $data["port"] = $matches_port[1];
    $StatusRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/status/" . $params["domain"], ["submit" => "time", "type" => "power"]), true);
    $data["runtime"] = $StatusRequest["status_key"];
    $data["password"] = $params["password"];
    return ["status" => "200", "data" => $data, "html" => $htmlRequest];
}
function prokvmmax_Sync($params)
{
    $url = $params["server_http_prefix"] . "://" . $params["server_ip"] . "/api/cloudapi.asp?userid=" . $params["server_username"] . "&userstr=" . md5($params["accesshash"] . "7i24.com") . "&action=getinfo&vpsname=" . $params["domain"];
    $return_info = prokvmmax_format(prokvmmax_request($url));
    $NetRequest = json_decode(prokvmmax_maxrequest($params, $params["configoptions"]["panel_url"] . "/server/status/" . $params["domain"], ["submit" => "time", "type" => "info"]), true);
    foreach ($NetRequest["data"]["ip_list"] as $i) {
        $ip[] = $i["ip"];
    }
    $data["assignedips"] = implode(",", $ip);
    $data["nextduedate"] = strtotime($return_info["endtime"]);
    think\Db::name("host")->where("id", $params["hostid"])->update($data);
    return ["status" => "success", "msg" => "同步完成" . json_encode($ip)];
}
function prokvmmax_findspan($html, $find_class, $find_title, $find_biaoqian)
{
    $html = voku\helper\HtmlDomParser::str_get_html($html);
    $defense_span = $html->find("span." . $find_class . ":contains(\"" . $find_title . "\")", 0);
    if ($defense_span) {
        $b_element = $defense_span->next_sibling();
        while ($b_element && $b_element->tag != $find_biaoqian) {
            $b_element = $b_element->next_sibling(true);
        }
        if ($b_element && $b_element->tag == $find_biaoqian) {
            $defense_value = $b_element->plaintext;
            return $defense_value;
        }
    }
}
function prokvmmax_convert_array($data)
{
    $max_value = 0;
    foreach ($data as $key => $value) {
        foreach ($value as $v) {
            $v = (double) $v;
            if ($max_value < $v) {
                $max_value = $v;
            }
        }
    }
    $units = ["B", "KB", "MB"];
    for ($i = 0; 1024 < $max_value; $i++) {
        $max_value /= 1024;
    }
    $converted_data = [];
    foreach ($data as $key => $value) {
        $converted_data[$key] = [];
        foreach ($value as $v) {
            $converted_data[$key][] = round((double) $v / pow(1024, $i), 2);
        }
    }
    return ["unit" => $units[$i], "data" => $converted_data];
}
function prokvmmax_request($url, $data = "", $method = "GET")
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["X-HTTP-Method-Override: " . $method, "Content-Type: application/json", "x-requested-with: xmlhttprequest"]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    $document = curl_exec($ch);
    curl_close($ch);
    $r = mb_convert_encoding($document, "UTF-8", "GBK");
    return $r;
}
function prokvmmax_maxrequest($params, $url, $data = "", $method = "")
{
    $path = $_SERVER["DOCUMENT_ROOT"];
    $file = "cookie.json";
    $path = str_replace(["public", "Public"], "app", $path);
    $fullPath = $path . "/" . $file;
    if (!file_exists($fullPath)) {
        $f = fopen($fullPath, "w");
        fclose($f);
    }
    $cookie_json = file_get_contents($fullPath);
    $cookie_array = json_decode($cookie_json, true);
    if ($cookie_array[$params["server_ip"] . "_" . $params["domain"]]) {
        if ($cookie_array[$params["server_ip"] . "_" . $params["domain"]]["time"] + 21600 >= time()) {
            $cookie = $cookie_array[$params["server_ip"] . "_" . $params["domain"]]["cookie"];
        }
        return Cookie_request($cookie, $url, $data);
    }
    $cookieArray = GetCookie($params["configoptions"]["panel_url"] . "/loginpanel/server", $params);
    if (!$cookieArray["status"]) {
        active_logs("prokvmmax_maxrequest:尝试登录失败" . json_encode($cookieArray), $params["uid"], 2);
        return false;
    }
    $cookie_array[$params["server_ip"] . "_" . $params["domain"]]["stand"] = $params["server_ip"];
    $cookie_array[$params["server_ip"] . "_" . $params["domain"]]["time"] = time();
    $cookie_array[$params["server_ip"] . "_" . $params["domain"]]["cookie"] = $cookieArray["cookie"];
    $cookie_array[$params["server_ip"] . "_" . $params["domain"]]["serverid"] = $params["domain"];
    $fp = fopen($fullPath, "w");
    fwrite($fp, json_encode($cookie_array));
    fclose($fp);
    $cookie = $cookieArray["cookie"];
    active_logs("prokvmmax_maxrequest:cookie过期或不存在该cookie,获取cookie:" . $cookie, $params["uid"], 2);
}
function GetCookie($url, $params)
{
    $path = $_SERVER["DOCUMENT_ROOT"];
    $path = str_replace(["public", "Public"], "app", $path);
    $fullPath = $path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $fullPath . "/prokvm_" . $params["server_ip"] . ".cookie");
    $data = curl_exec($ch);
    curl_close($ch);
    unset($ch);
    $customfieldsDB = think\Db::name("customfields")->where("relid", $params["productid"])->select()->toArray();
    foreach ($customfieldsDB as $i) {
        if ($i["fieldname"] == "panel_ip") {
            $panelDB = think\Db::name("customfieldsvalues")->where("relid", $params["hostid"])->where("fieldid", $i["id"])->find();
            active_logs("使用自定义字段进行COOKIE登录:" . json_encode($panelDB) . "|" . $i["id"], $params["uid"], 2);
            $body["user"] = $panelDB["value"];
            if ($body["user"] == "") {
                $body["user"] = $params["notes"];
            }
            $body["pass"] = $params["password"];
            $body["product"] = "server";
            $body["submit"] = 1;
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_COOKIEFILE, $fullPath . "/prokvm_" . $params["server_ip"] . ".cookie");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            $response = curl_exec($ch);
            curl_close($ch);
            $regex = "{.*}";
            if (!preg_match($regex, $response, $matches)) {
                return ["status" => "0", "msg" => "正则匹配失败", "data" => $response];
            }
            if (!strpos($response, "window.parent.location.hre")) {
                return ["status" => "0", "msg" => "登陆失败", "data" => $response];
            }
            $cookie = file_get_contents($fullPath . "/prokvm_" . $params["server_ip"] . ".cookie");
            $regex = "/(?<=sw110xy\\s)\\S+/";
            if (!preg_match($regex, $cookie, $matches)) {
                return ["status" => "0", "msg" => "获取cookie的正则匹配失败", "data" => $cookie];
            }
            $cookie = $matches[0];
            return ["status" => "1", "msg" => "cookie登录成功", "cookie" => $cookie];
        }
    }
}
function Cookie_request($cookie, $url, $data)
{
    $options = [CURLOPT_URL => $url, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_HTTPHEADER => ["cookie: sw110xy=" . $cookie]];
    $curl = curl_init();
    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    if (curl_errno($curl)) {
        echo "Error: " . curl_error($curl);
        curl_close($curl);
    } else {
        return $response;
    }
}
function prokvmmax_format($text)
{
    if ($text == "") {
        return 0;
    }
    $text = explode("&", $text);
    $arr = [];
    foreach ($text as $i) {
        $i = explode("=", $i);
        $arr[$i[0]] = $i[1];
    }
    return $arr;
}

?>