<?php
function pterodactyl_idcsmartauthorizes()
{
}
function pterodactyl_GetHostname($params)
{
    $hostname = $params["server_host"];
    if ($hostname === "") {
        return ["status" => "error", "msg" => "主机名为空"];
    }
    foreach (["DOT" => ".", "DASH" => "-"] as $from => $to) {
        $hostname = str_replace($from, $to, $hostname);
    }
    if (ip2long($hostname) !== false) {
        $hostname = "http://" . $hostname;
    } else {
        $hostname = ($params["secure"] ? "https://" : "http://") . $hostname;
    }
    return rtrim($hostname, "/");
}
function pterodactyl_API(array $params, $endpoint, array $data = [], $method = "GET", $dontLog = false)
{
    $url = pterodactyl_gethostname($params) . "/api/application/" . $endpoint;
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
    curl_setopt($curl, CURLOPT_USERAGENT, "Pterodactyl-WHMCS");
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($curl, CURLOPT_POSTREDIR, CURL_REDIR_POST_301);
    curl_setopt($curl, CURLOPT_TIMEOUT, 5);
    $headers = ["Authorization: Bearer " . $params["accesshash"], "Accept: Application/vnd.pterodactyl.v1+json"];
    if ($method === "POST" || $method === "PATCH") {
        $jsonData = json_encode($data);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        array_push($headers, "Content-Type: application/json");
        array_push($headers, "Content-Length: " . strlen($jsonData));
    }
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    $response = curl_exec($curl);
    $responseData = json_decode($response, true);
    $responseData["status_code"] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    return $responseData;
}
function pterodactyl_Error($func, $params, Exception $err)
{
    active_logs($err->getMessage(), $params["uid"], 2);
}
function random($length)
{
    $str = NULL;
    $strPol = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    $max = strlen($strPol) - 1;
    for ($i = 0; $i < $length; $i++) {
        $str .= $strPol[rand(0, $max)];
    }
    return $str;
}
function pterodactyl_GenerateUsername($length = 8)
{
    $returnable = false;
    while (!$returnable) {
        $generated = random($length);
        if (preg_match("/[A-Z]+[a-z]+[0-9]+/", $generated)) {
            $returnable = true;
        }
    }
    return $generated;
}
function pterodactyl_GetOption(array $params, $id, $default = NULL)
{
    $options = pterodactyl_ConfigOptions();
    $friendlyName = $options[$id]["name"];
    if (isset($params["configoptions"][$friendlyName]) && $params["configoptions"][$friendlyName] !== "") {
        return $params["configoptions"][$friendlyName];
    }
    if (isset($params["configoptions"][$id]) && $params["configoptions"][$id] !== "") {
        return $params["configoptions"][$id];
    }
    if (isset($params["customfields"][$friendlyName]) && $params["customfields"][$friendlyName] !== "") {
        return $params["customfields"][$friendlyName];
    }
    if (isset($params["customfields"][$id]) && $params["customfields"][$id] !== "") {
        return $params["customfields"][$id];
    }
    $found = false;
    $i = 0;
    foreach (pterodactyl_ConfigOptions() as $key => $value) {
        $i++;
        if ($key === $id) {
            $found = true;
            if ($found && isset($params["configoption" . $i]) && $params["configoption" . $i] !== "") {
                return $params["configoption" . $i];
            }
            return $default;
        }
    }
}
function pterodactyl_GetServerID($params, $raw = false)
{
    $serverResult = pterodactyl_api($params, "servers/external/" . $params["hostid"], [], "GET", true);
    if ($serverResult["status_code"] === 200) {
        if ($raw) {
            return $serverResult;
        }
        return $serverResult["attributes"]["id"];
    }
    if ($serverResult["status_code"] === 500) {
        return ["status" => "error", "msg" => "无法获取服务器，面板错误。查看面板日志了解更多信息"];
    }
}
function pterodactyl_MetaData()
{
    return ["DisplayName" => "Pterodactyl对接模块", "APIVersion" => "1.0.0", "HelpDoc" => ""];
}
function pterodactyl_ConfigOptions()
{
    return [["type" => "text", "name" => "CPU限制 (%)", "description" => "要分配给创建的服务器的CPU量", "key" => "cpu"], ["type" => "text", "name" => "磁盘空间 (MB)", "description" => "要分配给创建的服务器的磁盘空间量", "key" => "disk"], ["type" => "text", "name" => "内存 (MB)", "description" => "要分配给创建的服务器的内存量", "key" => "memory"], ["type" => "text", "name" => "交换 (MB)", "description" => "要分配给创建的服务器的交换量", "key" => "swap"], ["type" => "text", "name" => "位置ID", "description" => "要自动部署到的位置的ID", "key" => "location_id"], ["type" => "yesno", "name" => "专用IP", "description" => "为服务器分配专用ip（可选）", "key" => "dedicated_ip"], ["type" => "text", "name" => "嵌套ID", "description" => "服务器要使用的嵌套ID", "key" => "nest_id"], ["type" => "text", "name" => "Egg ID", "description" => "服务器要使用的Egg ID", "key" => "egg_id"], ["type" => "text", "name" => "Block IO Weight", "description" => "块IO调整编号（10-1000）", "key" => "io", "default" => "500"], ["type" => "text", "name" => "Pack ID", "description" => "用于安装服务器的包的ID（可选）[未使用，出于兼容性原因保留]", "key" => "pack_id"], ["type" => "text", "name" => "端口范围", "description" => "以逗号分隔的端口范围分配给服务器（例如：25565-255702580-25590）（可选）", "key" => "port_range"], ["type" => "text", "name" => "启动", "description" => "要分配给创建的服务器的自定义启动命令（可选）", "key" => "startup"], ["type" => "text", "name" => "镜像", "description" => "要分配给创建的服务器的自定义Docker镜像（可选）", "key" => "image"], ["type" => "text", "name" => "数据库", "description" => "客户端将能够为其服务器创建此数量的数据库（可选）", "key" => "databases"], ["type" => "text", "name" => "服务器名称", "description" => "面板上显示的服务器名称（可选）", "key" => "server_name"], ["type" => "text", "name" => "禁用OOM Killer", "description" => "是否禁用内存不足Killer（可选）", "key" => "oom_disabled"], ["type" => "text", "name" => "备份", "description" => "客户端将能够为其服务器创建此数量的备份（可选）", "key" => "backups"], ["type" => "text", "name" => "分配", "description" => "客户端将能够为其服务器创建此数量的分配（可选）", "key" => "allocations"]];
}
function pterodactyl_TestLink($params)
{
    $solutions = ["检查模块调试日志以了解更详细的错误", "401" => "缺少或未提供授权标头", "403" => "再次检查密码（应为应用程序密钥）", "404" => "未找到结果", "422" => "验证错误", "500" => "面板出错，请检查面板日志"];
    $err = "";
    $response = pterodactyl_api($params, "nodes");
    if ($response["status_code"] !== 200) {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = "接收到无效的status代码： " . $response["status_code"] . ". 可能的解决方案: " . (isset($solutions[$response["status_code"]]) ? $solutions[$response["status_code"]] : "None.");
    } else {
        if ($response["meta"]["pagination"]["count"] === 0) {
            $result["status"] = 200;
            $result["data"]["server_status"] = 0;
            $result["data"]["msg"] = "身份验证成功，但没有可用的节点.";
        } else {
            $result["status"] = 200;
            $result["data"]["server_status"] = 1;
        }
    }
    return $result;
}
function pterodactyl_CreateAccount($params)
{
    $serverId = pterodactyl_getserverid($params);
    if (isset($serverId)) {
        return ["status" => "error", "msg" => "无法创建服务器，因为它已创建."];
    }
    $userResult = pterodactyl_api($params, "users/external/" . $params["uid"]);
    if ($userResult["status_code"] === 404) {
        $userResult = pterodactyl_api($params, "users?filter[email]=" . urlencode($params["user_info"]["email"]));
        if ($userResult["meta"]["pagination"]["total"] === 0) {
            $userResult = pterodactyl_api($params, "users", ["username" => pterodactyl_getoption($params, "username", pterodactyl_generateusername()), "email" => $params["user_info"]["email"], "first_name" => "名", "last_name" => "姓", "external_id" => (string) $params["uid"]], "POST");
        } else {
            foreach ($userResult["data"] as $key => $value) {
                if ($value["attributes"]["email"] === $params["user_info"]["email"]) {
                    $userResult = array_merge($userResult, $value);
                    $userResult = array_merge($userResult, $userResult["data"][0]);
                }
            }
        }
    }
    if ($userResult["status_code"] === 200 || $userResult["status_code"] === 201) {
        $userId = $userResult["attributes"]["id"];
        $nestId = pterodactyl_getoption($params, "nest_id");
        $eggId = pterodactyl_getoption($params, "egg_id");
        $eggData = pterodactyl_api($params, "nests/" . $nestId . "/eggs/" . $eggId . "?include=variables");
        if ($eggData["status_code"] !== 200) {
            return ["status" => "error", "msg" => "获取Egg数据失败，收到错误代码: " . $eggData["status_code"] . ". 有关详细信息，请启用模块调试日志."];
        }
        $environment = [];
        foreach ($eggData["attributes"]["relationships"]["variables"]["data"] as $key => $val) {
            $attr = $val["attributes"];
            $var = $attr["env_variable"];
            $default = $attr["default_value"];
            $friendlyName = pterodactyl_getoption($params, $attr["name"]);
            $envName = pterodactyl_getoption($params, $attr["env_variable"]);
            if (isset($friendlyName)) {
                $environment[$var] = $friendlyName;
            } else {
                if (isset($envName)) {
                    $environment[$var] = $envName;
                } else {
                    $environment[$var] = $default;
                }
            }
        }
        $name = pterodactyl_getoption($params, "server_name", pterodactyl_generateusername() . "_" . $params["hostid"]);
        $memory = pterodactyl_getoption($params, "memory");
        $swap = pterodactyl_getoption($params, "swap");
        $io = pterodactyl_getoption($params, "io");
        $cpu = pterodactyl_getoption($params, "cpu");
        $disk = pterodactyl_getoption($params, "disk");
        $location_id = pterodactyl_getoption($params, "location_id");
        $dedicated_ip = pterodactyl_getoption($params, "dedicated_ip") ? true : false;
        $port_range = pterodactyl_getoption($params, "port_range");
        $port_range = isset($port_range) ? explode(",", $port_range) : [];
        $image = pterodactyl_getoption($params, "image", $eggData["attributes"]["docker_image"]);
        $startup = pterodactyl_getoption($params, "startup", $eggData["attributes"]["startup"]);
        $databases = pterodactyl_getoption($params, "databases");
        $allocations = pterodactyl_getoption($params, "allocations");
        $backups = pterodactyl_getoption($params, "backups");
        $oom_disabled = pterodactyl_getoption($params, "oom_disabled") ? true : false;
        $serverData = ["name" => $name, "user" => (int) $userId, "nest" => (int) $nestId, "egg" => (int) $eggId, "docker_image" => $image, "startup" => $startup, "oom_disabled" => $oom_disabled, "limits" => ["memory" => (int) $memory, "swap" => (int) $swap, "io" => (int) $io, "cpu" => (int) $cpu, "disk" => (int) $disk], "feature_limits" => ["databases" => $databases ? (int) $databases : NULL, "allocations" => (int) $allocations, "backups" => (int) $backups], "deploy" => ["locations" => [(int) $location_id], "dedicated_ip" => $dedicated_ip, "port_range" => $port_range], "environment" => $environment, "start_on_completion" => true, "external_id" => (string) $params["hostid"]];
        $server = pterodactyl_api($params, "servers?include=allocations", $serverData, "POST");
        if ($server["status_code"] === 400) {
            return ["status" => "error", "msg" => "找不到任何满足请求的节点。"];
        }
        if ($server["status_code"] !== 201) {
            return ["status" => "error", "msg" => "创建服务器失败，收到错误代码： " . $server["status_code"] . ". 有关详细信息，请启用模块调试日志"];
        }
        unset($params["password"]);
        $_IP = $server["attributes"]["relationships"]["allocations"]["data"][0]["attributes"]["ip"];
        $_Port = $server["attributes"]["relationships"]["allocations"]["data"][0]["attributes"]["port"];
        if (isset($_IP) && isset($_Port)) {
            think\Db::name("host")->where("id", $params["hostid"])->update(["dedicatedip" => $_IP, "port" => $_Port]);
        }
        think\Db::name("host")->where("id", $params["hostid"])->update(["username" => "", "password" => ""]);
        return "success";
    } else {
        return ["status" => "error", "msg" => "创建用户失败，收到错误代码: " . $userResult["status_code"] . ". 有关详细信息，请启用模块调试日志."];
    }
}
function pterodactyl_ChangePackage($params)
{
    $serverData = pterodactyl_getserverid($params, true);
    if ($serverData["status_code"] === 404 || !isset($serverData["attributes"]["id"])) {
        return ["status" => "error", "msg" => "服务器不存在"];
    }
    $serverId = $serverData["attributes"]["id"];
    $memory = pterodactyl_getoption($params, "memory");
    $swap = pterodactyl_getoption($params, "swap");
    $io = pterodactyl_getoption($params, "io");
    $cpu = pterodactyl_getoption($params, "cpu");
    $disk = pterodactyl_getoption($params, "disk");
    $databases = pterodactyl_getoption($params, "databases");
    $allocations = pterodactyl_getoption($params, "allocations");
    $backups = pterodactyl_getoption($params, "backups");
    $oom_disabled = pterodactyl_getoption($params, "oom_disabled") ? true : false;
    $updateData = ["allocation" => $serverData["attributes"]["allocation"], "memory" => (int) $memory, "swap" => (int) $swap, "io" => (int) $io, "cpu" => (int) $cpu, "disk" => (int) $disk, "oom_disabled" => $oom_disabled, "feature_limits" => ["databases" => (int) $databases, "allocations" => (int) $allocations, "backups" => (int) $backups]];
    $updateResult = pterodactyl_api($params, "servers/" . $serverId . "/build", $updateData, "PATCH");
    if ($updateResult["status_code"] !== 200) {
        return ["status" => "error", "msg" => "未能更新服务器的内部版本，收到错误代码：" . $updateResult["status_code"] . ". 有关详细信息，请启用模块调试日志"];
    }
    $nestId = pterodactyl_getoption($params, "nest_id");
    $eggId = pterodactyl_getoption($params, "egg_id");
    $eggData = pterodactyl_api($params, "nests/" . $nestId . "/eggs/" . $eggId . "?include=variables");
    if ($eggData["status_code"] !== 200) {
        return ["status" => "error", "msg" => "获取Egg数据失败，收到错误代码：" . $updateResult["status_code"] . ". 有关详细信息，请启用模块调试日志"];
    }
    $environment = [];
    foreach ($eggData["attributes"]["relationships"]["variables"]["data"] as $key => $val) {
        $attr = $val["attributes"];
        $var = $attr["env_variable"];
        $friendlyName = pterodactyl_getoption($params, $attr["name"]);
        $envName = pterodactyl_getoption($params, $attr["env_variable"]);
        if (isset($friendlyName)) {
            $environment[$var] = $friendlyName;
        } else {
            if (isset($envName)) {
                $environment[$var] = $envName;
            } else {
                if (isset($serverData["attributes"]["container"]["environment"][$var])) {
                    $environment[$var] = $serverData["attributes"]["container"]["environment"][$var];
                } else {
                    if (isset($attr["default_value"])) {
                        $environment[$var] = $attr["default_value"];
                    }
                }
            }
        }
    }
    $image = pterodactyl_getoption($params, "image", $serverData["attributes"]["container"]["image"]);
    $startup = pterodactyl_getoption($params, "startup", $serverData["attributes"]["container"]["startup_command"]);
    $updateData = ["environment" => $environment, "startup" => $startup, "egg" => (int) $eggId, "image" => $image, "skip_scripts" => false];
    $updateResult = pterodactyl_api($params, "servers/" . $serverId . "/startup", $updateData, "PATCH");
    if ($updateResult["status_code"] !== 200) {
        return ["status" => "error", "msg" => "无法更新服务器的启动，收到错误代码：" . $updateResult["status_code"] . ". 有关详细信息，请启用模块调试日志"];
    }
    $result["status"] = "success";
    $result["msg"] = "升级配置成功";
    return $result;
}
function pterodactyl_SuspendAccount($params)
{
    $serverId = pterodactyl_getserverid($params);
    if (!isset($serverId)) {
        return ["status" => "error", "msg" => "服务器不存在"];
    }
    $suspendResult = pterodactyl_api($params, "servers/" . $serverId . "/suspend", [], "POST");
    if ($suspendResult["status_code"] !== 204) {
        return ["status" => "error", "msg" => "未能挂起服务器，收到错误代码： " . $suspendResult["status_code"] . ". 有关详细信息，请启用模块调试日志。"];
    }
    return "success";
}
function pterodactyl_UnsuspendAccount($params)
{
    $serverId = pterodactyl_getserverid($params);
    if (!isset($serverId)) {
        return ["status" => "error", "msg" => "服务器不存在"];
    }
    $suspendResult = pterodactyl_api($params, "servers/" . $serverId . "/unsuspend", [], "POST");
    if ($suspendResult["status_code"] !== 204) {
        return ["status" => "error", "msg" => "未能取消挂起服务器，收到错误代码： " . $suspendResult["status_code"] . ". 有关详细信息，请启用模块调试日志。"];
    }
    return "success";
}
function pterodactyl_TerminateAccount($params)
{
    $serverId = pterodactyl_getserverid($params);
    if (!isset($serverId)) {
        return ["status" => "error", "msg" => "服务器不存在"];
    }
    $deleteResult = pterodactyl_api($params, "servers/" . $serverId, [], "DELETE");
    if ($deleteResult["status_code"] !== 204) {
        return ["status" => "error", "msg" => "无法终止服务器，收到错误代码：： " . $deleteResult["status_code"] . ". 有关详细信息，请启用模块调试日志。"];
    }
    return "success";
}
function pterodactyl_CrackPassword($params, $new_pass)
{
    if ($new_pass === "") {
        return ["status" => "error", "msg" => "密码不能为空"];
    }
    $serverData = pterodactyl_getserverid($params, true);
    if (!isset($serverData)) {
        return ["status" => "error", "msg" => "服务器不存在"];
    }
    $userId = $serverData["attributes"]["user"];
    $userResult = pterodactyl_api($params, "users/" . $userId);
    if ($userResult["status_code"] !== 200) {
        return ["status" => "error", "msg" => "检索用户失败，收到错误代码： " . $userResult["status_code"]];
    }
    $updateResult = pterodactyl_api($params, "users/" . $serverData["attributes"]["user"], ["username" => $userResult["attributes"]["username"], "email" => $userResult["attributes"]["email"], "first_name" => $userResult["attributes"]["first_name"], "last_name" => $userResult["attributes"]["last_name"], "password" => $new_pass], "PATCH");
    if ($updateResult["status_code"] !== 200) {
        return ["status" => "error", "msg" => "更改密码失败，收到错误代码：" . $userResult["status_code"]];
    }
    unset($params["password"]);
    think\Db::name("host")->where("id", $params["hostid"])->update(["username" => "", "password" => ""]);
    return "success";
}
function pterodactyl_Status($params)
{
    $result["status"] = "success";
    $host = think\Db::name("host")->where("id", $params["hostid"])->find();
    if ($host["domainstatus"] == "Active") {
        $result["data"]["status"] = "on";
        $result["data"]["des"] = "运行中";
    } else {
        if ($host["domainstatus"] == "Suspended") {
            $result["data"]["status"] = "suspend";
            $result["data"]["des"] = "暂停";
        } else {
            if ($host["domainstatus"] == "Pending") {
                $result["data"]["status"] = "unknown";
                $result["data"]["des"] = "待开通";
            } else {
                if ($host["domainstatus"] == "Deleted") {
                    $result["data"]["status"] = "waiting";
                    $result["data"]["des"] = "已删除";
                }
            }
        }
    }
    return $result;
}
function pterodactyl_ClientArea($params)
{
    return ["index" => ["name" => "主机信息"]];
}
function pterodactyl_ClientAreaOutput($params, $key)
{
    $hostname = pterodactyl_gethostname($params);
    $serverData = pterodactyl_getserverid($params, true);
    if ($key == "index") {
        return ["template" => "templates/information.html", "vars" => ["params" => $params, "url" => $hostname . "/server/" . $serverData["attributes"]["identifier"]]];
    }
}

?>