<?php
function qimenidc_MetaData()
{
    return ["DisplayName" => "QimenIDC", "APIVersion" => "1.1", "HelpDoc" => "https://www.idcsmart.com/wiki_list/339.html#3.3", "version" => "1.0.0"];
}
function qimenidc_ConfigOptions()
{
    return [["type" => "text", "name" => "数据中心", "description" => "所属数据中心位置", "key" => "Location"], ["type" => "text", "name" => "节点ID", "description" => "ID(必填)", "key" => "nodeid"], ["type" => "text", "name" => "配置模板ID", "description" => "配置模板ID,默认0不使用配置模板", "default" => "0", "key" => "configureTemplateId"], ["type" => "text", "name" => "内存", "description" => "MB", "default" => "1024", "key" => "Memory"], ["type" => "text", "name" => "带宽", "description" => "Mbps", "default" => "1", "key" => "bandwidth"], ["type" => "text", "name" => "备份迁移I/O限制", "description" => "MB/s", "default" => "200", "key" => "bwlimit"], ["type" => "text", "name" => "流量", "description" => "GB(0为不限制)", "default" => "0", "key" => "flow_limit"], ["type" => "text", "name" => "IP数量", "description" => "默认分配公网IP数量", "default" => "1", "key" => "ipv4"], ["type" => "text", "name" => "默认镜像", "description" => "可填镜像ID或者镜像名称,如果设置可选配置则优先可选配置", "key" => "os"], ["type" => "text", "name" => "插槽数", "description" => "CPU插槽数", "default" => "1", "key" => "sockets"], ["type" => "text", "name" => "核心数", "description" => "核心", "default" => "2", "key" => "cores"], ["type" => "text", "name" => "线程数", "description" => "线程数", "default" => "1", "key" => "threads"], ["type" => "text", "name" => "系统硬盘大小", "description" => "GB", "default" => "40", "key" => "SystemDisk"], ["type" => "text", "name" => "CPU类型", "description" => "如:kvm64,host,注意开启嵌套虚拟化后,此处必须填写host", "default" => "kvm64", "key" => "cpu_mode"], ["type" => "text", "name" => "嵌套虚拟化", "description" => "是否开启嵌套虚拟化", "options" => ["false" => "关闭", "true" => "开启"], "default" => "false", "key" => "nested"], ["type" => "text", "name" => "KVM虚拟化", "description" => "是否开启KVM虚拟化", "options" => ["false" => "关闭", "true" => "开启"], "default" => "true", "key" => "kvm"], ["type" => "text", "name" => "去虚拟化机化", "description" => "是否去虚拟机化", "options" => ["false" => "关闭", "true" => "开启"], "default" => "false", "key" => "devirtualization"], ["type" => "text", "name" => "CPU限制", "description" => "%", "default" => "70", "key" => "cpuUnits"], ["type" => "text", "name" => "组合模型ID", "description" => "组合型产品ID,默认0不使用组合模型", "default" => "0", "key" => "modelGroup"], ["type" => "text", "name" => "VNC控制器名称", "description" => "指定VNC控制器,该项为后台控制器名称,默认0为不指定", "default" => "0", "key" => "vncKey"], ["type" => "text", "name" => "NAT", "description" => "是否为NAT产品(暂不支持，请勿更改！)", "options" => ["否", "是"], "default" => "0", "key" => "nat"]];
}
function qimenidc_TestLink($params)
{
    $url = qimenidc_GetUrl($params, "/api/v1/status", $sign);
    $res = qimenidc_Curl($params, $url, [], 10, "GET");
    if (isset($res["code"]) && $res["code"] == 20000) {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = $res["message"];
    }
    return $result;
}
function qimenidc_Chart()
{
    return ["cpu" => ["title" => "CPU使用量"], "memory" => ["title" => "内存用量"], "disk" => ["title" => "磁盘IO"], "flow" => ["title" => "网卡"]];
}
function qimenidc_ChartData($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return ["status" => "error", "msg" => "数据获取失败"];
    }
    $query = ["hostId" => $vserverid];
    $url = qimenidc_GetUrl($params, "/api/v1/pve/getVmInfo", $query);
    $res = qimenidc_Curl($params, $url, [], 30, "GET");
    if (isset($res["code"]) && $res["code"] == 20000) {
        $start = $params["chart"]["start"] / 1000;
        $result["status"] = "success";
        $result["data"] = [];
        if (isset($params["chart"]["type"]) && $params["chart"]["type"] == "cpu") {
            $result["data"]["unit"] = "%";
            $result["data"]["chart_type"] = "area";
            $result["data"]["list"] = [];
            $result["data"]["label"] = ["CPU使用率(%)"];
            foreach ($res["data"]["rrddata"]["data"] as $v) {
                $time = $v["time"];
                if ($time >= $start) {
                    if (isset($v["cpu"])) {
                        $cpu = $v["cpu"];
                        $cpu = round($cpu, 2);
                        $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $time), "value" => $cpu];
                    }
                }
            }
        } else {
            if (isset($params["chart"]["type"]) && $params["chart"]["type"] == "memory") {
                $result["data"]["unit"] = "GB";
                $result["data"]["chart_type"] = "bar";
                $result["data"]["list"] = [];
                $result["data"]["label"] = ["总量(GB)", "已用(GB)"];
                foreach ($res["data"]["rrddata"]["data"] as $v) {
                    $time = $v["time"];
                    if ($time >= $start) {
                        if (isset($v["mem"])) {
                            $max = $v["maxmem"];
                            $memory = $v["mem"];
                            $max = $max / 1024 / 1024 / 1024;
                            $memory = $memory / 1024 / 1024 / 1024;
                            $max = round($max, 2);
                            $memory = round($memory, 2);
                            $result["data"]["list"][0][] = ["time" => date("Y-m-d H:i:s", $time), "value" => $max];
                            $result["data"]["list"][1][] = ["time" => date("Y-m-d H:i:s", $time), "value" => $memory];
                        }
                    }
                }
            } else {
                if (isset($params["chart"]["type"]) && $params["chart"]["type"] == "disk") {
                    $result["data"]["unit"] = "mb/s";
                    $result["data"]["chart_type"] = "line";
                    $result["data"]["list"] = [];
                    $result["data"]["label"] = ["读取速度(mb/s)", "写入速度(mb/s)"];
                    foreach ($res["data"]["rrddata"]["data"] as $v) {
                        $time = $v["time"];
                        if ($time >= $start) {
                            if (isset($v["diskread"]) && isset($v["diskwrite"])) {
                                $diskread = $v["diskread"];
                                $diskwrite = $v["diskwrite"];
                                $diskread = $diskread / 1024 / 1024;
                                $diskwrite = $diskwrite / 1024 / 1024;
                                $diskread = round($diskread, 2);
                                $diskwrite = round($diskwrite, 2);
                                $date = date("Y-m-d H:i:s", $time);
                                $result["data"]["list"][0][] = ["time" => $date, "value" => $diskread];
                                $result["data"]["list"][1][] = ["time" => $date, "value" => $diskwrite];
                            }
                        }
                    }
                } else {
                    if (isset($params["chart"]["type"]) && $params["chart"]["type"] == "flow") {
                        $result["data"]["unit"] = "KB/s";
                        $result["data"]["chart_type"] = "line";
                        $result["data"]["list"] = [];
                        $result["data"]["label"] = ["进(KB/s)", "出(KB/s)"];
                        foreach ($res["data"]["rrddata"]["data"] as $v) {
                            $time = $v["time"];
                            if ($time >= $start) {
                                if (isset($v["netin"]) && isset($v["netout"])) {
                                    $netin = $v["netin"];
                                    $netout = $v["netout"];
                                    $netin = $netin / 1024;
                                    $netout = $netout / 1024;
                                    $netin = round($netin, 2);
                                    $netout = round($netout, 2);
                                    $date = date("Y-m-d H:i:s", $time);
                                    $result["data"]["list"][0][] = ["time" => $date, "value" => $netin];
                                    $result["data"]["list"][1][] = ["time" => $date, "value" => $netout];
                                }
                            }
                        }
                    }
                }
            }
        }
        return $result;
    } else {
        return ["status" => "error", "msg" => "数据获取失败"];
    }
}
function qimenidc_ClientArea($params)
{
    if ($params["configoptions"]["nat"] == 1) {
        $panel = ["snapshot" => ["name" => "快照"], "security_group" => ["name" => "策略"], "backups" => ["name" => "备份"], "cd_rom" => ["name" => "光驱"], "nat_acl" => ["name" => "NAT转发"], "nat_web" => ["name" => "NAT建站"]];
    } else {
        $panel = ["snapshot" => ["name" => "快照"], "security_group" => ["name" => "策略"], "backups" => ["name" => "备份"], "cd_rom" => ["name" => "光驱"]];
    }
    unset($panel["nat_acl"]);
    unset($panel["nat_web"]);
    unset($panel["snapshot"]);
    unset($panel["backups"]);
    return $panel;
}
function qimenidc_ClientAreaOutput($params, $key)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "";
    }
    if ($key == "snapshot") {
        return ["template" => "templates/snapshot.html", "vars" => ["list" => []]];
    }
    if ($key == "security_group") {
        return ["template" => "templates/security_group.html", "vars" => ["list" => [], "used" => []]];
    }
    if ($key == "backups") {
        return ["template" => "templates/backups.html", "vars" => ["list" => []]];
    }
    if ($key == "cd_rom") {
        return ["template" => "templates/cd_rom.html", "vars" => ["list" => [], "host" => []]];
    }
    if ($key == "nat_acl") {
        return ["template" => "templates/nat_acl.html", "vars" => ["list" => []]];
    }
    if ($key == "nat_web") {
        return ["template" => "templates/nat_web.html", "vars" => ["list" => []]];
    }
}
function qimenidc_CreateAccount($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (!empty($vserverid)) {
        return "已开通,不能重复开通";
    }
    if (empty($params["password"])) {
        $sys_pwd = randStr(8);
    } else {
        $sys_pwd = $params["password"];
    }
    $vnc_pwd = randStr(8);
    $post_data = [];
    $post_data["nodeid"] = $params["configoptions"]["nodeid"];
    $post_data["core"] = $params["configoptions"]["cores"];
    $post_data["cpu"] = $params["configoptions"]["cpu_mode"];
    $post_data["memory"] = $params["configoptions"]["Memory"];
    $post_data["systemDiskSize"] = $params["configoptions"]["SystemDisk"];
    $post_data["bandwidth"] = $params["configoptions"]["bandwidth"];
    $post_data["sockets"] = $params["configoptions"]["sockets"];
    $post_data["bwlimit"] = $params["configoptions"]["bwlimit"];
    $post_data["threads"] = $params["configoptions"]["threads"];
    $post_data["kvm"] = $params["configoptions"]["kvm"];
    $post_data["devirtualization"] = $params["configoptions"]["devirtualization"];
    $post_data["cpuUnits"] = $params["configoptions"]["cpuUnits"];
    if ($params["configoptions"]["modelGroup"] != 0) {
        $post_data["modelGroup"] = $params["configoptions"]["modelGroup"];
    }
    if ($params["configoptions"]["configureTemplateId"] != 0) {
        $post_data["configureTemplateId"] = $params["configoptions"]["configureTemplateId"];
    }
    $post_data["nested"] = $params["configoptions"]["nested"];
    $post_data["os"] = $params["configoptions"]["os"];
    if (!empty($params["domain"])) {
        $post_data["hostname"] = $params["domain"];
    }
    $post_data["password"] = $sys_pwd;
    $url = qimenidc_GetUrl($params, "/api/v1/pve/cerateVM");
    $res = qimenidc_Curl($params, $url, $post_data);
    if (isset($res["code"]) && $res["code"] == 20000) {
        $customid = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->where("fieldname", "vserverid")->value("id");
        if (empty($customid)) {
            $customfields = ["type" => "product", "relid" => $params["productid"], "fieldname" => "vserverid", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
            $customid = think\Db::name("customfields")->insertGetId($customfields);
        }
        $exist = think\Db::name("customfieldsvalues")->where("fieldid", $customid)->where("relid", $params["hostid"])->find();
        if (empty($exist)) {
            $data = ["fieldid" => $customid, "relid" => $params["hostid"], "value" => $res["data"]["hostid"], "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $exist["id"])->update(["value" => $res["data"]["hostid"]]);
        }
        $mainip = "";
        $ip = [];
        foreach ($res["data"]["ipData"] as $v) {
            if (1 < count($res["data"]["ipData"])) {
                if ($res["data"]["ipData"][0]["ip"] == $v["ip"]) {
                    $mainip = $v["ip"];
                } else {
                    $ip[] = $v["ip"];
                }
            } else {
                $mainip = $v["ip"];
            }
        }
        $os_info = think\Db::name("host_config_options")->alias("a")->field("c.option_name")->leftJoin("product_config_options b", "a.configid=b.id")->leftJoin("product_config_options_sub c", "a.optionid=c.id")->where("a.relid", $params["hostid"])->where("b.option_type", 5)->find();
        $username = $res["data"]["username"];
        $update["dedicatedip"] = $mainip;
        $update["assignedips"] = implode(",", $ip);
        $update["domainstatus"] = "Active";
        $update["username"] = $username;
        $update["password"] = cmf_encrypt($res["data"]["password"]);
        $update["domain"] = $res["data"]["hostname"];
        if (empty($os_info)) {
            $update["os"] = $post_data["os"];
        }
        $update["bwlimit"] = (int) $params["configoptions"]["flow_limit"];
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return "ok";
    } else {
        return ["status" => "error", "msg" => $res["message"] ?: "开通失败"];
    }
}
function qimenidc_SuspendAccount($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/pause");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "暂停失败"];
}
function qimenidc_UnsuspendAccount($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/unpause");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "解除暂停失败"];
}
function qimenidc_TerminateAccount($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/delete/" . $vserverid);
    $res = qimenidc_Curl($params, $url, [], 30, "DELETE");
    if (isset($res["code"]) && $res["code"] == 20000) {
        $customid = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->where("fieldname", "vserverid")->value("id");
        think\Db::name("customfieldsvalues")->where("fieldid", $customid)->where("relid", $params["hostid"])->delete();
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "删除失败"];
}
function qimenidc_On($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/start");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "开机失败"];
}
function qimenidc_Off($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/stop");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "关机失败"];
}
function qimenidc_Reboot($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/reboot");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "关机失败"];
}
function qimenidc_HardOff($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/shutdown");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "关机失败"];
}
function qimenidc_HardReboot($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/power/" . $vserverid . "/reboot");
    $res = qimenidc_Curl($params, $url, [], 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "关机失败"];
}
function qimenidc_Vnc($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $query = ["hostId" => $vserverid, "page" => 1, "size" => 1000000];
    $url = qimenidc_GetUrl($params, "/api/v1/pve/getVnc", $query);
    $res = qimenidc_Curl($params, $url, [], 15, "GET");
    if (isset($res["code"]) && $res["code"] == 20000) {
        $records = $res["data"]["records"];
        $vnc_url = "";
        if ($params["configoptions"]["vncKey"] == 0) {
            foreach ($records as $json) {
                foreach ($json as $k => $v) {
                    $vnc_url = $v;
                }
            }
        } else {
            foreach ($records as $json) {
                foreach ($json as $k => $v) {
                    if ($k == $params["configoptions"]["vncKey"]) {
                        $vnc_url = $v;
                    }
                }
            }
        }
        if (empty($vnc_url)) {
            return ["status" => "error", "msg" => "VNC获取失败"];
        }
        $result["status"] = "success";
        $result["msg"] = "vnc获取成功";
        $result["url"] = $vnc_url;
    } else {
        $result["status"] = "error";
        $result["msg"] = "VNC获取失败";
    }
    return $result;
}
function qimenidc_Reinstall($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    if (empty($params["reinstall_os"])) {
        return "操作系统错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/reinstall");
    $put_data = ["vmHostId" => $vserverid, "os" => $params["reinstall_os"]];
    $res = qimenidc_Curl($params, $url, $put_data, 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        if (stripos($params["reinstall_os_name"], "win") !== false) {
            $username = "administrator";
        } else {
            $username = "root";
        }
        think\Db::name("host")->where("id", $params["hostid"])->update(["username" => $username]);
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "重装失败"];
}
function qimenidc_CrackPassword($params, $new_pass)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $url = qimenidc_GetUrl($params, "/api/v1/pve/updateVmConfig/restPassword");
    $post_data["hostId"] = $vserverid;
    $post_data["newPassword"] = $new_pass;
    $res = qimenidc_Curl($params, $url, $post_data, 30, "PUT");
    if (isset($res["code"]) && $res["code"] == 20000) {
        return ["status" => "success", "msg" => $res["message"]];
    }
    return ["status" => "error", "msg" => $res["message"] ?: "同步失败"];
}
function qimenidc_Sync($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $query = ["hostId" => $vserverid];
    $url = qimenidc_GetUrl($params, "/api/v1/pve/getVmInfo", $query);
    $res = qimenidc_Curl($params, $url, [], 30, "GET");
    if (isset($res["code"]) && $res["code"] == 20000) {
        $mainip = "";
        $ip = [];
        foreach ($res["data"]["vmhost"]["ipData"] as $v) {
            if (1 < count($res["data"]["vmhost"]["ipData"])) {
                if ($res["data"]["vmhost"]["ipData"][0]["ip"] == $v["ip"]) {
                    $mainip = $v["ip"];
                } else {
                    $ip[] = $v["ip"];
                }
            } else {
                $mainip = $v["ip"];
            }
        }
        $update["dedicatedip"] = $mainip;
        $update["assignedips"] = implode(",", $ip);
        $update["password"] = cmf_encrypt($res["data"]["vmhost"]["password"]);
        $update["domain"] = $res["data"]["vmhost"]["hostname"];
        $username = $res["data"]["vmhost"]["username"];
        $update["username"] = $username;
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return ["status" => "success", "msg" => $res["message"]];
    } else {
        return ["status" => "error", "msg" => $res["message"] ?: "同步失败"];
    }
}
function qimenidc_Status($params)
{
    $vserverid = qimenidc_GetServerid($params);
    if (empty($vserverid)) {
        return "QimenIDC VM ID错误";
    }
    $query = ["hostId" => $vserverid];
    $url = qimenidc_GetUrl($params, "/api/v1/pve/getVmInfo", $query);
    $res = qimenidc_Curl($params, $url, [], 30, "GET");
    if (isset($res["code"]) && $res["code"] == 20000) {
        $status = ["运行中", "已关机", "挂起", "恢复中", "暂停", "到期", "创建中", "开机中", "关机中", "停止中", "挂起中", "暂停中", "重启中", "重装系统中", "修改密码中", "超流断网"];
        $result["status"] = "success";
        if (in_array($res["data"]["vmhost"]["status"], [0])) {
            $result["data"]["status"] = "on";
            $result["data"]["des"] = "开机";
        } else {
            if (in_array($res["data"]["vmhost"]["status"], [1])) {
                $result["data"]["status"] = "off";
                $result["data"]["des"] = "关机";
            } else {
                if (in_array($res["data"]["vmhost"]["status"], [2])) {
                    $result["data"]["status"] = "suspend";
                    $result["data"]["des"] = "挂起";
                } else {
                    if (in_array($res["data"]["vmhost"]["status"], [3, 6, 7, 8, 9, 10, 11, 12, 13, 14])) {
                        $result["data"]["status"] = "process";
                        $result["data"]["des"] = $status[$res["data"]["vmhost"]["status"]];
                    } else {
                        if ($res["data"]["vmhost"]["status"] == 4) {
                            $result["data"]["status"] = "suspend";
                            $result["data"]["des"] = $res["data"]["vmhost"]["pauseInfo"];
                        } else {
                            if ($res["data"]["vmhost"]["status"] == 15) {
                                $result["data"]["status"] = "suspend";
                                $result["data"]["des"] = "流量超限";
                            } else {
                                $result["data"]["status"] = "unknown";
                                $result["data"]["des"] = "未知";
                            }
                        }
                    }
                }
            }
        }
        return $result;
    }
    return ["status" => "error", "msg" => $res["message"] ?: "获取失败"];
}
function qimenidc_DailyCron()
{
    if (date("Y-m-d") == date("Y-m-01")) {
        $time = time();
        $host_data = think\Db::name("host")->alias("a")->field("a.id,a.uid")->leftJoin("products b", "a.productid=b.id")->leftJoin("servers c", "a.serverid=c.id")->leftJoin("server_groups d", "c.gid=d.id")->leftJoin("customfields e", "a.productid=e.relid AND e.type=\"product\" AND e.fieldname=\"vserverid\"")->leftJoin("customfieldsvalues f", "e.id=f.fieldid and a.id=f.relid")->whereIn("a.domainstatus", "Active,Suspended")->where("a.nextduedate=0 OR a.nextduedate>" . $time)->where("a.serverid", ">", 0)->whereIn("b.api_type", ["", "normal"])->where("d.system_type", "normal")->where("d.type", "nokvm")->where("f.value", ">", 0)->select()->toArray();
        $host = new app\common\logic\Host();
        $model = new app\common\model\HostModel();
        foreach ($host_data as $v) {
            $params = $model->getProvisionParams($v["id"]);
            if (isset($params["configoptions"]["flow_limit"])) {
                if (0 < $params["configoptions"]["flow_limit"]) {
                    $capacity = think\Db::name("dcim_buy_record")->where("type", "flow_packet")->where("hostid", $v["id"])->where("uid", $v["uid"])->where("status", 1)->where("show_status", 0)->where("pay_time", ">", strtotime(date("Y-m-01 00:00:00")))->sum("capacity");
                    $post_data["flow_limit"] = $params["configoptions"]["flow_limit"] + $capacity;
                } else {
                    $post_data["flow_limit"] = 0;
                }
                qimenidc_sync($params);
            }
        }
    }
}
function qimenidc_AdminButtonHide($params)
{
    if (qimenidc_GetServerid($params) && 0 < $params["serverid"]) {
        return ["CreateAccount"];
    }
    return ["SuspendAccount", "UnsuspendAccount", "TerminateAccount", "On", "Off", "Reboot", "HardOff", "HardReboot", "Reinstall", "CrackPassword", "Vnc", "Sync"];
}
function qimenidc_GetServerid($params)
{
    return (int) $params["customfields"]["vserverid"];
}
function qimenidc_CreateSign($token = "")
{
    $data["timeStamp"] = time();
    $data["randomStr"] = randStr(6);
    $data["token"] = $token;
    $res["time"] = $data["timeStamp"];
    $res["random"] = $data["randomStr"];
    sort($data, SORT_STRING);
    $str = implode($data);
    $signature = md5($str);
    $signature = strtoupper($signature);
    $res["signature"] = $signature;
    return $res;
}
function qimenidc_GetUrl($params, $path = "/api/v1/pve/cerateVM", $query = [])
{
    $url = "";
    if ($params["secure"]) {
        $url = "https://";
    } else {
        $url = "http://";
    }
    $url .= $params["server_ip"] ?: $params["server_host"];
    if (!empty($params["port"])) {
        $url .= ":" . $params["port"];
    }
    $url .= $path;
    $q = "";
    foreach ($query as $k => $v) {
        $q .= "&" . $k . "=" . $v;
    }
    if (!empty($q)) {
        $url = $url . "?" . ltrim($q, "&");
    }
    return $url;
}
function qimenidc_Curl($params, $url, $data = [], $timeout = 30, $request = "POST", $headers = [])
{
    $curl = curl_init();
    $username = $params["server_username"];
    $password = $params["server_password"];
    if ($request == "GET") {
        $queryString = http_build_query($data);
        $url .= $queryString ? "?" . $queryString : "";
    }
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($curl, CURLOPT_HEADER, 0);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    if (strtoupper($request) == "GET") {
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPGET, 1);
    }
    if (strtoupper($request) == "POST" || strtoupper($request) == "PUT" || strtoupper($request) == "DELETE") {
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, strtoupper($request));
        if (is_array($data)) {
            $data = json_encode($data);
        }
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        $headers[] = "Content-Type: application/json";
    }
    if ($username && $password) {
        $authString = base64_encode($username . ":" . $password);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array_merge(["Authorization: Basic " . $authString], $headers));
    }
    $res = curl_exec($curl);
    $error = curl_error($curl);
    if (!empty($error)) {
        return ["status" => 500, "message" => "CURL ERROR: " . $error];
    }
    $info = curl_getinfo($curl);
    curl_close($curl);
    return json_decode($res, true);
}
function qimenidc_downloadResource()
{
    $metaData = qimenidc_metadata();
    $result = ["status" => 200, "msg" => "请求成功", "data" => ["module" => "nokvm", "url" => request()->domain() . "/plugins/servers/nokvm/data/abc.zip", "version" => $metaData["version"] ?? "1.0.0"]];
    return $result;
}

?>