<?php
function qzvps_MetaData()
{
    return ["DisplayName" => "轻舟VPS模块", "APIVersion" => "1.0.0", "HelpDoc" => "http://www.xnidc.cc/"];
}
function qzvps_ConfigOptions()
{
    return [["type" => "text", "name" => "节点ID", "description" => "数据中心ID", "key" => "idc"], ["type" => "text", "name" => "产品ID", "description" => "套餐ID", "key" => "pid"]];
}
function qzvps_TestLink($params)
{
    if ($params["secure"]) {
        $secure = "https://";
    } else {
        $secure = "http://";
    }
    $md5 = md5($params["accesshash"] . "7i24.com");
    $api_url = $secure . $params["server_host"] . "/api/cloudapi.asp";
    $data = ["action" => "getinfo", "userstr" => $md5];
    $post_data = http_build_query($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    $api_data = curl_exec($ch);
    curl_close($ch);
    if ($api_data == "ret=err") {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = $res["message"];
    }
    return $result;
}
function qzvps_CreateAccount($params)
{
    if (empty($params["password"])) {
        $sys_pwd = randStr(8);
    } else {
        $sys_pwd = $params["password"];
    }
    if ($params["billingcycle"] == "monthly") {
        $cycle = "0.1";
    }
    if ($params["billingcycle"] == "quarterly") {
        $cycle = "0.25";
    }
    if ($params["billingcycle"] == "semiannually") {
        $cycle = "0.5";
    }
    if ($params["billingcycle"] == "annually") {
        $cycle = "1";
    }
    if ($params["billingcycle"] == "biennially") {
        $cycle = "2";
    }
    if ($params["billingcycle"] == "triennially") {
        $cycle = "3";
    }
    if ($params["billingcycle"] == "fourly") {
        $cycle = "4";
    }
    if ($params["billingcycle"] == "fively") {
        $cycle = "5";
    }
    $vos = $params["configoptions"]["userid"] . "|h";
    if ($params["configoptions"]["userid"] == "") {
        $vos = $params["configoptions"]["os"] . "|h";
    }
    if ($params["secure"]) {
        $secure = "https://";
    } else {
        $secure = "http://";
    }
    $md5 = md5($params["accesshash"] . "7i24.com");
    $api_url = $secure . $params["server_host"] . "/api/cloudapi.asp";
    $data = ["action" => "activate", "userstr" => $md5, "idc" => $params["configoptions"]["idc"], "productid" => $params["configoptions"]["pid"], "userid" => $vos, "vpsname" => $params["domain"], "VPSpassword" => $sys_pwd, "year" => $cycle];
    $post_data = http_build_query($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    $api_data = curl_exec($ch);
    curl_close($ch);
    $data2 = ["action" => "getinfo", "userstr" => $md5, "vpsname" => $params["domain"]];
    $post_data2 = http_build_query($data2);
    $ch2 = curl_init();
    curl_setopt($ch2, CURLOPT_URL, $api_url);
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch2, CURLOPT_POST, 1);
    curl_setopt($ch2, CURLOPT_POSTFIELDS, $post_data2);
    $api_data2 = curl_exec($ch2);
    curl_close($ch2);
    $query = explode("&", $api_data2);
    $arr = [];
    foreach ($query as $v) {
        $r = explode("=", $v);
        $arr[$r[0]] = $r[1];
    }
    $update["domainstatus"] = "Active";
    $update["username"] = $params["domain"];
    $update["dedicatedip"] = $arr["ip"];
    $update["password"] = cmf_encrypt($sys_pwd);
    Db::name("host")->where("id", $params["hostid"])->update($update);
    return "ok";
}
function qzvps_Renew($params)
{
    if ($params["secure"]) {
        $secure = "https://";
    } else {
        $secure = "http://";
    }
    if ($params["billingcycle"] == "monthly") {
        $cycle = "0.1";
    }
    if ($params["billingcycle"] == "quarterly") {
        $cycle = "0.25";
    }
    if ($params["billingcycle"] == "semiannually") {
        $cycle = "0.5";
    }
    if ($params["billingcycle"] == "annually") {
        $cycle = "1";
    }
    if ($params["billingcycle"] == "biennially") {
        $cycle = "2";
    }
    if ($params["billingcycle"] == "triennially") {
        $cycle = "3";
    }
    if ($params["billingcycle"] == "fourly") {
        $cycle = "4";
    }
    if ($params["billingcycle"] == "fively") {
        $cycle = "5";
    }
    $md5 = md5($params["accesshash"] . "7i24.com");
    $api_url = $secure . $params["server_host"] . "/api/cloudapi.asp";
    $data = ["action" => "renew", "userstr" => $md5, "vpsname" => $params["domain"], "year" => $cycle];
    $post_data = http_build_query($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    $api_data = curl_exec($ch);
    curl_close($ch);
}
function qzvps_ChangePackage($params)
{
    if ($params["secure"]) {
        $secure = "https://";
    } else {
        $secure = "http://";
    }
    $md5 = md5($params["accesshash"] . "7i24.com");
    $api_url = $secure . $params["server_host"] . "/api/cloudapi.asp";
    $data = ["action" => "update", "userstr" => $md5, "productid" => $params["configoptions"]["pid"], "vpsname" => $params["domain"]];
    $post_data = http_build_query($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    $api_data = curl_exec($ch);
    curl_close($ch);
}
function qzvps_ClientArea($params)
{
    return ["info" => ["name" => "产品信息"]];
}
function qzvps_ClientAreaOutput($params, $key)
{
    if ($params["secure"]) {
        $secure = "https://";
    } else {
        $secure = "http://";
    }
    $login_url = $secure . $params["server_host"] . "/vpsadm/login.asp?vpsname=" . $params["domain"] . "&vpspassword=" . $params["password"];
    if ($key == "info") {
        return ["template" => "templates/info.html", "vars" => ["login_url" => $login_url, "panel_url" => $panel, "ip" => $params["dedicatedip"], "root" => $root, "username" => $params["username"], "password" => $params["password"]]];
    }
}

?>