<?php

/*
ver:1.3~20221104
插件只能用于对接RStack主控（Hyper-V KVM 2种虚拟化类型），RStack被控永久免费欢迎使用对接RStack
RStack也提供IDC财务系统对接自营主控被控兼容更完善，更多详情请咨询我们！
官网网址：http://www.rstack.com.cn/
*/

use app\common\logic\RunMap;
use app\common\model\HostModel;
use think\Db;


define('virtualType2', 'kvm');
//define('moduleName', 'rstackkvm');

#function rstackkvm_idcsmartauthorize(){}N

// 配置数据
function rstackkvm_MetaData(){
	return ['DisplayName'=>'rstackkvm', 'APIVersion'=>'1.2', 'HelpDoc'=>'http://www.rstack.com.cn/docs?id=49'];
}

function rstackkvm_ConfigOptions(){
	return [
		[
			'type'=>'text', 
			'name'=>'数据中心ID', 
			'description'=>'数据中心ID自动轮询节点节点）',
			'key'=>'areaid'
		],
		[
			'type'=>'text', 
			'name'=>'节点ID', 
			'description'=>'计算节点ID(不填则自动分配)',
			'key'=>'nodeid',
		],
		[
			'type'=>'text', 
			'name'=>'CPU', 
			'description'=>'核',
			'default'=>'2',
			'key'=>'cpu',
		],
		[
			'type'=>'text', 
			'name'=>'CPU限制', 
			'description'=>'% (推荐50%++)',
			'default'=>'100',
			'key'=>'cpu_limit',
		],
		
		[
			'type'=>'text', 
			'name'=>'内存', 
			'description'=>'MB',
			'default'=>'1024',
			'key'=>'ram',
		],
		[
			'type'=>'text', 
			'name'=>'数据磁盘', 
			'description'=>'GB(为0不创建数据磁盘)',
			'default'=>'20',
			'key'=>'disk',
		],
		[
			'type'=>'text', 
			'name'=>'系统盘读写', 
			'description'=>'MB(为0不限制IO读写)',
			'default'=>'0',
			'key'=>'disk_sys_iops',
		],
		[
			'type'=>'text', 
			'name'=>'数据盘读写', 
			'description'=>'MB(为0不限制IO读写)',
			'default'=>'0',
			'key'=>'disk_data_iops',
		],
		[
			'type'=>'text', 
			'name'=>'上行速率', 
			'description'=>'MB(最小1)',
			'default'=>'1',
			'key'=>'port',
		],
		[
			'type'=>'text', 
			'name'=>'下行速率', 
			'description'=>'MB(最小1)',
			'default'=>'100',
			'key'=>'ports',
		],
		[
			'type'=>'text', 
			'name'=>'每月流量', 
			'description'=>'GB(0为不限制流量)',
			'default'=>'0',
			'key'=>'bwlimit',
		],
		[
			'type'=>'text', 
			'name'=>'默认安装镜像', 
			'description'=>'默认开通镜像ID(推荐做自定义)',
			//'default'=>'0',
			'key'=>'osid',
		],
		[
			'type'=>'text', 
			'name'=>'快照数量', 
			'description'=>'0为不允许',
			'default'=>'0',
			'key'=>'backup_snapshot',
		],
		[
			'type'=>'text', 
			'name'=>'备份数量', 
			'description'=>'0为不允许',
			'default'=>'0',
			'key'=>'backup_full',
		],
		[
			'type'=>'text', 
			'name'=>'NAT映射数', 
			'description'=>'0为不允许',
			'default'=>'0',
			'key'=>'portmap',
		],
		[
			'type'=>'text', 
			'name'=>'NAT建站数', 
			'description'=>'0为不允许',
			'default'=>'0',
			'key'=>'binding_domain',
		],
		[
			'type'=>'yesno', 
			'name'=>'随机端口', 
			'description'=>'勾选表示创建后随机端口', 
			'default'=>'0',
			'key'=>'remote_port',
		],
		[
			'type'=>'yesno', 
			'name'=>'随机IP分配', 
			'description'=>'勾选表示创建后随机IP', 
			'default'=>'0',
			'key'=>'iprandom',
		],
		[
			'type'=>'text', 
			'name'=>'IP数量', 
			'description'=>'(如果NAT必须选1否则允许多个)', 
			'default'=>'1',
			'key'=>'ip',
		],
		[
			'type'=>'text', 
			'name'=>'IPv6数量', 
			'description'=>'(如果支持v6可以选择)', 
			'default'=>'0',
			'key'=>'ipv6',
		],
		[
			'type'=>'dropdown', 
			'name'=>'混合云模式', 
			'description'=>'', 
			'options'=>[
			    ''=>'全部',
			    '0'=>'只开公网Ipv4/包含IPV6',
			    '2'=>'只开内网ipv4(NAT专用)'
			    ],
			'default'=>'',
			'key'=>'iptype',
		],
	
	];
}

// 连接测试
function rstackkvm_TestLink($params){
    $data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "test";

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    $result['status'] = 200;
		$result['data']['server_status'] = 1;
	}else{
	    $result['status'] = 200;
		$result['data']['server_status'] = 0;
		$result['data']['msg'] = $ret["msg"];
	}
	return $result;
}

// 图表
function rstackkvm_Chart(){
	return [
		'cpu'=>[
			'title'=>'CPU',
		],
		/*
		'disk'=>[
			'title'=>'磁盘IO',
			'select'=>[
				[
					'name'=>'系统盘',
					'value'=>'vda'
				],
				[
					'name'=>'数据盘',
					'value'=>'vdb'
				],
			]
		],
		*/
		'ram'=>[
			'title'=>'内存'
		],
		'disk'=>[
			'title'=>'磁盘IO'
		],
		'flow'=>[
			'title'=>'流量图'
		],
		
	];
}

// 图表数据
function rstackkvm_ChartData($params){

	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return ['status'=>'error', 'msg'=>'数据获取失败'];
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_monitor";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);
	
	$ret = rstackkvm_CheckReturn($rsret);
	
	
	if ($ret["code"]=="-1"){
	    //获取数据错误
	    return ['status'=>'error', 'msg'=>$ret["msg"]];
	}
	
	$rsret2 = json_decode($rsret,true);

	$start = $params['chart']['start']/1000;
	
	$result['status'] = 'success';
	$result['data'] = [];
	if($params['chart']['type'] == 'cpu'){
		$result['data']['unit'] = '%';
		$result['data']['chart_type'] = 'line';
		$result['data']['list'] = [];
		$result['data']['label'] = ['CPU使用率(%)'];
		foreach($rsret2 as $v){
			$time = $v["time"];
			$result['data']['list'][0][] = [
				'time'=>date('Y-m-d H:i:s', $time),
				'value'=>$v['cpu']
			]; 
		}
	} else if($params['chart']['type'] == 'ram'){
	    $result['data']['unit'] = 'MB';
		$result['data']['chart_type'] = 'line';
		$result['data']['list'] = [];
		$result['data']['label'] = ['已使用(MB)','总内存(MB)'];

		foreach($rsret2 as $v){
			$time = $v["time"];
			$date = date('Y-m-d H:i:s', $time);
			//$tmp  = explode("|",$str);
			$result['data']['list'][0][] = [
				'time'=>$date,
				'value'=>explode(",",$v["memory"])[0] / 1024//$v['Disk'][$params['chart']['select']][0]
			];
			$result['data']['list'][1][] = [
				'time'=>$date,
				'value'=>explode(",",$v["memory"])[1] / 1024//$v['Disk'][$params['chart']['select']][1]
			];
		}				
	} else if($params['chart']['type'] == 'disk'){
		
		$result['data']['unit'] = 'kb/s';
		$result['data']['chart_type'] = 'line';
		$result['data']['list'] = [];
		$result['data']['label'] = ['读取速度(kb/s)','写入速度(kb/s)'];

		foreach($rsret2 as $v){
			$time = $v["time"];
			$date = date('Y-m-d H:i:s', $time);
			//$tmp  = explode("|",$str);
			$result['data']['list'][0][] = [
				'time'=>$date,
				'value'=>explode(",",$v["disk"])[0]//$v['Disk'][$params['chart']['select']][0]
			];
			$result['data']['list'][1][] = [
				'time'=>$date,
				'value'=>explode(",",$v["disk"])[1]//$v['Disk'][$params['chart']['select']][1]
			];
		}				
	}else if($params['chart']['type'] == 'flow'){

		$result['data']['unit'] = 'KB/s';
		$result['data']['chart_type'] = 'line'; //area
		$result['data']['list'] = [];
		$result['data']['label'] = ['进(KB/s)','出(KB/s)'];

		foreach($rsret2 as $v){
			$time = $v["time"];
			$date = date('Y-m-d H:i:s', $time);
			$result['data']['list'][0][] = [
				'time'=>$date,
				'value'=>explode(",",$v["network"])[0]
			];
			$result['data']['list'][1][] = [
				'time'=>$date,
				'value'=>explode(",",$v["network"])[1]
			];
		}
	}
	
	return $result;

	
}

// 标准输出
function rstackkvm_ClientArea($params){
	if($params['configoptions']['portmap'] != 0){
		$panel = [
			'backup_snapshot'=>[
				'name'=>'快照',
			],
			'backup_full'=>[
				'name'=>'备份',
			],
			'cdid'=>[
				'name'=>'光驱',
			],
			'portmap'=>[
				'name'=>'NAT转发',
			],
			'binding_domain'=>[
				'name'=>'NAT建站',
			]
		];
	}else{
		$panel = [
			'backup_snapshot'=>[
				'name'=>'快照',
			],
			'backup_full'=>[
				'name'=>'备份',
			],
			'cdid'=>[
				'name'=>'光驱',
			]
		];
	}
	if(empty($params['configoptions']['portmap'])){
		unset($panel['portmap']);
	}
	if(empty($params['configoptions']['binding_domain'])){
		unset($panel['binding_domain']);
	}
	if(empty($params['configoptions']['backup_snapshot'])){
		unset($panel['backup_snapshot']);
	}
	if(empty($params['configoptions']['backup_full'])){
		unset($panel['backup_full']);
	}
	return $panel;
}

// 输出内容
function rstackkvm_ClientAreaOutput($params, $key){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return '';
	}
	if($key == 'backup_snapshot'){
	    $data = rstackkvm_sign($params["server_password"]);
        $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
        $header = array();
        $data["action"] = "kvmbackup";
        $data["vmid"] = $vserverid;
        $data["backuptype"]="1";
    	$rsret = rstackkvm_post($url,$header,$data);
    	
    	$rsret2 = json_decode($rsret,true);
    	
    	foreach($rsret2 AS $k=>$v){
			$rsret2[$k]['time'] = date("Y-m-d H:i:s",strtotime($v['time']));
		}
		
		return [
			'template'=>'templates/snapshot.html',
			'vars'=>[
				'list'=>$rsret2
			]
		];
	}else if($key == 'backup_full'){
	    $data = rstackkvm_sign($params["server_password"]);
        $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
        $header = array();
        $data["action"] = "kvmbackup";
        $data["vmid"] = $vserverid;
        $data["backuptype"]="2";
    	$rsret = rstackkvm_post($url,$header,$data);
    	$rsret2 = json_decode($rsret,true);
    	foreach($rsret2 AS $k=>$v){
			$rsret2[$k]['time'] = date("Y-m-d H:i:s",strtotime($v['time']));
		}
		return [
			'template'=>'templates/backups.html',
			'vars'=>[
				'list'=>$rsret2
			]
		];
	}else if($key == 'cdid'){
	    $data = rstackkvm_sign($params["server_password"]);
        $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
        $header = array();
        $data["action"] = "kvm_cd_manage";
        $data["vmid"] = $vserverid;
        $data["subvaction"]="list";
    	$rsret = rstackkvm_post($url,$header,$data);
    	$rsret2 = json_decode($rsret,true);
    	
    	//获取主机信息
    	$data2 = rstackkvm_sign($params["server_password"]);
    	$data2["action"] = "kvm";
        $data2["id"] = $vserverid;
        $rsret3 = rstackkvm_post($url,$header,$data2);
        $rsret4 = json_decode($rsret3,true);
    	
		return [
			'template'=>'templates/cd_rom.html',
			'vars'=>[
				'list'=>$rsret2,
				'host'=>$rsret4
				//'host'=>$host['data']
			]
		];
	}else if($key == 'portmap'){
	    $data = rstackkvm_sign($params["server_password"]);
        $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
        $header = array();
        $data["action"] = "kvmnat";
        $data["vmid"] = $vserverid;
        $data["nattype"]="1";
    	$rsret = rstackkvm_post($url,$header,$data);
    	$rsret2 = json_decode($rsret,true);
    	
    	$data2 = rstackkvm_sign($params["server_password"]);
    	$data2["action"] = "kvm_exinfo";
        $data2["vmid"] = $vserverid;
        $rsret3 = rstackkvm_post($url,$header,$data2);
    	$rsret4 = json_decode($rsret3,true);
    	
		return [
			'template'=>'templates/nat_acl.html',
			'vars'=>[
				'list'=>$rsret2,
				'vm_exinfo'=>$rsret4
			]
		];
	}else if($key == 'binding_domain'){
		$data = rstackkvm_sign($params["server_password"]);
        $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
        $header = array();
        $data["action"] = "kvmnat";
        $data["vmid"] = $vserverid;
        $data["nattype"]="2";
    	$rsret = rstackkvm_post($url,$header,$data);
    	$rsret2 = json_decode($rsret,true);
    	
    	$data2 = rstackkvm_sign($params["server_password"]);
    	$data2["action"] = "kvm_exinfo";
        $data2["vmid"] = $vserverid;
        $rsret3 = rstackkvm_post($url,$header,$data2);
    	$rsret4 = json_decode($rsret3,true);
    	
		return [
			'template'=>'templates/nat_web.html',
			'vars'=>[
				'list'=>$rsret2,
				'vm_exinfo'=>$rsret4
			]
		];
	}
}

// 可以执行自定义方法
function rstackkvm_AllowFunction(){
	return [
		'client'=>['CreateSnap','DeleteSnap','RestoreSnap','CreateBackup','DeleteBackup','RestoreBackup','CreateSecurityGroup','DeleteSecurityGroup','ApplySecurityGroup','ShowSecurityGroupAcl','CreateSecurityGroupAcl','DeleteSecurityGroupAcl','MountCdRom','UnmountCdRom','addNatAcl','delNatAcl','addNatWeb','delNatWeb'],
	];
}

// 创建转发
function rstackkvm_addNatAcl($params){
	if($params['configoptions']['portmap'] == 0){
		return '该产品不是NAT产品,不支持创建转发';
	}
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_portmap";
    $data["vmid"]=$vserverid;
    $data["subvaction"] = "add";
    $data["privateport"]=trim($post['privateport']);

	$rsret = rstackkvm_post($url,$header,$data);
	
	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    $description = sprintf("NAT转发添加成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("NAT转发添加失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: 'NAT转发添加失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 删除转发
function rstackkvm_delNatAcl($params){
	if($params['configoptions']['portmap'] == 0){
		return '该产品不是NAT产品,不支持删除转发';
	}
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_portmap";
    $data["vmid"]=$vserverid;
    $data["subvaction"] = "del";
    $data["portid"]=trim($post['portid']);

	$rsret = rstackkvm_post($url,$header,$data);
	
	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    $description = sprintf("NAT转发删除成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("NAT转发删除失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: 'NAT转发删除失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 创建建站
function rstackkvm_addNatWeb($params){
	if($params['configoptions']['binding_domain'] == 0){
		return '该产品不是NAT产品,不支持建站';
	}
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);

    $data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_domain";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="add";
    $data["domainname"]= trim($post['domainname']); //域名
    $data["privateport"]= trim($post['privateport']); //内部端口如80

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	   	$description = sprintf("NAT建站添加成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("NAT建站添加失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: 'NAT建站添加失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 删除建站
function rstackkvm_delNatWeb($params){
	if($params['configoptions']['binding_domain'] == 0){
		return '该产品不是NAT产品,不支持删除建站';
	}
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
    $data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_domain";
    $data["vmid"]= $vserverid;
    $data["subvaction"]="del";
    $data["domainid"]= trim($post['domainid']); //删除的域名ID

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
		$description = sprintf("NAT网站删除成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
		$description = sprintf("NAT网站删除失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: 'NAT网站删除失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 创建快照
function rstackkvm_CreateSnap($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_snapshot";
    $data["subvaction"]="create";
    $data["vmid"]=$vserverid;
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("快照创建成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("快照创建失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '快照创建失败'];
	}
    active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 删除快照
function rstackkvm_DeleteSnap($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_snapshot";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="del";
    $data["snapshotname"] = trim($post['snapshotname']); //待删除快照名称。
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("快照删除成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("快照删除失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '快照删除失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 恢复快照
function rstackkvm_RestoreSnap($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_snapshot";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="revert";
    $data["snapshotname"] = trim($post['snapshotname']); //待恢复快照名称。
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("快照恢复成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("快照恢复失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '快照恢复失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 创建备份
function rstackkvm_CreateBackup($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_backup";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="create";
    //$data["backupname"] = trim($post['backupname']); //待恢复快照名称。
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("备份创建成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("备份创建失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '备份创建失败'];
	}
	
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 删除备份
function rstackkvm_DeleteBackup($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_backup";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="del";
    $data["backupname"] = trim($post['backupname']); //待恢复快照名称。
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("备份删除成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("备份删除失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '备份删除失败'];
	}

	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 还原备份
function rstackkvm_RestoreBackup($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_backup";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="revert";
    $data["backupname"] = trim($post['backupname']); //待恢复快照名称。
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("备份恢复成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("备份恢复失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '备份恢复失败'];
	}

	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 挂载光驱
function rstackkvm_MountCdRom($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_cd_manage";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="change";
    $data["cdid"] = trim($post['cdid']);;  // 光驱ID
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("光驱挂载成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("光驱挂载失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '光驱挂载失败'];
	}
	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 卸载光驱
function rstackkvm_UnmountCdRom($params){
	// 通过post接受自定义参数
	$post = input('post.');
	$vserverid = rstackkvm_GetServerid($params);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();
    $data["action"] = "kvm_cd_manage";
    $data["vmid"]=$vserverid;
    $data["subvaction"]="change";
    $data["cdid"] = "-1";  //-1为拆卸光驱。
	$rsret = rstackkvm_post($url,$header,$data);
	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	   	$description = sprintf("光驱卸载成功 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'success', 'msg'=>$description];
	}else{
	    $description = sprintf("光驱卸载失败 - Host ID:%d", $params['hostid']);
		$result = ['status'=>'error', 'msg'=>$ret['msg'] ?: '光驱卸载失败'];
	}

	active_logs($description,$params['uid'],2);
    active_logs($description,$params['uid'],2,2);
    return $result;
}

// 开通
function rstackkvm_CreateAccount($params){
	// 获取自定义字段
	$vserverid = rstackkvm_GetServerid($params);
	if(!empty($vserverid)){
		return '已开通,不能重复开通';
	}
	
	$vmpass = "";
	if(empty($params['password'])){
		$vmpass = randStr(8);
	}else{
		$vmpass = $params['password'];
	}

	//查询RSTACK主控和注册账号：
	$uid = $params['uid']; 
	$username = ($params['user_info']['phonenumber'] ?: $params['user_info']['email']) ?: $params['user_info']['username']; //手机>邮箱>用户名
	$username2 = $username;
	$email = "";
	if (stripos($username,"@") > -1){
	    //用户名是邮箱：
	    $email = $username;
	    $username = str_replace("@","",$username);
	    $username = str_replace(".","",$username);
	}else{
	    $email = $username."@qq.com";
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "user_info";
    $data["userid"] = $uid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"] == "-1"){
	    return ['status'=>'error', 'msg'=>$ret['msg'] ?: '开通失败,原因查询用户失败'];
	}
	
	if ($rsret == ""){
	     $data["action"] = "user_add";
         $data["userid"] = $uid;
         $data["username"] = $username;
         $data["password"] = $vmpass;
         $data["email"] = $email;
         $data["status"] = "0";
    	$rsret = rstackkvm_post($url,$header,$data);
    	$ret = rstackkvm_CheckReturn($rsret);
		if ($ret["code"] == "-1"){
            return ['status'=>'error', 'msg'=>$ret['msg'] ?: '开通失败,原因注册用户失败'];
        }
	}
	
	$post_data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $post_data["action"] = "kvm_create";

	//$post_data = [];
	$post_data['userid'] = $uid; 
	$post_data['areaid'] = $params['configoptions']['areaid'];
	$post_data['nodeid'] = $params['configoptions']['nodeid'];
	$post_data['osid'] = $params['configoptions']['osid'];
	//$post_data['osid'] = 
	$post_data['vmname'] = $params['domain'];
	$post_data['cpu'] = $params['configoptions']['cpu'];
	//RS CPU
	$post_data['cpu_limit'] = $params['configoptions']['cpu_limit'];
	$post_data['cpu_weight']="10";
	//$post_data['ram_min'] = $params['configoptions']['ram_min'];
	$post_data['ram'] = $params['configoptions']['ram'];
	$post_data['ram_buffer']= "20";
	$post_data['ram_weight']="50";
	$post_data['disk'] = $params['configoptions']['disk'];
	$post_data['disk_sys_iops'] = $params['configoptions']['disk_sys_iops'];
	$post_data['disk_data_iops'] = $params['configoptions']['disk_data_iops'];
	$post_data['port'] = $params['configoptions']['port'];
	$post_data['ports'] = $params['configoptions']['ports']; //下行
	$post_data['bwlimit'] = $params['configoptions']['bwlimit'];
	$post_data['backup_snapshot'] = $params['configoptions']['backup_snapshot'];
	$post_data['backup_full'] = $params['configoptions']['backup_full'];
	$post_data['portmap'] = $params['configoptions']['portmap'];
	$post_data['binding_domain'] = $params['configoptions']['binding_domain'];
	$post_data['vmpass'] = $vmpass;
	$post_data['remote_port'] = $params['configoptions']['remote_port'];
	$post_data['ip'] = $params['configoptions']['ip'];
	$post_data['ipv6'] = $params['configoptions']['ipv6'];
	$post_data['iprandom'] = $params['configoptions']['iprandom'];
	$post_data['iptype'] = $params['configoptions']['iptype'];//$params['configoptions']['RS Iptype'] ?? $params['configoptions']['iptype']; 
	$post_data['remark'] = "ZJMF[".$username2."].创建";
	$post_data['returnjson'] = "1";
 
	if(!empty($params['configoptions']['nodeid'])){
		$post_data['nodeid'] = $params['configoptions']['nodeid'];
	}
	
	
	
	$rsret = rstackkvm_post($url,$header,$post_data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	$tmp  = explode("|",$rsret);
	$rsJSON = json_decode($tmp[1]); 
	
	if ($ret["code"]=="0"){
	    
	    //测试返回。。。。。。。
	    //return ['status'=>'success', 'msg'=>$rsJSON->vmname];
	    
	    $remote_port = $rsJSON->remote_port;
	    if ($remote_port == "0"){
	        $remote_port = "";
	    }
	     
	    //return ['status'=>'success', 'msg'=>"创建OK2"];
	    //return ['status'=>'error', 'msg'=>$rsret ?: '开通失33败'];
		// 存入产品自定义字段
		$customid = Db::name('customfields')
					->where('type', 'product')
					->where('relid', $params['productid'])
					->where('fieldname', 'vserverid')
					->value('id');
		if(empty($customid)){
			// 添加自定义字段
			$customfields = [
				'type'=>'product',
				'relid'=>$params['productid'],
				'fieldname'=>'vserverid',
				'fieldtype'=>'text',
				'adminonly'=>1,
				'create_time'=>time()
			];
			$customid = Db::name('customfields')->insertGetId($customfields);
		}
		$exist = Db::name('customfieldsvalues')
				->where('fieldid', $customid)
				->where('relid', $params['hostid'])
				->find();
		if(empty($exist)){
			$data = [
				'fieldid'=>$customid,
				'relid'=>$params['hostid'],
				'value'=>$rsJSON->id,
				'create_time'=>time()
			];
			Db::name('customfieldsvalues')->insert($data);
		}else{
			Db::name('customfieldsvalues')->where('id', $exist['id'])->update(['value'=>$rsJSON->id]);
		}
		// 存入IP
		$mainip = $rsJSON->ip;
		$otherip = "";
		$additionals_ip = $rsJSON->additionals_ip;
		if ($additionals_ip != ""){
			$otherip .=",".$additionals_ip;
		}
		$ipv6 = $rsJSON->ipv6;
		if ($ipv6 == "0"){
			$ipv6 = "";
		}
		if ($ipv6 !=""){
		    $otherip .= ",".$ipv6;
		}
		$additionals_ipv6 = $rsJSON->additionals_ipv6;
		if ($additionals_ipv6 != ""){
			$otherip .= ",".$additionals_ipv6;
		}
		// 获取当前操作系统
		$os_info = Db::name('host_config_options')
                    ->alias('a')
                    ->field('c.option_name')
                    ->leftJoin('product_config_options b', 'a.configid=b.id')
                    ->leftJoin('product_config_options_sub c', 'a.optionid=c.id')
                    ->where('a.relid', $params['hostid'])
                    ->where('b.option_type', 5)
                    ->find();
        if(stripos($os_info['option_name'], 'win') !== false){
            $username = 'administrator';
        }else{
            $username = 'root';
        }
		$update['dedicatedip'] = $mainip;
		$update['assignedips'] = $otherip;//implode(',', $ip);
		$update['port'] = $remote_port;
		// 存入服务器密码
		$update['domainstatus'] = 'Active';
		$update['username'] = $username;
		$update['password'] = cmf_encrypt($vmpass);
		$update['domain'] = $rsJSON->vmname;
		if(empty($os_info)){
			$update['os'] = $post_data['osid'];
		}
  		$update['bwlimit'] = (int)$post_data['bwlimit'];
		Db::name('host')->where('id', $params['hostid'])->update($update);
		//return 'ok';
		return ['status'=>'success', 'msg'=>"rstack创建模块完成！"];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '开通失败'];
	}
}

// 暂停
function rstackkvm_SuspendAccount($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_stop";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    //return ['status'=>'success', 'msg'=>"暂停主机完成"];
		$data["id"] = $vserverid;
		$data["action"] = "kvm_update";
		$data["status"] = "-1";
		$rsret = rstackkvm_post($url,$header,$data);
		$ret = rstackkvm_CheckReturn($rsret);
		if ($ret["code"]=="0"){
			return ['status'=>'success', 'msg'=>"暂停主机完成"];
		}else{
			 return ['status'=>'error', 'msg'=>$ret['msg'] ?: '修改状态>暂停失败'];
		}
	}else{
	   return ['status'=>'error', 'msg'=>$ret['msg'] ?: '暂停失败'];
	}
}

// 解除暂停
function rstackkvm_UnsuspendAccount($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

	$data["id"] = $vserverid;
	$data["action"] = "kvm_update";
	$data["status"] = "2";

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    //return ['status'=>'success', 'msg'=>"解除暂停完成"];
		$data["action"] = "kvm_start";
		$data["vmid"]= $vserverid;
		$data["id"] ="";
		$rsret = rstackkvm_post($url,$header,$data);
		$ret = rstackkvm_CheckReturn($rsret);
		if ($ret["code"]=="0"){
			return ['status'=>'success', 'msg'=>"解除暂停完成"];
		}else{
			 return ['status'=>'error', 'msg'=>$ret['msg'] ?: '解除暂停失败'];
		}
	}else{
	   return ['status'=>'error', 'msg'=>$ret['msg'] ?: '修改状态>解除暂停失败'];
	}
}

// 删除
function rstackkvm_TerminateAccount($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_delete";
    $data["vmid"]= $vserverid;
    $data["forcedelete"] = "1"; //强制删除

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
		// 删除成功后
		$customid = Db::name('customfields')
					->where('type', 'product')
					->where('relid', $params['productid'])
					->where('fieldname', 'vserverid')
					->value('id');
		Db::name('customfieldsvalues')->where('fieldid', $customid)->where('relid', $params['hostid'])->delete();
		// Db::name('host')->where('id', $params['hostid'])->update(['dedicatedip'=>'','assignedips'=>'','password'=>'']);
		return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '删除失败'];
	}
}

// 开机
function rstackkvm_On($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_start";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);

	if ($ret["code"]=="0"){
		return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '开机失败'];
	}
}

// 关机
function rstackkvm_Off($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_stop";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);

	if ($ret["code"]=="0"){
		return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '关机失败'];
	}
}

// 重启
function rstackkvm_Reboot($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_restart";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);

	if ($ret["code"]=="0"){
		return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '重启失败'];
	}
}

// 硬关机
function rstackkvm_HardOff($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_force_stop";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);

	if ($ret["code"]=="0"){
		return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '强制关机失败'];
	}
}

// 硬重启
function rstackkvm_HardReboot($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_force_restart";
    $data["vmid"]= $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);

	if ($ret["code"]=="0"){
		return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '强制重启失败'];
	}
}

// Vnc
function rstackkvm_Vnc($params){
    
    $vserverid = rstackkvm_GetServerid($params);
    if(empty($vserverid)){
        return 'rstackID错误';
    }
    
    $data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_console";
    $data["vmid"]= $vserverid;
    $data["subvaction"] = "enable"; //启用VNC服务

	$rsret = rstackkvm_post($url,$header,$data);
	
	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    
	    $data["subvaction"] = "state";
	    $rsret = rstackkvm_post($url,$header,$data);
	    $rsret2 = json_decode($rsret,true);
	    $ret = rstackkvm_CheckReturn($rsret);
	    
	    if ($rsret2["vncserver"] == ""){
	        $result["status"] = 'error';
            $result["msg"] = 'VNC未启用';
	        return 'rstack未启用VNC服务器';
	    }
	    if ($rsret2["state"] !="enabled"){
	        $result["status"] = 'error';
            $result["msg"] = 'VNC未启用成功';
	        return 'rstack VNC未启用成功';
	    }
	    
	    $result['status'] = 'success';
        $result['msg'] = 'vnc获取成功';
        $urlfield = "?uuid=".$rsret2["uuid"]."&token=".$rsret2["vnctoken"];
        $result["url"]= $rsret2["vncserver"]."/".$urlfield;
       
	    
	}else{
	    $result['status'] = 'error';
        $result['msg'] = $ret["msg"];//.$ret["msg"];
	    
	}
    return $result;
    
}



// 重装系统
function rstackkvm_Reinstall($params){

	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	//$os = input('post.os', 0, 'intval');
	if(empty($params['reinstall_os'])){
		return '操作系统错误';
	}
	// 判断是否是可配置选项
	// $r = Db::name('product_config_options_sub')
	// 	->alias('a')
	// 	->field('a.*')
	// 	->leftJoin('product_config_options b', 'a.config_id=b.id')
	// 	->leftJoin('product_config_links c', 'b.gid=c.gid')
	// 	->where('c.pid', $params['productid'])
	// 	->where('a.id', $os)
	// 	->find();
	// if(empty($r)){
	// 	return '操作系统错误';
	// }
	// $arr = explode('|', $r['option_name']);
	
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_reload";
    $data["osid"] = $params['reinstall_os'];
    $data["rot"] = "0";// 默认重装系统盘，如果为1全盘重装（因为魔方不支持参数！）
    $data["vmid"] = $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);

	//$res = rstackkvm_Curl($url, [], 30, 'GET');
	if ($ret["code"]=="0"){
		if(stripos($params['reinstall_os_name'], 'win') !== false){
        	$username = 'administrator';
    	}else{
        	$username = 'root';
    	}
    	Db::name('host')->where('id', $params['hostid'])->update(['username'=>$username]);
		return ['status'=>'success', 'msg'=>"重装任务开始！"];
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '重装失败'];
	}
	
}

// 破解密码
function rstackkvm_CrackPassword($params, $new_pass){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_resetps";
    $data["vmpass"] = $new_pass;
    $data["vmid"] = $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	    return ['status'=>'success', 'msg'=>$ret['msg']];
	}else{
	    
	    return ['status'=>'error', 'msg'=>$ret['msg'] ?: '修改密码失败'];
	}
}

// 续费
function rstackkvm_Renew($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_update";
    $data["id"] = $vserverid;
    $data["status"]="2";//修改正常服务；

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	if ($ret["code"]=="0"){
	     $data["action"] = "kvm_start";
	     $data["vmid"] = $vserverid;
	     $rsret = rstackkvm_post($url,$header,$data);
    	 $ret = rstackkvm_CheckReturn($rsret);
    	 if ($ret["code"] == "0"){
    	     return ['status'=>'success', 'msg'=>$ret['msg']];
    	 }else {
    	      return ['status'=>'error', 'msg'=>$ret['msg'] ?: '续费调用rstack失败'];
    	 }
	    
	}else{
	    
	    return ['status'=>'error', 'msg'=>$ret['msg'] ?: '续费调用rstack失败！'];
	}
}

// 同步
function rstackkvm_Sync($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误';
	}

	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm";
    $data["id"] = $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	$rsret2 = json_decode($rsret,true);

	if ($rsret2[0]["vmname"] != ""){
	    
	    $retJSON = json_decode($rsret,true);
	    $vmname = $retJSON[0]["vmname"];
	    
	    $data["action"] = "kvmip";
	    $data["vmid"] = $vserverid;
	    $data["id"]="";
	    
	    $rsret = rstackkvm_post($url,$header,$data);
	    
	    $ret2 = json_decode($rsret,true);
	    
	    //return ['status'=>'error', 'msg'=>$ret['msg'] ?: $rsret];
	    
	    if ($vmname != ""){
    		// 存入IP
    		$mainip = '';
    		$adds = "";
    		$ip = [];
    		foreach($ret2 as $v){
    		    $adds .= ",".$v["ip"];
    			if ($v["ip"] == $retJSON[0]["ip"]){
    			    
    			    $mainip = $retJSON[0]["ip"];
    			}else{
    			    $ip[] = $v["ip"];
    			}
    		}
    		//	return ['status'=>'error', 'msg'=>$ret['msg'] ?: $retJSON[0]["ip"]];
    		$update['dedicatedip'] = $mainip;
    		$update['assignedips'] = implode(',', $ip);
    		$update['password'] = cmf_encrypt($retJSON[0]['vmpass']);
    		$update['domain'] = $retJSON[0]['vmname'];
    		if ($retJSON[0]["remote_port"] !="0"){
    		    $update["port"]=$retJSON[0]["remote_port"];
    		}
    		
    		
    		
    		/*
    		if(is_numeric($res['data']['flow']['code']) && $res['data']['flow']['code'] == 0){
      			$update['bwusage'] = round(($res['data']['flow']['data']['in'] + $res['data']['flow']['data']['out'])/1024/1024/1024, 2);
      			if(is_numeric($res['data']['flow_limit'])){
      				$update['bwlimit'] = (int)$res['data']['flow_limit'];
      			}
      		}
      		*/
      		$os_info = Db::name('host_config_options')
                        ->alias('a')
                        ->field('c.option_name')
                        ->leftJoin('product_config_options b', 'a.configid=b.id')
                        ->leftJoin('product_config_options_sub c', 'a.optionid=c.id')
                        ->where('a.relid', $params['hostid'])
                        ->where('b.option_type', 5)
                        ->find();
            if(stripos($os_info['option_name'], 'win') !== false){
                $update['username'] = 'administrator';
            }else{
                $update['username'] = 'root';
            }
    		Db::name('host')->where('id', $params['hostid'])->update($update);
    		
    		return ['status'=>'success', 'msg'=>"同步完成！"];
    	}else{
    	    return ['status'=>'error', 'msg'=>"未找到rstack主机名" ?: '同步失败'];
    	    
    	}
	}else{
		return ['status'=>'error', 'msg'=>$ret['msg'] ?: '同步失败3'];
	}
}
/*
function rstackkvm_ChangePackage($params){
    $result['status'] = 'error';
	$result['msg'] = "错误111";
	return $result;
}
*/

// 升降级
function rstackkvm_ChangePackage($params){
    /*
    $result['status'] = 'error';
	$result['msg'] = "错误111";
	return $result;
	*/
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
	    # wyh 20201109 增
        $vserverid = intval($params['old_configoptions']['customfields']['vserverid']);
        if (empty($vserverid)){
            return 'rstackID错误';
        }
	}
	
	$post_data = [];
	$post_data = rstackkvm_sign($params["server_password"]);
	
	$post_data["update_vm"]="1";
    
	
	if(isset($params['configoptions_upgrade']['cpu'])){
		$post_data['cpu'] = $params['configoptions']['cpu'];
	}
	if(isset($params['configoptions_upgrade']['cpu_limit'])){
		$post_data['cpu_limit'] = $params['configoptions']['cpu_limit'];
	}
	if(isset($params['configoptions_upgrade']['ram'])){
		$post_data['ram'] = $params['configoptions']['ram'];
		//$post_data['ram_min'] = $post_data['ram'];
	}
	if(isset($params['configoptions_upgrade']['disk'])){
		$post_data['disk'] = $params['configoptions']['disk'];
	}
	if(isset($params['configoptions_upgrade']['port']) || isset($params['configoptions_upgrade']['port'])){
		$post_data['port'] = $params['configoptions']['port'] ?? $params['configoptions']['port'];
	}
	if(isset($params['configoptions_upgrade']['ports']) || isset($params['configoptions_upgrade']['ports'])){
		$post_data['ports'] = $params['configoptions']['ports'] ?? $params['configoptions']['ports'];
	}
	
	//=========
	if(isset($params['configoptions_upgrade']['bwlimit'])){
		$post_data['bwlimit'] = $params['configoptions']['bwlimit'];
	}
	if(isset($params['configoptions_upgrade']['backup_snapshot'])){
		$post_data['backup_snapshot'] = $params['configoptions']['backup_snapshot'];
	}
	if(isset($params['configoptions_upgrade']['backup_full'])){
		$post_data['backup_full'] = $params['configoptions']['backup_full'];
	}
	if(isset($params['configoptions_upgrade']['portmap'])){
		$post_data['portmap'] = $params['configoptions']['portmap'];
	}
	if(isset($params['configoptions_upgrade']['binding_domain'])){
		$post_data['binding_domain'] = $params['configoptions']['binding_domain'];
	}
	if(isset($params['configoptions_upgrade']['ip'])){
		$post_data['addipnumber'] = $params['configoptions']['ip'];
	}
	
	if(isset($params['configoptions_upgrade']['iptype'])){
		$post_data['iptype'] = $params['configoptions']['iptype'];
	}
	
	//$post_data['cpu'] = "6";
	
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $post_data["action"] = "kvm_update";
    $post_data["id"] = $vserverid;

	$rsret = rstackkvm_post($url,$header,$post_data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="0"){
	    $result['status'] = 'success';
		$result['msg'] = $ret['msg'] ?: '升级配置成功';
	}else{
	    $result['status'] = 'error';
		$result['msg'] = $ret['msg'] ?: $ret["msg"];
	}

    # TODO wyh 20201105 新增 vserverid
    $pid = $params['productid'];
    $customid = Db::name('customfields')
        ->where('type', 'product')
        ->where('relid', $pid)
        ->where('fieldname', 'vserverid')
        ->value('id');

    if(empty($customid)){
        $customfields = [
            'type'=>'product',
            'relid'=>$pid,
            'fieldname'=>'vserverid',
            'fieldtype'=>'text',
            'adminonly'=>1,
            'create_time'=>time()
        ];
        $customid = Db::name('customfields')->insertGetId($customfields);
    }
    $exist = Db::name('customfieldsvalues')
        ->where('fieldid', $customid)
        ->where('relid', $params['hostid'])
        ->find();
    if(empty($exist)){
        $data = [
            'fieldid'=>$customid,
            'relid'=>$params['hostid'],
            'value'=>$vserverid??$vserverid,
            'create_time'=>time()
        ];
        Db::name('customfieldsvalues')->insert($data);
    }else{
        Db::name('customfieldsvalues')->where('id', $exist['id'])->update(['value'=>$vserverid??$vserverid]);
    }
    
    //升级完毕 拉取更新一次主控数据！
    rstackkvm_Sync($params);
    # 结束

	return $result;
}

// 云主机状态
function rstackkvm_Status($params){
	$vserverid = rstackkvm_GetServerid($params);
	if(empty($vserverid)){
		return 'rstackID错误2';
	}
	$data = rstackkvm_sign($params["server_password"]);
    $url = $params["secure"] ? "https://":"http://".$params["server_ip"]."/api/v3";
    $header = array();

    $data["action"] = "kvm_state";
    $data["vmid"] = $vserverid;

	$rsret = rstackkvm_post($url,$header,$data);

	$ret = rstackkvm_CheckReturn($rsret);
	
	if ($ret["code"]=="-1"){
	    return ['status'=>'error', 'msg'=>$res['msg'] ?: '获取失败'];
	}else{
	    $state_code  = explode("|",$rsret)[0];
	    
	    if ($state_code == "setupfailed"){
	         return ['status'=>'error', 'msg'=>"安装发生错误,请重新安装！" ?: '安装发生错误,请重新安装！'];
	    }
	    
	    $stateJSON = json_decode(explode("|",$rsret)[1],true);
	    $taskmsg = $stateJSON["taskmsg"];
	    if ($taskmsg ==""){
	        $taskmsg = "0";
	    }
	    
	    
	    //魔方：
	    //on,off,suspend,waiting,process,unknown
	    //打开、关闭、挂起、等待、进程、未知
	    $result['status'] = 'success';
	    if ($state_code == "running"){
	       	$result['data']['status'] = 'on';
			$result['data']['des'] = '开机';
	    }else if ($state_code == "setup"){
	        $result['data']['status'] = 'process';
	        //$result['data']['des'] = "正在安装中";
			$result['data']['des'] = "正在安装中,安装进度：".$taskmsg."% (虚拟化平台：RStack)";
	    }else if ($state_code == "off"){
	        $result['data']['status'] = 'off';
			$result['data']['des'] = '关机';
	    }else if ($state_code == "paused"){
	        $result['data']['status'] = 'suspend';
			$result['data']['des'] = '暂停';
	    }else if ($state_code =="saved"){
	        $result['data']['status'] = 'suspend';
			$result['data']['des'] = '挂起';
	    }else if ($state_code == "overbw"){
	        $result['data']['status'] = 'off';
			$result['data']['des'] = '关机';
	    }else if ($state_code == "overdue"){
	        $result['data']['status'] = 'suspend';
			$result['data']['des'] = '到期关机';
	    }else  if ($sta == "locked"){
	        $result['data']['status'] = 'suspend';
			$result['data']['des'] = '锁定';
	    }
	    return $result;
	    
	}
}


// 后台按钮隐藏
function rstackkvm_AdminButtonHide($params){
	if(!empty(rstackkvm_GetServerid($params)) && $params['serverid']>0){
		return ['CreateAccount'];
	}else{
		return ['SuspendAccount','UnsuspendAccount','TerminateAccount','On','Off','Reboot','HardOff','HardReboot','Reinstall','CrackPassword','Vnc','Sync'];
	}
}

// 获取自定义字段value
function rstackkvm_GetServerid($params){
	return (int)$params['customfields']['vserverid'];
	// return Db::name('customfields')
	// 		->alias('a')
	// 		->leftJoin('customfieldsvalues b', 'a.id=b.fieldid')
	// 		->where('a.type', 'product')
	// 		->where('a.relid', $params['productid'])
	// 		->where('a.fieldname', 'vserverid')
	// 		->where('b.relid', $params['hostid'])
	// 		->value('value');
}


// 创建签名
function rstackkvm_CreateSign($token = ''){
	$res['api_timestamp'] =  time();
	$res['api_random'] = randStr(6); 
	$res['api_sign'] = strtolower(md5($token.$res['api_random'].$res['api_timestamp']));
	$res['api_type']= virtualType2;
	$res['api_language'] = "chinese";
	return $res;
}

function rstackkvm_sign($apikey)
{
    $api_timestamp = time();
	$api_random = rstackkvm_GetRandStr(16);
    //加密MD5
	$api_sign = md5($apikey.$api_random.$api_timestamp);
    //返回sign签名
    return array(
        "api_sign"=>$api_sign,
        "api_timestamp"=>$api_timestamp,
        "api_random"=>$api_random,
        "api_language"=>"chinese",
        "api_type"=>virtualType2
    );
}

function rstackkvm_GetRandStr($length){
    $str = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $len = strlen($str)-1;
    $randstr = '';
    for ($i=0;$i<$length;$i++) {
        $num=mt_rand(0,$len);
        $randstr .= $str[$num];
    }
    return $randstr;
}

function rstackkvm_CheckReturn($str){
	$tmp  = explode("|",$str);
	if (count($tmp)>2){
		return array(
			"code"=>"-1",
			"msg"=>"API返回格式不能出现多个|符号",
		);
	}else if (count($tmp) == 2){
		//带返回值 格式如  0|success
		return array(
			"code"=>$tmp[0],
			"msg"=>$tmp[1],
		);
	}else{
		if ($str == "0"){
			// 只返回 0 的接口
			return array(
				"code"=>$str,
				"msg"=>"",
			);
		}else{
			// 返回错误信息
			return array(
				"code"=>$tmp[0],
				"msg"=>$tmp[1],
			);
		}
	}
}
// 发送POST请求
function rstackkvm_post($url,$header,$data){
    $cUrl = curl_init();
    curl_setopt($cUrl, CURLOPT_URL, $url);//目标URL
    curl_setopt($cUrl, CURLOPT_TIMEOUT,600);//超时时间
    curl_setopt($cUrl, CURLOPT_POST, true);	//POST请求
    curl_setopt($cUrl, CURLOPT_POSTFIELDS, http_build_query($data));//POST数据
    curl_setopt($cUrl, CURLOPT_RETURNTRANSFER, 1);//设置接收返回值
    curl_setopt($cUrl, CURLOPT_HTTPHEADER, $header);//请求头
    curl_setopt($cUrl, CURLOPT_HEADER, true);//请求头
    curl_setopt($cUrl, CURLOPT_SSL_VERIFYPEER, FALSE);//不验证证书
    curl_setopt($cUrl, CURLOPT_SSL_VERIFYHOST, FALSE);//不验证HOSTS
    
    $output = curl_exec($cUrl); //发送
    $headerSize = curl_getinfo($cUrl, CURLINFO_HEADER_SIZE);//获取响应头长度
    $body = substr($output, $headerSize); //获取内容
    curl_close($cUrl);//释放curl资源
    return $body;
}


