<?php
define("virtualType", "vhost");
define("moduleName", "rstackvhost");
function rstackvhost_MetaData()
{
    return ["DisplayName" => "rstackvhost", "APIVersion" => "1.0", "HelpDoc" => "http://www.rstack.com.cn/docs?id=49"];
}
function rstackvhost_ConfigOptions()
{
    return [["type" => "text", "name" => "数据中心ID", "description" => "数据中心ID自动轮询节点节点）", "key" => "areaid"], ["type" => "text", "name" => "节点ID", "description" => "计算节点ID(不填则自动分配)", "default" => "3", "key" => "nodeid"], ["type" => "dropdown", "name" => "ASP脚本", "description" => "", "options" => ["不支持", "支持"], "default" => "", "key" => "aspscript"], ["type" => "dropdown", "name" => "ASP.NET脚本", "description" => "", "options" => ["不支持", "支持"], "default" => "", "key" => "aspxscript"], ["type" => "dropdown", "name" => "PHP脚本", "description" => "", "options" => ["不支持", "支持"], "default" => "", "key" => "phpscript"], ["type" => "text", "name" => "赠送MYSQL", "description" => "MB(为0不赠送)", "default" => "0", "key" => "mysqlspace"], ["type" => "text", "name" => "赠送MSSQL", "description" => "MB (为0不赠送)", "default" => "0", "key" => "mssqlspace"], ["type" => "text", "name" => "CPU限制", "description" => "% （仅对独立池有效）", "default" => "100", "key" => "cpulimit"], ["type" => "text", "name" => "空间容量", "description" => "MB", "default" => "1024", "key" => "diskspace"], ["type" => "text", "name" => "域名绑定数", "description" => "个", "default" => "20", "key" => "bindingdomain"], ["type" => "text", "name" => "IIS连接数", "description" => "个(推荐最小50以上)", "default" => "200", "key" => "maxconnections"], ["type" => "text", "name" => "站点宽带", "description" => "Mbps(最小1)", "default" => "1", "key" => "maxbandwidth"], ["type" => "text", "name" => "每月流量", "description" => "GB(0为不限制流量)", "default" => "0", "key" => "bwlimit"], ["type" => "text", "name" => "站点池分配", "description" => "多少站共享一个池", "default" => "1", "key" => "apppoolnum"], ["type" => "yesno", "name" => "IP开通模式", "description" => "勾选表示独立IP空间", "default" => "0", "key" => "hostip"], ["type" => "dropdown", "name" => "默认PHP版本", "description" => "", "options" => ["5.2" => "PHP5.2", "5.3" => "PHP5.3", "5.4" => "PHP5.4", "5.5" => "PHP5.5", "5.6" => "PHP5.6", "7.0" => "PHP7.0", "7.1" => "PHP7.1", "7.2" => "PHP7.2", "7.3" => "PHP7.3", "7.4" => "PHP7.4", "8.1" => "PHP8.1"], "default" => "", "key" => "phpversion"], ["type" => "dropdown", "name" => "默认NET版本", "description" => "", "options" => ["2.0" => "2.0/3.5", "4.0" => "4.0"], "default" => "", "key" => "netversion"], ["type" => "dropdown", "name" => "NET池模式", "description" => "", "options" => ["经典(推荐)", "集成"], "default" => "", "key" => "netmode"], ["type" => "dropdown", "name" => "开通后显示IP或CNAME", "description" => "CNAME的话方便以后换IP", "options" => ["cname" => "CNAME", "ip" => "IP地址"], "default" => "", "key" => "netmode"]];
}
function rstackvhost_TestLink($params)
{
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "test";
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        $result["status"] = 200;
        $result["data"]["server_status"] = 1;
    } else {
        $result["status"] = 200;
        $result["data"]["server_status"] = 0;
        $result["data"]["msg"] = $ret["msg"];
    }
    return $result;
}
function rstackvhost_Chart_NOP()
{
    return ["flow" => ["title" => "流量图"]];
}
function rstackvhost_ChartData_NOP($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return ["status" => "error", "msg" => "数据获取失败"];
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "vhost_monitor";
    $data["hostid"] = $vserverid;
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "-1") {
        return ["status" => "error", "msg" => $ret["msg"]];
    }
    $rsret2 = json_decode($rsret, true);
    $start = $params["chart"]["start"] / 1000;
    $result["status"] = "success";
    $result["data"] = [];
    if ($params["chart"]["type"] == "flow") {
        $result["data"]["unit"] = "KB/s";
        $result["data"]["chart_type"] = "line";
        $result["data"]["list"] = [];
        $result["data"]["label"] = ["进(KB/s)", "出(KB/s)"];
        foreach ($rsret2 as $v) {
            $time = $v["time"];
            $date = date("Y-m-d H:i:s", $time);
            $result["data"]["list"][0][] = ["time" => $date, "value" => explode(",", $v["network"])[0]];
            $result["data"]["list"][1][] = ["time" => $date, "value" => explode(",", $v["network"])[1]];
        }
    }
    return $result;
}
function rstackvhost_ClientArea($params)
{
    return ["login" => ["name" => "控制面板"]];
}
function rstackvhost_ClientAreaOutput($params, $key)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "";
    }
    if ($key == "login") {
        $data = rstackvhost_sign($params["server_password"]);
        $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
        $header = [];
        $data["action"] = "vhost_data";
        $data["id"] = $vserverid;
        $rsret = rstackvhost_post($url, $header, $data);
        $rsret2 = json_decode($rsret, true);
        $statueMsg = "";
        $status = $rsret2["status"];
        if ($status == "1") {
            $statueMsg = "已锁定！";
        } else {
            if ($status == "-1") {
                $statueMsg = "服务中止";
            } else {
                if ($status == "-2") {
                    $statueMsg = "超流量运行";
                } else {
                    if ($status == "-3") {
                        $statueMsg = "超流量停止";
                    } else {
                        if ($status == "2") {
                            $data = rstackvhost_sign($params["server_password"]);
                            $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
                            $header = [];
                            $data["action"] = "state";
                            $data["hostid"] = $vserverid;
                            $rsret = rstackvhost_post($url, $header, $data);
                            $ret = rstackvhost_CheckReturn($rsret);
                            if ($ret["code"] == "-1") {
                                $statueMsg = "获取主机状态失败：" . $res["msg"];
                            } else {
                                list($state_code) = explode("|", $rsret);
                                if ($state_code == "running") {
                                    $statueMsg = "站点运行中";
                                } else {
                                    if ($state_code == "off") {
                                        $statueMsg = "站点停止中";
                                    } else {
                                        if ($state_code == "overbw") {
                                            $statueMsg = "超流量停机";
                                        } else {
                                            if ($state_code == "overdue") {
                                                $statueMsg = "中止服务！";
                                            } else {
                                                if ($sta == "locked") {
                                                    $statueMsg = "主机已锁定！";
                                                } else {
                                                    if ($sta == "unknown") {
                                                        $statueMsg = "未知状态";
                                                    } else {
                                                        $statueMsg = $state_code;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        $usedisk = "";
        $usedisk = "已使用容量：" . $rsret2["diskspace_use"] / 1024 . "MB / 总空间容量：" . $rsret2["diskspace"] . "MB";
        $hostip = $rsret2["hostip"];
        if ($rsret2["cname"] != "") {
            $hostip .= " / CNAME别名解析：" . $rsret2["cname"];
        }
        return ["template" => "templates/login.html", "vars" => ["vhost_data" => $rsret2, "name" => $params["name"], "address" => $params["address"], "username" => $rsret2["ftpname"], "password" => $rsret2["ftppassword"], "ip" => $hostip, "status" => $statueMsg, "api" => str_replace("/api/v3", "", $url), "ftpport" => $rsret2["ftpport"], "usedisk" => $usedisk]];
    }
}
function rstackvhost_AllowFunction()
{
    return ["client" => ["CreateSnap", "DeleteSnap", "RestoreSnap", "CreateBackup", "DeleteBackup", "RestoreBackup", "CreateSecurityGroup", "DeleteSecurityGroup", "ApplySecurityGroup", "ShowSecurityGroupAcl", "CreateSecurityGroupAcl", "DeleteSecurityGroupAcl", "MountCdRom", "UnmountCdRom", "addNatAcl", "delNatAcl", "addNatWeb", "delNatWeb"]];
}
function rstackvhost_CreateAccount($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (!empty($vserverid)) {
        return "已开通,不能重复开通";
    }
    $domain = $params["domain"];
    $domains = "";
    if (strpos($domain, ".")) {
        $domains = $domain;
    }
    $ftpusername = $params["username"];
    if ($ftpusername == "") {
        $ftpusername = "vhost" . strtolower(rstackvhost_GetRandStr(8));
    }
    $ftppassword = "";
    if (empty($params["password"])) {
        $ftppassword = randStr(14);
    } else {
        $ftppassword = $params["password"];
    }
    $uid = $params["uid"];
    $username = $params["user_info"]["phonenumber"] ?: $params["user_info"]["email"] ?: $params["user_info"]["username"];
    $username2 = $username;
    $email = "";
    if (-1 < stripos($username, "@")) {
        $email = $username;
        $username = str_replace("@", "", $username);
        $username = str_replace(".", "", $username);
    } else {
        $email = $username . "@qq.com";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "user_info";
    $data["userid"] = $uid;
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "-1") {
        return ["status" => "error", "msg" => $ret["msg"] ?: "开通失败,原因查询用户失败"];
    }
    if ($rsret == "") {
        $data["action"] = "user_add";
        $data["userid"] = $uid;
        $data["username"] = $username;
        $data["password"] = $vmpass;
        $data["email"] = $email;
        $data["status"] = "0";
        $rsret = rstackvhost_post($url, $header, $data);
        $ret = rstackvhost_CheckReturn($rsret);
        if ($ret["code"] == "-1") {
            return ["status" => "error", "msg" => $ret["msg"] ?: "开通失败,原因注册用户失败"];
        }
    }
    $post_data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $enable_mysql = "0";
    $mysqlbackupnum = "5";
    $enable_mssql = "0";
    $mssqlbackupnum = "5";
    $mysqlspace = $params["configoptions"]["mysqlspace"];
    $mssqlspace = $params["configoptions"]["mssqlspace"];
    $header = [];
    if ($mysqlspace != "0") {
        $enable_mysql = "1";
    }
    if ($mssqlspace != "0") {
        $enable_mssql = "1";
    }
    $tmp1 = explode(",", $mysqlspace);
    $tmp2 = explode(",", $mssqlspace);
    if (count(tmp1) == 2) {
        $mysqlspace = tmp1[0];
        ${$mysqlbackupnum} = tmp1[1];
    }
    if (count(tmp2) == 2) {
        $mssqlspace = tmp2[0];
        $mssqlbackupnum = tmp2[1];
    }
    $post_data["action"] = "vhost_create";
    $post_data["userid"] = $uid;
    $post_data["areaid"] = $params["configoptions"]["areaid"];
    $post_data["nodeid"] = $params["configoptions"]["nodeid"];
    $post_data["ftpname"] = $ftpusername;
    $post_data["ftppassword"] = $ftppassword;
    $post_data["aspscript"] = $params["configoptions"]["aspscript"];
    $post_data["phpscript"] = $params["configoptions"]["phpscript"];
    $post_data["aspxscript"] = $params["configoptions"]["aspxscript"];
    $post_data["enable_mysql"] = $enable_mysql;
    $post_data["mysqlspace"] = $mysqlspace;
    $post_data["mysqlbackupnum"] = $mysqlbackupnum;
    $post_data["enable_mssql"] = $enable_mssql;
    $post_data["mssqlspace"] = $mssqlspace;
    $post_data["mssqlbackupnum"] = $mssqlbackupnum;
    $post_data["domains"] = $domains;
    $post_data["cpulimit"] = $params["configoptions"]["cpulimit"];
    $post_data["diskspace"] = $params["configoptions"]["diskspace"];
    $post_data["bindingdomain"] = $params["configoptions"]["bindingdomain"];
    $post_data["maxconnections"] = $params["configoptions"]["maxconnections"];
    $post_data["bwlimit"] = $params["configoptions"]["bwlimit"];
    $post_data["maxbandwidth"] = $params["configoptions"]["maxbandwidth"];
    $post_data["apppoolnum"] = $params["configoptions"]["apppoolnum"];
    $hostip = $params["configoptions"]["hostip"];
    if ($hostip == "0") {
        $hostip = "";
    }
    $post_data["hostip"] = $hostip;
    $post_data["phpversion"] = $params["configoptions"]["phpversion"];
    $post_data["netversion"] = $params["configoptions"]["netversion"];
    $post_data["netmode"] = $params["configoptions"]["netmode"];
    $post_data["remark"] = "ZJMF[" . $username2 . "].创建";
    $post_data["returnjson"] = "1";
    if (!empty($params["configoptions"]["nodeid"])) {
        $post_data["nodeid"] = $params["configoptions"]["nodeid"];
    }
    $rsret = rstackvhost_post($url, $header, $post_data);
    $ret = rstackvhost_CheckReturn($rsret);
    $tmp = explode("|", $rsret);
    $rsJSON = json_decode($tmp[1]);
    if ($ret["code"] == "0") {
        $customid = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->where("fieldname", "vserverid")->value("id");
        if (empty($customid)) {
            $customfields = ["type" => "product", "relid" => $params["productid"], "fieldname" => "vserverid", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
            $customid = think\Db::name("customfields")->insertGetId($customfields);
        }
        $exist = think\Db::name("customfieldsvalues")->where("fieldid", $customid)->where("relid", $params["hostid"])->find();
        if (empty($exist)) {
            $data = ["fieldid" => $customid, "relid" => $params["hostid"], "value" => $rsJSON->id, "create_time" => time()];
            think\Db::name("customfieldsvalues")->insert($data);
        } else {
            think\Db::name("customfieldsvalues")->where("id", $exist["id"])->update(["value" => $rsJSON->id]);
        }
        $mainip = $rsJSON->hostip;
        $ftpport = $rsJSON->ftpport;
        $os_info = think\Db::name("host_config_options")->alias("a")->field("c.option_name")->leftJoin("product_config_options b", "a.configid=b.id")->leftJoin("product_config_options_sub c", "a.optionid=c.id")->where("a.relid", $params["hostid"])->where("b.option_type", 5)->find();
        $update["dedicatedip"] = $mainip;
        $update["port"] = $ftpport;
        $update["domainstatus"] = "Active";
        $update["username"] = $ftpusername;
        $update["password"] = cmf_encrypt($ftppassword);
        $update["domain"] = $rsJSON->{$domain};
        $update["bwlimit"] = (int) $post_data["bwlimit"];
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return ["status" => "success", "msg" => "rstack创建模块完成！"];
    }
    return ["status" => "error", "msg" => $ret["msg"] ?: "开通失败"];
}
function rstackvhost_SuspendAccount($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "vhost_update";
    $data["id"] = $vserverid;
    $data["update_host"] = "1";
    $data["status"] = "1";
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        return ["status" => "success", "msg" => "暂停主机完成"];
    }
    return ["status" => "error", "msg" => $ret["msg"] ?: "暂停失败"];
}
function rstackvhost_UnsuspendAccount($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "vhost_update";
    $data["id"] = $vserverid;
    $data["update_host"] = "1";
    $data["status"] = "2";
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        return ["status" => "success", "msg" => "解除暂停完成"];
    }
    return ["status" => "error", "msg" => $ret["msg"] ?: "修改状态>解除暂停失败"];
}
function rstackvhost_TerminateAccount($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "vhost_delete";
    $data["hostid"] = $vserverid;
    $data["forcedelete"] = "1";
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        $customid = think\Db::name("customfields")->where("type", "product")->where("relid", $params["productid"])->where("fieldname", "vserverid")->value("id");
        think\Db::name("customfieldsvalues")->where("fieldid", $customid)->where("relid", $params["hostid"])->delete();
        return ["status" => "success", "msg" => "删除完成"];
    }
    return ["status" => "error", "msg" => $ret["msg"] ?: "删除失败"];
}
function encode($str)
{
    $result = "";
    $addstr = "";
    $bytes = [];
    for ($i = 0; $i < strlen($str); $i++) {
        $bytes[] = ord($str[$i]);
        $addstr .= chr($bytes[$i] + 2);
    }
    $result = $addstr;
    return $result;
}
function rstackvhost_CrackPassword($params, $new_pass)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $new_ftppassword = $new_pass;
    $data["action"] = "set_ftppassword";
    $data["new_ftppassword"] = $new_ftppassword;
    $data["hostid"] = $vserverid;
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        $update["password"] = $new_ftppassword;
        think\Db::name("host")->where("id", $params["hostid"])->update($update);
        return ["status" => "success", "msg" => "FTP密码修改成功"];
    }
    return ["status" => "error", "msg" => $ret["msg"] ?: "修改密码失败"];
}
function rstackvhost_Renew($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "vhost_update";
    $data["id"] = $vserverid;
    $data["status"] = "2";
    $data["update_host"] = "1";
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        return ["status" => "success", "msg" => "续费成功！"];
    }
    return ["status" => "error", "msg" => $ret["msg"] ?: "续费调用rstack失败！"];
}
function rstackvhost_Sync($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "vhost_data";
    $data["id"] = $vserverid;
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    $rsret2 = json_decode($rsret, true);
    if ($rsret2["id"] != "") {
        $retJSON = json_decode($rsret, true);
        $ftpname = $rsret2["ftpname"];
        if ($ftpname != "") {
            $add_domain = "";
            foreach ($rsret2["domainlist"] as $item) {
                $domainname = $item["domain"];
                if ($add_domain == "") {
                    $add_domain = $domainname;
                } else {
                    $add_domain .= "," + $domainname;
                }
            }
            $update["dedicatedip"] = $rsret2["hostip"];
            $update["assignedips"] = $add_domain;
            $update["username"] = $rsret2["ftpname"];
            $update["password"] = cmf_encrypt($rsret2["ftppassword"]);
            $update["domain"] = $add_domain;
            $update["port"] = $rsret2["ftpport"];
            $os_info = think\Db::name("host_config_options")->alias("a")->field("c.option_name")->leftJoin("product_config_options b", "a.configid=b.id")->leftJoin("product_config_options_sub c", "a.optionid=c.id")->where("a.relid", $params["hostid"])->where("b.option_type", 5)->find();
            think\Db::name("host")->where("id", $params["hostid"])->update($update);
            return ["status" => "success", "msg" => "同步完成！"];
        } else {
            return ["status" => "error", "msg" => "未找到rstack主机名"];
        }
    } else {
        return ["status" => "error", "msg" => $ret["msg"] ?: "同步失败3"];
    }
}
function rstackvhost_ChangePackage($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        $vserverid = intval($params["old_configoptions"]["customfields"]["vserverid"]);
    }
    if (empty($vserverid)) {
        return "rstackID错误";
    }
    $post_data = [];
    $post_data = rstackvhost_sign($params["server_password"]);
    $post_data["update_vm"] = "1";
    if (isset($params["configoptions_upgrade"]["mysqlspace"])) {
        $post_data["mysqlspace"] = $params["configoptions"]["mysqlspace"];
    }
    if (isset($params["configoptions_upgrade"]["mssqlspace"])) {
        $post_data["mssqlspace"] = $params["configoptions"]["mssqlspace"];
    }
    if (isset($params["configoptions_upgrade"]["cpulimit"])) {
        $post_data["cpulimit"] = $params["configoptions"]["cpulimit"];
    }
    if (isset($params["configoptions_upgrade"]["diskspace"])) {
        $post_data["diskspace"] = $params["configoptions"]["diskspace"];
    }
    if (isset($params["configoptions_upgrade"]["port"]) || isset($params["configoptions_upgrade"]["bindingdomain"])) {
        $post_data["port"] = $params["configoptions"]["bindingdomain"] ?? $params["configoptions"]["bindingdomain"];
    }
    if (isset($params["configoptions_upgrade"]["maxconnections"])) {
        $post_data["maxconnections"] = $params["configoptions"]["maxconnections"];
    }
    if (isset($params["configoptions_upgrade"]["maxbandwidth"])) {
        $post_data["maxbandwidth"] = $params["configoptions"]["maxbandwidth"];
    }
    if (isset($params["configoptions_upgrade"]["bwlimit"])) {
        $post_data["bwlimit"] = $params["configoptions"]["bwlimit"];
    }
    if (isset($params["configoptions_upgrade"]["portmap"])) {
        $post_data["portmap"] = $params["configoptions"]["portmap"];
    }
    if (isset($params["configoptions_upgrade"]["binding_domain"])) {
        $post_data["binding_domain"] = $params["configoptions"]["binding_domain"];
    }
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $post_data["action"] = "vhost_update";
    $post_data["id"] = $vserverid;
    $post_data["status"] = "2";
    $post_data["vhost_update"] = "1";
    $rsret = rstackvhost_post($url, $header, $post_data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "0") {
        $result["status"] = "success";
        $result["msg"] = $ret["msg"] ?: "升级配置成功";
    } else {
        $result["status"] = "error";
        $result["msg"] = $ret["msg"] ?: $ret["msg"];
    }
    $pid = $params["productid"];
    $customid = think\Db::name("customfields")->where("type", "product")->where("relid", $pid)->where("fieldname", "vserverid")->value("id");
    if (empty($customid)) {
        $customfields = ["type" => "product", "relid" => $pid, "fieldname" => "vserverid", "fieldtype" => "text", "adminonly" => 1, "create_time" => time()];
        $customid = think\Db::name("customfields")->insertGetId($customfields);
    }
    $exist = think\Db::name("customfieldsvalues")->where("fieldid", $customid)->where("relid", $params["hostid"])->find();
    if (empty($exist)) {
        $data = ["fieldid" => $customid, "relid" => $params["hostid"], "value" => $vserverid ?? $vserverid, "create_time" => time()];
        think\Db::name("customfieldsvalues")->insert($data);
    } else {
        think\Db::name("customfieldsvalues")->where("id", $exist["id"])->update(["value" => $vserverid ?? $vserverid]);
    }
    rstackvhost_sync($params);
    return $result;
}
function rstackvhost_Status($params)
{
    $vserverid = rstackvhost_GetServerid($params);
    if (empty($vserverid)) {
        return "rstackID错误2";
    }
    $data = rstackvhost_sign($params["server_password"]);
    $url = $params["secure"] ? "https://" : "http://" . $params["server_ip"] . "/api/v3";
    $header = [];
    $data["action"] = "state";
    $data["hostid"] = $vserverid;
    $rsret = rstackvhost_post($url, $header, $data);
    $ret = rstackvhost_CheckReturn($rsret);
    if ($ret["code"] == "-1") {
        return ["status" => "error", "msg" => $res["msg"] ?: "获取失败"];
    }
    list($state_code) = explode("|", $rsret);
    if ($state_code == "setupfailed") {
        return ["status" => "error", "msg" => "安装发生错误,请重新安装！"];
    }
    $result["status"] = "success";
    if ($state_code == "running") {
        $result["data"]["status"] = "on";
        $result["data"]["des"] = "运行中";
    } else {
        if ($state_code == "off") {
            $result["data"]["status"] = "off";
            $result["data"]["des"] = "停止中";
        } else {
            if ($state_code == "overbw") {
                $result["data"]["status"] = "off";
                $result["data"]["des"] = "关机";
            } else {
                if ($state_code == "overdue") {
                    $result["data"]["status"] = "suspend";
                    $result["data"]["des"] = "到期关机";
                } else {
                    if ($sta == "locked") {
                        $result["data"]["status"] = "suspend";
                        $result["data"]["des"] = "锁定";
                    } else {
                        if ($sta == "unknown") {
                            $result["data"]["status"] = "unknown";
                            $result["data"]["des"] = "未知状态";
                        }
                    }
                }
            }
        }
    }
    return $result;
}
function rstackvhost_AdminButtonHide($params)
{
    if (rstackvhost_GetServerid($params) && 0 < $params["serverid"]) {
        return ["CreateAccount"];
    }
    return ["SuspendAccount", "UnsuspendAccount", "TerminateAccount", "CrackPassword", "Sync"];
}
function rstackvhost_GetServerid($params)
{
    return (int) $params["customfields"]["vserverid"];
}
function rstackvhost_CreateSign($token = "")
{
    $res["api_timestamp"] = time();
    $res["api_random"] = randStr(6);
    $res["api_sign"] = strtolower(md5($token . $res["api_random"] . $res["api_timestamp"]));
    $res["api_type"] = virtualType;
    $res["api_language"] = "chinese";
    return $res;
}
function rstackvhost_sign($apikey)
{
    $api_timestamp = time();
    $api_random = rstackvhost_GetRandStr(16);
    $api_sign = md5($apikey . $api_random . $api_timestamp);
    return ["api_sign" => $api_sign, "api_timestamp" => $api_timestamp, "api_random" => $api_random, "api_language" => "chinese", "api_type" => virtualType];
}
function rstackvhost_GetRandStr($length)
{
    $str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $len = strlen($str) - 1;
    $randstr = "";
    for ($i = 0; $i < $length; $i++) {
        $num = mt_rand(0, $len);
        $randstr .= $str[$num];
    }
    return $randstr;
}
function rstackvhost_CheckReturn($str)
{
    $tmp = explode("|", $str);
    if (2 < count($tmp)) {
        return ["code" => "-1", "msg" => "API返回格式不能出现多个|符号"];
    }
    if (count($tmp) == 2) {
        return ["code" => $tmp[0], "msg" => $tmp[1]];
    }
    if ($str == "0") {
        return ["code" => $str, "msg" => ""];
    }
    return ["code" => $tmp[0], "msg" => $tmp[1]];
}
function rstackvhost_post($url, $header, $data)
{
    $cUrl = curl_init();
    curl_setopt($cUrl, CURLOPT_URL, $url);
    curl_setopt($cUrl, CURLOPT_TIMEOUT, 600);
    curl_setopt($cUrl, CURLOPT_POST, true);
    curl_setopt($cUrl, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($cUrl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($cUrl, CURLOPT_HTTPHEADER, $header);
    curl_setopt($cUrl, CURLOPT_HEADER, true);
    curl_setopt($cUrl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($cUrl, CURLOPT_SSL_VERIFYHOST, false);
    $output = curl_exec($cUrl);
    $headerSize = curl_getinfo($cUrl, CURLINFO_HEADER_SIZE);
    $body = substr($output, $headerSize);
    curl_close($cUrl);
    return $body;
}

?>