CREATE TABLE `shd_certssl_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `p_id` int(11) NOT NULL DEFAULT '0' COMMENT 'cert产品ID',
  `brand_name` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `brand_type` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌类型',
  `cert_type` varchar(255) NOT NULL DEFAULT '' COMMENT '证书类型',
  `rep_csr` int(1) NOT NULL DEFAULT '1' COMMENT 'csr是否可更换',
  `algorithm` varchar(100) NOT NULL DEFAULT '' COMMENT '算法支持',
  `dcv_token` int(1) NOT NULL DEFAULT '1' COMMENT 'dcvToken是否可以重新生成',
  `server_name` varchar(100) NOT NULL DEFAULT '' COMMENT 'server 模块名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4;
insert  into `shd_certssl_product`(`id`,`p_id`,`brand_name`,`brand_type`,`cert_type`,`rep_csr`,`algorithm`,`dcv_token`,`server_name`) values (1,119,'GeoTrust','single|Multi|Pan|Wildcard','dv',1,'RSA',1,'certbase'),(2,120,'RapidSSL','single','dv',0,'RSA',1,'certbase'),(3,121,'RapidSSL','Wildcard','dv',0,'RSA',1,'certbase'),(4,127,'DigiCert','single|Multi|Pan|Wildcard','ev',1,'RSA|ECC',1,'certbase'),(5,125,'DigiCert','single|Multi|Pan|Wildcard','ov',1,'RSA|ECC',1,'certbase'),(6,129,'Secure_Site','single|Multi|Pan|Wildcard','ev',1,'RSA|ECC',1,'certbase'),(7,131,'Secure_Site','single|Multi|Pan|Wildcard','ov',1,'RSA|ECC',1,'certbase'),(8,138,'Thawte','single|Multi|Pan|Wildcard','ev',1,'RSA',1,'certbase'),(9,142,'Secure_Site_China','single|Multi|Pan|Wildcard','ov',1,'RSA|ECC',1,'certbase'),(10,145,'Secure_Site_China','single|Multi|Pan|Wildcard','ev',1,'RSA|ECC',1,'certbase'),(11,147,'GeoTrust_China','single|Multi|Pan|Wildcard','ov',1,'RSA|ECC',1,'certbase'),(12,150,'GeoTrust_China','single|Multi|Pan|Wildcard','ev',1,'RSA|ECC',1,'certbase'),(13,152,'GeoTrust','single|Multi|Pan|Wildcard','ov',1,'RSA|ECC',1,'certbase'),(14,155,'GeoTrust','single|Multi|Pan|Wildcard','ev',1,'RSA|ECC',1,'certbase'),(15,157,'Thawte','single|Multi|Pan|Wildcard','dv',1,'RSA',1,'certbase'),(16,160,'Thawte','single|Multi|Pan|Wildcard','ov',1,'RSA',1,'certbase'),(17,173,'Secure_Site_Pro','single|Multi|Pan|Wildcard','ov',1,'RSA|ECC',1,'certbase'),(18,174,'Secure_Site_Pro','single|Multi|Pan|Wildcard','ev',1,'RSA|ECC',1,'certbase'),(19,176,'AlphaSSL','single','dv',0,'RSA',0,'certbase'),(20,177,'AlphaSSL','Wildcard','dv',0,'RSA',0,'certbase'),(21,178,'GlobalSign','single','dv',0,'RSA|ECC',0,'certbase'),(22,179,'GlobalSign','Wildcard','dv',0,'RSA|ECC',0,'certbase'),(23,182,'GlobalSign','single|Multi|Pan|Wildcard','ov',0,'RSA|ECC',0,'certbase'),(24,185,'GlobalSign','single|Multi|Pan|Wildcard','ev',0,'RSA|ECC',0,'certbase'),(25,114,'Bitcert','single|Multi|Pan|Wildcard','dv',0,'RSA|ECC',0,'certbase');
CREATE TABLE `shd_certssl_orderinfo` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '证书年限，免费证书没有年限',
  `dcvMethod` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'dns' COMMENT '域名验证方式 file,dns',
  `csr` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'csr',
  `domainNames` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '域名信息，多域名逗号隔开',
  `lastname` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '姓',
  `firstname` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '名',
  `position` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '职位',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '邮箱',
  `telephone` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '电话',
  `orgName` varchar(200) COLLATE utf8_unicode_ci NOT NULL COMMENT '公司名称',
  `creditCode` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '社会信用代码',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '国家',
  `province` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '省份或州',
  `locality` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '城市',
  `address` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '地址',
  `postalCode` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '邮编',
  `joiCountry` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '注册国家',
  `joiProvince` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '注册省份或州',
  `joiLocality` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '注册城市',
  `registryAddr` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '注册地址',
  `dateOfIncorporation` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '注册日期',
  `certID` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '证书编号',
  `orderNo` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '第三方订单编号',
  `hostid` int(11) NOT NULL DEFAULT '0' COMMENT '产品id',
  `cert_pid` int(11) NOT NULL DEFAULT '0' COMMENT '第三方的产品id',
  `cost` int(11) NOT NULL DEFAULT '0' COMMENT '订单金额（分）',
  `priceDiff` int(11) NOT NULL DEFAULT '0' COMMENT '重签插价（分）',
  `csr_key` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'csr_key',
  `is_csr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是自行上传 1 是 0 自动生成',
  `issus_time` int(11) DEFAULT '0' COMMENT '签发时间',
  `company_phone` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '公司电话',
  `used_domainNames` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '主域名信息，单个',
  `certPrepareStatus` int(4) NOT NULL DEFAULT '0' COMMENT '证书准备状态  2001 未验证 | 2002 已验证',
  `certStatus` int(4) NOT NULL DEFAULT '0' COMMENT '证书状态 3002 | 3003 | 3004 | 3005 | 3006',
  `dcvStatus` int(4) NOT NULL DEFAULT '0' COMMENT '域名验证状态 2000 不需要此验证 | 2001 未验证 | 2002 已验证',
  `isReSignOrder` enum('Y','N') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N' COMMENT '是否为重签订单(我们没有重签)',
  `orderStatus` int(4) NOT NULL DEFAULT '0' COMMENT '订单状态',
  `ovValidationStatus` int(4) NOT NULL DEFAULT '0' COMMENT 'ov证书企业验证状态 2000 不需要此验证  2001 未验证 | 2002 已验证',
  `evValidationStatus` int(4) NOT NULL DEFAULT '0' COMMENT 'ev证书企业验证状态 2000 不需要此验证  2001 未验证 | 2002 已验证',
  `down_path` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '证书下载路径',
  `due_time` int(11) NOT NULL DEFAULT '0' COMMENT '到期时间',
  `server_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'server 模块标识',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `shd_certssl_download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `co_id` int(11) NOT NULL DEFAULT '0' COMMENT 'certssl_orderinfo id',
  `certContent` text NOT NULL COMMENT '证书',
  `midCertContent` text NOT NULL COMMENT '中间证书',
  `notBefore` varchar(20) NOT NULL DEFAULT '0' COMMENT '证书签发日期(毫秒)',
  `notAfter` varchar(20) NOT NULL DEFAULT '0' COMMENT '证书到期日期（毫秒）',
  `privatekey` varchar(100) NOT NULL DEFAULT '' COMMENT '私钥（用户自己生成的置空）',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4;