# -*- coding: utf-8 -*-
import os
import sys

import urllib
import requests
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmcvfs
import urllib3
import re
#import json
#import random
#import time

try:
    from urllib.parse import urlencode, quote_plus, quote, unquote, parse_qsl
except ImportError:
    from urllib import urlencode, quote_plus, quote, unquote
    
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.betatv')

mode = addon.getSetting('mode')

baseurl='http://217.61.2.227/'
UA='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:98.0) Gecko/20100101 Firefox/98.0'

def build_url(query):
    return base_url + '?' + urlencode(query)


def getChannels():
    url='http://217.61.2.227/'
    resp=requests.get(url).text
    ch_block=resp.split('<div class=\"channels')
    st=ch_block[1].split('</li>')
    channels=[]
    for c in st:
        if 'href' in c:
            title=re.compile('title=\"(.*)\" href').findall(c)[0]
            link=re.compile('href=\"(.*)\" target').findall(c)[0]
            img=re.compile('img src=\"(.*)\">').findall(c)[0]
            channels.append([title,link,img])
    return channels

def channelList():
    channels=getChannels()
    for c in channels:
        img=baseurl+c[2]
        li=xbmcgui.ListItem(c[0])
        li.setProperty("IsPlayable", 'true')
        li.setInfo(type='video', infoLabels={'title': c[0],'sorttitle': c[0],'plot': ''})
        li.setArt({'thumb': img, 'poster': '', 'banner': '', 'icon': img, 'fanart': img})
        url_stream = build_url({'mode':'play','url':c[1]})
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url_stream, listitem=li, isFolder=False)
    xbmcplugin.endOfDirectory(addon_handle)


def PlayStream(link):
    hea={'Referer':baseurl, 'User-Agent':UA}
    resp=requests.get('http:'+link, headers=hea).text
    u=re.compile('source src=\"(.*)\" type').findall(resp)
    print(u)
    if len(u)>0:
        if not u[0].startswith('http'):
            u[0]='http:'+u[0]
        stream_url=u[0]+'|Referer='+link+'&User-Agent='+UA
        play_item = xbmcgui.ListItem(path=stream_url)
        play_item.setProperty("IsPlayable", "true")
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    else:
        xbmcgui.Dialog().notification('[COLOR orangered][B]Error[/B][/COLOR]', '[COLOR orangered][B]Brak sygnału[/B][/COLOR]', '', 5000)
        return


mode = params.get('mode', None)

if not mode:
    channelList()
else:
    if mode=='play':
        link=params.get('url')
        PlayStream(link)
    
