# -*- coding: utf-8 -*-
import os
import sys

import requests
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmcvfs
import re
#import base64
#import unicodedata
#import json
#import random
#import time
#from resources.lib import jsunpack
from urllib.parse import urlencode, quote_plus, quote, unquote, parse_qsl

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.replaymatches')
PATH=addon.getAddonInfo('path')
img_empty=PATH+'/resources/empty.png'

mode = addon.getSetting('mode')
baseurl='http://www.replaymatches.net'
UA='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:98.0) Gecko/20100101 Firefox/98.0'

def build_url(query):
    return base_url + '?' + urlencode(query)

def main_menu():
    sources=[
        ['HOME',''],
        ['PREMIER LEAGUE','Premier%20League'],
        ['LA LIGA','La%20Liga'],
        ['SERIE A','Serie%20A'],
        ['BUNDESLIGA','Bundesliga'],
        ['LIGUE 1','Ligue%201'],
        ['UEFA',''],
        ['FIFA','']
    ]
    for s in sources:
        li=xbmcgui.ListItem(s[0])
        li.setProperty("IsPlayable", 'false')
        li.setInfo(type='video', infoLabels={'title': '','sorttitle': '','plot': ''})
        li.setArt({'thumb': '', 'poster': '', 'banner': '', 'icon': 'OverlayUnwatched.png', 'fanart':''})
        url = build_url({'mode':'subcategs','categ':s[0],'link':s[1]})
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True)
    
    li=xbmcgui.ListItem('[COLOR=orange]Search[/COLOR]')
    li.setProperty("IsPlayable", 'false')
    li.setInfo(type='video', infoLabels={'title': '','sorttitle': '','plot': ''})
    li.setArt({'thumb': '', 'poster': '', 'banner': '', 'icon': 'OverlayUnwatched.png', 'fanart':''})
    url = build_url({'mode':'search'})
    xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True)
    
    xbmcplugin.endOfDirectory(addon_handle)

def subcategs(l,c):
    subCategs=[
        ['PREMIER LEAGUE','FA%20Cup'],
        ['PREMIER LEAGUE','FA%20Community%20Shield'],
        ['PREMIER LEAGUE','England%20League%20Cup'],
        ['LA LIGA','Copa%20del%20Rey',''],
        ['LA LIGA','Spanish%20Super%20Cup',''],
        ['SERIE A','Coppa%20Italia',''],
        ['SERIE A','Italian%20Super%20Cup',''],
        ['BUNDESLIGA','DFB%20Pokal',''],
        ['BUNDESLIGA','German%20Super%20Cup',''],
        ['LIGUE 1','Coupe%20De%20France',''],
        ['LIGUE 1','Coupe%20De%20La%20Ligue',''],
        ['LIGUE 1','France%20Super%20Cup',''],
        ['UEFA','UCL',''],
        ['UEFA','UEL',''],
        ['UEFA','UEFA%20Nations%20League',''],
        ['UEFA','Euro%20Qualifiers',''],
        ['UEFA','Euro',''],
        ['FIFA','World%20Cup',''],
        ['FIFA','WC%20Qualification',''],
        ['FIFA','FRIENDLIES',''],
        ['FIFA','Confederations%20Cup',''],
        ['FIFA','Gold%20Cup',''],
        ['FIFA','Copa%20America',''],
        ['FIFA','Africa%20Cup%20of%20Nations','']
    ]
    
    counter=0
    for s in subCategs:
        if s[0]==c:
            counter +=1
            title=s[1].replace('%20',' ')
            li=xbmcgui.ListItem(title)
            li.setProperty("IsPlayable", 'false')
            li.setInfo(type='video', infoLabels={'title': title,'sorttitle': title,'plot': ''})
            li.setArt({'thumb': '', 'poster': '', 'banner': '', 'icon': 'OverlayUnwatched.png', 'fanart':''})
            url = build_url({'mode':'videoList','link':s[1],'page':'0','query':False})
            xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True)
    
    if counter>0:
        title='Video'
        li=xbmcgui.ListItem('[B][COLOR=yellow]'+title+'[/COLOR][/B]')
        li.setProperty("IsPlayable", 'false')
        li.setInfo(type='video', infoLabels={'title': title,'sorttitle': title,'plot': ''})
        li.setArt({'thumb': '', 'poster': '', 'banner': '', 'icon': 'OverlayUnwatched.png', 'fanart':''})
        url = build_url({'mode':'videoList','link':l,'page':'0','query':False})
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle)
    else:
        videoList('','0','False')
    
    
   
def videoList(l,p,query):
    count=50
    if query=='False':
        u=baseurl+'/search?max-results='+str(count)+'&start='+str(int(p)*count)+'&by-date=true'
        if l !='None':
            u=u.replace('search','search/label/'+l)
    else:
        u=baseurl+'/search?q='+query+'&max-results='+str(count)+'&by-date=true'
    hea={
        'referer':baseurl+'/',
        'User-Agent':UA
    }
    print(u)
    resp=requests.get(u, headers=hea).text
    resp1=resp.split('blog-posts hfeed')[1].split('blog-pager')[0].split('</article>')
    items=[]
    for r in resp1:
        if 'content' in r:
            img=re.compile('<a content=\'([^\']+?)\'').findall(r)[0]
            link,tit=re.compile('<a href=\'([^\']+?)\' title=\'([^\']+?)\'').findall(r)[1]
            items.append([tit,link,img])
    
    for i in items:
        img=i[2]
        li=xbmcgui.ListItem(i[0])
        li.setProperty("IsPlayable", 'false')
        li.setInfo(type='video', infoLabels={'title': i[0],'sorttitle': i[0],'plot': ''})
        li.setArt({'thumb': img, 'poster': img, 'banner': img, 'icon': img, 'fanart':img})
        url = build_url({'mode':'videos','link':i[1]})
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=True)
    
    if len(items)==count:
        li=xbmcgui.ListItem('[COLOR yellow]>>> następna strona[/COLOR]')
        li.setProperty("IsPlayable", 'false')
        li.setInfo(type='video', infoLabels={'title': '','sorttitle': '','plot': ''})
        li.setArt({'thumb': 'img_empty', 'poster': 'img_empty', 'banner': 'img_empty', 'icon': 'img_empty', 'fanart': ''})
        url_cont = build_url({'mode':'videoList','link':l,'page':str(int(p)+1),'query':query})
        xbmcplugin.addDirectoryItem(handle=addon_handle, url=url_cont, listitem=li, isFolder=True)
    
    xbmcplugin.endOfDirectory(addon_handle)

def videos(l):
    hea={
        'referer':baseurl+'/',
        'User-Agent':UA
    }
    resp=requests.get(l, headers=hea).text
    link_tit=re.compile('link-iframe\" href=\"([^"]+?)\"[^<]+?>([^<]+?)</a>').findall(resp)
    if len(link_tit)>0:
        for link,title in link_tit:
            li=xbmcgui.ListItem(title)
            li.setProperty("IsPlayable", 'true')
            li.setInfo(type='video', infoLabels={'title': title,'sorttitle': title,'plot': ''})
            li.setArt({'thumb': '', 'poster': '', 'banner': '', 'icon': 'OverlayUnwatched.png', 'fanart':''})
            url = build_url({'mode':'playSource','link':link})
            xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=False)
        xbmcplugin.endOfDirectory(addon_handle)
    else:
        link=re.compile('iframe1\" src=\"([^"]+?)\"').findall(resp)
        if len(link)!=0:
            title='Watch'
            li=xbmcgui.ListItem(title)
            li.setProperty("IsPlayable", 'true')
            li.setInfo(type='video', infoLabels={'title': title,'sorttitle': title,'plot': ''})
            li.setArt({'thumb': '', 'poster': '', 'banner': '', 'icon': 'OverlayUnwatched.png', 'fanart':''})
            url = build_url({'mode':'playSource','link':link[0]})
            xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li, isFolder=False)
            xbmcplugin.endOfDirectory(addon_handle)
        else:
            xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem())

def playSource(l): 
    if 'hdmatchessa' in l:
        url=l.replace('player/PopUpIframe','embed').split('?')[0]+'?autoplay=1&htmlplayer=1'
        hea={
            'referer':baseurl+'/',
            'User-Agent':UA
        }
        resp=requests.get(url,headers=hea).text
        url_stream=re.compile('hls:\'([^\']+?)\'').findall(resp)[0]
        if url_stream.startswith('//'):
            url_stream='https:'+url_stream
    
    else:   
        import resolveurl
        url_stream=resolveurl.resolve(l)
    play_item = xbmcgui.ListItem(path=url_stream)
    play_item.setProperty("IsPlayable", "true")
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)   
    
mode = params.get('mode', None)

if not mode:
    main_menu()
else:
    if mode=='subcategs':
        l=params.get('link')
        c=params.get('categ')
        subcategs(l,c)
        
    if mode=='videoList':
        l=params.get('link')
        p=params.get('page')
        query=params.get('query')
        videoList(l,p,query)
        
    if mode=='videos':
        l=params.get('link')
        videos(l)
        
    if mode=='search':
        query = xbmcgui.Dialog().input(u'Szukaj, Podaj tytuł:', type=xbmcgui.INPUT_ALPHANUM)
        if query:
           videoList('','0',query)
    
    if mode=='playSource':
        l=params.get('link')
        playSource(l)
