import socket
import requests
import threading
import http
from base64 import b64decode
from http import HTTPStatus
from http.server import ThreadingHTTPServer, BaseHTTPRequestHandler
from io import BytesIO

import json
import m3u8
from urllib.parse import urlparse, parse_qs, urlencode

import xbmcaddon, xbmc

import traceback
from warnings import simplefilter

simplefilter("ignore")
try:
    import zlib
except ImportError:
    zlib = None

# Generators for HTTP compression
def _zlib_producer(fileobj, wbits):
    """Generator that yields data read from the file object fileobj,
    compressed with the zlib library.
    wbits is the same argument as for zlib.compressobj.
    """
    bufsize = 2 << 17
    producer = zlib.compressobj(wbits=wbits)
    with fileobj:
        while True:
            buf = fileobj.read(bufsize)
            if not buf:  # end of file
                yield producer.flush()
                return
            yield producer.compress(buf)


def _gzip_producer(fileobj):
    """Generator for gzip compression."""
    return _zlib_producer(fileobj, 31)


def _deflate_producer(fileobj):
    """Generator for deflate compression."""
    return _zlib_producer(fileobj, 15)


"""
Some Kodi Threading/sub-interpeter bullshit
"""
import ssl
from urllib3.util.ssltransport import SSLTransport

SSL_BLOCKSIZE = 16384


def _wrap_ssl_read(self, len, buffer=None):
    try:
        return self._ssl_io_loop(self.sslobj.read, len, buffer)
    except Exception as e:
        if e.errno == ssl.SSL_ERROR_EOF and self.suppress_ragged_eofs:
            return 0  # eof, return 0.
        else:
            raise


def _ssl_io_loop(self, func, *args):
    """Performs an I/O loop between incoming/outgoing and the socket."""
    should_loop = True
    ret = None
    while should_loop:
        errno = None
        try:
            ret = func(*args)
        except Exception as e:
            if e.errno not in (ssl.SSL_ERROR_WANT_READ, ssl.SSL_ERROR_WANT_WRITE):
                # WANT_READ, and WANT_WRITE are expected, others are not.
                raise e
            errno = e.errno

        buf = self.outgoing.read()
        self.socket.sendall(buf)

        if errno is None:
            should_loop = False
        elif errno == ssl.SSL_ERROR_WANT_READ:
            buf = self.socket.recv(SSL_BLOCKSIZE)
            if buf:
                self.incoming.write(buf)
            else:
                self.incoming.write_eof()
    return ret


SSLTransport._wrap_ssl_read = _wrap_ssl_read
SSLTransport._ssl_io_loop = _ssl_io_loop


def find_free_port():
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        s.bind(("127.0.0.1", 0))
        return s.getsockname()[1]


def filter_best(playlist, maxbr):
    """delete all other streams to speed up ffmpeg"""
    best = max(
        filter(lambda pl: pl.stream_info.bandwidth <= maxbr, playlist.playlists),
        key=lambda pl: pl.stream_info.bandwidth,
    )
    playlist.playlists.clear()
    playlist.playlists.append(best)

    # media_list = playlist.media.copy()
    # playlist.media.clear()
    # for media in filter(lambda media: media.name == "English", media_list):
    # playlist.playlists.append(media)


def mlb_add_chapters(playlist):
    """try to fix mlb.com ad breaks"""
    ads = False
    playlist.discontinuity_sequence = 0
    for segment in playlist.segments:
        if "dai.google.com" in segment.uri:
            if ads:
                pass
            else:
                segment.discontinuity = True
                ads = True
        else:
            if ads:
                segment.discontinuity = True
                ads = False
            else:
                pass


def media66_key(key_uri):
    if "mf.svc.nhl.com" in key_uri:
        return key_uri.replace("mf.svc.nhl.com", "api.nhl66.ir/api/get_key_url")
    elif "playback.svcs.mlb.com" in key_uri:
        return key_uri.replace("playback.svcs.mlb.com", "api.mlb66.ir/api/get_key_url")
    else:
        return key_uri


class HLSProxyServer(ThreadingHTTPServer):
    def __init__(self, server_address, RequestHandlerClass, bind_and_activate=True):
        self.s = requests.Session()
        super(ThreadingHTTPServer, self).__init__(server_address, RequestHandlerClass, bind_and_activate=True)

    def handle_error(self, request, client_address):
        print(repr(request))


class HLSProxyRequestHandler(BaseHTTPRequestHandler):
    protocol_version = "HTTP/1.1"

    compressions = {}
    if zlib:
        compressions = {
            "deflate": _deflate_producer,
            "gzip": _gzip_producer,
            "x-gzip": _gzip_producer,  # alias for gzip
        }

    def _make_chunk(self, data):
        """Make a data chunk in Chunked Transfer Encoding format."""
        return f"{len(data):X}".encode("ascii") + b"\r\n" + data + b"\r\n"

    def do_HEAD(self):
        self.do_GET()

    def do_GET(self):
        url = urlparse(self.path)
        path = url.path
        query = parse_qs(url.query)

        proxies = {}
        if "__hls_http_proxy" in query:
            proxies["http"] = query["__hls_http_proxy"][0]
            proxies["https"] = query["__hls_http_proxy"][0]

        request_headers = {}
        if "Origin" in self.headers:
            request_headers["Origin"] = self.headers["Origin"]
        if "Referer" in self.headers:
            request_headers["Referer"] = self.headers["Referer"]
        if "User-Agent" in self.headers:
            request_headers["User-Agent"] = self.headers["User-Agent"]

        response = None
        ctype = None
        try:
            if path == "/segment-proxy.ts":
                _origin_seg_url = query["__hls_origin_seg_url"][0]
                r = self.server.s.get(_origin_seg_url, headers=request_headers, proxies=proxies, timeout=5, stream=True)
                r.raise_for_status()
                response = r
                ctype = r.headers["Content-Type"]
            elif path == "/key-proxy.key":
                _origin_seg_url = query["__hls_origin_key_url"][0]
                r = self.server.s.get(
                    _origin_seg_url, headers=request_headers, proxies=proxies, timeout=5, stream=True, verify=False
                )
                r.raise_for_status()
                response = r
                ctype = r.headers["Content-Type"]
            elif path == "/hls.key":
                response = BytesIO(b64decode(query["__hls_key"][0]))
                ctype = "application/octet-stream"
            elif path == "/lazy.m3u8":
                _headers = {}
                if "User-Agent" in request_headers:
                    _headers["User-Agent"] = request_headers["User-Agent"]
                _origin_url = query["__hls_origin_url"][0]
                r = self.server.s.get(_origin_url, headers=request_headers, proxies=proxies, timeout=5)
                r.raise_for_status()
                playlist = m3u8.loads(r.content.decode("utf-8"), uri=_origin_url)
                for key in playlist.keys:
                    if key.uri:
                        if "__hls_lazy_server" in query:
                            query["__hls_origin_key_url"] = (
                                urlparse(key.uri)._replace(netloc=query["__hls_lazy_server"][0]).geturl()
                            )
                            key.uri = "key-proxy.key?" + urlencode(query, doseq=True)
                        elif "__hls_keys" in query:
                            _keys = json.loads(query["__hls_keys"][0])
                            if key.uri in _keys:
                                key.uri = "hls.key?" + urlencode({"__hls_key": _keys[key.uri]}, doseq=True)
                            else:
                                query["__hls_origin_key_url"] = media66_key(key.uri)
                                key.uri = "key-proxy.key?" + urlencode(query, doseq=True)
                if playlist.is_variant is True:
                    if "__hls_bitrate" in query:
                        filter_best(playlist, int(query["__hls_bitrate"][0]))
                    for media in playlist.media:
                        if media.uri:
                            query["__hls_origin_url"] = media.absolute_uri
                            media.uri = "lazy.m3u8?" + urlencode(query, doseq=True)
                    for pl in playlist.playlists:
                        if pl.uri:
                            query["__hls_origin_url"] = pl.absolute_uri
                            pl.uri = "lazy.m3u8?" + urlencode(query, doseq=True)
                else:
                    if "gdfp.m3u8" in _origin_url:
                        mlb_add_chapters(playlist)
                    for segment in playlist.segments:
                        segment.uri = segment.absolute_uri
                response = BytesIO(playlist.dumps().encode("utf-8"))
                ctype = r.headers["Content-Type"]
            elif path == "/lazy_proxy.m3u8":
                _headers = {}
                if "User-Agent" in request_headers:
                    _headers["User-Agent"] = request_headers["User-Agent"]
                _origin_url = query["__hls_origin_url"][0]
                r = self.server.s.get(_origin_url, headers=request_headers, proxies=proxies, timeout=5)
                r.raise_for_status()
                playlist = m3u8.loads(r.content.decode("utf-8"), uri=_origin_url)
                for key in playlist.keys:
                    if key.uri:
                        if "__hls_lazy_server" in query:
                            query["__hls_origin_key_url"] = (
                                urlparse(key.uri)._replace(netloc=query["__hls_lazy_server"][0]).geturl()
                            )
                            key.uri = "key-proxy.key?" + urlencode(query, doseq=True)
                        elif "__hls_keys" in query:
                            _keys = json.loads(query["__hls_keys"][0])
                            if key.uri in _keys:
                                key.uri = "hls.key?" + urlencode({"__hls_key": _keys[key.uri]}, doseq=True)
                            else:
                                query["__hls_origin_key_url"] = media66_key(key.uri)
                                key.uri = "key-proxy.key?" + urlencode(query, doseq=True)
                if playlist.is_variant is True:
                    if "__hls_bitrate" in query:
                        filter_best(playlist, int(query["__hls_bitrate"][0]))
                    for media in playlist.media:
                        if media.uri:
                            query["__hls_origin_url"] = media.absolute_uri
                            media.uri = "lazy_proxy.m3u8?" + urlencode(query, doseq=True)
                    for pl in playlist.playlists:
                        if pl.uri:
                            query["__hls_origin_url"] = pl.absolute_uri
                            pl.uri = "lazy_proxy.m3u8?" + urlencode(query, doseq=True)
                else:
                    if "gdfp.m3u8" in _origin_url:
                        mlb_add_chapters(playlist)
                    for segment in playlist.segments:
                        query["__hls_origin_seg_url"] = segment.absolute_uri
                        segment.uri = "segment-proxy.ts?" + urlencode(query, doseq=True)
                response = BytesIO(playlist.dumps().encode("utf-8"))
                ctype = r.headers["Content-Type"]
            else:
                self.send_error(HTTPStatus.INTERNAL_SERVER_ERROR)
                self.end_headers()
                return
        except:
            traceback.print_exc()
            self.send_error(HTTPStatus.INTERNAL_SERVER_ERROR)
            self.end_headers()
            return

        self.send_response_only(HTTPStatus.OK)
        self.send_header("Content-type", ctype)

        if type(response) == BytesIO:
            # Use HTTP compression if possible

            # Get accepted encodings ; "encodings" is a dictionary mapping
            # encodings to their quality ; eg for header "gzip; q=0.8",
            # encodings["gzip"] is set to 0.8
            accept_encoding = self.headers.get_all("Accept-Encoding", ())
            encodings = {}
            for accept in http.cookiejar.split_header_words(accept_encoding):
                params = iter(accept)
                encoding = next(params, ("", ""))[0]
                quality, value = next(params, ("", ""))
                if quality == "q" and value:
                    try:
                        q = float(value)
                    except ValueError:
                        # Invalid quality : ignore encoding
                        q = 0
                else:
                    q = 1  # quality defaults to 1
                if q:
                    encodings[encoding] = max(encodings.get(encoding, 0), q)

            compressions = set(encodings).intersection(self.compressions)
            compression = None
            if compressions:
                # Take the encoding with highest quality
                compression = max((encodings[enc], enc) for enc in compressions)[1]
            elif "*" in encodings and self.compressions:
                # If no specified encoding is supported but "*" is accepted,
                # take one of the available compressions.
                compression = list(self.compressions)[1]
            else:
                # send gzip to ffmpeg anyway
                compression = list(self.compressions)[1]
            if compression:
                # If at least one encoding is accepted, send data compressed
                # with the selected compression algorithm.
                producer = self.compressions[compression]
                self.send_header("Content-Encoding", compression)
                self.send_header("Transfer-Encoding", "chunked")
                self.end_headers()
                # send data
                if self.command == "GET":
                    for data in producer(response):
                        if data:
                            self.wfile.write(self._make_chunk(data))
                        else:
                            continue
                    self.wfile.write(self._make_chunk(b""))
        else:
            self.send_header("Transfer-Encoding", "chunked")
            self.end_headers()

            if self.command == "GET":
                for data in response.iter_content(chunk_size=(16 * 1024)):
                    self.wfile.write(self._make_chunk(data))
                self.wfile.write(self._make_chunk(b""))


if __name__ == "__main__":
    host = ("127.0.0.1", find_free_port())
    hls_proxy = f"http://{host[0]}:{host[1]}/"
    server = HLSProxyServer(host, HLSProxyRequestHandler)
    addon = xbmcaddon.Addon()
    addon.setSetting("hls_proxy", hls_proxy)
    monitor = xbmc.Monitor()
    httpd = threading.Thread(target=server.serve_forever, daemon=True)
    httpd.start()
    xbmc.log(f"Too Lazy HLS Proxy running at {hls_proxy}", xbmc.LOGINFO)
    while not monitor.abortRequested():
        if monitor.waitForAbort(1):
            break
    server.shutdown()
    httpd.join(5)
