import xml.etree.ElementTree as ET
import json, requests

user_agent = 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36'
headers = {'User-Agent': user_agent}

class Parser:
	def __init__(self, url):
		self.url = url
	
	def get_list(self):
		if self.url.endswith('.xml'):
			try:
				xml = ET.fromstring(self.get_page().replace('&', '&amp;').replace("'", "&apos;").replace('"', '&quot;'))
			except ET.ParseError:
				xml = ET.fromstringlist(["<root>", self.get_page().replace('&', '&amp;').replace("'", "&apos;").replace('"', '&quot;'), "</root>"])
			item_list = []
			for item in xml:
				item_list.append({child.tag: child.text for child in item})
			return json.dumps({'items': item_list})	
		elif self.url.endswith('.json'):
			return json.dumps(self.get_page())
	
	def get_list_xtasy(self):
		if self.url.endswith('.xml'):
			try:
				xml = ET.fromstring('<xml>'.strip() + self.get_page().split('METHODS!!!-->')[-1].strip().replace('&', '&amp;').replace("'", "&apos;").replace('"', '&quot;').replace('<thumbnail></thumbnail>','').replace('<fanart></fanart>', '').strip())
			except ET.ParseError:
				xml = ET.fromstringlist(["<root>", '<xml>'.strip() + self.get_page().split('METHODS!!!-->')[-1].strip().replace('&', '&amp;').replace("'", "&apos;").replace('"', '&quot;').replace('<thumbnail></thumbnail>','').replace('<fanart></fanart>', '').strip(), "</root>"])
			item_list = []
			for item in xml:
				item_list.append({child.tag: child.text for child in item})
			return json.dumps({'items': item_list})	
		elif self.url.endswith('.json'):
			return json.dumps(self.get_page())

	def get_page(self):
		if self.url.startswith('http'):
			session = requests.Session()
			return session.get(self.url, headers=headers).text	
		else:
			return open(self.url).read()