#!/usr/bin/env python3
'''
    script to update streamlink for Kodi
'''
import fileinput

text_list = [
    {
        'file': 'resources/lib/streamlink/cache.py',
        'find': 'class Cache:',
        'replace': '''import xbmc
import xbmcvfs

try:
    xdg_cache = xbmc.translatePath('special://profile/addon_data/script.module.streamlink')
except:
    xdg_cache = xbmcvfs.translatePath('special://profile/addon_data/script.module.streamlink')
try:
    temp_dir = xbmc.translatePath('special://temp')
except:
    temp_dir = xbmcvfs.translatePath('special://temp')

cache_dir = os.path.join(xdg_cache, "streamlink")

temp_streamlink = os.path.join(temp_dir, 'script.module.streamlink')
if not xbmcvfs.exists(cache_dir):
    xbmcvfs.mkdirs(cache_dir)
if not xbmcvfs.exists(temp_streamlink):
    xbmcvfs.mkdirs(temp_streamlink)
\n\nclass Cache:''',
    },
    {
        'file': 'resources/lib/streamlink/cache.py',
        'find': '        fd, tempname = tempfile.mkstemp()',
        'replace': '        fd, tempname = tempfile.mkstemp(dir=temp_streamlink)',
    },
       
]


for data in text_list:
    with fileinput.FileInput(data['file'], inplace=True) as file:
        for line in file:
            print(line.replace(data['find'], data['replace']), end='')

