# -*- coding: utf-8 -*-


#Freedocast fix
#http://forum.xbmc.org/showthread.php?tid=100597&pid=1094333#pid1094333

import os, sys
import urllib
import xbmcplugin
import xbmc, xbmcgui
from xbmcaddon import Addon as Addon
try:
    import inputstreamhelper
except:
    pass

from . import common
from .utils import fileUtils as fu
from .utils.regexUtils import parseText
from .utils.xbmcUtils import getKeyboard, setSortMethodsForCurrentXBMCList
from .dialogs.dialogProgress import DialogProgress
from .parser import Parser, ParsingResult
from .downloader import Downloader
from .favouritesManager import FavouritesManager
from .entities import CListItem as ListItem
from .entities import CList as CList
from .utils import xbmcUtils
from .dialogs.dialogQuestion import DialogQuestion
from .customModulesManager import CustomModulesManager
from .utils.addon import Addon
from .customConversions import slresolve

#from cacheManager import CacheManager


class Mode:
    UPDATE = 0
    VIEW = 1
    PLAY = 2
    QUEUE = 3
    EXECUTE = 5
    ADDTOFAVOURITES = 6
    REMOVEFROMFAVOURITES = 7
    EDITITEM = 8
    ADDITEM = 9
    INSTALLADDON = 12
    CHROME = 13
    WEBDRIVER = 14
    SLPROXY = 15
    ADDONSETTINGS = 16
    SLRESOLVE = 17
    DOWNLOAD = 98
    REMOVEFROMCUSTOMMODULES = 99


class Main:

    MAIN_MENU_FILE = 'mainMenu.cfg'

    def __init__(self):

        if not os.path.exists(common.Paths.pluginDataDir):
            os.makedirs(common.Paths.pluginDataDir, mode=0o777)

        self.favouritesManager = FavouritesManager(common.Paths.favouritesFolder)
        self.parser = Parser()
        self.currentlist = None
        self.addon = None
        self.kodiver = float(xbmc.getInfoLabel('System.BuildVersion')[0:3])

        INPUTSTREAM_PROTOCOLS = {
            'mpd': 'inputstream.adaptive',
            'ism': 'inputstream.adaptive',
            'hls': 'inputstream.adaptive',
            'rtmp': 'inputstream.rtmp',
            'ts': 'inputstream.ffmpegdirect',
            'm3u': 'inputstream.ffmpegdirect'
        }

        try:
            inputstreamhelper.config.INPUTSTREAM_PROTOCOLS = INPUTSTREAM_PROTOCOLS
        except:
            pass

        common.log('SD initialized')
        # common.log('Running on Python %s'%(str(sys.version)))

    def playVideo(self, videoItem, isAutoplay=False, slr=False):
        # common.log(" player trying to play    " + videoItem['url'])
        if not videoItem:
            return

        if ('offline' in videoItem['url']):
            common.showInfo('Stream is offline - please try again later.')
            return

        if any(x in videoItem['url'] for x in ['slplugin://', 'hls://', 'hlsvariant://', 'httpstream://', 'hds://', 'akamaihd://']):
            self.playSLProxy(videoItem)
            return

        reslnk = ""
        if slr:
            reslnk = slresolve(videoItem['url'])
            videoItem['url'] = reslnk
            if reslnk and "streams.wilmaa.com" in reslnk:
                self.playSLProxy(videoItem)
                return            

        listitem = self.createXBMCListItem(videoItem)
        if listitem is None or reslnk is None: 
            return

        title = videoItem['videoTitle']
        if title:
            if self.kodiver > 19.8:
                vtag = listitem.getVideoInfoTag()
                vtag.setTitle(title)
            else:
                listitem.setInfo('video', {'title': title})

        if not isAutoplay:
            listitem.setProperty('IsPlayable', 'true')
            xbmcplugin.setResolvedUrl(self.handle, True, listitem)

        else:
            common.log(' player playing ... ' + videoItem['url'])
            url = urllib.parse.unquote_plus(videoItem['url'])
            xbmc.Player().play(url, listitem)

    def playSLProxy(self, videoItem):
        if not videoItem:
            return

        listitem = self.createXBMCListItem(videoItem)
        if listitem is None:
            return

        title = videoItem['videoTitle']
        url = videoItem['url']

        if title:
            if self.kodiver > 19.8:
                vtag = listitem.getVideoInfoTag()
                vtag.setTitle(title)
            else:
                listitem.setInfo('video', {'title': title})

        from dsp import streamlink_proxy
        slProxy = streamlink_proxy.SLProxy_Helper()
        slProxy.playSLink(url, listitem)
        pass

    def launchChrome(self, url, title):
        # action = 'RunPlugin(%s)' % ('plugin://plugin.program.chrome.launcher/?kiosk=yes&mode=showSite&stopPlayback=yes&url=' + url)
        '''thanks to udangaribaldi - use other browsers than chrome, too'''
        action = 'RunPlugin(%s)' % ('plugin://plugin.program.browser.launcher/?kiosk=no&mode=showSite&stopPlayback=yes&url=' + url)
        # common.log('chrome test:' + str(action))
        xbmc.executebuiltin(action)

    def playWebDriver(self, url, title):
        # try:
        #     import liveremote
        #     video = liveremote.resolve(url)
        #     liz = xbmcgui.ListItem(title)
        #     liz.setPath(video)
        #     liz.setProperty('IsPlayable','true')
        #     xbmc.Player().play(video, liz)
        # except:
        #     import sys,traceback
        #     traceback.print_exc(file = sys.stdout)
        #     common.showInfo('This is not the option you are looking for.')
        pass

    def getVideos(self, lItem, dia=None, percent=0, percentSpan=100):
        allitems = []

        if dia and dia.isCanceled():
            return allitems

        currentName = lItem['title']

        if lItem['type'].find('video') != -1:
            if dia:
                dia.update(percent + percentSpan, thirdline=currentName)
            allitems.append(lItem)
        else:
            tmpList = self.parser.parse(lItem).list
            if tmpList and len(tmpList.items) > 0:

                if dia:
                    dia.update(percent, secondline=currentName, thirdline=' ')

                inc = percentSpan / len(tmpList.items)
                for item in tmpList.items:

                    if dia and dia.isCanceled():
                        break

                    children = self.getVideos(item, dia, percent, inc)
                    if children:
                        allitems.extend(children)
                    percent += inc

        return allitems

    def getSearchPhrase(self):
        searchCache = os.path.join(common.Paths.cacheDir, 'search')
        default_phrase = fu.getFileContent(searchCache)
        if not default_phrase:
            default_phrase = ''

        search_phrase = common.showOSK(default_phrase, common.translate(30102))
        if search_phrase == '':
            return None
        xbmc.sleep(10)
        fu.setFileContent(searchCache, search_phrase)

        return search_phrase

    def parseView(self, lItem):

        def endOfDirectory(succeeded=True):
            if self.handle > -1:
                xbmcplugin.endOfDirectory(handle=self.handle, succeeded=succeeded, cacheToDisc=True)
            else:
                common.log('Handle -1')

        if not lItem:
            endOfDirectory(False)
            return None

        if lItem['type'] == 'search':
            search_phrase = self.getSearchPhrase()
            if not search_phrase:
                common.log("search canceled")
                endOfDirectory(False)
                return None
            else:
                lItem['type'] = 'rss'
                lItem['url'] = lItem['url'] % (urllib.parse.quote_plus(search_phrase))

        url = lItem['url']

        if url == common.Paths.customModulesFile:
            self.customModulesManager.getCustomModules()

        tmpList = None
        result = self.parser.parse(lItem)

        if result.code == ParsingResult.Code.SUCCESS:
            tmpList = result.list
        elif result.code == ParsingResult.Code.CFGFILE_NOT_FOUND:
            common.showError("Cfg file not found")
            endOfDirectory(False)
            return None
        elif result.code == ParsingResult.Code.CFGSYNTAX_INVALID:
            common.showError("Cfg syntax invalid")
            endOfDirectory(False)
            return None
        elif result.code == ParsingResult.Code.WEBREQUEST_FAILED:
            common.showError("Web request failed")
            if len(result.list.items) > 0:
                tmpList = result.list
            else:
                endOfDirectory(False)
                return None
        elif result.code == ParsingResult.Code.NO_EVENT_FOUND:
            common.showError("No events or streams available")
            endOfDirectory(False)
            return None

        # if it's the main menu, add folder 'Favourites'
        if url == self.MAIN_MENU_FILE:

            tmp['title'] = 'Favourites'
            tmp['type'] = 'rss'
            tmp['icon'] = os.path.join(common.Paths.imgDir, 'icons/favourites.png')
            tmp['url'] = str(common.Paths.favouritesFile)
            tmpList.items.insert(0, tmp)

        # if it's the favourites menu, add item 'Add item'
        elif url == common.Paths.favouritesFile or url.startswith('favfolders'):

            if url.startswith('favfolders'):
                url = os.path.normpath(os.path.join(common.Paths.favouritesFolder, url))

            tmp = ListItem.create()
            tmp['title'] = 'Add item...'
            tmp['type'] = 'command'
            tmp['icon'] = os.path.join(common.Paths.imgDir, 'icons/add_favourites.png')
            action = 'RunPlugin(%s)' % (self.base + '?mode=' + str(Mode.ADDITEM) + '&item=url=' + url)
            tmp['url'] = action
            tmpList.items.append(tmp)

        # Create menu or play, if it's a single video and autoplay is enabled
        count = len(tmpList.items)
        if (count == 0 and not url.startswith('favfolders')):
            common.showInfo('No events or streams available')
            # Directory with 0 items
            endOfDirectory(False)
        elif not (common.getSetting('autoplay') == 'true' and count == 1 and len(tmpList.getVideos()) == 1):
            # sort methods
            sortKeys = tmpList.sort.split('|')
            setSortMethodsForCurrentXBMCList(self.handle, sortKeys)
            # Add items to XBMC list
            for m in tmpList.items:
                self.addListItem(m, len(tmpList.items))
            # Directory with >1 items
            endOfDirectory(True)
        else:
            # Directory with 0 items
            endOfDirectory(False)

        return tmpList

    def createXBMCListItem(self, item):
        title = item['title']
        m_type = item['type']
        icon = item['icon']
        plot = item['plot']
        v_type = 'default'

        try:
            v_type = item['videoType'] if item['videoType'] is not None else 'default'
        except:
            v_type = 'default'

        if icon and not icon.startswith('http'):
            try:
                if not fu.fileExists(icon):
                    tryFile = os.path.join(common.Paths.modulesDir, icon)
                    if not fu.fileExists(tryFile):
                        tryFile = os.path.join(common.Paths.customModulesDir, icon)
                    if fu.fileExists(tryFile):
                        icon = tryFile
            except:
                pass

        if not icon:
            if m_type == 'video':
                icon = common.Paths.defaultVideoIcon
            else:
                icon = common.Paths.defaultCategoryIcon

        fanart = item['fanart']
        if not fanart:
            fanart = common.Paths.pluginFanart

        liz = xbmcgui.ListItem(title)
        liz.setArt({'thumb': icon, 'fanart': fanart})

        if self.kodiver > 19.8:
            vtag = liz.getVideoInfoTag()
            vtag.setTitle(title)
            vtag.setPlot(plot)
        else:
            # use infolabels to pass commands?
            infoLabels = {}
            # for video_info_name in item.infos.keys():
            #     infoLabels[video_info_name] = item[video_info_name]
            infoLabels['title'] = title
            infoLabels["plot"] = plot
            liz.setInfo('video', infoLabels)

        if m_type == 'video':
            liz.setProperty('IsPlayable', 'true')

        try:
            url = urllib.parse.unquote_plus(item['url'])
        except:
            url = ""
            liz.setProperty('IsPlayable', 'false')

        liz.setPath(url)

        if title is not None and title.startswith('nohead'):
            try:
                liz.setMimeType('video/x-mpegts')
                liz.setContentLookup(False)
            except:
                pass

        if '.m3u8' in url:
            liz.setMimeType('application/vnd.apple.mpegurl')
            liz.setContentLookup(False)

        if any(x in url for x in ['rtmp://', 'rtmpe://', 'rtmps://', 'rtmpt://']):
            try:
                helper = inputstreamhelper.Helper('rtmp')
                if not helper.check_inputstream():
                    return None
            except:
                return None

        if v_type is not None and v_type != 'default' and common.getSetting("adaptive") == "true" and v_type.startswith('adaptive_'):
            try:
                # if xbmc.getCondVisibility("System.HasAddon(inputstream.adaptive)"): #\
                # and xbmc.getCondVisibility("System.AddonIsEnabeled(inputstream.adaptive)"):
                if 'adaptive_mpd' in v_type:
                    if '@@@' in v_type:
                        helper = inputstreamhelper.Helper('mpd', 'com.widevine.alpha')
                    else:
                        helper = inputstreamhelper.Helper('mpd')
                else:
                    prot = v_type.replace("adaptive_", "")
                    helper = inputstreamhelper.Helper(prot)

                if helper.check_inputstream():
                    common.log('Trying to use inputstream.adaptive to demux stream... ', xbmc.LOGINFO)

                    liz.setProperty('inputstream', helper.inputstream_addon)
                    liz.setContentLookup(False)

                    if '|' in url:
                        url, strhdr = url.split('|')
                        liz.setPath(url)
                        liz.setProperty('inputstream.adaptive.stream_headers', strhdr)
                        if self.kodiver > 19.8:
                            liz.setProperty('inputstream.adaptive.manifest_headers', strhdr)

                    if v_type == 'adaptive_hls':
                        liz.setMimeType('application/vnd.apple.mpegurl')
                        if self.kodiver < 20.9:
                            liz.setProperty('inputstream.adaptive.manifest_type', 'hls')

                    elif 'adaptive_mpd' in v_type:
                        liz.setMimeType('application/dash+xml')
                        if self.kodiver < 20.9:
                            liz.setProperty('inputstream.adaptive.manifest_type', 'mpd')
                        try:
                            licurl = v_type.split("@@@")[1]
                            if '{SSM}' not in licurl:
                                licurl += '||R{SSM}|'
                            common.log("Using custom widevine license url " + licurl, xbmc.LOGINFO)
                            liz.setProperty('inputstream.adaptive.license_type', 'com.widevine.alpha')
                            liz.setProperty('inputstream.adaptive.license_key', licurl)
                        except:
                            pass

                    elif v_type == 'adaptive_ism':
                        if self.kodiver < 20.9:
                            liz.setProperty('inputstream.adaptive.manifest_type', 'ism')
                        liz.setMimeType('application/vnd.ms-sstr+xml')

                else:
                    raise Exception()

            except:
                import traceback
                traceback.print_exc()
                common.log('Error using inputstream.adaptive. Make sure plugin is installed and Kodi is version 17+. Falling back to ffmpeg ...')
                liz.setProperty('inputstream', None)
                liz.setContentLookup(True)
                pass

        if v_type is not None and v_type == 'ffmpegdirect' and common.getSetting("ffmpegdirect") == "true":
            # import traceback
            try:
                # if not xbmc.getCondVisibility("System.HasAddon(inputstream.ffmpegdirect)"):

                #     try:
                #         common.execute('InstallAddon(inputstream.ffmpegdirect)', True)
                #     except Exception:
                #         #traceback.print_exc()
                #         common.showInfo('Could not install ffmpegdirect addon. '
                #                         'Either it is not supported on your devive '
                #                         'or you can try to install it from zip file.')

                #         raise ImportError()

                # if not xbmc.getCondVisibility("System.HasAddon(inputstream.ffmpegdirect)"):
                #     common.showInfo('Could not install ffmpegdirect addon. '
                #                         'Either it is not supported on your devive '
                #                         'or you can try to install it from zip file.')

                #     raise ImportError()

                # try:
                #     if xbmc.getCondVisibility("System.HasAddon(inputstream.ffmpegdirect)") \
                #         and not xbmc.getCondVisibility("System.AddonIsEnabeled(inputstream.ffmpegdirect)"):
                #         common.execute('EnableAddon(inputstream.ffmpegdirect)', True)
                # except:
                #     #traceback.print_exc()
                #     raise Exception()

                helper = inputstreamhelper.Helper('m3u')
                if helper.check_inputstream():
                    common.log('[SD] Trying to use inputstream.ffmpegdirect to play stream... ', xbmc.LOGINFO)
                    liz.setProperty('inputstream', helper.inputstream_addon)
                    liz.setContentLookup(False)
                    if '.ts' in url:
                        liz.setMimeType('video/mp2t')
                        liz.setProperty('inputstream.ffmpegdirect.mime_type', 'video/mp2t')
                        pass
                    elif '.mpd' not in url:
                        liz.setMimeType('application/vnd.apple.mpegurl')
                        liz.setProperty('inputstream.ffmpegdirect.mime_type', 'application/vnd.apple.mpegurl')

                    liz.setProperty('inputstream.ffmpegdirect.is_realtime_stream','true')

                else: raise ImportError()

            except:
                # import traceback
                # traceback.print_exc()
                common.log('[SD] Error using inputstream.ffmpegdirect. Make sure plugin is installed. Falling back to standard player ...')
                liz.setProperty('inputstream', None)
                liz.setContentLookup(True)
                pass

        return liz


    def addListItem(self, lItem, totalItems):
        
        def createContextMenuItem(label, mode, codedItem):            
            action = 'XBMC.RunPlugin(%s)' % (self.addon.build_plugin_url({'mode': str(mode), 'item': codedItem}))
            return (label, action)

        def encoded_dict(in_dict):
            out_dict = {}
            for k, v in in_dict.items():                
                if isinstance(v, bytes):
                    v = v.decode('utf8')
                elif isinstance(v, str):
                    # Must be encoded in UTF-8
                    v.encode('utf8').decode()
                out_dict[k] = v
            return urllib.parse.urlencode(out_dict)

        contextMenuItems = []
        definedIn = lItem['definedIn']

        codedItem = urllib.parse.quote(encoded_dict(lItem.infos))        

        if definedIn:
            # Queue
            #contextMenuItem = createContextMenuItem('Queue', Mode.QUEUE, codedItem)
            #contextMenuItems.append(contextMenuItem)

            # Favourite
            if definedIn.endswith('favourites.cfg') or definedIn.startswith("favfolders/"):
                # Remove from favourites
                contextMenuItem = createContextMenuItem('Remove', Mode.REMOVEFROMFAVOURITES, codedItem)
                contextMenuItems.append(contextMenuItem)

                # Edit label
                contextMenuItem = createContextMenuItem('Edit', Mode.EDITITEM, codedItem)
                contextMenuItems.append(contextMenuItem)

            else:
                # Custom module
                if definedIn.endswith('custom.cfg'):
                    # Remove from custom modules
                    contextMenuItem = createContextMenuItem('Remove module', Mode.REMOVEFROMCUSTOMMODULES, codedItem)
                    contextMenuItems.append(contextMenuItem)

#                if lItem['title'] != "Favourites":
                        # Add to favourites
#                        contextMenuItem = createContextMenuItem('Add to SD favourites', Mode.ADDTOFAVOURITES, codedItem)
#                        contextMenuItems.append(contextMenuItem)
                #contextMenuItem = createContextMenuItem('Open with Chrome launcher', Mode.CHROME, codedItem)
#                contextMenuItem = createContextMenuItem('Open with Browser launcher', Mode.CHROME, codedItem)
#                contextMenuItems.append(contextMenuItem)
                #contextMenuItem = createContextMenuItem('Open with WebDriver', Mode.WEBDRIVER, codedItem)
                #contextMenuItems.append(contextMenuItem)

        liz = self.createXBMCListItem(lItem)
        
        m_type = lItem['type']
        if not m_type:
            m_type = 'rss'

        if m_type == 'video':
            if any(x in lItem['url'] for x in ['hls://', 'hlsvariant://', 'httpstream://', 'hds://', 'akamaihd://']):
                u = self.base + '?mode=' + str(Mode.SLPROXY) + '&item=' + codedItem
                m_type = 'slproxy'
                liz.setProperty('IsPlayable','false')           
            else:
                u = self.base + '?mode=' + str(Mode.PLAY) + '&item=' + codedItem
                if lItem['IsDownloadable']:
                    contextMenuItem = createContextMenuItem('Download', Mode.DOWNLOAD, codedItem)
                    contextMenuItems.append(contextMenuItem)
                liz.setProperty('IsPlayable','true')
            isFolder = False            
        elif m_type == 'slproxy':
            u = self.base + '?mode=' + str(Mode.SLPROXY) + '&item=' + codedItem
            isFolder = False
            liz.setProperty('IsPlayable','false')
        elif m_type == 'slresolve':
            u = self.base + '?mode=' + str(Mode.SLRESOLVE) + '&item=' + codedItem
            isplayable = 'true' if 'streams.wilmaa.com' not in lItem['url'] else 'false'
            liz.setProperty('IsPlayable', isplayable)
            isFolder = False
        elif m_type.find('command') > -1:
            u = self.base + '?mode=' + str(Mode.EXECUTE) + '&item=' + codedItem
            isFolder = False
        elif m_type == 'virtualdir': #open external addon dir
            u = lItem['url']
            isFolder = True
            liz.setProperty('IsPlayable','false')
        else:
            u = self.base + '?mode=' + str(Mode.VIEW) + '&item=' + codedItem
            isFolder = True

        liz.addContextMenuItems(contextMenuItems)
        xbmcplugin.addDirectoryItem(handle = self.handle, url = u, listitem = liz, isFolder = isFolder, totalItems = totalItems)


    def clearCache(self):
        cacheDir = common.Paths.cacheDir
        if not os.path.exists(cacheDir):
            os.mkdir(cacheDir, mode=0o777)
            common.log('Cache directory created' + str(cacheDir))
        else:
            size, within_limit = fu.checkQuota(cacheDir)
            if not within_limit:
                fu.clearDirectory(cacheDir)
                common.log('Cache directory purged')
            common.log('Cache Usage:' + str(size))

    def queueAllVideos(self, item):
        dia = DialogProgress()
        dia.create('SD', 'Get videos...' + item['title'])
        dia.update(0)

        items = self.getVideos(item, dia)
        if items:
            for it in items:
                item = self.createXBMCListItem(it)
                queries = {'mode': str(Mode.PLAY), 'url': self.addon.build_plugin_url(it.infos)}
                uc = self.addon.build_plugin_url(queries)
                xbmc.PlayList(xbmc.PLAYLIST_VIDEO).add(uc, item)
            resultLen = len(items)
            msg = 'Queued ' + str(resultLen) + ' video'
            if resultLen > 1:
                msg += 's'
            dia.update(100, msg)
            xbmc.sleep(500)
            dia.update(100, msg,' ',' ')
        else:
            dia.update(0, 'No items found',' ')

        xbmc.sleep(700)
        dia.close()


    def executeItem(self, item):
        url = item['url']
        if '(' in url:
            xbmcCommand = parseText(url,'([^\(]*).*')
            if xbmcCommand.lower() in ['activatewindow', 'runscript', 'runplugin', 'playmedia']:
                if xbmcCommand.lower() == 'activatewindow':
                    params = parseText(url, '.*\(\s*(.+?)\s*\).*').split(',')
                    for i in range(len(params)-1,-1,-1):
                        p = params[i]
                        if p == 'return':
                            params.remove(p)
                    path = params[len(params)-1]
                    xbmc.executebuiltin('Container.Update(' + path + ')')
                    return
                xbmc.executebuiltin(url)


    def _parseParameters(self):
        mode = int(self.addon.queries['mode'])
        queryString = self.addon.queries['item']
        item = ListItem.create()
        if mode in [Mode.CHROME, Mode.ADDTOFAVOURITES, Mode.REMOVEFROMFAVOURITES, Mode.EDITITEM, Mode.WEBDRIVER]:
            item.infos = self.addon.parse_query(urllib.parse.unquote(queryString), {})
        else:
            item.infos = self.addon.parse_query(queryString, {})
        item.infos = dict((k.encode('utf8').decode(), v.encode('utf8').decode()) for k, v in item.infos.items())
        #item.infos = dict((k, v) for k, v in item.infos.items())
        return [mode, item]

    # def _build_plugin_url(self, url, queries):
    #     '''
    #     Returns a ``plugin://`` URL which can be used to call the addon with 
    #     the specified queries.
        
    #     Example:
        
    #     >>> addon.build_plugin_url({'name': 'test', 'type': 'basic'})
    #     'plugin://your.plugin.id/?name=test&type=basic'
        
        
    #     Args:
    #         queries (dict): A dctionary of keys/values to be added to the 
    #         ``plugin://`` URL.
            
    #     Retuns:
    #         A string containing a fully formed ``plugin://`` URL.
    #     '''
    #     out_dict = {}
    #     for k, v in queries.items():
    #         if isinstance(v, bytes):
    #             v = v.decode('utf8')
    #         elif isinstance(v, str):
    #             # Must be encoded in UTF-8
    #             v.encode('utf8')
    #         out_dict[k] = v
    #     return url + '?' + urllib.parse.urlencode(out_dict)


    def run(self, argv=None):
        self.addon = Addon('plugin.video.sportsdevil', argv)
        common.log('SD running ...')
        common.log('... on Kodi %s, Python %s' % (str(self.kodiver), str(sys.version)))

        base = argv[0]
        handle = int(argv[1])
        parameter = argv[2]
        self.base = base
        self.handle = handle

        paramstring = urllib.parse.unquote_plus(parameter)
        common.log(paramstring)

        try:

            # if addon is started
            listItemPath = xbmcUtils.getListItemPath()
            if not listItemPath.startswith(self.base):
                if not('mode=' in paramstring and not 'mode=1&' in paramstring):
                    xbmcplugin.setPluginFanart(self.handle, common.Paths.pluginFanart)
                    self.clearCache()

            # Main Menu
            if len(paramstring) <= 2:
                mainMenu = ListItem.create()
                mainMenu['url'] = self.MAIN_MENU_FILE
                tmpList = self.parseView(mainMenu)
                if tmpList:
                    self.currentlist = tmpList

            else:
                [mode, item] = self._parseParameters()
                # switch(mode)
                if mode == Mode.VIEW:
                    tmpList = self.parseView(item)

                    if tmpList:
                        self.currentlist = tmpList
                        count = len(self.currentlist.items)
                        if count == 1:
                            # Autoplay single video
                            autoplayEnabled = common.getSetting('autoplay') == 'true'
                            if autoplayEnabled:
                                videos = self.currentlist.getVideos()
                                if len(videos) == 1:
                                    self.playVideo(videos[0], True)



                elif mode == Mode.ADDITEM:

                    tmp = os.path.normpath(paramstring.split('url=')[1])
                    if tmp:
                        suffix = tmp.split(os.path.sep)[-1]
                        tmp = tmp.replace(suffix,'') + urllib.parse.quote_plus(suffix)

                    if self.favouritesManager.add(tmp):
                        xbmc.executebuiltin('Container.Refresh()')


                elif mode in [Mode.ADDTOFAVOURITES, Mode.REMOVEFROMFAVOURITES, Mode.EDITITEM]:

                    if mode == Mode.ADDTOFAVOURITES:
                        self.favouritesManager.addItem(item)
                    elif mode == Mode.REMOVEFROMFAVOURITES:
                        self.favouritesManager.removeItem(item)
                        xbmc.executebuiltin('Container.Refresh()')
                    elif mode == Mode.EDITITEM:
                        if self.favouritesManager.editItem(item):
                            xbmc.executebuiltin('Container.Refresh()')


                elif mode == Mode.EXECUTE:
                    self.executeItem(item)

                elif mode == Mode.PLAY:
                    self.playVideo(item)

                elif mode == Mode.SLRESOLVE:
                    self.playVideo(item, slr=True)

                elif mode == Mode.SLPROXY:
                    self.playSLProxy(item)

                elif mode == Mode.WEBDRIVER:
                    url = urllib.parse.quote(item['url'])
                    title = item['title']
                    self.playWebDriver(url, title)

                elif mode == Mode.QUEUE:
                    self.queueAllVideos(item)

                elif mode == Mode.CHROME:
                    url = urllib.parse.quote(item['url'])
                    title = item['title']
                    self.launchChrome(url, title)

                elif mode == Mode.ADDONSETTINGS:
                    addonid = item['url']
                    common.openSettings(id=addonid)
                    pass

        except BaseException as Ex:
            import traceback
            traceback.print_exc()
            common.showError('Error running SD')
            common.log('Error running SD. Reason:' + str(Ex))
