//
//  Category.m
//  Categorizer
//
//  Created by Andrew Pontious on 8/6/05.
//

#import "Category.h"

#import "MyDelegate.h"

@implementation Category

static Category *allCategory = nil;

- (id)initAsAllCategory
{
	NSAssert(allCategory == nil, @"Can't make more than one \"All\" category!");
	
	self = [super init];
	if (self != nil)
	{
		// TODO localize
		name = [@"All" retain];
		allCategory = self;
	}
	return self;
}

- (void)dealloc
{
	[name release];
	[specialSortKey release];
	
	[super dealloc];
}

- (NSString *)name
{
	return name;
}
- (void)setName:(NSString *)newName
{
	[newName retain];
	[name release];
	
	name = newName;
	
	[specialSortKey release];
	specialSortKey = nil;
}

- (NSString *)specialSortKey
{
	if (specialSortKey == nil)
	{
		if (self == allCategory)
		{
			specialSortKey = [@"0" retain];
		}
		else if (name == nil)
		{
			specialSortKey = [@"2" retain];
		}
		else
		{
			specialSortKey = 
				[[NSString alloc] 
					initWithFormat:@"1%@", 
						[self name]];
		}
	}
	return specialSortKey;
}

- (BOOL)editable
{
	return (self != allCategory);
}

- (BOOL)validateName:(id *)ioValue error:(NSError **)outError
{
	BOOL result = YES;

	NSMutableArray *categories = 
		[[NSMutableArray alloc] initWithArray:[[MyDelegate sharedDelegate] categories]];
	[categories removeObjectAtIndex:[categories indexOfObjectIdenticalTo:self]];

	if ([[categories valueForKey:@"name"] indexOfObject:(*ioValue)] != NSNotFound) {
		result = NO;
	}
	
	[categories release];
	
	return result;
}

- (NSString *)description
{
	return [NSString stringWithFormat:@"%@ %p \"%@\", is \"All\": %@", NSStringFromClass([self class]), self, [self name], (self == allCategory ? @"YES" : @"NO")];
}

@end
