//
//  MyDelegate.m
//  Categorizer
//
//  Created by Andrew Pontious on 8/6/05.
//

#import "MyDelegate.h"

#import "Category.h"

@implementation MyDelegate

static MyDelegate *_sharedDelegate = nil;

- (id)init
{
	self = [super init];
	if (self != nil) 
	{
		categories = [[NSMutableArray alloc] init];
		
		Category *allCategory = [[Category alloc] initAsAllCategory];
		
		// Add special initial category.
		[categories addObject:allCategory];
		
		[allCategory release];
		
		_sharedDelegate = self;
	}
	return self;
}

- (void)dealloc
{
	[categories release];
	
	[super dealloc];
}

- (void)awakeFromNib
{
	// Set table to be initially sorted as specified in the category column of the category table.
	NSSortDescriptor *sortDescriptor = [categoryTableColumn sortDescriptorPrototype];

	NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];

	[categoriesController setSortDescriptors:sortDescriptors];

	[sortDescriptors release];
}

// Never called, if we use an array controller.
- (void)textDidEndEditing:(NSNotification *)notification
{
	if ([notification object] == categoryTable)
	{
		[categoriesController rearrangeObjects];
	}
}

// Called, even if we use an array controller! Yay!
- (void)controlTextDidEndEditing:(NSNotification *)notification
{
	if ([notification object] == categoryTable)
	{
		[categoriesController rearrangeObjects];
	}
}

- (IBAction)newCategory:(id)sender
{
	[categoriesController add:sender];

	// Doesn't work: row hasn't been created yet.
//	int count = [categoryTable numberOfRows];
//	[categoryTable editColumn:0 row:count-1 withEvent:nil select:NO];
}

#pragma mark Methods for Category name validation.

+ (MyDelegate *)sharedDelegate
{
	return _sharedDelegate;
}

- (NSArray *)categories
{
	return categories;
}


@end
