//
//  BindingsArrayController.m
//  Bindings Categorizer
//
//  Created by Andrew Pontious on 8/10/05.
//

#import "BindingsArrayController.h"


@implementation BindingsArrayController

- (void)setSortDescriptors:(NSArray *)sortDescriptors
{
}

// This *almost* works.
// If you remove the Sort Key from the table's nib, when you first launch
// the application, it has no sort array in the header, but it calls this
// method to sort the rows and everything works.
// Then you click the header. Oops! Sort arrow appears, ascending.
// Click again. Sort arrow becomes descending, and selected rows change
// as if the contents of the table had been reversed vertically, even though,
// thanks to this override, they haven't been.
// Overriding setSortDescriptors: to do nothing, as I do above, fixes this 
// problem.
- (id)arrangedObjects
{
	NSArray *content = [self content];
	static NSArray *sortDescriptors = nil;
	if (sortDescriptors == nil)
	{
		NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"specialSortKey" ascending:YES];
		sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
		[sortDescriptor release];
	}
	
	return [content sortedArrayUsingDescriptors:sortDescriptors];
}

@end
