//
//  DataSourceTableView.m
//  DataSource Categorizer
//
//  Created by Andrew Pontious on 8/10/05.
//

#import "DataSourceTableView.h"

@implementation DataSourceTableView

- (void)textDidEndEditing:(NSNotification *)notification
{
	BOOL shouldHandle = YES;

	if ([[self delegate] respondsToSelector:
			@selector(tableView:shouldHandleString:forTableColumn:row:)])
	{
		shouldHandle = 
			[[self delegate] tableView:self
				shouldHandleString:[NSString stringWithString:[[self currentEditor] string]]
				forTableColumn:[[self tableColumns] objectAtIndex:[self editedColumn]]
				row:[self editedRow]];
	}

	if (shouldHandle)
	{
		[super textDidEndEditing:notification];
	}
}

@end
