import torch
import torch.nn as nn

class DDPMScheduler(nn.Module):
    def __init__(self, num_train_timesteps, beta_1, beta_T, mode="linear", sigma_type="small"):
        super().__init__()
        self.num_train_timesteps = num_train_timesteps
        self.timesteps = torch.arange(num_train_timesteps - 1, -1, -1)

        self.betas = None
        self.alphas = None
        self.alphas_cumprod = None
        self.sigmas = None

    def uniform_sample_t(self, batch_size, device):
        raise NotImplementedError

    def add_noise(self, x0, t, noise=None):
        raise NotImplementedError

    def step(self, x_t, t, eps_theta):
        raise NotImplementedError
