﻿// ECMAScript 5 strict mode
"use strict";

assert2(cr, "cr namespace not created");
assert2(cr.plugins_, "cr.plugins_ not created");

/////////////////////////////////////
// Plugin class
// *** CHANGE THE PLUGIN ID HERE *** - must match the "id" property in edittime.js
//          vvvvvvvv
cr.plugins_.armaldio_mail = function (runtime) {
    this.runtime = runtime;
};

(function () {
    /////////////////////////////////////
    // *** CHANGE THE PLUGIN ID HERE *** - must match the "id" property in edittime.js
    //                            vvvvvvvv
    var pluginProto = cr.plugins_.armaldio_mail.prototype;

    /////////////////////////////////////
    // Object type class
    pluginProto.Type = function (plugin) {
        this.plugin = plugin;
        this.runtime = plugin.runtime;
    };

    var typeProto = pluginProto.Type.prototype;

    // called on startup for each object type
    typeProto.onCreate = function () {
    };

    /////////////////////////////////////
    // Instance class
    pluginProto.Instance = function (type) {
        this.type = type;
        this.runtime = type.runtime;

        // any other properties you need, e.g...
        // this.myValue = 0;
    };

    var instanceProto = pluginProto.Instance.prototype;

    // called whenever an instance is created
    instanceProto.onCreate = function () {
        // note the object is sealed after this call; ensure any properties you'll ever need are set on the object
        // e.g...
        // this.myValue = 0;
    };

    // called whenever an instance is destroyed
    // note the runtime may keep the object after this call for recycling; be sure
    // to release/recycle/reset any references to other objects in this function.
    instanceProto.onDestroy = function () {
    };

    // called when saving the full state of the game
    instanceProto.saveToJSON = function () {
        // return a Javascript object containing information about your object's state
        // note you MUST use double-quote syntax (e.g. "property": value) to prevent
        // Closure Compiler renaming and breaking the save format
        return {
            // e.g.
            //"myValue": this.myValue
        };
    };

    // called when loading the full state of the game
    instanceProto.loadFromJSON = function (o) {
        // load from the state previously saved by saveToJSON
        // 'o' provides the same object that you saved, e.g.
        // this.myValue = o["myValue"];
        // note you MUST use double-quote syntax (e.g. o["property"]) to prevent
        // Closure Compiler renaming and breaking the save format
    };

    // only called if a layout object - draw to a canvas 2D context
    instanceProto.draw = function (ctx) {
    };

    // only called if a layout object in WebGL mode - draw to the WebGL context
    // 'glw' is not a WebGL context, it's a wrapper - you can find its methods in GLWrap.js in the install
    // directory or just copy what other plugins do.
    instanceProto.drawGL = function (glw) {
    };

    // The comments around these functions ensure they are removed when exporting, since the
    // debugger code is no longer relevant after publishing.
    /**BEGIN-PREVIEWONLY**/
    instanceProto.getDebuggerValues = function (propsections) {
        // Append to propsections any debugger sections you want to appear.
        // Each section is an object with two members: "title" and "properties".
        // "properties" is an array of individual debugger properties to display
        // with their name and value, and some other optional settings.
        propsections.push({
            "title": "My debugger section",
            "properties": [
                // Each property entry can use the following values:
                // "name" (required): name of the property (must be unique within this section)
                // "value" (required): a boolean, number or string for the value
                // "html" (optional, default false): set to true to interpret the name and value
                //									 as HTML strings rather than simple plain text
                // "readonly" (optional, default false): set to true to disable editing the property

                // Example:
                // {"name": "My property", "value": this.myValue}
            ]
        });
    };

    instanceProto.onDebugValueEdited = function (header, name, value) {
        // Called when a non-readonly property has been edited in the debugger. Usually you only
        // will need 'name' (the property name) and 'value', but you can also use 'header' (the
        // header title for the section) to distinguish properties with the same name.
        if (name === "My property")
            this.myProperty = value;
    };
    /**END-PREVIEWONLY**/

    //////////////////////////////////////
    // Conditions
    function Cnds() {
    };

    // the example condition
    Cnds.prototype.OnSendSuccess = function () {
      return true;
    };

    Cnds.prototype.OnSendFail = function () {
      return true;
    };
    // ... other conditions here ...

    pluginProto.cnds = new Cnds();

    //////////////////////////////////////
    // Actions
    function Acts() {
    };

    // the example action
    Acts.prototype.Send = function (smtp_server, port, password, from_mail, from_name, to_mail, subject, body, filename, base64_file, security, debug, console_log) {
	  var s;
    var log;

	  if (security == 0)
		  s = "";
	  else if (security == 1)
		  s = "ssl";
	  else if (security == 2)
		  s = "tls";

    log = (console_log != 1);

	  if (log) console.log(s);

	  var self = this;
        $.ajax({
            url:"http://morbidgame.com/c2-assets/plugins/email/host/mail.php",
            type:"POST",
            dataType:"html",
            data: JSON.stringify({
                "subject": subject,
                "from_mail": from_mail,
                "attachment_name": filename,
                "file": base64_file,
                "body": body,
                "name_from": from_name,
                "recipient": to_mail,
        				"port": port,
        				"password": password,
        				"smtp_server": smtp_server,
        				"debug": debug,
        				"security" : s
             }),
            //contentType:"application/json; charset=utf-8",
            success: function (data) {
      				if (data.substr(data.length - 2, 2) == "OK")
      					{
      						self.runtime.trigger(cr.plugins_.armaldio_mail.prototype.cnds.OnSendSuccess, self);
      						return true;
      					}
      				else
      					{
      						if (log) console.log("It seems that the request is successfull but there is still a problem...\nPlease check 'Enable debug' and report error to the dev ;)");
      						if (log) console.log(data);
                  self.runtime.trigger(cr.plugins_.armaldio_mail.prototype.cnds.OnSendFail, self);
      						return false;
      					}
            },
            complete: function () {
            },
            error: function (xhr, textStatus, errorThrown) {
                if (log) console.log('ajax loading error... \n' + textStatus + "\n" + errorThrown);
                self.runtime.trigger(cr.plugins_.armaldio_mail.prototype.cnds.OnSendFail, self);
                return false;
            }
        });
    };

    pluginProto.acts = new Acts();

    //////////////////////////////////////
    // Expressions
    function Exps() {
    };

    // the example expression
    Exps.prototype.MyExpression = function (ret)	// 'ret' must always be the first parameter - always return the expression's result through it!
    {
        ret.set_int(1337);				// return our value
        // ret.set_float(0.5);			// for returning floats
        // ret.set_string("Hello");		// for ef_return_string
        // ret.set_any("woo");			// for ef_return_any, accepts either a number or string
    };

    // ... other expressions here ...

    pluginProto.exps = new Exps();

}());
