/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.merging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifc.ReferenceCounter;
import org.bimserver.merging.AbstractModelMerger;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.store.Project;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIntelligentModelMerger
extends AbstractModelMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractIntelligentModelMerger.class);
    private ReferenceCounter referenceCounter;
    private IfcModelInterface model;

    public abstract String getIdentifier(IdEObject var1);

    public IfcModelInterface merge(Project project, IfcModelSet modelSet, ModelHelper modelHelper) throws MergeException {
        if (modelSet.size() == 1) {
            return (IfcModelInterface)modelSet.iterator().next();
        }
        modelSet.sortByDate();
        this.model = this.mergeScales(project, (Set<IfcModelInterface>)modelSet, modelHelper);
        this.LOGGER.info("Intelligent merging");
        this.referenceCounter = new ReferenceCounter(this.model);
        this.referenceCounter.updateReferences();
        Map<String, List<IdEObject>> identifierMap = this.buildIdentifierMap();
        this.cleanIdentifierMap(identifierMap);
        this.LOGGER.info("Model size: " + this.model.size());
        return this.model;
    }

    private Map<String, List<IdEObject>> buildIdentifierMap() {
        HashMap<String, List<IdEObject>> map = new HashMap<String, List<IdEObject>>();
        for (IdEObject idEObject : this.model.getValues()) {
            if (!(idEObject instanceof IfcRoot)) continue;
            IfcRoot ifcRoot = (IfcRoot)idEObject;
            String identifier = this.getIdentifier(idEObject);
            if (identifier == null) continue;
            if (map.containsKey(identifier)) {
                if (((IdEObject)((List)map.get(identifier)).get(0)).eClass() != ifcRoot.eClass()) {
                    this.LOGGER.info("Not merging " + identifier + " because different types are found: " + ((IdEObject)((List)map.get(identifier)).get(0)).eClass().getName() + " and " + ifcRoot.eClass().getName());
                    continue;
                }
                if (!this.model.contains((IdEObject)ifcRoot)) continue;
                ((List)map.get(identifier)).add(ifcRoot);
                continue;
            }
            if (!this.model.contains((IdEObject)ifcRoot)) continue;
            ArrayList<IfcRoot> list = new ArrayList<IfcRoot>();
            list.add(ifcRoot);
            map.put(identifier, list);
        }
        return map;
    }

    private void cleanIdentifierMap(Map<String, List<IdEObject>> identifierMap) {
        for (String identifier : identifierMap.keySet()) {
            List<IdEObject> list = identifierMap.get(identifier);
            if (list.size() <= 1) continue;
            IdEObject newestObject = list.get(list.size() - 1);
            block1: for (EAttribute eAttribute : newestObject.eClass().getEAllAttributes()) {
                if (eAttribute.isMany() || newestObject.eIsSet((EStructuralFeature)eAttribute)) continue;
                for (int i = list.size() - 2; i >= 0; --i) {
                    IdEObject olderObject = list.get(i);
                    if (!olderObject.eIsSet((EStructuralFeature)eAttribute)) continue;
                    newestObject.eSet((EStructuralFeature)eAttribute, olderObject.eGet((EStructuralFeature)eAttribute));
                    continue block1;
                }
            }
            block3: for (EReference eReference : newestObject.eClass().getEAllReferences()) {
                if (eReference.isMany()) {
                    if (newestObject.eIsSet((EStructuralFeature)eReference)) continue;
                    List l = (List)newestObject.eGet((EStructuralFeature)eReference);
                    for (int i = list.size() - 2; i >= 0; --i) {
                        IdEObject olderObject = list.get(i);
                        if (!olderObject.eIsSet((EStructuralFeature)eReference)) continue;
                        List a = (List)olderObject.eGet((EStructuralFeature)eReference);
                        l.addAll(a);
                        for (Object o : a) {
                            this.referenceCounter.addReference((ReferenceCounter.Reference)new ReferenceCounter.MultiReference(newestObject, (IdEObject)o, eReference));
                        }
                        a.clear();
                        continue block3;
                    }
                    continue;
                }
                if (newestObject.eIsSet((EStructuralFeature)eReference)) continue;
                for (int i = list.size() - 2; i >= 0; --i) {
                    IdEObject olderObject = list.get(i);
                    if (!olderObject.eIsSet((EStructuralFeature)eReference)) continue;
                    newestObject.eSet((EStructuralFeature)eReference, olderObject.eGet((EStructuralFeature)eReference));
                    this.referenceCounter.addReference((ReferenceCounter.Reference)new ReferenceCounter.SingleReference(newestObject, (IdEObject)olderObject.eGet((EStructuralFeature)eReference), eReference));
                    continue block3;
                }
            }
            for (IdEObject idEObject : list) {
                if (idEObject == newestObject) continue;
                this.removeReplaceLinks(newestObject, idEObject);
            }
        }
    }

    private void removeReplaceLinks(IdEObject mainObject, IdEObject objectToRemove) {
        if (mainObject.eClass() != objectToRemove.eClass()) {
            throw new RuntimeException("Classes must be the same");
        }
        Set referencesTo = this.referenceCounter.getReferencesTo(objectToRemove);
        if (referencesTo != null) {
            Iterator referenceIterator = referencesTo.iterator();
            HashSet<ReferenceCounter.Reference> newReferences = new HashSet<ReferenceCounter.Reference>();
            while (referenceIterator.hasNext()) {
                ReferenceCounter.Reference reference = (ReferenceCounter.Reference)referenceIterator.next();
                newReferences.add(reference.reAttach(mainObject));
                referenceIterator.remove();
            }
            for (ReferenceCounter.Reference reference : newReferences) {
                this.referenceCounter.addReference(reference);
            }
        }
        this.referenceCounter.remove(objectToRemove);
        this.model.remove(objectToRemove);
    }
}

