/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import java.util.ArrayList;
import java.util.List;
import org.bimserver.serializers.binarygeometry.GeometryBuffer;

public class GeometryMainBuffer {
    private final int MAX_SIZE = 0x6400000;
    private final List<GeometryBuffer> buffers = new ArrayList<GeometryBuffer>();
    private GeometryBuffer currentBuffer;
    private int currentIndex = 0;

    public GeometryBuffer getCurrentWriteBuffer() {
        if (this.currentBuffer == null || this.currentBuffer.getPreparedByteSize() > 0x6400000) {
            this.currentBuffer = new GeometryBuffer();
            this.buffers.add(this.currentBuffer);
        }
        return this.currentBuffer;
    }

    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    public boolean hasNextReadBuffer() {
        return this.currentIndex < this.buffers.size() - 1;
    }

    public GeometryBuffer getCurrentReadBuffer() {
        if (this.buffers.size() == 0) {
            return null;
        }
        return this.buffers.get(this.currentIndex);
    }

    public GeometryBuffer getNextReadBuffer() {
        ++this.currentIndex;
        GeometryBuffer geometryBuffer = this.buffers.get(this.currentIndex);
        return geometryBuffer;
    }
}

