/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers;

import java.io.InputStream;
import java.io.OutputStream;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.SharedJsonStreamingSerializer;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.SerializerInputstream;
import org.bimserver.plugins.serializers.StreamingReader;
import org.bimserver.plugins.serializers.StreamingSerializer;

public class MinimalStreamingJsonSerializer
implements StreamingSerializer,
StreamingReader {
    private ObjectProvider objectProvider;
    private IfcHeader ifcHeader;
    private PluginConfiguration pluginConfiguration;
    private SharedJsonStreamingSerializer sharedJsonStreamingSerializer;

    public MinimalStreamingJsonSerializer(PluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public void init(ObjectProvider objectProvider, ProjectInfo projectInfo, IfcHeader ifcHeader, PluginManagerInterface pluginManager, PackageMetaData packageMetaData) throws SerializerException {
        this.objectProvider = objectProvider;
        this.ifcHeader = ifcHeader;
        this.sharedJsonStreamingSerializer = new SharedJsonStreamingSerializer(objectProvider, ifcHeader, true, true);
    }

    public void writeToOutputStream(OutputStream outputStream) throws SerializerException, BimserverDatabaseException {
        boolean result = this.sharedJsonStreamingSerializer.write(outputStream);
        while (result) {
            result = this.sharedJsonStreamingSerializer.write(outputStream);
        }
    }

    public InputStream getInputStream() {
        return new SerializerInputstream((StreamingReader)this);
    }

    public boolean write(OutputStream out) throws SerializerException, BimserverDatabaseException {
        return this.sharedJsonStreamingSerializer.write(out);
    }
}

