/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.compare;

import java.util.List;
import javax.activation.DataHandler;
import org.bimserver.interfaces.objects.SCompareType;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SDownloadResult;
import org.bimserver.interfaces.objects.SModelComparePluginConfiguration;
import org.bimserver.interfaces.objects.SObjectType;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SRevision;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.interfaces.objects.SService;
import org.bimserver.models.store.ServiceDescriptor;
import org.bimserver.plugins.services.AbstractService;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompareService.class);

    public void newRevision(AbstractService.RunningService runningService, BimServerClientInterface bimServerClientInterface, long poid, long roid, String userToken, long soid, SObjectType settings) throws Exception {
        SRevision revision = bimServerClientInterface.getServiceInterface().getRevision(Long.valueOf(roid));
        if (revision.getServicesLinked().contains(soid)) {
            throw new UserException("Not running service on this revision because it was generated by the same service");
        }
        if (revision.getServiceId() == soid) {
            throw new UserException("Not running service on this revision because it was generated by the same service");
        }
        List allModelCompares = bimServerClientInterface.getPluginInterface().getAllModelCompares(Boolean.valueOf(true));
        SModelComparePluginConfiguration modelComparePlugin = null;
        for (SModelComparePluginConfiguration modelComparePluginConfiguration : allModelCompares) {
            if (!modelComparePluginConfiguration.getName().equals("GUID based")) continue;
            modelComparePlugin = modelComparePluginConfiguration;
        }
        if (modelComparePlugin == null) {
            throw new UserException("No GUID based model compare plugin found");
        }
        SProject project = bimServerClientInterface.getServiceInterface().getProjectByPoid(Long.valueOf(poid));
        if (project.getRevisions().size() < 2) {
            throw new UserException("At least 2 revision required to be able to run compare");
        }
        Long secondLastRoid = (Long)project.getRevisions().get(project.getRevisions().size() - 2);
        SSerializerPluginConfiguration serializerByContentType = bimServerClientInterface.getServiceInterface().getSerializerByContentType("application/ifc");
        Long topicId = bimServerClientInterface.getServiceInterface().downloadCompareResults(Long.valueOf(serializerByContentType.getOid()), secondLastRoid, Long.valueOf(roid), Long.valueOf(modelComparePlugin.getOid()), SCompareType.ALL, Boolean.valueOf(true));
        SDownloadResult downloadData = bimServerClientInterface.getServiceInterface().getDownloadData(topicId);
        DataHandler file = downloadData.getFile();
        SDeserializerPluginConfiguration suggestedDeserializerForExtension = bimServerClientInterface.getServiceInterface().getSuggestedDeserializerForExtension("ifc", Long.valueOf(poid));
        LOGGER.info("Using " + suggestedDeserializerForExtension.getName() + " as serializer");
        SService service = bimServerClientInterface.getServiceInterface().getService(Long.valueOf(soid));
        bimServerClientInterface.checkinSync(service.getWriteRevisionId(), "test", suggestedDeserializerForExtension.getOid(), false, -1L, "", file.getInputStream());
    }

    public void addRequiredRights(ServiceDescriptor serviceDescriptor) {
        serviceDescriptor.setWriteRevision(true);
    }
}

