/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.deserializer;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.MetaDataException;
import org.bimserver.ifc.step.deserializer.IfcHeaderParser;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.utils.FakeClosingInputStream;

public class DetectIfcVersion {
    private int lineNumber;
    private IfcHeader ifcHeader = StoreFactory.eINSTANCE.createIfcHeader();

    public static void main(String[] args) {
        Path path = Paths.get("C:\\Bulk\\Single\\beam-standard-case.ifc", new String[0]);
        byte[] head = new byte[4096];
        try {
            IOUtils.readFully((InputStream)Files.newInputStream(path, new OpenOption[0]), (byte[])head);
            System.out.println(new DetectIfcVersion().detectVersion(head, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DeserializeException e) {
            e.printStackTrace();
        }
    }

    public String detectVersion(byte[] head, boolean usesZip) throws DeserializeException, IOException {
        if (usesZip) {
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(head));
            ZipEntry nextEntry = zipInputStream.getNextEntry();
            if (nextEntry == null) {
                throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file looks empty");
            }
            if (nextEntry.getName().toUpperCase().endsWith(".IFC")) {
                FakeClosingInputStream fakeClosingInputStream = new FakeClosingInputStream((InputStream)zipInputStream);
                this.read((InputStream)fakeClosingInputStream);
            }
        } else {
            this.read(new ByteArrayInputStream(head));
        }
        if (this.ifcHeader.getIfcSchemaVersion() == null) {
            throw new DeserializeException("No IFC schema found");
        }
        return this.ifcHeader.getIfcSchemaVersion();
    }

    private long read(InputStream inputStream) throws DeserializeException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        this.lineNumber = 0;
        try {
            String line = reader.readLine();
            if (line == null) {
                throw new DeserializeException(0, "Unexpected end of stream reading first line");
            }
            while (line != null) {
                try {
                    String readLine;
                    while (!this.processLine(line.trim()) && (readLine = reader.readLine()) != null) {
                        line = line + readLine;
                        ++this.lineNumber;
                    }
                }
                catch (Exception e) {
                    if (e instanceof DeserializeException) {
                        throw (DeserializeException)((Object)e);
                    }
                    throw new DeserializeException(this.lineNumber, " (" + e.getMessage() + ") " + line, e);
                }
                if (this.ifcHeader.getIfcSchemaVersion() != null) {
                    return this.lineNumber;
                }
                line = reader.readLine();
                ++this.lineNumber;
            }
            return this.lineNumber;
        }
        catch (FileNotFoundException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        catch (IOException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
    }

    private boolean processLine(String line) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        if (line.length() > 0) {
            if (line.endsWith(";")) {
                this.processHeader(line);
                return true;
            }
            return false;
        }
        if (line.equals("DATA;")) {
            return true;
        }
        return true;
    }

    private boolean processHeader(String line) throws DeserializeException {
        if (line.startsWith("/*") && line.contains("*/")) {
            line = line.substring(line.indexOf("*/") + 2);
        }
        if (line.startsWith("FILE_SCHEMA")) {
            String fileschema = line.substring("FILE_SCHEMA".length()).trim();
            new IfcHeaderParser().parseFileSchema(fileschema.substring(1, fileschema.length() - 2), this.ifcHeader);
            return true;
        }
        return line.startsWith("ENDSEC;");
    }

    public static enum Mode {
        HEADER,
        DATA,
        FOOTER,
        DONE;

    }
}

