/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bimserver.geometry.Matrix;
import org.bimserver.plugins.renderengine.RenderEngineException;

public class IfcGeomServerClientEntity {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private int id;
    private String guid;
    private String name;
    private String type;
    private int parentId;
    private double[] matrix;
    private int repId;
    private ByteBuffer positions;
    private ByteBuffer normals;
    private ByteBuffer indices;
    private ByteBuffer colors;
    private ByteBuffer materialIndices;
    private ObjectNode extendedData;

    public IfcGeomServerClientEntity(int id, String guid, String name, String type, int parentId, double[] matrix, int repId, ByteBuffer positions, ByteBuffer normals, ByteBuffer indices, ByteBuffer colors, ByteBuffer materialIndices, String messageRemainder) {
        this.id = id;
        this.guid = guid;
        this.name = name;
        this.type = type;
        this.parentId = parentId;
        this.matrix = Matrix.changeOrientation((double[])matrix);
        this.repId = repId;
        this.positions = positions;
        this.normals = normals;
        this.indices = indices;
        this.colors = colors;
        this.materialIndices = materialIndices;
        if (messageRemainder != null && messageRemainder.length() > 0) {
            try {
                this.extendedData = (ObjectNode)OBJECT_MAPPER.readValue(messageRemainder.trim(), ObjectNode.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getParentId() {
        return this.parentId;
    }

    public double[] getMatrix() {
        return this.matrix;
    }

    public int getRepId() {
        return this.repId;
    }

    public ByteBuffer getPositions() {
        return this.positions;
    }

    public ByteBuffer getNormals() {
        return this.normals;
    }

    public ByteBuffer getIndices() {
        return this.indices;
    }

    public ByteBuffer getColors() {
        return this.colors;
    }

    public ByteBuffer getMaterialIndices() {
        return this.materialIndices;
    }

    public ObjectNode getAllExtendedData() throws RenderEngineException {
        return this.extendedData;
    }
}

