/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.bimserver.plugins.renderengine.EntityNotFoundException;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.ifcopenshell.IfcGeomServerClient;
import org.ifcopenshell.IfcGeomServerClientEntity;
import org.ifcopenshell.IfcOpenShellEntityInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcOpenShellModel
implements RenderEngineModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcOpenShellModel.class);
    private InputStream ifcInputStream;
    private HashMap<Integer, IfcOpenShellEntityInstance> instancesById;
    private IfcGeomServerClient client;

    public IfcOpenShellModel(IfcGeomServerClient client, InputStream ifcInputStream) throws RenderEngineException, IOException {
        this.client = client;
        this.ifcInputStream = ifcInputStream;
        client.loadModel(ifcInputStream);
    }

    public IfcOpenShellModel(IfcGeomServerClient client, InputStream ifcInputStream, long length) throws RenderEngineException, IOException {
        this.client = client;
        this.ifcInputStream = ifcInputStream;
        client.loadModel(ifcInputStream, length);
    }

    public void close() throws RenderEngineException {
        if (this.instancesById != null) {
            this.instancesById.clear();
        }
        try {
            this.ifcInputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void generateGeneralGeometry() throws RenderEngineException {
        this.instancesById = new HashMap();
        double t0 = System.nanoTime();
        while (this.client.hasNext()) {
            IfcGeomServerClientEntity next = this.client.getNext();
            IfcOpenShellEntityInstance instance = new IfcOpenShellEntityInstance(next);
            this.instancesById.put(next.getId(), instance);
        }
        double t1 = System.nanoTime();
        LOGGER.debug(String.format("Took %.2f seconds to obtain representations for %d entities", (t1 - t0) / 1.0E9, this.instancesById.size()));
    }

    public RenderEngineInstance getInstanceFromExpressId(int oid) throws RenderEngineException {
        if (this.instancesById.containsKey(oid)) {
            return this.instancesById.get(oid);
        }
        throw new EntityNotFoundException("Entity " + oid + " not found in model");
    }

    public void setFormat(int format, int mask) throws RenderEngineException {
    }

    public void setSettings(RenderEngineSettings settings) throws RenderEngineException {
    }

    public void setFilter(RenderEngineFilter renderEngineFilter) {
    }

    public Collection<RenderEngineInstance> listInstances() throws RenderEngineException {
        return null;
    }
}

