/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.compare;

import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.compare.AbstractModelCompare;
import org.bimserver.models.store.CompareContainer;
import org.bimserver.models.store.CompareResult;
import org.bimserver.models.store.CompareType;
import org.bimserver.models.store.ObjectAdded;
import org.bimserver.models.store.ObjectRemoved;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.modelcompare.ModelCompareException;
import org.eclipse.emf.ecore.EClass;

public class GuidBasedModelCompare
extends AbstractModelCompare {
    public CompareResult compare(IfcModelInterface model1, IfcModelInterface model2, CompareType compareType) throws ModelCompareException {
        CompareResult result = StoreFactory.eINSTANCE.createCompareResult();
        try {
            PackageMetaData packageMetaData = model1.getPackageMetaData();
            for (EClass eClass : packageMetaData.getAllSubClasses(packageMetaData.getEClass("IfcRoot"))) {
                IdEObject eObject2;
                IdEObject eObject1;
                for (String guid : model1.getGuids(eClass)) {
                    eObject1 = model1.getByGuid(guid);
                    eObject2 = model2.getByGuid(guid);
                    if (eObject2 != null || compareType != CompareType.ALL && compareType != CompareType.DELETE) continue;
                    ObjectRemoved objectRemoved = StoreFactory.eINSTANCE.createObjectRemoved();
                    objectRemoved.setDataObject(this.makeDataObject(eObject1));
                    this.getCompareContainer(eObject1.eClass()).getItems().add((Object)objectRemoved);
                }
                for (String guid : model2.getGuids(eClass)) {
                    eObject1 = model1.getByGuid(guid);
                    eObject2 = model2.getByGuid(guid);
                    if (eObject1 == null) {
                        if (compareType != CompareType.ALL && compareType != CompareType.ADD) continue;
                        ObjectAdded objectAdded = StoreFactory.eINSTANCE.createObjectAdded();
                        objectAdded.setDataObject(this.makeDataObject(eObject2));
                        this.getCompareContainer(eObject2.eClass()).getItems().add((Object)objectAdded);
                        continue;
                    }
                    this.compareEObjects(eClass, eObject1, eObject2, result, compareType);
                }
            }
        }
        catch (Exception e) {
            throw new ModelCompareException(e);
        }
        for (CompareContainer compareContainer : this.getMap().values()) {
            result.getItems().add((Object)compareContainer);
        }
        return result;
    }
}

