/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import java.util.ArrayList;
import java.util.List;
import org.bimserver.serializers.binarygeometry.GeometrySubBuffer;

public class GeometryBuffer {
    private static final int THRESHOLD = 50000;
    private final List<GeometrySubBuffer> geometryMappings = new ArrayList<GeometrySubBuffer>();
    private int currentIndex;
    private boolean initSent;
    private int nrIndices;
    private int nrVertices;
    private int nrColors;
    private int preparedByteSize;
    private int nrObjects;

    public GeometryBuffer() {
        GeometrySubBuffer current = new GeometrySubBuffer(this, 0);
        this.geometryMappings.add(current);
    }

    public List<GeometrySubBuffer> getGeometryMappings() {
        return this.geometryMappings;
    }

    public boolean isEmpty() {
        return this.geometryMappings.isEmpty();
    }

    public GeometrySubBuffer getCurrentGeometryMapping(boolean canUpdate) {
        GeometrySubBuffer current = this.geometryMappings.get(this.geometryMappings.size() - 1);
        if (current.getNrTriangles() > 50000 && canUpdate) {
            current = new GeometrySubBuffer(this, current.getBaseIndex() + current.getNrVertices() / 3);
            this.geometryMappings.add(current);
        }
        return current;
    }

    public boolean hasNextGeometryMapping() {
        return this.currentIndex < this.geometryMappings.size();
    }

    public GeometrySubBuffer getNextGeometryMapping() {
        GeometrySubBuffer geometrySubBuffer = this.geometryMappings.get(this.currentIndex);
        ++this.currentIndex;
        return geometrySubBuffer;
    }

    public void setInitSent() {
        this.initSent = true;
    }

    public boolean initSent() {
        return this.initSent;
    }

    public int getPreparedByteSize() {
        return this.preparedByteSize;
    }

    public int getNrObjects() {
        return this.nrObjects;
    }

    public int getNrIndices() {
        return this.nrIndices;
    }

    public int getNrVertices() {
        return this.nrVertices;
    }

    public int getNrColors() {
        return this.nrColors;
    }

    public void incNrIndices(int nrIndices) {
        this.nrIndices += nrIndices;
    }

    public void incNrVertices(int nrVertices) {
        this.nrVertices += nrVertices;
    }

    public void incNrColors(int nrColors) {
        this.nrColors += nrColors;
    }

    public void incPreparedByteSize(int byteSize) {
        this.preparedByteSize += byteSize;
    }

    public void incNrObjects() {
        ++this.nrObjects;
    }
}

