/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry.clipping;

import org.bimserver.serializers.binarygeometry.clipping.Vector;

public class Point {
    protected double[] e = new double[3];
    public static Point Zero = new Point(0.0, 0.0, 0.0);

    public Point(double x, double y, double z) {
        this.e[0] = x;
        this.e[1] = y;
        this.e[2] = z;
    }

    public double getX() {
        return this.e[0];
    }

    public double getY() {
        return this.e[1];
    }

    public double getZ() {
        return this.e[2];
    }

    public void setX(double x) {
        this.e[0] = x;
    }

    public void setY(double y) {
        this.e[1] = y;
    }

    public void setZ(double z) {
        this.e[2] = z;
    }

    public Point add(Point p) {
        return new Point(this.e[0] + p.e[0], this.e[1] + p.e[1], this.e[2] + p.e[2]);
    }

    public Vector sub(Point p) {
        return new Vector(this.e[0] - p.e[0], this.e[1] - p.e[1], this.e[2] - p.e[2]);
    }

    public Point mul(Point p) {
        return new Point(this.e[0] * p.e[0], this.e[1] * p.e[1], this.e[2] * p.e[2]);
    }

    public Point div(Point p) {
        return new Point(this.e[0] / p.e[0], this.e[1] / p.e[1], this.e[2] / p.e[2]);
    }

    public Point add(double s) {
        return new Point(this.e[0] + s, this.e[1] + s, this.e[2] + s);
    }

    public Point sub(double s) {
        return new Point(this.e[0] - s, this.e[1] - s, this.e[2] - s);
    }

    public Point mul(double s) {
        return new Point(this.e[0] * s, this.e[1] * s, this.e[2] * s);
    }

    public Point div(double s) {
        double inv = 1.0 / s;
        return new Point(this.e[0] * inv, this.e[1] * inv, this.e[2] * inv);
    }

    public Point midPoint(Point p) {
        Point m = this.add(p);
        return m.mul(0.5);
    }

    public Vector toVector() {
        return new Vector(this.e[0], this.e[1], this.e[2]);
    }

    public String toString() {
        return this.e[0] + ", " + this.e[1] + ", " + this.e[2];
    }
}

