/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.ifcopenshell.IfcGeomServerClient;
import org.ifcopenshell.IfcOpenShellModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcOpenShellEngine
implements RenderEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcOpenShellEngine.class);
    private Path executableFilename;
    private IfcGeomServerClient client;
    private boolean calculateQuantities;
    private boolean applyLayerSets;

    public IfcOpenShellEngine(Path executableFilename, boolean calculateQuantities, boolean applyLayerSets) throws IOException {
        this.executableFilename = executableFilename;
        this.setCalculateQuantities(calculateQuantities);
        this.setApplyLayerSets(applyLayerSets);
    }

    public void init() throws RenderEngineException {
        LOGGER.debug("Initializing IfcOpenShell engine");
        this.client = new IfcGeomServerClient(this.executableFilename);
        this.client.setCalculateQuantities(this.isCalculateQuantities());
        this.client.setApplyLayersets(this.isApplyLayerSets());
    }

    public void close() throws RenderEngineException {
        LOGGER.debug("Closing IfcOpenShell engine");
        if (this.client.isRunning()) {
            this.client.close();
        }
    }

    public RenderEngineModel openModel(InputStream inputStream, long size) throws RenderEngineException {
        if (!this.client.isRunning()) {
            this.client = new IfcGeomServerClient(this.executableFilename);
        }
        try {
            return new IfcOpenShellModel(this.client, inputStream, size);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public RenderEngineModel openModel(InputStream inputStream) throws RenderEngineException {
        if (!this.client.isRunning()) {
            this.client = new IfcGeomServerClient(this.executableFilename);
        }
        try {
            return new IfcOpenShellModel(this.client, inputStream);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public boolean isCalculateQuantities() {
        return this.calculateQuantities;
    }

    public void setCalculateQuantities(boolean calculateQuantities) {
        this.calculateQuantities = calculateQuantities;
    }

    public boolean isApplyLayerSets() {
        return this.applyLayerSets;
    }

    public void setApplyLayerSets(boolean applyLayerSets) {
        this.applyLayerSets = applyLayerSets;
    }
}

