/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.merging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.ObjectFactory;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.ifc.Scaler;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.ifc2x3tc1.IfcSIPrefix;
import org.bimserver.models.ifc2x3tc1.IfcSIUnit;
import org.bimserver.models.ifc2x3tc1.IfcUnit;
import org.bimserver.models.ifc2x3tc1.IfcUnitAssignment;
import org.bimserver.models.ifc2x3tc1.IfcUnitEnum;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.SIPrefix;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.modelmerger.ModelMerger;
import org.bimserver.utils.IfcUtils;
import org.eclipse.emf.common.util.EList;

public abstract class AbstractModelMerger
implements ModelMerger {
    protected IfcModelInterface mergeScales(Project project, Set<IfcModelInterface> ifcModels, ModelHelper modelHelper) throws MergeException {
        long size = 0L;
        PackageMetaData packageMetaData = null;
        for (IfcModelInterface ifcModel : ifcModels) {
            size += ifcModel.size();
            packageMetaData = ifcModel.getPackageMetaData();
        }
        BasicIfcModel endModel = new BasicIfcModel(packageMetaData, null, (int)size);
        modelHelper.setTargetModel((IfcModelInterface)endModel);
        modelHelper.setObjectFactory((ObjectFactory)endModel);
        modelHelper.setKeepOriginalOids(true);
        float foundPrefix = Float.MIN_VALUE;
        boolean allModelsSameScale = this.allModelsSameScale(ifcModels, foundPrefix);
        if (allModelsSameScale) {
            for (IfcModelInterface ifcModel : ifcModels) {
                Iterator iterator = new HashSet(ifcModel.keySet()).iterator();
                while (iterator.hasNext()) {
                    String name;
                    long key = (Long)iterator.next();
                    IdEObject ideObject = ifcModel.get(key);
                    if (ideObject instanceof IfcRoot && (name = ((IfcRoot)ideObject).getName()) != null && name.equalsIgnoreCase("dummy")) continue;
                    try {
                        modelHelper.copy(ideObject, true);
                    }
                    catch (IfcModelInterfaceException e) {
                        throw new MergeException((Exception)((Object)e));
                    }
                }
            }
        } else {
            endModel.setUseDoubleStrings(false);
            SIPrefix prefix = project.getExportLengthMeasurePrefix();
            for (IfcModelInterface ifcModel : ifcModels) {
                float scale = (float)((double)IfcUtils.getLengthUnitPrefix((IfcModelInterface)ifcModel) / Math.pow(10.0, prefix.getValue()));
                this.setLengthUnitMeasure(ifcModel, prefix);
                ifcModel.indexGuids();
                Scaler scaler = new Scaler(ifcModel);
                scaler.scale(scale);
                Iterator iterator = ifcModel.keySet().iterator();
                while (iterator.hasNext()) {
                    long key = (Long)iterator.next();
                    try {
                        modelHelper.copy(ifcModel.get(key), true);
                    }
                    catch (IfcModelInterfaceException e) {
                        throw new MergeException((Exception)((Object)e));
                    }
                }
            }
        }
        return endModel;
    }

    private boolean allModelsSameScale(Set<IfcModelInterface> ifcModels, float foundPrefix) {
        for (IfcModelInterface ifcModel : ifcModels) {
            float lengthUnitPrefix = IfcUtils.getLengthUnitPrefix((IfcModelInterface)ifcModel);
            if (foundPrefix != Float.MIN_VALUE && lengthUnitPrefix != foundPrefix) {
                return false;
            }
            foundPrefix = lengthUnitPrefix;
        }
        return true;
    }

    private void setLengthUnitMeasure(IfcModelInterface model, SIPrefix prefix) {
        boolean prefixFound = false;
        for (IfcProject ifcProject : model.getAll(IfcProject.class)) {
            IfcUnitAssignment unitsInContext = ifcProject.getUnitsInContext();
            EList units = unitsInContext.getUnits();
            for (IfcUnit unit : units) {
                IfcSIUnit ifcSIUnit;
                IfcUnitEnum unitType;
                if (!(unit instanceof IfcSIUnit) || (unitType = (ifcSIUnit = (IfcSIUnit)unit).getUnitType()) != IfcUnitEnum.LENGTHUNIT) continue;
                prefixFound = true;
                if (prefix == SIPrefix.METER) {
                    ifcSIUnit.setPrefix(null);
                    break;
                }
                String siPrefix = prefix.getLiteral().substring(0, prefix.getLiteral().length() - 5).toUpperCase();
                ifcSIUnit.setPrefix(IfcSIPrefix.valueOf((String)siPrefix));
                break;
            }
            if (!prefixFound) continue;
            break;
        }
    }
}

